/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.impl;

import com.github.pagehelper.PageHelper;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.common.util.PageInfo;
import com.pamirs.tro.entity.domain.entity.TFirstLinkMnt;
import com.pamirs.tro.entity.domain.entity.TSecondBasic;
import com.pamirs.tro.entity.domain.entity.TSecondLinkMnt;
import com.pamirs.tro.entity.domain.vo.TLinkServiceMntVo;
import io.shulie.tro.web.app.common.CommonService;
import io.shulie.tro.web.app.service.TFirstLinkMntService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TFirstLinkMntServiceImpl
extends CommonService
implements TFirstLinkMntService {
    private static final String SECOND_LINKS = "SECOND_LINKS";
    private static final String LINK_TPS_RULE = "LINK_TPS_RULE";

    public void saveLink(TFirstLinkMnt firstLinkMnt) throws TROModuleException {
        String firstLinkName = firstLinkMnt.getLinkName();
        int linkExist = this.firstLinkMntDao.saveLinkExist(firstLinkName);
        if (linkExist > 0) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_FIRST_LINK_DUPICATE_EXCEPTION);
        }
        firstLinkMnt.setLinkId(String.valueOf(this.snowflake.next()));
        this.firstLinkMntDao.addLink(firstLinkMnt);
    }

    public PageInfo<TFirstLinkMnt> queryLinkList(String firstLinkName, String secondLinkName, Integer pageNum, Integer pageSize) throws TROModuleException {
        if (pageSize == null || pageNum == null) {
            throw new TROModuleException(TROErrorEnum.PAGE_PARAM_EXCEPTION);
        }
        if (pageSize != -1) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List firstLinkList = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)secondLinkName)) {
            firstLinkList = this.firstLinkMntDao.queryLinkList(firstLinkName);
        } else {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("firstLinkName", firstLinkName);
            paramMap.put("secondLinkName", secondLinkName);
            firstLinkList = this.firstLinkMntDao.queryLinkListByView(paramMap);
        }
        for (TFirstLinkMnt firstLink : firstLinkList) {
            String secondLinks = firstLink.getSecondLinks();
            String secondNames = this.transSecondLinkIdToName(firstLink, secondLinks, SECOND_LINKS);
            firstLink.setSecondLinks(secondNames);
            String linkTpsRule = firstLink.getLinkTpsRule();
            String linkTpsRuleName = this.transSecondLinkIdToName(firstLink, linkTpsRule, LINK_TPS_RULE);
            firstLink.setLinkTpsRule(linkTpsRuleName);
        }
        return new PageInfo(firstLinkList);
    }

    private String transSecondLinkIdToName(TFirstLinkMnt firstLink, String linkIds, String updateFiled) throws TROModuleException {
        if (linkIds == null) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_SECOND_LINKID_LIST_IS_NULL_EXCEPTION);
        }
        String[] linkIdArr = linkIds.split(",");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < linkIdArr.length; ++i) {
            String linkId = linkIdArr[i];
            TSecondLinkMnt secondLinkMnt = this.secondLinkDao.queryLinkByLinkId(linkId);
            if (secondLinkMnt == null) continue;
            sb.append(secondLinkMnt.getLinkName());
            sb.append(",");
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.substring(0, sb.length() - 1).toString();
    }

    public TFirstLinkMnt queryLinkByLinkId(String linkId) throws TROModuleException {
        TFirstLinkMnt firstLinkMnt = this.firstLinkMntDao.queryLinkByLinkId(linkId);
        return firstLinkMnt;
    }

    public Map<String, Object> queryLinkMapByLinkId(String linkId) throws TROModuleException {
        TFirstLinkMnt firstLinkMnt = this.firstLinkMntDao.queryLinkByLinkId(linkId);
        HashMap<String, Object> firstLinkMap = new HashMap<String, Object>();
        if (firstLinkMnt != null) {
            List secondLinkList = this.getLinkDetailByIds(firstLinkMnt.getSecondLinks());
            List linkTpsRuleList = this.getLinkDetailByIds(firstLinkMnt.getLinkTpsRule());
            firstLinkMap.put("linkId", firstLinkMnt.getLinkId());
            firstLinkMap.put("linkName", firstLinkMnt.getLinkName());
            firstLinkMap.put("linkTps", firstLinkMnt.getLinkTps());
            firstLinkMap.put("linkTpsRule", linkTpsRuleList);
            firstLinkMap.put("createTime", firstLinkMnt.getCreateTime());
            firstLinkMap.put("remark", firstLinkMnt.getRemark());
            firstLinkMap.put("secondLinks", secondLinkList);
            firstLinkMap.put("updateTime", firstLinkMnt.getUpdateTime());
            firstLinkMap.put("useYn", firstLinkMnt.getUseYn());
        }
        return firstLinkMap;
    }

    private List<Map<String, Object>> getLinkDetailByIds(String linkIds) {
        String[] linkIdArr = linkIds.split(",");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < linkIdArr.length; ++i) {
            String linkId = linkIdArr[i];
            TSecondLinkMnt secondLinkMnt = this.secondLinkDao.queryLinkByLinkId(linkId);
            if (secondLinkMnt == null) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            String linkName = secondLinkMnt.getLinkName();
            map.put("label", linkName);
            map.put("value", linkId);
            list.add(map);
        }
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteLinkByLinkIds(String linkIds) throws TROModuleException {
        List linkIdLists = Arrays.stream(linkIds.split(",")).filter(e -> StringUtils.isNotEmpty((CharSequence)e)).distinct().collect(Collectors.toList());
        this.firstLinkMntDao.deleteLinkByLinkIds(linkIdLists);
        List tFirstLinkMnts = this.firstLinkMntDao.queryFirstLinkByIds(linkIdLists);
    }

    public void updateLinkinfo(TFirstLinkMnt firstLinkMnt) throws TROModuleException {
        String linkId = firstLinkMnt.getLinkId();
        TFirstLinkMnt originFirstLinkMnt = this.firstLinkMntDao.queryLinkByLinkId(linkId);
        if (Objects.isNull(originFirstLinkMnt)) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_NOT_FOUND_FIRST_LINKID_EXCEPTION);
        }
        this.firstLinkMntDao.updateLink(firstLinkMnt);
    }

    public Map<String, Object> getLinkTopologyByFirstLinkId(String linkId) throws TROModuleException {
        TFirstLinkMnt firstLinkMnt = this.firstLinkMntDao.queryLinkByLinkId(linkId);
        if (firstLinkMnt != null) {
            String secondLinks = firstLinkMnt.getSecondLinks();
            String[] secondLinkIds = secondLinks.split(",");
            HashMap<String, Object> firstLinkMap = new HashMap<String, Object>();
            firstLinkMap.put("firstLinkId", firstLinkMnt.getLinkId());
            firstLinkMap.put("firstLinkName", firstLinkMnt.getLinkName());
            firstLinkMap.put("firstLinkTps", firstLinkMnt.getLinkTps());
            firstLinkMap.put("firstLinkTpsRule", firstLinkMnt.getLinkTpsRule());
            firstLinkMap.put("createTime", firstLinkMnt.getCreateTime());
            firstLinkMap.put("remark", firstLinkMnt.getRemark());
            firstLinkMap.put("secondLinks", firstLinkMnt.getSecondLinks());
            firstLinkMap.put("updateTime", firstLinkMnt.getUpdateTime());
            firstLinkMap.put("firstUseYn", firstLinkMnt.getUseYn());
            ArrayList secondLinkMntList = new ArrayList();
            for (int i = 0; i < secondLinkIds.length; ++i) {
                String secondLinkId = secondLinkIds[i];
                TSecondLinkMnt secondLinkMnt = this.secondLinkDao.queryLinkByLinkId(secondLinkId);
                if (secondLinkMnt == null) continue;
                HashMap<String, Object> secondLinkMap = new HashMap<String, Object>();
                secondLinkMap.put("secondLinkId", secondLinkMnt.getLinkId());
                secondLinkMap.put("secondLinkName", secondLinkMnt.getLinkName());
                secondLinkMap.put("secondAswanId", secondLinkMnt.getAswanId());
                secondLinkMap.put("baseLinks", secondLinkMnt.getBaseLinks());
                secondLinkMap.put("createTime", secondLinkMnt.getCreateTime());
                secondLinkMap.put("secondLinkTps", secondLinkMnt.getLinkTps());
                secondLinkMap.put("secondLinkTpsRule", secondLinkMnt.getLinkTpsRule());
                secondLinkMap.put("remark", secondLinkMnt.getRemark());
                secondLinkMap.put("updateTime", secondLinkMnt.getUpdateTime());
                secondLinkMap.put("secondUseYn", secondLinkMnt.getUseYn());
                List basicLinkList = this.getBasicLinkBySecondLinkId(secondLinkId);
                secondLinkMap.put("baseLinkList", basicLinkList);
                secondLinkMntList.add(secondLinkMap);
            }
            firstLinkMap.put("secondLinkList", secondLinkMntList);
            return firstLinkMap;
        }
        return Collections.EMPTY_MAP;
    }

    private List<Object> getBasicLinkBySecondLinkId(String linkId) {
        ArrayList<Object> baseLinkList = new ArrayList<Object>();
        List tSecondBasics = this.secondBasicDao.querySecondBasicLinkBySecondLinkId(linkId);
        if (tSecondBasics != null && tSecondBasics.size() > 0) {
            List blinkBankList = this.getBlinkBank(tSecondBasics);
            for (Integer linkBank : blinkBankList) {
                ArrayList<TLinkServiceMntVo> baseLinkBankList = new ArrayList<TLinkServiceMntVo>();
                for (TSecondBasic secondBasic : tSecondBasics) {
                    long basicLinkId;
                    TLinkServiceMntVo tLinkServiceMntVo;
                    int blinkBank = secondBasic.getBlinkBank();
                    if (blinkBank != linkBank || (tLinkServiceMntVo = this.tLinkMnDao.queryLinkByLinkId(String.valueOf(basicLinkId = secondBasic.getBasicLinkId()))) == null) continue;
                    HashMap<String, String> map = new HashMap<String, String>(5);
                    String linkName = tLinkServiceMntVo.getLinkName();
                    map.put("label", linkName);
                    map.put("value", (String)tLinkServiceMntVo);
                    baseLinkBankList.add(tLinkServiceMntVo);
                }
                baseLinkList.add(baseLinkBankList);
            }
        }
        return baseLinkList;
    }

    private List<Integer> getBlinkBank(List<TSecondBasic> tSecondBasics) {
        ArrayList<Integer> blinkBankList = new ArrayList<Integer>();
        for (TSecondBasic secondBasic : tSecondBasics) {
            int blinkBank = secondBasic.getBlinkBank();
            if (blinkBankList.contains(blinkBank)) continue;
            blinkBankList.add(blinkBank);
        }
        return blinkBankList;
    }

    public List<TFirstLinkMnt> queryLinkBySecondLinkId(String secondLinkId) {
        List tFirstLinkMnts = this.firstLinkMntDao.queryLinkBySecondLinkId(secondLinkId);
        return tFirstLinkMnts;
    }
}

