/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.entity.domain.entity.TAlarm;
import com.pamirs.tro.entity.domain.query.Result;
import com.pamirs.tro.entity.domain.query.ResultList;
import com.pamirs.tro.entity.domain.query.TAlarmQuery;
import io.shulie.tro.web.app.common.CommonService;
import io.shulie.tro.web.app.service.TAlarmService;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class TAlarmServiceImpl
extends CommonService
implements TAlarmService {
    public Result<Void> add(TAlarm tAlarm) {
        Result result = new Result();
        try {
            int count = this.tAlarmDao.insert((Object)tAlarm);
            if (count != 1) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setErrorMessage(TROErrorEnum.MONITOR_DB_ADD_EXCEPTION.getErrorMessage());
            }
        }
        catch (Exception e) {
            this.LOGGER.error(MessageFormat.format("error:{0},model:{1}", TROErrorEnum.MONITOR_DB_ADD_EXCEPTION.getErrorMessage(), JSON.toJSONString((Object)tAlarm)), (Throwable)e);
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage(TROErrorEnum.MONITOR_DB_ADD_EXCEPTION.getErrorMessage());
        }
        return result;
    }

    public Result<Void> modify(TAlarm tAlarm) {
        Result result = new Result();
        if (null == tAlarm || null == tAlarm.getId()) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            return result;
        }
        try {
            int count = this.tAlarmDao.update((Object)tAlarm);
            if (count != 1) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setErrorMessage(TROErrorEnum.MONITOR_DB_UPDATE_EXCEPTION.getErrorMessage());
            }
        }
        catch (Exception e) {
            this.LOGGER.error(MessageFormat.format("error:{0},model:{1}", TROErrorEnum.MONITOR_DB_UPDATE_EXCEPTION.getErrorMessage(), JSON.toJSONString((Object)tAlarm)), (Throwable)e);
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage(TROErrorEnum.MONITOR_DB_UPDATE_EXCEPTION.getErrorMessage());
        }
        return result;
    }

    public Result<Void> deleteById(Long id) {
        Result result = new Result();
        if (null == id) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            return result;
        }
        try {
            int count = this.tAlarmDao.delete(id);
            if (count != 1) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setErrorMessage(TROErrorEnum.MONITOR_DB_DELETE_EXCEPTION.getErrorMessage());
            }
        }
        catch (Exception e) {
            this.LOGGER.error(MessageFormat.format("error:{0},id:{1}", TROErrorEnum.MONITOR_DB_DELETE_EXCEPTION.getErrorMessage(), id), (Throwable)e);
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage(TROErrorEnum.MONITOR_DB_DELETE_EXCEPTION.getErrorMessage());
        }
        return result;
    }

    public ResultList<TAlarm> queryListByQuery(TAlarmQuery query) {
        ResultList resultList = new ResultList();
        try {
            query.setOrderBy("create_time desc");
            List goodsDOList = this.tAlarmDao.selectList(query);
            long count = this.tAlarmDao.selectListCount(query);
            resultList.setDatalist((Collection)goodsDOList);
            resultList.setTotal(count);
        }
        catch (Exception e) {
            this.LOGGER.error(MessageFormat.format("error:{0},query:{1}", TROErrorEnum.MONITOR_DB_QUERYLIST_EXCEPTION.getErrorMessage(), JSON.toJSONString((Object)query)), (Throwable)e);
            resultList.setSuccess(Boolean.FALSE.booleanValue());
            resultList.setErrorMessage(TROErrorEnum.MONITOR_DB_QUERYLIST_EXCEPTION.getErrorMessage());
        }
        return resultList;
    }

    public Result<TAlarm> queryOneById(Long id) {
        Result result = new Result();
        if (null == id) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            return result;
        }
        try {
            TAlarm tAlarm = (TAlarm)this.tAlarmDao.selectOneById(id);
            result.setData((Object)tAlarm);
        }
        catch (Exception e) {
            this.LOGGER.error(MessageFormat.format("error:{0},id:{1}", TROErrorEnum.MONITOR_DB_QUERY_EXCEPTION.getErrorMessage(), id), (Throwable)e);
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage(TROErrorEnum.MONITOR_DB_QUERY_EXCEPTION.getErrorMessage());
        }
        return result;
    }
}

