/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pamirs.tro.common.util.MD5Util;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.web.amdb.api.ApplicationEntranceClient;
import io.shulie.tro.web.amdb.enums.MiddlewareTypeGroupEnum;
import io.shulie.tro.web.app.agent.vo.ShadowConsumerVO;
import io.shulie.tro.web.app.cache.AgentConfigCacheManager;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.request.application.ShadowConsumerCreateRequest;
import io.shulie.tro.web.app.request.application.ShadowConsumerQueryRequest;
import io.shulie.tro.web.app.request.application.ShadowConsumerUpdateRequest;
import io.shulie.tro.web.app.request.application.ShadowConsumerUpdateUserRequest;
import io.shulie.tro.web.app.request.application.ShadowConsumersOperateRequest;
import io.shulie.tro.web.app.response.application.ShadowConsumerResponse;
import io.shulie.tro.web.app.service.ShadowConsumerService;
import io.shulie.tro.web.common.enums.shadow.ShadowMqConsumerType;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.dao.application.ShadowMqConsumerDAO;
import io.shulie.tro.web.data.mapper.mysql.ShadowMqConsumerMapper;
import io.shulie.tro.web.data.model.mysql.ShadowMqConsumerEntity;
import io.shulie.tro.web.data.result.application.ApplicationDetailResult;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShadowConsumerServiceImpl
implements ShadowConsumerService {
    private static final Logger log = LoggerFactory.getLogger(ShadowConsumerServiceImpl.class);
    @Resource
    private ShadowMqConsumerMapper shadowMqConsumerMapper;
    @Autowired
    private ApplicationDAO applicationDAO;
    @Autowired
    private ApplicationEntranceClient applicationEntranceClient;
    @Autowired
    private AgentConfigCacheManager agentConfigCacheManager;
    @Autowired
    private ShadowMqConsumerDAO shadowMqConsumerDAO;

    public List<ShadowConsumerResponse> getShadowConsumersByApplicationId(long applicationId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(ShadowMqConsumerEntity::getApplicationId, (Object)applicationId);
        query.eq(ShadowMqConsumerEntity::getStatus, (Object)1);
        List shadowMqConsumerEntities = this.shadowMqConsumerMapper.selectList((Wrapper)query);
        if (CollectionUtils.isEmpty((Collection)shadowMqConsumerEntities)) {
            return Lists.newArrayList();
        }
        return shadowMqConsumerEntities.stream().map(entry -> {
            ShadowConsumerResponse response = new ShadowConsumerResponse();
            response.setId(entry.getId());
            response.setUnionId(null);
            response.setType(ShadowMqConsumerType.of((String)entry.getType()));
            response.setTopicGroup(entry.getTopicGroup());
            response.setGmtCreate(entry.getCreateTime());
            response.setGmtUpdate(entry.getUpdateTime());
            response.setEnabled(Boolean.valueOf(entry.getStatus() == 1));
            response.setDeleted(entry.getDeleted());
            response.setFeature(entry.getFeature());
            return response;
        }).collect(Collectors.toList());
    }

    public ShadowConsumerResponse getMqConsumerById(Long id) {
        ShadowMqConsumerEntity entity = (ShadowMqConsumerEntity)this.shadowMqConsumerMapper.selectById((Serializable)id);
        if (entity == null) {
            return null;
        }
        ShadowConsumerResponse response = new ShadowConsumerResponse();
        response.setId(entity.getId());
        response.setUnionId(null);
        response.setType(ShadowMqConsumerType.of((String)entity.getType()));
        response.setTopicGroup(entity.getTopicGroup());
        response.setEnabled(Boolean.valueOf(entity.getStatus() == 1));
        response.setGmtCreate(entity.getCreateTime());
        response.setGmtUpdate(entity.getUpdateTime());
        return response;
    }

    public PagingList<ShadowConsumerResponse> pageMqConsumers(ShadowConsumerQueryRequest request) {
        ApplicationDetailResult application = this.applicationDAO.getApplicationById(request.getApplicationId());
        if (application == null) {
            throw new RuntimeException(String.format("\u5e94\u7528id:%s\u5bf9\u5e94\u7684\u5e94\u7528\u4e0d\u5b58\u5728", request.getApplicationId()));
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)request.getTopicGroup())) {
            lambdaQueryWrapper.like(ShadowMqConsumerEntity::getTopicGroup, (Object)request.getTopicGroup());
        }
        if (request.getType() != null) {
            lambdaQueryWrapper.eq(ShadowMqConsumerEntity::getType, (Object)request.getType().name());
        }
        if (request.getEnabled() != null) {
            lambdaQueryWrapper.eq(ShadowMqConsumerEntity::getStatus, (Object)(request.getEnabled() != false ? 1 : 0));
        }
        if (CollectionUtils.isNotEmpty((Collection)RestContext.getQueryAllowUserIdList())) {
            lambdaQueryWrapper.in(ShadowMqConsumerEntity::getUserId, (Collection)RestContext.getQueryAllowUserIdList());
        }
        lambdaQueryWrapper.eq(ShadowMqConsumerEntity::getApplicationId, (Object)request.getApplicationId());
        lambdaQueryWrapper.eq(ShadowMqConsumerEntity::getDeleted, (Object)0);
        List dbResult = this.shadowMqConsumerMapper.selectList((Wrapper)lambdaQueryWrapper);
        List amdbResult = Lists.newArrayList();
        if (request.getEnabled() == null) {
            amdbResult = this.queryAmdbDefaultEntrances(request, application.getApplicationName());
        }
        List totalResult = this.mergeResult(amdbResult, dbResult);
        totalResult = this.filterResult(request, totalResult);
        return this.splitPage(request, totalResult);
    }

    private List<ShadowConsumerResponse> filterResult(ShadowConsumerQueryRequest request, List<ShadowConsumerResponse> totalResult) {
        if (request.getEnabled() != null) {
            totalResult = request.getEnabled() != false ? totalResult.stream().filter(ShadowConsumerResponse::getEnabled).collect(Collectors.toList()) : totalResult.stream().filter(e -> e.getEnabled() == false).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getTopicGroup())) {
            totalResult = totalResult.stream().filter(e -> e.getTopicGroup().contains(request.getTopicGroup())).collect(Collectors.toList());
        }
        if (request.getType() != null) {
            totalResult = totalResult.stream().filter(e -> e.getType() == request.getType()).collect(Collectors.toList());
        }
        return totalResult;
    }

    private List<ShadowConsumerResponse> mergeResult(List<ShadowMqConsumerEntity> amdbResult, List<ShadowMqConsumerEntity> dbResult) {
        List allowUpdateUserIdList = RestContext.getUpdateAllowUserIdList();
        List allowDeleteUserIdList = RestContext.getDeleteAllowUserIdList();
        List allowEnableDisableUserIdList = RestContext.getEnableDisableAllowUserIdList();
        Map<Object, Object> amdbMap = new HashMap();
        if (CollectionUtils.isNotEmpty(amdbResult)) {
            amdbMap = amdbResult.stream().map(e -> {
                ShadowConsumerResponse response = new ShadowConsumerResponse();
                response.setUnionId(MD5Util.getMD5((String)(e.getApplicationName() + "#" + e.getTopicGroup() + "#" + e.getType())));
                response.setType(ShadowMqConsumerType.of((String)e.getType()));
                response.setTopicGroup(e.getTopicGroup());
                response.setEnabled(Boolean.valueOf(e.getStatus() == 1));
                response.setGmtCreate(e.getCreateTime());
                response.setGmtUpdate(e.getUpdateTime());
                response.setCanEdit(Boolean.valueOf(false));
                response.setCanRemove(Boolean.valueOf(false));
                response.setCanEnableDisable(Boolean.valueOf(false));
                return response;
            }).collect(Collectors.toMap(ShadowConsumerResponse::getUnionId, e -> e, (oV, nV) -> nV));
        }
        Map<Object, Object> dbMap = new HashMap();
        if (CollectionUtils.isNotEmpty(dbResult)) {
            dbMap = dbResult.stream().map(e -> {
                ShadowConsumerResponse response = new ShadowConsumerResponse();
                response.setId(e.getId());
                response.setUnionId(MD5Util.getMD5((String)(e.getApplicationName() + "#" + e.getTopicGroup() + "#" + e.getType())));
                response.setType(ShadowMqConsumerType.of((String)e.getType()));
                response.setTopicGroup(e.getTopicGroup());
                response.setEnabled(Boolean.valueOf(e.getStatus() == 1));
                response.setGmtCreate(e.getCreateTime());
                response.setGmtUpdate(e.getUpdateTime());
                if (CollectionUtils.isNotEmpty((Collection)allowEnableDisableUserIdList)) {
                    response.setCanEnableDisable(Boolean.valueOf(allowEnableDisableUserIdList.contains(e.getUserId())));
                }
                if (CollectionUtils.isNotEmpty((Collection)allowDeleteUserIdList)) {
                    response.setCanRemove(Boolean.valueOf(allowDeleteUserIdList.contains(e.getUserId())));
                }
                if (CollectionUtils.isNotEmpty((Collection)allowUpdateUserIdList)) {
                    response.setCanEdit(Boolean.valueOf(allowUpdateUserIdList.contains(e.getUserId())));
                }
                return response;
            }).collect(Collectors.toMap(ShadowConsumerResponse::getUnionId, e -> e, (oV, nV) -> nV));
        }
        for (Map.Entry dbEntry : dbMap.entrySet()) {
            amdbMap.merge(dbEntry.getKey(), dbEntry.getValue(), (amdbValue, dbValue) -> {
                dbValue.setCanEdit(Boolean.valueOf(false));
                dbValue.setCanRemove(Boolean.valueOf(false));
                dbValue.setCanEnableDisable(dbValue.getCanEnableDisable());
                return dbValue;
            });
        }
        return Lists.newArrayList(amdbMap.values());
    }

    private List<ShadowMqConsumerEntity> queryAmdbDefaultEntrances(ShadowConsumerQueryRequest request, String applicationName) {
        List mqTopicGroups = this.applicationEntranceClient.getMqTopicGroups(applicationName);
        if (CollectionUtils.isEmpty((Collection)mqTopicGroups)) {
            return Lists.newArrayList();
        }
        return mqTopicGroups.stream().map(mqTopicGroup -> {
            ShadowMqConsumerEntity shadowMqConsumerEntity = new ShadowMqConsumerEntity();
            shadowMqConsumerEntity.setTopicGroup(mqTopicGroup.getServiceName() + "#" + mqTopicGroup.getMethodName());
            shadowMqConsumerEntity.setType(MiddlewareTypeGroupEnum.getMiddlewareGroupType((String)mqTopicGroup.getMiddlewareName()).getType());
            shadowMqConsumerEntity.setApplicationId(request.getApplicationId());
            shadowMqConsumerEntity.setApplicationName(applicationName);
            shadowMqConsumerEntity.setStatus(Integer.valueOf(0));
            shadowMqConsumerEntity.setCustomerId(RestContext.getUser().getCustomerId());
            shadowMqConsumerEntity.setUserId(RestContext.getUser().getId());
            shadowMqConsumerEntity.setDeleted(Integer.valueOf(0));
            return shadowMqConsumerEntity;
        }).collect(Collectors.toList());
    }

    private PagingList<ShadowConsumerResponse> splitPage(ShadowConsumerQueryRequest request, List<ShadowConsumerResponse> responses) {
        responses.sort((o1, o2) -> {
            if (o1.getGmtCreate() != null && o2.getGmtCreate() != null) {
                int firstSort = -o1.getGmtCreate().compareTo(o2.getGmtCreate());
                if (firstSort == 0) {
                    return -o1.getId().compareTo(o2.getId());
                }
                return firstSort;
            }
            return 1;
        });
        int total = responses.size();
        int start = Math.min(request.getOffset(), total);
        int end = Math.min(request.getOffset() + request.getPageSize(), total);
        responses = responses.subList(start, end);
        return PagingList.of(responses, (long)total);
    }

    @Transactional(rollbackFor={Throwable.class})
    public void createMqConsumers(ShadowConsumerCreateRequest request) {
        if (!request.getTopicGroup().contains("#")) {
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\uff0cGroup\u548cTopic\u4ee5#\u53f7\u62fc\u63a5");
        }
        String[] split = request.getTopicGroup().split("#");
        if (split.length != 2) {
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\uff0cGroup\u548cTopic\u4e2d\u95f4\u5305\u542b\u8d85\u8fc71\u4e2a#");
        }
        ApplicationDetailResult application = this.applicationDAO.getApplicationById(request.getApplicationId());
        if (application == null) {
            throw new RuntimeException(String.format("\u5e94\u7528id:%s\u5bf9\u5e94\u7684\u5e94\u7528\u4e0d\u5b58\u5728", request.getApplicationId()));
        }
        List exists = this.getExists(request.getTopicGroup(), request.getApplicationId(), request.getType());
        if (CollectionUtils.isNotEmpty((Collection)exists)) {
            throw new RuntimeException(String.format("\u7c7b\u578b\u4e3a[%s]\uff0c\u5bf9\u5e94\u7684[%s]\u5df2\u5b58\u5728", request.getType().name(), request.getTopicGroup()));
        }
        ApplicationDetailResult applicationDetailResult = this.applicationDAO.getApplicationById(request.getApplicationId());
        OperationLogContextHolder.operationType((String)"\u65b0\u589e");
        OperationLogContextHolder.addVars((String)"consumerType", (String)request.getType().name());
        OperationLogContextHolder.addVars((String)"topicGroup", (String)request.getTopicGroup());
        ShadowMqConsumerEntity shadowMqConsumerEntity = new ShadowMqConsumerEntity();
        shadowMqConsumerEntity.setTopicGroup(request.getTopicGroup());
        shadowMqConsumerEntity.setType(request.getType().name());
        shadowMqConsumerEntity.setApplicationId(application.getApplicationId());
        shadowMqConsumerEntity.setApplicationName(application.getApplicationName());
        Integer status = request.getStatus() == null ? 0 : request.getStatus();
        shadowMqConsumerEntity.setStatus(status);
        shadowMqConsumerEntity.setDeleted(Integer.valueOf(0));
        shadowMqConsumerEntity.setCustomerId(applicationDetailResult.getCustomerId());
        shadowMqConsumerEntity.setUserId(applicationDetailResult.getUserId());
        this.shadowMqConsumerMapper.insert((Object)shadowMqConsumerEntity);
        this.agentConfigCacheManager.evictShadowConsumer(application.getApplicationName());
    }

    @Transactional(rollbackFor={Throwable.class})
    public void updateMqConsumers(ShadowConsumerUpdateRequest request) {
        if (!request.getTopicGroup().contains("#")) {
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\uff0cGroup\u548cTopic\u4ee5#\u53f7\u62fc\u63a5");
        }
        String[] split = request.getTopicGroup().split("#");
        if (split.length != 2) {
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\uff0cGroup\u548cTopic\u4e2d\u95f4\u5305\u542b\u8d85\u8fc71\u4e2a#");
        }
        ApplicationDetailResult application = this.applicationDAO.getApplicationById(request.getApplicationId());
        if (application == null) {
            throw new RuntimeException(String.format("\u5e94\u7528id:%s\u5bf9\u5e94\u7684\u5e94\u7528\u4e0d\u5b58\u5728", request.getApplicationId()));
        }
        List exists = this.getExists(request.getTopicGroup(), request.getApplicationId(), request.getType());
        if (CollectionUtils.isNotEmpty(exists = exists.stream().filter(item -> !item.getId().equals(request.getId())).collect(Collectors.toList()))) {
            throw new RuntimeException(String.format("\u7c7b\u578b\u4e3a[%s]\uff0c\u5bf9\u5e94\u7684[%s]\u5df2\u5b58\u5728", request.getType().name(), request.getTopicGroup()));
        }
        OperationLogContextHolder.operationType((String)"\u7f16\u8f91");
        OperationLogContextHolder.addVars((String)"consumerType", (String)request.getType().name());
        OperationLogContextHolder.addVars((String)"topicGroup", (String)request.getTopicGroup());
        ShadowMqConsumerEntity updateEntity = new ShadowMqConsumerEntity();
        updateEntity.setId(request.getId());
        updateEntity.setTopicGroup(request.getTopicGroup());
        updateEntity.setType(request.getType().name());
        updateEntity.setStatus(request.getStatus());
        this.shadowMqConsumerMapper.updateById((Object)updateEntity);
        this.agentConfigCacheManager.evictShadowConsumer(application.getApplicationName());
    }

    @Transactional(rollbackFor={Throwable.class})
    public void deleteMqConsumers(List<Long> ids) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(ShadowMqConsumerEntity::getId, ids);
        lambdaQueryWrapper.eq(ShadowMqConsumerEntity::getDeleted, (Object)0);
        List shadowMqConsumerEntities = this.shadowMqConsumerMapper.selectList((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)shadowMqConsumerEntities)) {
            return;
        }
        Long applicationId = ((ShadowMqConsumerEntity)shadowMqConsumerEntities.get(0)).getApplicationId();
        ApplicationDetailResult application = this.applicationDAO.getApplicationById(applicationId);
        if (application == null) {
            throw new RuntimeException(String.format("\u5e94\u7528id:%s\u5bf9\u5e94\u7684\u5e94\u7528\u4e0d\u5b58\u5728", applicationId));
        }
        shadowMqConsumerEntities.forEach(mq -> {
            OperationLogContextHolder.operationType((String)"\u5220\u9664");
            OperationLogContextHolder.addVars((String)"consumerType", (String)mq.getType());
            OperationLogContextHolder.addVars((String)"topicGroup", (String)mq.getTopicGroup());
            this.shadowMqConsumerDAO.removeById((Serializable)mq.getId());
        });
        this.agentConfigCacheManager.evictShadowConsumer(application.getApplicationName());
    }

    public void operateMqConsumers(ShadowConsumersOperateRequest requests) {
        ApplicationDetailResult application = this.applicationDAO.getApplicationById(requests.getApplicationId());
        if (application == null) {
            throw new RuntimeException(String.format("\u5e94\u7528id:%s\u5bf9\u5e94\u7684\u5e94\u7528\u4e0d\u5b58\u5728", requests.getApplicationId()));
        }
        if (requests.getEnable().booleanValue()) {
            OperationLogContextHolder.operationType((String)"\u542f\u7528");
            requests.getRequests().forEach(request -> {
                if (request.getId() != null) {
                    ShadowMqConsumerEntity entity = new ShadowMqConsumerEntity();
                    entity.setId(request.getId());
                    entity.setStatus(Integer.valueOf(1));
                    this.shadowMqConsumerMapper.updateById((Object)entity);
                } else {
                    if (request.getTopicGroup() == null || request.getType() == null) {
                        throw new RuntimeException("\u542f\u7528\u5931\u8d25\uff0c\u7f3a\u5c11\u5bf9\u5e94\u7684\u53c2\u6570");
                    }
                    ShadowMqConsumerEntity shadowMqConsumerEntity = new ShadowMqConsumerEntity();
                    shadowMqConsumerEntity.setTopicGroup(request.getTopicGroup());
                    shadowMqConsumerEntity.setType(request.getType().name());
                    shadowMqConsumerEntity.setApplicationId(application.getApplicationId());
                    shadowMqConsumerEntity.setApplicationName(application.getApplicationName());
                    shadowMqConsumerEntity.setStatus(Integer.valueOf(1));
                    shadowMqConsumerEntity.setDeleted(Integer.valueOf(0));
                    shadowMqConsumerEntity.setCustomerId(RestContext.getUser().getCustomerId());
                    shadowMqConsumerEntity.setUserId(RestContext.getUser().getId());
                    try {
                        this.shadowMqConsumerMapper.insert((Object)shadowMqConsumerEntity);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        } else {
            OperationLogContextHolder.operationType((String)"\u7981\u7528");
            List ids = requests.getRequests().stream().map(ShadowConsumersOperateRequest.ShadowConsumerOperateRequest::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(ShadowMqConsumerEntity::getId, ids);
            lambdaQueryWrapper.eq(ShadowMqConsumerEntity::getDeleted, (Object)0);
            List shadowMqConsumerEntities = this.shadowMqConsumerMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)shadowMqConsumerEntities)) {
                for (ShadowMqConsumerEntity shadowMqConsumerEntity : shadowMqConsumerEntities) {
                    ShadowMqConsumerEntity updateEntity = new ShadowMqConsumerEntity();
                    updateEntity.setId(shadowMqConsumerEntity.getId());
                    updateEntity.setStatus(Integer.valueOf(0));
                    this.shadowMqConsumerMapper.updateById((Object)updateEntity);
                }
            }
        }
        this.agentConfigCacheManager.evictShadowConsumer(application.getApplicationName());
    }

    public List<ShadowConsumerVO> agentSelect(String appName) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(ShadowMqConsumerEntity::getDeleted, (Object)0);
        lambdaQueryWrapper.eq(ShadowMqConsumerEntity::getStatus, (Object)1);
        lambdaQueryWrapper.eq(ShadowMqConsumerEntity::getApplicationName, (Object)appName);
        List entities = this.shadowMqConsumerMapper.selectList((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return Lists.newArrayList();
        }
        Map<String, List<ShadowMqConsumerEntity>> collect = entities.stream().collect(Collectors.groupingBy(ShadowMqConsumerEntity::getType));
        if (MapUtils.isEmpty(collect)) {
            return Lists.newArrayList();
        }
        return collect.entrySet().stream().map(entity -> {
            ShadowConsumerVO shadowConsumerVO = new ShadowConsumerVO();
            shadowConsumerVO.setType((String)entity.getKey());
            HashMap topicGroupMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty((Collection)((Collection)entity.getValue()))) {
                for (ShadowMqConsumerEntity shadowMqConsumerEntity : (List)entity.getValue()) {
                    String[] topicGroup = shadowMqConsumerEntity.getTopicGroup().split("#");
                    Set groups = (Set)topicGroupMap.get(topicGroup[0]);
                    if (groups == null) {
                        topicGroupMap.put(topicGroup[0], Sets.newHashSet((Object[])new String[]{topicGroup[1]}));
                        continue;
                    }
                    groups.add(topicGroup[1]);
                }
            }
            shadowConsumerVO.setTopicGroups((Map)topicGroupMap);
            return shadowConsumerVO;
        }).collect(Collectors.toList());
    }

    public int allocationUser(ShadowConsumerUpdateUserRequest request) {
        if (Objects.isNull(request.getApplicationId())) {
            return 0;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ShadowMqConsumerEntity::getApplicationId, (Object)request.getApplicationId());
        List shadowMqConsumerEntityList = this.shadowMqConsumerMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)shadowMqConsumerEntityList)) {
            for (ShadowMqConsumerEntity entity : shadowMqConsumerEntityList) {
                entity.setUserId(request.getUserId());
                this.shadowMqConsumerMapper.updateById((Object)entity);
            }
        }
        return 0;
    }

    private List<ShadowMqConsumerEntity> getExists(String topicGroup, Long applicationId, ShadowMqConsumerType type) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(ShadowMqConsumerEntity::getTopicGroup, (Object)topicGroup);
        lambdaQueryWrapper.eq(ShadowMqConsumerEntity::getType, (Object)type.name());
        lambdaQueryWrapper.eq(ShadowMqConsumerEntity::getApplicationId, (Object)applicationId);
        lambdaQueryWrapper.eq(ShadowMqConsumerEntity::getDeleted, (Object)0);
        return this.shadowMqConsumerMapper.selectList((Wrapper)lambdaQueryWrapper);
    }
}

