/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.constant.InterfaceLevelEnum;
import com.pamirs.tro.common.constant.LinkBottleneckLevelEnum;
import com.pamirs.tro.common.constant.LinkBottleneckTypeEnum;
import com.pamirs.tro.common.constant.PageLevelEnum;
import com.pamirs.tro.common.util.DateUtils;
import com.pamirs.tro.common.util.HttpUtils;
import com.pamirs.tro.common.util.http.DateUtil;
import com.pamirs.tro.entity.dao.bottleneck.TLinkBottleneckDao;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.dao.confcenter.TLinkTopologyInfoDao;
import com.pamirs.tro.entity.dao.confcenter.TWListMntDao;
import com.pamirs.tro.entity.dao.transparentflow.TPressureTimeRecordDao;
import com.pamirs.tro.entity.domain.entity.LinkBottleneck;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import com.pamirs.tro.entity.domain.entity.TLinkTopologyInfo;
import com.pamirs.tro.entity.domain.entity.TPressureTimeRecord;
import com.pamirs.tro.entity.domain.entity.TWList;
import io.shulie.tro.web.app.service.LinkBottleneckService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class LinkBottleneckServiceImpl
implements LinkBottleneckService {
    private static Logger logger = LoggerFactory.getLogger(LinkBottleneckServiceImpl.class);
    @Autowired
    private TLinkBottleneckDao TLinkBottleneckDao;
    @Autowired
    private TApplicationMntDao tApplicationMntDao;
    @Autowired
    private TLinkTopologyInfoDao tLinkTopologyInfoDao;
    @Autowired
    private TPressureTimeRecordDao tPressureTimeRecordDao;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private TWListMntDao twListMntDao;
    @Value(value="${aops.ip}")
    private String AOPS_IP;
    @Value(value="${aops.host}")
    private String BOTTLENECK_URL;
    @Value(value="${pradar.open.web.ip}")
    private String PRADAR_IP;
    @Value(value="${stp.web.ip}")
    private String STP_WEB_IP;
    @Value(value="${stp.web.job}")
    private String STP_WEB_JOB_URL;
    @Value(value="${pradar.open.web.avgTpsRt}")
    private String RT_TPS_URL;
    @Value(value="${pradar.open.web.rtCount}")
    private String RT_COUNT_URL;
    private int preNSecond = 60;
    private int pageSize = 20;
    private int mqSerious = 1000000;
    private int mqGeneral = 500000;

    public void handleLinkBottleneck() {
        try {
            List apps = Optional.ofNullable(this.tApplicationMntDao.queryApplicationdata()).orElse(Lists.newArrayList());
            if (CollectionUtils.isEmpty((Collection)apps)) {
                return;
            }
            Set appNames = apps.stream().map(app -> ObjectUtils.toString(app.get("applicationName"))).collect(Collectors.toSet());
            JSONObject dataObject = Optional.ofNullable(this.getLinkBottleneck(new ArrayList(appNames))).orElse(new JSONObject());
            ArrayList insertList = Lists.newArrayList();
            ArrayList noAppNames = Lists.newArrayList();
            String mqValue = ObjectUtils.toString((Object)this.redisTemplate.opsForValue().get((Object)"calMq"));
            for (String appName : dataObject.keySet()) {
                JSONArray valueArray = dataObject.getJSONArray(appName);
                if (CollectionUtils.isEmpty((Collection)valueArray)) {
                    noAppNames.add(appName);
                    continue;
                }
                ArrayList loadSeriousList = Lists.newArrayList();
                HashMap loadSeriousTextMap = Maps.newHashMap();
                loadSeriousTextMap.put("text", new StringBuffer());
                for (int k = 0; k < valueArray.size(); ++k) {
                    JSONObject valueObject = valueArray.getJSONObject(k);
                    int loadLevel = this.calLoadExeceptionLevel(valueObject, (Map)loadSeriousTextMap);
                    if (loadLevel == LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_SERIOUS.getCode()) {
                        loadSeriousList.add(valueObject);
                    }
                    if (StringUtils.isNotBlank((String)mqValue)) continue;
                    ArrayList links = Lists.newArrayList();
                    this.calAsynLevel(valueObject, (List)links, appName);
                    if (!CollectionUtils.isNotEmpty((Collection)links)) continue;
                    insertList.addAll(links);
                }
                if (!CollectionUtils.isNotEmpty((Collection)loadSeriousList)) continue;
                this.buildBottleneck((List)insertList, appName, (List)loadSeriousList, LinkBottleneckTypeEnum.BOTTLENECK_LOAD_EXECEPTION.getCode(), LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_SERIOUS.getCode(), loadSeriousTextMap.getOrDefault("text", new StringBuffer()).toString());
            }
            if (StringUtils.isBlank((String)mqValue)) {
                this.redisTemplate.opsForValue().set((Object)"calMq", (Object)"calMq", 5L, TimeUnit.MINUTES);
            }
            this.calTpsRt((List)insertList);
            if (CollectionUtils.isNotEmpty((Collection)insertList)) {
                this.batchInsert((List)insertList);
            }
            if (CollectionUtils.isNotEmpty((Collection)noAppNames)) {
                logger.error("\u672a\u91c7\u96c6\u5230\u6570\u636e\u5e94\u7528:" + JSONObject.toJSONString((Object)noAppNames));
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void calJob(List<LinkBottleneck> insertList) {
        TLinkTopologyInfo record = new TLinkTopologyInfo();
        ArrayList entranceTypes = Lists.newArrayList();
        entranceTypes.add("JOB");
        record.setEntranceTypes((List)entranceTypes);
        List list = this.tLinkTopologyInfoDao.list(record);
        HashMap duplicateMap = Maps.newHashMap();
        for (int i = 0; i < list.size(); ++i) {
            TLinkTopologyInfo info = (TLinkTopologyInfo)list.get(i);
            String appName = info.getApplicationName();
            String linkEntrance = info.getLinkEntrance();
            String key = appName + linkEntrance;
            if (duplicateMap.containsKey(key)) continue;
            duplicateMap.put(key, key);
            Date endTime = new Date();
            HashMap queryMap = Maps.newHashMap();
            queryMap.put("appName", appName);
            queryMap.put("targetCode", linkEntrance);
            queryMap.put("startTime", DateUtil.getYYYYMMDDHHMMSS((Date)endTime));
            queryMap.put("endTime", DateUtil.getYYYYMMDDHHMMSS((Date)endTime));
            JSONObject presObject = this.getPostData(this.STP_WEB_IP + this.STP_WEB_JOB_URL, (Map)queryMap);
            Double jobSum = Double.parseDouble(ObjectUtils.toString((Object)presObject.getOrDefault((Object)"sum", (Object)"0")));
            TApplicationMnt app = Optional.ofNullable(this.tApplicationMntDao.queryApplicationinfoByName(appName)).orElse(new TApplicationMnt());
            if (StringUtils.isBlank((String)(app.getApplicationId() + ""))) continue;
            HashMap querytwMap = Maps.newHashMap();
            querytwMap.put("appId", "" + app.getApplicationId());
            querytwMap.put("url", linkEntrance);
            TWList twList = Optional.ofNullable(this.twListMntDao.getWListByParam((Map)querytwMap)).orElse(new TWList());
            String interval = twList.getJobInterval();
            int times = this.getTimesByInterval(interval);
            if (times == 0) continue;
            Double topTps = this.getTopTps((Map)queryMap);
            Double dataSum = topTps * (double)times * 60.0;
            if (BigDecimal.valueOf(jobSum).compareTo(BigDecimal.valueOf(dataSum)) < 0) continue;
            String text = linkEntrance + " \u79ef\u538b\u6570\u636e\u91cf\u8d85\u8fc7" + jobSum;
            LinkBottleneck jobEntity = new LinkBottleneck();
            jobEntity.setAppName(appName);
            jobEntity.setBottleneckType(LinkBottleneckTypeEnum.BOTTLENECK_ASYN.getCode());
            jobEntity.setBottleneckLevel(LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_SERIOUS.getCode());
            jobEntity.setText(text);
            jobEntity.setKeyWords(linkEntrance);
            jobEntity.setContent(JSONObject.toJSONString((Object)queryMap));
            insertList.add(jobEntity);
        }
    }

    private Double getTopTps(Map<String, Object> queryMap) {
        return 0.0;
    }

    private int getTimesByInterval(String interval) {
        int defaultTimes = 0;
        if (StringUtils.isBlank((String)interval)) {
            return defaultTimes;
        }
        int inter = Integer.parseInt(interval);
        if (inter > 60) {
            return defaultTimes;
        }
        if (inter <= 1) {
            return 10;
        }
        if (inter <= 5) {
            return 30;
        }
        if (inter <= 15) {
            return 60;
        }
        if (inter <= 60) {
            return 120;
        }
        return defaultTimes;
    }

    private void batchInsert(List<LinkBottleneck> insertList) {
        insertList.stream().forEach(linkBottleneck -> {
            try {
                this.TLinkBottleneckDao.insertSelective(linkBottleneck);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        });
    }

    private void calTpsRt(List<LinkBottleneck> insertList) {
        TPressureTimeRecord timeRecord = Optional.ofNullable(this.tPressureTimeRecordDao.queryLatestPressureTime()).orElse(new TPressureTimeRecord());
        if (StringUtils.isNotBlank((String)timeRecord.getStartTime())) {
            Date currentTime;
            String value = ObjectUtils.toString((Object)this.redisTemplate.opsForValue().get((Object)"calTpsRt"));
            if (StringUtils.isNotBlank((String)value)) {
                return;
            }
            Date pressureTime = DateUtil.getDate((String)timeRecord.getStartTime());
            Long second = DateUtil.getUntilSecond((Date)pressureTime, (Date)(currentTime = new Date()));
            if (second > 2160L) {
                TLinkTopologyInfo record = new TLinkTopologyInfo();
                ArrayList entranceTypes = Lists.newArrayList();
                entranceTypes.add("http");
                entranceTypes.add("DUBBO");
                record.setEntranceTypes((List)entranceTypes);
                List list = this.tLinkTopologyInfoDao.list(record);
                HashMap duplicateMap = Maps.newHashMap();
                for (int i = 0; i < list.size(); ++i) {
                    int rtTime;
                    TApplicationMnt app;
                    TLinkTopologyInfo info = (TLinkTopologyInfo)list.get(i);
                    String appName = info.getApplicationName();
                    String url = info.getLinkEntrance();
                    String key = appName + url;
                    if (duplicateMap.containsKey(key)) continue;
                    duplicateMap.put(key, key);
                    Date startPreTime = DateUtil.afterXMinuteDate((Date)pressureTime, (long)30L);
                    Date endTime = new Date();
                    HashMap queryMap = Maps.newHashMap();
                    queryMap.put("appName", appName);
                    queryMap.put("event", url);
                    queryMap.put("ptFlag", false);
                    queryMap.put("startTime", DateUtil.getYYYYMMDDHHMMSS((Date)startPreTime));
                    queryMap.put("endTime", DateUtil.getYYYYMMDDHHMMSS((Date)endTime));
                    JSONObject presObject = this.getPostData(this.PRADAR_IP + this.RT_TPS_URL, (Map)queryMap);
                    Double presRT = Double.parseDouble(ObjectUtils.toString((Object)presObject.getOrDefault((Object)"rt", (Object)"0")));
                    Double presTPS = Double.parseDouble(ObjectUtils.toString((Object)presObject.getOrDefault((Object)"tps", (Object)"0")));
                    Date preXDate = DateUtil.preXMinuteDate((Date)endTime, (long)5L);
                    queryMap.put("startTime", DateUtil.getYYYYMMDDHHMMSS((Date)preXDate));
                    JSONObject currentObj = this.getPostData(this.PRADAR_IP + this.RT_TPS_URL, (Map)queryMap);
                    Double currRT = Double.parseDouble(ObjectUtils.toString((Object)currentObj.getOrDefault((Object)"rt", (Object)"0")));
                    Double currTPS = Double.parseDouble(ObjectUtils.toString((Object)currentObj.getOrDefault((Object)"tps", (Object)"0")));
                    BigDecimal diffRT = presRT == 0.0 ? BigDecimal.valueOf(currRT).multiply(BigDecimal.valueOf(100L)) : BigDecimal.valueOf(currRT - presRT).divide(BigDecimal.valueOf(presRT), 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).abs();
                    BigDecimal diffTPS = presTPS == 0.0 ? BigDecimal.valueOf(currTPS).multiply(BigDecimal.valueOf(100L)) : BigDecimal.valueOf(currTPS - presTPS).divide(BigDecimal.valueOf(presRT), 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).abs();
                    int rtLevel = LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_NORMAL.getCode();
                    int tpsLevel = LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_NORMAL.getCode();
                    String rtText = "";
                    String tpsText = "";
                    if (diffRT.compareTo(BigDecimal.valueOf(20L)) > 0) {
                        rtLevel = diffRT.compareTo(BigDecimal.valueOf(50L)) > 0 ? LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_SERIOUS.getCode() : LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_GENERAl.getCode();
                        rtText = "\u5165\u53e3RT\u6ce2\u52a8:" + diffRT + "%";
                    }
                    if (diffTPS.compareTo(BigDecimal.valueOf(20L)) > 0) {
                        tpsLevel = diffTPS.compareTo(BigDecimal.valueOf(50L)) > 0 ? LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_SERIOUS.getCode() : LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_GENERAl.getCode();
                        tpsText = "\u5165\u53e3TPS\u6ce2\u52a8:" + diffTPS + "%";
                    }
                    if (rtLevel != tpsLevel || rtLevel != LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_NORMAL.getCode()) {
                        LinkBottleneck rtTpsEntity;
                        if (rtLevel == tpsLevel && (rtLevel == LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_SERIOUS.getCode() || rtLevel == LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_GENERAl.getCode())) {
                            rtTpsEntity = new LinkBottleneck();
                            rtTpsEntity.setAppName(appName);
                            rtTpsEntity.setKeyWords(url);
                            rtTpsEntity.setBottleneckType(LinkBottleneckTypeEnum.BOTTLENECK_TPS_RT.getCode());
                            String text = rtText + ";" + tpsText;
                            rtTpsEntity.setText(text);
                            rtTpsEntity.setBottleneckLevel(rtLevel);
                            rtTpsEntity.setContent(JSONObject.toJSONString((Object)queryMap));
                            insertList.add(rtTpsEntity);
                        } else {
                            if (rtLevel != LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_NORMAL.getCode()) {
                                rtTpsEntity = new LinkBottleneck();
                                rtTpsEntity.setAppName(appName);
                                rtTpsEntity.setKeyWords(url);
                                rtTpsEntity.setBottleneckType(LinkBottleneckTypeEnum.BOTTLENECK_TPS_RT.getCode());
                                rtTpsEntity.setBottleneckLevel(rtLevel);
                                rtTpsEntity.setContent(JSONObject.toJSONString((Object)queryMap));
                                rtTpsEntity.setText(rtText);
                                insertList.add(rtTpsEntity);
                            }
                            if (tpsLevel != LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_NORMAL.getCode()) {
                                LinkBottleneck rtTpsEntity2 = new LinkBottleneck();
                                rtTpsEntity2.setAppName(appName);
                                rtTpsEntity2.setKeyWords(url);
                                rtTpsEntity2.setBottleneckType(LinkBottleneckTypeEnum.BOTTLENECK_TPS_RT.getCode());
                                rtTpsEntity2.setText(tpsText);
                                rtTpsEntity2.setBottleneckLevel(tpsLevel);
                                rtTpsEntity2.setContent(JSONObject.toJSONString((Object)queryMap));
                                insertList.add(rtTpsEntity2);
                            }
                        }
                    }
                    if (StringUtils.isBlank((String)((app = Optional.ofNullable(this.tApplicationMntDao.queryApplicationinfoByName(appName)).orElse(new TApplicationMnt())).getApplicationId() + ""))) continue;
                    HashMap querytwMap = Maps.newHashMap();
                    querytwMap.put("appId", "" + app.getApplicationId());
                    querytwMap.put("url", url);
                    TWList twList = Optional.ofNullable(this.twListMntDao.getWListByParam((Map)querytwMap)).orElse(new TWList());
                    String httpType = twList.getHttpType();
                    if (StringUtils.isBlank((String)httpType)) continue;
                    String pageLevel = twList.getPageLevel();
                    String interfaceLevel = twList.getInterfaceLevel();
                    HashMap queryRt = Maps.newHashMap();
                    queryRt.put("appName", appName);
                    queryRt.put("event", url);
                    queryRt.put("startTime", preXDate);
                    queryRt.put("endTime", endTime);
                    PageLevelEnum pageLevelEnum = PageLevelEnum.getPageLevelEnum((String)pageLevel);
                    if (pageLevelEnum == null) {
                        logger.error("pageLevel->" + pageLevel);
                        continue;
                    }
                    InterfaceLevelEnum interfaceLevelEnum = InterfaceLevelEnum.getInterfaceLevelEnum((String)interfaceLevel);
                    if (interfaceLevelEnum == null) {
                        logger.error("interfaceLevel->" + interfaceLevel);
                        continue;
                    }
                    if ("1".equals(httpType)) {
                        rtTime = pageLevelEnum.getTime();
                    } else {
                        if (!"2".equals(httpType)) continue;
                        rtTime = interfaceLevelEnum.getTime();
                    }
                    queryRt.put("rtTime", rtTime);
                    JSONObject rtObject = this.getPostData(this.RT_COUNT_URL, (Map)queryRt);
                    Double rtCount = Double.parseDouble(ObjectUtils.toString((Object)rtObject.getOrDefault((Object)"rtCount", (Object)"0")));
                    if (rtCount == 0.0) continue;
                    StringBuffer text = new StringBuffer();
                    if ("1".equals(httpType)) {
                        text = text.append(pageLevelEnum.getName());
                    } else if ("2".equals(httpType)) {
                        text = text.append(interfaceLevelEnum.getName());
                    }
                    text = text.append("\u6b21\u6570").append(rtCount);
                    LinkBottleneck rtEntity = new LinkBottleneck();
                    rtEntity.setAppName(appName);
                    rtEntity.setBottleneckType(LinkBottleneckTypeEnum.BOTTLENECK_OTHER.getCode());
                    rtEntity.setText(text.toString());
                    rtEntity.setKeyWords(url);
                    rtEntity.setContent(JSONObject.toJSONString((Object)queryRt));
                    insertList.add(rtEntity);
                }
                this.redisTemplate.opsForValue().set((Object)"calTpsRt", (Object)"calTpsRt", 5L, TimeUnit.MINUTES);
            }
        }
    }

    private JSONObject getPostData(String url, Map<String, Object> queryMap) {
        JSONObject dataObject = new JSONObject();
        try {
            String pres = HttpUtils.post((String)url, (String)JSONObject.toJSONString(queryMap));
            dataObject = (JSONObject)JSONObject.parseObject((String)pres, JSONObject.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dataObject;
    }

    private void calAsynLevel(JSONObject valueObject, List<LinkBottleneck> links, String appName) {
        JSONArray jsonArray = valueObject.getJSONArray("rktmqDepth");
        if (CollectionUtils.isEmpty((Collection)jsonArray)) {
            return;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject dataObject = jsonArray.getJSONObject(i);
            String topic = ObjectUtils.toString((Object)dataObject.getOrDefault((Object)"topic", (Object)""));
            if (StringUtils.isBlank((String)topic)) continue;
            Double depth = Double.parseDouble(ObjectUtils.toString((Object)dataObject.getOrDefault((Object)"depth", (Object)"0")));
            LinkBottleneck linkBottleneck = new LinkBottleneck();
            if (depth <= (double)this.mqGeneral) continue;
            if (depth > (double)this.mqSerious) {
                linkBottleneck.setBottleneckLevel(LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_SERIOUS.getCode());
            } else if (depth > (double)this.mqGeneral) {
                linkBottleneck.setBottleneckLevel(LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_GENERAl.getCode());
            }
            linkBottleneck.setAppName(appName);
            linkBottleneck.setKeyWords(topic);
            linkBottleneck.setContent(JSONObject.toJSONString((Object)dataObject));
            String text = "topic:" + depth.intValue() / 10000 + "w";
            linkBottleneck.setText(text);
            links.add(linkBottleneck);
        }
    }

    private int calLoadExeceptionLevel(JSONObject valueObject, Map<String, StringBuffer> textMap) {
        double disk;
        double cpu;
        double mem;
        StringBuffer text = textMap.getOrDefault("text", new StringBuffer());
        StringBuffer newText = new StringBuffer();
        double io = Double.parseDouble(ObjectUtils.toString((Object)valueObject.getOrDefault((Object)"io", (Object)"0")));
        if (io > 90.0) {
            newText = newText.append("io\u4f7f\u7528\u7387\u5927\u4e8e90%,");
        }
        if ((mem = Double.parseDouble(ObjectUtils.toString((Object)valueObject.getOrDefault((Object)"mem", (Object)"0")))) > 90.0) {
            newText = newText.append("\u5185\u5b58\u603b\u4f7f\u7528\u7387\u5927\u4e8e90%,");
        }
        if ((cpu = Double.parseDouble(ObjectUtils.toString((Object)valueObject.getOrDefault((Object)"cpu", (Object)"0")))) > 90.0) {
            newText = newText.append("cpu\u767e\u5206\u6bd4\u4f7f\u7528\u738790%,");
        }
        if ((disk = Double.parseDouble(ObjectUtils.toString((Object)valueObject.getOrDefault((Object)"disk", (Object)"0")))) > 100.0) {
            newText = newText.append("\u78c1\u76d8\u5206\u533a\u4f7f\u7528\u7387\u5927\u4e8e100%,");
        }
        double fullgcCount = Double.parseDouble(ObjectUtils.toString((Object)valueObject.getOrDefault((Object)"fullgcCount", (Object)"0")));
        double fullgcTime = Double.parseDouble(ObjectUtils.toString((Object)valueObject.getOrDefault((Object)"fullgcTime", (Object)"0")));
        if (fullgcTime > 5.0 && fullgcCount > 10.0) {
            newText = newText.append("fullgc\u6b21\u657010\u6b21,\u65f6\u95f4\u5927\u4e8e5\u79d2,");
        }
        if (cpu > 90.0 || mem > 90.0 || io > 90.0 || disk > 100.0 || fullgcCount > 10.0 && fullgcTime > 5.0) {
            text = text.append("ip=" + valueObject.getOrDefault((Object)"ip", (Object)"") + ",");
            text = text.append(newText).append(";");
            textMap.put("text", text);
            return LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_SERIOUS.getCode();
        }
        return LinkBottleneckLevelEnum.BOTTLENECK_LEVEL_NORMAL.getCode();
    }

    private void buildBottleneck(List<LinkBottleneck> insertList, String appName, List<JSONObject> contextList, int type, int level, String text) {
        LinkBottleneck insertEntity = new LinkBottleneck();
        insertEntity.setAppName(appName);
        insertEntity.setBottleneckType(type);
        insertEntity.setBottleneckLevel(level);
        insertEntity.setContent(JSONObject.toJSONString(contextList));
        insertEntity.setText(text);
        insertList.add(insertEntity);
    }

    private JSONObject getLinkBottleneck(List<String> appNames) {
        JSONObject dataObject = new JSONObject();
        int total = appNames.size();
        for (int i = 0; i < total; i += this.pageSize) {
            List<String> subList;
            JSONObject jsonObject;
            if (i + this.pageSize > total) {
                this.pageSize = total - i;
            }
            if ((jsonObject = this.queryBottleneck(subList = appNames.subList(i, i + this.pageSize))) == null || jsonObject.size() == 0) continue;
            dataObject.putAll((Map)jsonObject);
        }
        return dataObject;
    }

    private JSONObject queryBottleneck(List<String> appNames) {
        JSONObject dataObject = new JSONObject();
        try {
            HashMap param = Maps.newHashMap();
            param.put("time", DateUtils.dateToString((Date)DateUtils.getPreviousNSecond((int)this.preNSecond), (String)"yyyy-MM-dd HH:mm:ss"));
            param.put("applist", appNames);
            String dataStr = HttpUtils.post((String)(this.AOPS_IP + this.BOTTLENECK_URL), (String)JSONObject.toJSONString((Object)param));
            if ("error".equals(dataStr)) {
                return null;
            }
            JSONObject rtObject = (JSONObject)JSONObject.parseObject((String)dataStr, JSONObject.class);
            dataObject = rtObject.getJSONObject("data");
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return dataObject;
    }
}

