/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.util.AESUtil;
import com.pamirs.tro.common.util.JdbcConnection;
import com.pamirs.tro.common.util.SqlParseUtil;
import io.shulie.tro.cloud.common.bean.scenemanage.SceneBusinessActivityRefBean;
import io.shulie.tro.cloud.open.req.scenemanage.SceneManageIdReq;
import io.shulie.tro.cloud.open.resp.scenemanage.SceneManageWrapperResp;
import io.shulie.tro.common.beans.response.ResponseResult;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.request.leakcheck.LeakSqlBatchRefsRequest;
import io.shulie.tro.web.app.request.leakcheck.LeakSqlCreateRequest;
import io.shulie.tro.web.app.request.leakcheck.LeakSqlDeleteRequest;
import io.shulie.tro.web.app.request.leakcheck.LeakSqlDetailRequest;
import io.shulie.tro.web.app.request.leakcheck.LeakSqlUpdateRequest;
import io.shulie.tro.web.app.request.leakcheck.SqlTestRequest;
import io.shulie.tro.web.app.request.leakverify.VerifyTaskConfig;
import io.shulie.tro.web.app.response.leakcheck.LeakSqlBatchRefsResponse;
import io.shulie.tro.web.app.response.leakcheck.LeakSqlRefsResponse;
import io.shulie.tro.web.app.response.leakcheck.SingleSqlDetailResponse;
import io.shulie.tro.web.app.service.LeakSqlService;
import io.shulie.tro.web.data.dao.datasource.DataSourceDAO;
import io.shulie.tro.web.data.dao.leakcheck.LeakCheckConfigDAO;
import io.shulie.tro.web.data.dao.leakcheck.LeakCheckConfigDetailDAO;
import io.shulie.tro.web.data.param.datasource.DataSourceQueryParam;
import io.shulie.tro.web.data.param.datasource.DataSourceSingleQueryParam;
import io.shulie.tro.web.data.param.leakcheck.LeakCheckConfigCreateParam;
import io.shulie.tro.web.data.param.leakcheck.LeakCheckConfigDeleteParam;
import io.shulie.tro.web.data.param.leakcheck.LeakCheckConfigDetailCreateParam;
import io.shulie.tro.web.data.param.leakcheck.LeakCheckConfigDetailDeleteParam;
import io.shulie.tro.web.data.param.leakcheck.LeakCheckConfigDetailQueryParam;
import io.shulie.tro.web.data.param.leakcheck.LeakCheckConfigQueryParam;
import io.shulie.tro.web.data.param.leakcheck.LeakCheckConfigSingleQueryParam;
import io.shulie.tro.web.data.param.leakcheck.LeakCheckConfigUpdateParam;
import io.shulie.tro.web.data.result.datasource.DataSourceResult;
import io.shulie.tro.web.data.result.leakcheck.LeakCheckConfigBatchDetailResult;
import io.shulie.tro.web.data.result.leakcheck.LeakCheckConfigResult;
import io.shulie.tro.web.data.result.leakcheck.LeakCheckConfigSingleDetailResult;
import io.shulie.tro.web.diff.api.scenemanage.SceneManageApi;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LeakSqlServiceImpl
implements LeakSqlService {
    private static final Logger log = LoggerFactory.getLogger(LeakSqlServiceImpl.class);
    @Autowired
    private LeakCheckConfigDAO checkConfigDAO;
    @Autowired
    private LeakCheckConfigDetailDAO checkConfigDetailDAO;
    @Autowired
    private DataSourceDAO dataSourceDAO;
    @Autowired
    private SceneManageApi sceneManageApi;

    @Transactional(rollbackFor={Throwable.class})
    public void createLeakCheckConfig(LeakSqlCreateRequest createRequest) {
        Long businessActivityId = createRequest.getBusinessActivityId();
        Long datasourceId = createRequest.getDatasourceId();
        List<String> sqlList = createRequest.getSqls();
        sqlList.forEach(arg_0 -> this.checkSql(arg_0));
        SqlTestRequest sqlTestRequest = new SqlTestRequest();
        sqlTestRequest.setDatasourceId(datasourceId);
        sqlTestRequest.setSqls((List)sqlList);
        String message = this.testSqlConnection(sqlTestRequest);
        if (StringUtils.isNotBlank((String)message)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.LEAK_SQL_REF_RUN_ERROR, (Object)"sql\u9a8c\u8bc1\u5931\u8d25");
        }
        LeakCheckConfigSingleQueryParam singleQueryParam = new LeakCheckConfigSingleQueryParam();
        singleQueryParam.setBusinessActivityId(businessActivityId);
        singleQueryParam.setDatasourceId(datasourceId);
        LeakCheckConfigResult oldLeakCheckConfigResult = this.checkConfigDAO.selectSingle(singleQueryParam);
        if (!Objects.isNull(oldLeakCheckConfigResult)) {
            LeakSqlUpdateRequest updateRequest = new LeakSqlUpdateRequest();
            updateRequest.setBusinessActivityId(businessActivityId);
            updateRequest.setDatasourceId(datasourceId);
            List oldSqlIdList = Arrays.stream(oldLeakCheckConfigResult.getLeakcheckSqlIds().split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
            LeakCheckConfigDetailQueryParam detailQueryParam = new LeakCheckConfigDetailQueryParam();
            detailQueryParam.setIds(oldSqlIdList);
            LeakCheckConfigSingleDetailResult detailResult = this.checkConfigDetailDAO.selectSingle(detailQueryParam);
            if (!Objects.isNull(detailResult) && CollectionUtils.isNotEmpty((Collection)detailResult.getSqls())) {
                sqlList.addAll(detailResult.getSqls());
            }
            HashMap sqlMap = Maps.newHashMap();
            sqlList.stream().forEach(s -> sqlMap.put(s.replace(" ", ""), s));
            sqlList = new ArrayList(sqlMap.values());
            updateRequest.setSqls(sqlList);
            this.updateLeakCheckConfig(updateRequest);
        } else {
            sqlList = sqlList.stream().distinct().collect(Collectors.toList());
            LeakCheckConfigDetailCreateParam detailCreateParam = new LeakCheckConfigDetailCreateParam();
            detailCreateParam.setDatasourceId(datasourceId);
            detailCreateParam.setSqlList(sqlList);
            List sqlIdList = this.checkConfigDetailDAO.insert(detailCreateParam);
            LeakCheckConfigCreateParam checkConfigCreateParam = new LeakCheckConfigCreateParam();
            checkConfigCreateParam.setBusinessActivityId(businessActivityId);
            checkConfigCreateParam.setDatasourceId(datasourceId);
            checkConfigCreateParam.setSqlIdList(sqlIdList);
            this.checkConfigDAO.insert(checkConfigCreateParam);
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    public void updateLeakCheckConfig(LeakSqlUpdateRequest updateRequest) {
        Long businessActivityId = updateRequest.getBusinessActivityId();
        Long datasourceId = updateRequest.getDatasourceId();
        List<String> sqlList = updateRequest.getSqls();
        sqlList.forEach(arg_0 -> this.checkSql(arg_0));
        LeakCheckConfigSingleQueryParam singleQueryParam = new LeakCheckConfigSingleQueryParam();
        singleQueryParam.setBusinessActivityId(businessActivityId);
        singleQueryParam.setDatasourceId(datasourceId);
        LeakCheckConfigResult oldLeakCheckConfigResult = this.checkConfigDAO.selectSingle(singleQueryParam);
        if (!Objects.isNull(oldLeakCheckConfigResult) && StringUtils.isNotBlank((String)oldLeakCheckConfigResult.getLeakcheckSqlIds())) {
            LeakCheckConfigDetailDeleteParam detailDeleteParam = new LeakCheckConfigDetailDeleteParam();
            String oldSqlIdString = oldLeakCheckConfigResult.getLeakcheckSqlIds();
            List oldSqlIdList = Arrays.stream(oldSqlIdString.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
            detailDeleteParam.setIds(oldSqlIdList);
            this.checkConfigDetailDAO.delete(detailDeleteParam);
        }
        LeakCheckConfigDetailCreateParam detailCreateParam = new LeakCheckConfigDetailCreateParam();
        detailCreateParam.setDatasourceId(datasourceId);
        sqlList = sqlList.stream().distinct().collect(Collectors.toList());
        HashMap sqlMap = Maps.newHashMap();
        sqlList.stream().forEach(s -> sqlMap.put(s.replace(" ", ""), s));
        sqlList = new ArrayList(sqlMap.values());
        detailCreateParam.setSqlList(sqlList);
        List sqlIdList = this.checkConfigDetailDAO.insert(detailCreateParam);
        LeakCheckConfigUpdateParam checkConfigUpdateParam = new LeakCheckConfigUpdateParam();
        checkConfigUpdateParam.setBusinessActivityId(businessActivityId);
        checkConfigUpdateParam.setDatasourceId(datasourceId);
        checkConfigUpdateParam.setSqlIdList(sqlIdList);
        this.checkConfigDAO.update(checkConfigUpdateParam);
    }

    public void deleteLeakCheckConfig(LeakSqlDeleteRequest deleteRequest) {
        Long businessActivityId = deleteRequest.getBusinessActivityId();
        Long datasourceId = deleteRequest.getDatasourceId();
        LeakCheckConfigSingleQueryParam singleQueryParam = new LeakCheckConfigSingleQueryParam();
        singleQueryParam.setBusinessActivityId(businessActivityId);
        singleQueryParam.setDatasourceId(datasourceId);
        LeakCheckConfigResult oldLeakCheckConfigResult = this.checkConfigDAO.selectSingle(singleQueryParam);
        if (!Objects.isNull(oldLeakCheckConfigResult)) {
            LeakCheckConfigDetailDeleteParam detailDeleteParam = new LeakCheckConfigDetailDeleteParam();
            String oldSqlIdString = oldLeakCheckConfigResult.getLeakcheckSqlIds();
            List oldSqlIdList = Arrays.stream(oldSqlIdString.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
            detailDeleteParam.setIds(oldSqlIdList);
            this.checkConfigDetailDAO.delete(detailDeleteParam);
            LeakCheckConfigDeleteParam checkConfigDeleteParam = new LeakCheckConfigDeleteParam();
            checkConfigDeleteParam.setIds(Arrays.asList(oldLeakCheckConfigResult.getId()));
            this.checkConfigDAO.delete(checkConfigDeleteParam);
        }
    }

    public LeakSqlRefsResponse getLeakCheckConfigDetail(LeakSqlDetailRequest detailRequest) {
        Long businessActivityId = detailRequest.getBusinessActivityId();
        Long datasourceId = detailRequest.getDatasourceId();
        LeakCheckConfigSingleQueryParam singleQueryParam = new LeakCheckConfigSingleQueryParam();
        singleQueryParam.setBusinessActivityId(businessActivityId);
        singleQueryParam.setDatasourceId(datasourceId);
        LeakCheckConfigResult leakCheckConfigResult = this.checkConfigDAO.selectSingle(singleQueryParam);
        if (!Objects.isNull(leakCheckConfigResult)) {
            LeakSqlRefsResponse refsResponse = new LeakSqlRefsResponse();
            refsResponse.setBusinessActivityId(leakCheckConfigResult.getBusinessActivityId());
            refsResponse.setDatasourceId(leakCheckConfigResult.getDatasourceId());
            String sqlIdString = leakCheckConfigResult.getLeakcheckSqlIds();
            List sqlIdList = Arrays.stream(sqlIdString.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
            LeakCheckConfigDetailQueryParam detailQueryParam = new LeakCheckConfigDetailQueryParam();
            detailQueryParam.setIds(sqlIdList);
            LeakCheckConfigSingleDetailResult detailResult = this.checkConfigDetailDAO.selectSingle(detailQueryParam);
            if (!Objects.isNull(detailResult)) {
                refsResponse.setSqls(detailResult.getSqls());
            }
            return refsResponse;
        }
        return null;
    }

    public List<LeakSqlBatchRefsResponse> getBatchLeakCheckConfig(LeakSqlBatchRefsRequest refsRequest) {
        List<Object> refsResponseList = Lists.newArrayList();
        LeakCheckConfigQueryParam checkConfigQueryParam = new LeakCheckConfigQueryParam();
        checkConfigQueryParam.setBusinessActivityIds(refsRequest.getBusinessActivityIds());
        List checkConfigResults = this.checkConfigDAO.selectList(checkConfigQueryParam);
        if (CollectionUtils.isNotEmpty((Collection)checkConfigResults)) {
            List datasourceIdList = checkConfigResults.stream().map(LeakCheckConfigResult::getDatasourceId).collect(Collectors.toList());
            ArrayList sqlIdToltalList = new ArrayList();
            for (LeakCheckConfigResult checkConfigResult : checkConfigResults) {
                String sqlIdString = checkConfigResult.getLeakcheckSqlIds();
                List sqlIdList = Arrays.stream(sqlIdString.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
                sqlIdToltalList.addAll(sqlIdList);
            }
            DataSourceQueryParam dataSourceQueryParam = new DataSourceQueryParam();
            dataSourceQueryParam.setDataSourceIdList(datasourceIdList);
            List dataSourceResultList = this.dataSourceDAO.selectList(dataSourceQueryParam);
            Map<Object, Object> dataSourceResultMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)dataSourceResultList)) {
                dataSourceResultMap = dataSourceResultList.stream().collect(Collectors.toMap(DataSourceResult::getId, DataSourceResult2 -> DataSourceResult2));
            }
            LeakCheckConfigDetailQueryParam checkConfigDetailQueryParam = new LeakCheckConfigDetailQueryParam();
            checkConfigDetailQueryParam.setIds(sqlIdToltalList);
            List sqlDetailResultList = this.checkConfigDetailDAO.selectList(checkConfigDetailQueryParam);
            Map<Object, Object> sqlDetailResultMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)sqlDetailResultList)) {
                sqlDetailResultMap = sqlDetailResultList.stream().collect(Collectors.toMap(LeakCheckConfigBatchDetailResult::getId, LeakCheckConfigBatchDetailResult2 -> LeakCheckConfigBatchDetailResult2));
            }
            Map<Object, Object> finalDataSourceResultMap = dataSourceResultMap;
            HashMap finalSqlDetailResultMap = sqlDetailResultMap;
            HashMap refsResponseListGroupByDsMap = Maps.newHashMap();
            checkConfigResults.forEach(leakCheckConfigResult -> {
                LeakSqlBatchRefsResponse refsResponse;
                List<SingleSqlDetailResponse> sqlResponseList = Lists.newArrayList();
                Long datasourceId = leakCheckConfigResult.getDatasourceId();
                if (refsResponseListGroupByDsMap.containsKey(datasourceId)) {
                    refsResponse = (LeakSqlBatchRefsResponse)refsResponseListGroupByDsMap.get(datasourceId);
                    sqlResponseList = refsResponse.getSqlResponseList();
                } else {
                    refsResponse = new LeakSqlBatchRefsResponse();
                    refsResponse.setDatasourceId(datasourceId);
                    if (finalDataSourceResultMap.containsKey(datasourceId)) {
                        DataSourceResult dataSourceResult = (DataSourceResult)finalDataSourceResultMap.get(datasourceId);
                        refsResponse.setDatasourceName(dataSourceResult.getName());
                        refsResponse.setJdbcUrl(dataSourceResult.getJdbcUrl());
                    }
                }
                String sqlIdString = leakCheckConfigResult.getLeakcheckSqlIds();
                List sqlIdList = Arrays.stream(sqlIdString.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(sqlIdList)) {
                    for (int i = 0; i < sqlIdList.size(); ++i) {
                        Long sqlId = (Long)sqlIdList.get(i);
                        if (!finalSqlDetailResultMap.containsKey(sqlId)) continue;
                        LeakCheckConfigBatchDetailResult detailResult = (LeakCheckConfigBatchDetailResult)finalSqlDetailResultMap.get(sqlId);
                        SingleSqlDetailResponse sqlDetailResponse = new SingleSqlDetailResponse();
                        Integer order = sqlResponseList.size() + 1;
                        sqlDetailResponse.setOrder(order);
                        sqlDetailResponse.setSql(detailResult.getSql());
                        sqlResponseList.add(sqlDetailResponse);
                    }
                    sqlResponseList = sqlResponseList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SingleSqlDetailResponse>(Comparator.comparing(SingleSqlDetailResponse::getSql))), ArrayList::new));
                    List sorted = sqlResponseList.stream().sorted(Comparator.comparing(SingleSqlDetailResponse::getOrder)).collect(Collectors.toList());
                    refsResponse.setSqlResponseList(sorted);
                }
                refsResponseListGroupByDsMap.put(datasourceId, refsResponse);
            });
            if (!refsResponseListGroupByDsMap.isEmpty()) {
                refsResponseList = refsResponseListGroupByDsMap.values().stream().collect(Collectors.toList());
            }
        }
        return refsResponseList;
    }

    public List<VerifyTaskConfig> getVerifyTaskConfig(LeakSqlBatchRefsRequest refsRequest) {
        ArrayList verifyTaskConfigList = Lists.newArrayList();
        LeakCheckConfigQueryParam checkConfigQueryParam = new LeakCheckConfigQueryParam();
        checkConfigQueryParam.setBusinessActivityIds(refsRequest.getBusinessActivityIds());
        List checkConfigResults = this.checkConfigDAO.selectList(checkConfigQueryParam);
        if (CollectionUtils.isNotEmpty((Collection)checkConfigResults)) {
            List datasourceIdList = checkConfigResults.stream().map(LeakCheckConfigResult::getDatasourceId).collect(Collectors.toList());
            ArrayList sqlIdToltalList = new ArrayList();
            for (LeakCheckConfigResult checkConfigResult : checkConfigResults) {
                String sqlIdString = checkConfigResult.getLeakcheckSqlIds();
                List sqlIdList = Arrays.stream(sqlIdString.split(",")).map(Long::parseLong).distinct().collect(Collectors.toList());
                sqlIdToltalList.addAll(sqlIdList);
            }
            DataSourceQueryParam dataSourceQueryParam = new DataSourceQueryParam();
            dataSourceQueryParam.setDataSourceIdList(datasourceIdList);
            List dataSourceResultList = this.dataSourceDAO.selectList(dataSourceQueryParam);
            Map<Object, Object> dataSourceResultMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)dataSourceResultList)) {
                dataSourceResultMap = dataSourceResultList.stream().collect(Collectors.toMap(DataSourceResult::getId, DataSourceResult2 -> DataSourceResult2));
            }
            LeakCheckConfigDetailQueryParam checkConfigDetailQueryParam = new LeakCheckConfigDetailQueryParam();
            checkConfigDetailQueryParam.setIds(sqlIdToltalList);
            List sqlDetailResultList = this.checkConfigDetailDAO.selectList(checkConfigDetailQueryParam);
            Map<Object, Object> finalDataSourceResultMap = dataSourceResultMap;
            HashMap verifyTaskConfigMap = Maps.newHashMap();
            checkConfigResults.forEach(leakCheckConfigResult -> {
                VerifyTaskConfig verifyTaskConfig = new VerifyTaskConfig();
                Long datasourceId = leakCheckConfigResult.getDatasourceId();
                verifyTaskConfig.setDatasourceId(datasourceId);
                if (finalDataSourceResultMap.containsKey(datasourceId)) {
                    DataSourceResult dataSourceResult = (DataSourceResult)finalDataSourceResultMap.get(datasourceId);
                    verifyTaskConfig.setDatasourceName(dataSourceResult.getName());
                    verifyTaskConfig.setJdbcUrl(dataSourceResult.getJdbcUrl());
                    verifyTaskConfig.setUsername(dataSourceResult.getUsername());
                    verifyTaskConfig.setPassword(AESUtil.decrypt((String)dataSourceResult.getPassword()));
                    verifyTaskConfig.setType(dataSourceResult.getType());
                    verifyTaskConfig.setSqls((List)Lists.newArrayList());
                }
                if (CollectionUtils.isNotEmpty((Collection)sqlDetailResultList)) {
                    List sqlList = sqlDetailResultList.stream().filter(sqlDetail -> datasourceId.equals(sqlDetail.getDatasourceId())).map(LeakCheckConfigBatchDetailResult::getSql).distinct().collect(Collectors.toList());
                    verifyTaskConfig.setSqls(sqlList);
                }
                if (verifyTaskConfigMap.containsKey(verifyTaskConfig.getDatasourceId())) {
                    VerifyTaskConfig v = (VerifyTaskConfig)verifyTaskConfigMap.get(verifyTaskConfig.getDatasourceId());
                    List sqlList = v.getSqls();
                    if (CollectionUtils.isNotEmpty((Collection)verifyTaskConfig.getSqls())) {
                        sqlList.addAll(verifyTaskConfig.getSqls());
                        sqlList = sqlList.stream().distinct().collect(Collectors.toList());
                        v.setSqls(sqlList);
                    }
                    verifyTaskConfigMap.put(verifyTaskConfig.getDatasourceId(), v);
                } else {
                    verifyTaskConfigMap.put(verifyTaskConfig.getDatasourceId(), verifyTaskConfig);
                }
            });
            if (!verifyTaskConfigMap.isEmpty()) {
                verifyTaskConfigList = new ArrayList(verifyTaskConfigMap.values());
            }
        }
        return verifyTaskConfigList;
    }

    public Boolean getSceneLeakConfig(Long sceneId) {
        SceneManageWrapperResp wrapperResp;
        List refRespList;
        SceneManageIdReq req = new SceneManageIdReq();
        req.setId(sceneId);
        ResponseResult sceneDetail = this.sceneManageApi.getSceneDetail(req);
        if (!Objects.isNull(sceneDetail.getData()) && CollectionUtils.isNotEmpty((Collection)(refRespList = (wrapperResp = (SceneManageWrapperResp)JSON.parseObject((String)JSON.toJSONString((Object)sceneDetail.getData()), SceneManageWrapperResp.class)).getBusinessActivityConfig()))) {
            List businessActivityIdList = refRespList.stream().map(SceneBusinessActivityRefBean::getBusinessActivityId).collect(Collectors.toList());
            LeakCheckConfigQueryParam checkConfigQueryParam = new LeakCheckConfigQueryParam();
            checkConfigQueryParam.setBusinessActivityIds(businessActivityIdList);
            List checkConfigResults = this.checkConfigDAO.selectList(checkConfigQueryParam);
            if (CollectionUtils.isNotEmpty((Collection)checkConfigResults)) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String testSqlConnection(SqlTestRequest sqlTestRequest) {
        StringBuilder msg = new StringBuilder();
        DataSourceSingleQueryParam queryParam = new DataSourceSingleQueryParam();
        queryParam.setId(sqlTestRequest.getDatasourceId());
        DataSourceResult dataSourceResult = this.dataSourceDAO.selectSingle(queryParam);
        String jdbcUrl = dataSourceResult.getJdbcUrl();
        String username = dataSourceResult.getUsername();
        String password = AESUtil.decrypt((String)dataSourceResult.getPassword());
        try {
            Connection connection = JdbcConnection.generateConnection((String)jdbcUrl, (String)username, (String)password);
            List sqls = sqlTestRequest.getSqls();
            try {
                sqls.forEach(sql -> {
                    try {
                        if (StringUtils.isNotBlank((String)sql)) {
                            if (sql.lastIndexOf(";") != -1) {
                                sql = sql.split(";")[0];
                            }
                            this.checkSql(sql);
                            Statement statement = connection.createStatement();
                            statement.setQueryTimeout(30);
                            ResultSet resultSet = statement.executeQuery((String)sql);
                            resultSet.close();
                            statement.close();
                        }
                    }
                    catch (SQLException throwables) {
                        String tmpMsg = throwables.getMessage();
                        String tableName = SqlParseUtil.parseAndGetTableName((String)sql);
                        tmpMsg = tmpMsg + ":" + tableName;
                        msg.append(tmpMsg).append(",");
                        log.error("Verify job run error:", (Throwable)throwables);
                    }
                });
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        log.error("error:", (Throwable)e);
                    }
                }
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            msg.append(e.getMessage());
            log.error("testSqlConnection error:", (Throwable)e);
        }
        return msg.toString();
    }

    private void checkSql(String sql) {
        if (StringUtils.isBlank((String)sql)) {
            return;
        }
        if (!SqlParseUtil.checkIsSelect((String)sql).booleanValue() || !SqlParseUtil.checkHasLimit((String)sql).booleanValue()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.LEAK_SQL_REF_INVALID_ERROR, (Object)"\u9a8c\u8bc1\u547d\u4ee4\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u6309\u7167\u6a21\u677f\u586b\u5199");
        }
    }
}

