/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.impl;

import com.google.common.collect.Lists;
import com.pamirs.tro.common.constant.DataSourceVerifyTypeEnum;
import com.pamirs.tro.common.util.AESUtil;
import com.pamirs.tro.common.util.JdbcConnection;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.request.datasource.DataSourceCreateRequest;
import io.shulie.tro.web.app.request.datasource.DataSourceQueryRequest;
import io.shulie.tro.web.app.request.datasource.DataSourceTestRequest;
import io.shulie.tro.web.app.request.datasource.DataSourceUpdateRequest;
import io.shulie.tro.web.app.request.datasource.DataSourceUpdateTagsRequest;
import io.shulie.tro.web.app.response.datasource.DataSourceTypeResponse;
import io.shulie.tro.web.app.response.datasource.DatasourceDetailResponse;
import io.shulie.tro.web.app.response.datasource.DatasourceDictionaryResponse;
import io.shulie.tro.web.app.response.datasource.DatasourceListResponse;
import io.shulie.tro.web.app.response.tagmanage.TagManageResponse;
import io.shulie.tro.web.app.service.DataSourceService;
import io.shulie.tro.web.data.dao.datasource.DataSourceDAO;
import io.shulie.tro.web.data.dao.datasource.DataSourceTagRefDAO;
import io.shulie.tro.web.data.dao.leakcheck.LeakCheckConfigDAO;
import io.shulie.tro.web.data.dao.leakcheck.LeakCheckConfigDetailDAO;
import io.shulie.tro.web.data.dao.linkmanage.BusinessLinkManageDAO;
import io.shulie.tro.web.data.dao.tagmanage.TagManageDAO;
import io.shulie.tro.web.data.param.datasource.DataSourceCreateParam;
import io.shulie.tro.web.data.param.datasource.DataSourceDeleteParam;
import io.shulie.tro.web.data.param.datasource.DataSourceQueryParam;
import io.shulie.tro.web.data.param.datasource.DataSourceSingleQueryParam;
import io.shulie.tro.web.data.param.datasource.DataSourceUpdateParam;
import io.shulie.tro.web.data.param.leakcheck.LeakCheckConfigDeleteParam;
import io.shulie.tro.web.data.param.leakcheck.LeakCheckConfigDetailDeleteParam;
import io.shulie.tro.web.data.param.leakcheck.LeakCheckConfigDetailQueryParam;
import io.shulie.tro.web.data.param.leakcheck.LeakCheckConfigQueryParam;
import io.shulie.tro.web.data.param.tagmanage.TagManageParam;
import io.shulie.tro.web.data.result.datasource.DataSourceResult;
import io.shulie.tro.web.data.result.datasource.DataSourceTagRefResult;
import io.shulie.tro.web.data.result.leakcheck.LeakCheckConfigBatchDetailResult;
import io.shulie.tro.web.data.result.leakcheck.LeakCheckConfigResult;
import io.shulie.tro.web.data.result.linkmange.BusinessLinkResult;
import io.shulie.tro.web.data.result.tagmanage.TagManageResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DataSourceServiceImpl
implements DataSourceService {
    private static final Logger log = LoggerFactory.getLogger(DataSourceServiceImpl.class);
    @Autowired
    private TagManageDAO tagManageDAO;
    @Autowired
    private DataSourceTagRefDAO dataSourceTagRefDAO;
    @Autowired
    private DataSourceDAO dataSourceDAO;
    @Autowired
    private LeakCheckConfigDAO checkConfigDAO;
    @Autowired
    private LeakCheckConfigDetailDAO checkDetailDAO;
    @Autowired
    private BusinessLinkManageDAO businessLinkManageDAO;

    @Transactional(rollbackFor={Throwable.class})
    public void createDatasource(DataSourceCreateRequest createRequest) {
        String password;
        String username;
        Integer type = createRequest.getType();
        String name = createRequest.getDatasourceName();
        String jdbcUrl = createRequest.getJdbcUrl();
        if (!this.checkConnection(jdbcUrl, username = createRequest.getUsername(), password = createRequest.getPassword(), type).booleanValue()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.DATASOURCE_TEST_CONNECTION_ERROR, (Object)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25");
        }
        if (!this.checkIsSupport(type).booleanValue()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.DATASOURCE_ADD_ERROR, (Object)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b");
        }
        if (this.checkIsExistName(name).booleanValue()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.DATASOURCE_ADD_ERROR, (Object)"\u6570\u636e\u6e90\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (this.checkIsExistJdbcUrl(jdbcUrl).booleanValue()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.DATASOURCE_ADD_ERROR, (Object)"\u6570\u636e\u6e90\u5730\u5740\u5df2\u5b58\u5728");
        }
        DataSourceCreateParam createParam = new DataSourceCreateParam();
        createParam.setType(type);
        createParam.setName(name);
        createParam.setJdbcUrl(jdbcUrl);
        createParam.setUsername(username);
        createParam.setPassword(AESUtil.encrypt((String)password));
        this.dataSourceDAO.insert(createParam);
    }

    @Transactional(rollbackFor={Throwable.class})
    public void updateDatasource(DataSourceUpdateRequest updateRequest) {
        Long id = updateRequest.getDatasourceId();
        Integer type = updateRequest.getType().getCode();
        String name = updateRequest.getDatasourceName();
        String jdbcUrl = updateRequest.getJdbcUrl();
        String username = updateRequest.getUsername();
        String password = updateRequest.getPassword();
        DataSourceSingleQueryParam queryIdParam = new DataSourceSingleQueryParam();
        queryIdParam.setId(id);
        DataSourceResult idResult = this.dataSourceDAO.selectSingle(queryIdParam);
        if (Objects.isNull(idResult)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.DATASOURCE_UPDATE_ERROR, (Object)"\u8be5\u6570\u636e\u6e90\u4e0d\u5b58\u5728");
        }
        if (!idResult.getType().equals(type) && !this.checkIsSupport(type).booleanValue()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.DATASOURCE_UPDATE_ERROR, (Object)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b");
        }
        if (!this.checkUpdatePermssion(idResult.getUserId()).booleanValue()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.DATASOURCE_UPDATE_ERROR, (Object)"\u6570\u636e\u6743\u9650\u4e0d\u8db3");
        }
        if (!idResult.getName().equals(name) && this.checkIsExistName(name).booleanValue()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.DATASOURCE_UPDATE_ERROR, (Object)"\u6570\u636e\u6e90\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (!idResult.getJdbcUrl().equals(jdbcUrl) && this.checkIsExistJdbcUrl(jdbcUrl).booleanValue()) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.DATASOURCE_UPDATE_ERROR, (Object)"\u6570\u636e\u6e90\u5730\u5740\u5df2\u5b58\u5728");
        }
        DataSourceUpdateParam updateParam = new DataSourceUpdateParam();
        updateParam.setId(id);
        updateParam.setType(type);
        updateParam.setName(name);
        updateParam.setJdbcUrl(jdbcUrl);
        updateParam.setUsername(username);
        String currentPassword = AESUtil.decrypt((String)idResult.getPassword());
        if (StringUtils.isNotBlank((String)password) && !currentPassword.equals(password)) {
            if (!this.checkConnection(jdbcUrl, username, AESUtil.decrypt((String)idResult.getPassword()), type).booleanValue()) {
                throw new TroWebException((ExceptionReadable)ExceptionCode.DATASOURCE_TEST_CONNECTION_ERROR, (Object)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25");
            }
            updateParam.setPassword(AESUtil.encrypt((String)password));
        }
        this.dataSourceDAO.update(updateParam);
    }

    @Transactional(rollbackFor={Throwable.class})
    public void deleteDatasource(List<Long> datasourceIds) {
        DataSourceQueryParam queryParam = new DataSourceQueryParam();
        queryParam.setDataSourceIdList(datasourceIds);
        List dataSourceResultList = this.dataSourceDAO.selectList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)dataSourceResultList)) {
            List userIdList = dataSourceResultList.stream().map(DataSourceResult::getUserId).collect(Collectors.toList());
            if (!this.checkDeletePermssion(userIdList).booleanValue()) {
                throw new TroWebException((ExceptionReadable)ExceptionCode.DATASOURCE_DELETE_ERROR, (Object)"\u6570\u636e\u6743\u9650\u4e0d\u8db3");
            }
            DataSourceDeleteParam deleteParam = new DataSourceDeleteParam();
            deleteParam.setIdList(datasourceIds);
            this.dataSourceDAO.delete(deleteParam);
            LeakCheckConfigQueryParam configQueryParam = new LeakCheckConfigQueryParam();
            configQueryParam.setDatasourceIds(datasourceIds);
            List configResultList = this.checkConfigDAO.selectList(configQueryParam);
            if (CollectionUtils.isNotEmpty((Collection)configResultList)) {
                List configIds = configResultList.stream().map(LeakCheckConfigResult::getId).collect(Collectors.toList());
                LeakCheckConfigDeleteParam configDeleteParam = new LeakCheckConfigDeleteParam();
                configDeleteParam.setIds(configIds);
                this.checkConfigDAO.delete(configDeleteParam);
            }
            LeakCheckConfigDetailQueryParam detailQueryParam = new LeakCheckConfigDetailQueryParam();
            detailQueryParam.setDatasourceIds(datasourceIds);
            List detailResultList = this.checkDetailDAO.selectList(detailQueryParam);
            if (CollectionUtils.isNotEmpty((Collection)detailResultList)) {
                List detailIds = detailResultList.stream().map(LeakCheckConfigBatchDetailResult::getId).collect(Collectors.toList());
                LeakCheckConfigDetailDeleteParam detailDeleteParam = new LeakCheckConfigDetailDeleteParam();
                detailDeleteParam.setIds(detailIds);
                this.checkDetailDAO.delete(detailDeleteParam);
            }
        }
    }

    public PagingList<DatasourceListResponse> listDatasource(DataSourceQueryRequest queryRequest) {
        List tagIdList;
        List tagManageResultList;
        PagingList pagingList;
        List<Object> filterDataSourceIdList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)queryRequest.getTagsIdList())) {
            List queryTagIdList = queryRequest.getTagsIdList();
            List tagRefResultListByTagId = this.dataSourceTagRefDAO.selectDataSourceTagRefByTagIds(queryTagIdList);
            if (CollectionUtils.isNotEmpty((Collection)tagRefResultListByTagId)) {
                filterDataSourceIdList = tagRefResultListByTagId.stream().map(DataSourceTagRefResult::getDataSourceId).collect(Collectors.toList());
            } else {
                return PagingList.empty();
            }
        }
        String name = queryRequest.getDatasourceName();
        String jdbcUrl = queryRequest.getJdbcUrl();
        DataSourceQueryParam queryParam = new DataSourceQueryParam();
        queryParam.setCurrent(queryRequest.getCurrent() + 1);
        queryParam.setPageSize(Integer.valueOf(queryRequest.getPageSize()));
        if (!Objects.isNull(queryRequest.getType())) {
            Integer type = queryRequest.getType().getCode();
            queryParam.setType(type);
        }
        queryParam.setName(name);
        queryParam.setJdbcUrl(jdbcUrl);
        if (CollectionUtils.isNotEmpty((Collection)filterDataSourceIdList)) {
            queryParam.setDataSourceIdList((List)filterDataSourceIdList);
        }
        if ((pagingList = this.dataSourceDAO.selectPage(queryParam)).isEmpty()) {
            return PagingList.empty();
        }
        List dataSourceIdList = pagingList.getList().stream().map(DataSourceResult::getId).collect(Collectors.toList());
        List tagRefResultList = this.dataSourceTagRefDAO.selectTagRefByDataSourceIds(dataSourceIdList);
        if (CollectionUtils.isNotEmpty((Collection)tagRefResultList) && CollectionUtils.isNotEmpty((Collection)(tagManageResultList = this.tagManageDAO.selectDataSourceTagsByIds(tagIdList = tagRefResultList.stream().map(DataSourceTagRefResult::getTagId).collect(Collectors.toList()))))) {
            for (DataSourceTagRefResult refResult : tagRefResultList) {
                Optional<TagManageResult> optional = tagManageResultList.stream().filter(tagManageResult -> tagManageResult.getId().equals(refResult.getTagId())).findFirst();
                optional.ifPresent(tagManageResult -> refResult.setTagName(tagManageResult.getTagName()));
            }
        }
        List responseList = pagingList.getList().stream().map(result -> {
            List dataSourceTagRefResultList;
            DatasourceListResponse response = new DatasourceListResponse();
            response.setDatasourceId(result.getId());
            response.setDatasourceName(result.getName());
            DataSourceTypeResponse typeResponse = new DataSourceTypeResponse();
            typeResponse.setLabel(DataSourceVerifyTypeEnum.getTypeByCode((Integer)result.getType()).name());
            typeResponse.setValue(result.getType());
            response.setType(typeResponse);
            response.setJdbcUrl(result.getJdbcUrl());
            response.setUsername(result.getUsername());
            response.setGmtUpdate(result.getUpdateTime());
            response.setTags(Collections.emptyList());
            if (CollectionUtils.isNotEmpty((Collection)tagRefResultList) && CollectionUtils.isNotEmpty(dataSourceTagRefResultList = tagRefResultList.stream().filter(tagRefResult -> tagRefResult.getDataSourceId().equals(result.getId())).collect(Collectors.toList()))) {
                List tagManageResponseList = dataSourceTagRefResultList.stream().map(tagRefResult -> {
                    TagManageResponse tagManageResponse = new TagManageResponse();
                    tagManageResponse.setId(tagRefResult.getTagId());
                    tagManageResponse.setTagName(tagRefResult.getTagName());
                    return tagManageResponse;
                }).collect(Collectors.toList());
                response.setTags(tagManageResponseList);
            }
            return response;
        }).collect(Collectors.toList());
        return PagingList.of(responseList, (long)pagingList.getTotal());
    }

    public List<DatasourceDictionaryResponse> listDatasourceNoPage() {
        List<Object> datasourceDictionaryResponseList = Lists.newArrayList();
        DataSourceQueryParam queryParam = new DataSourceQueryParam();
        List dataSourceResultList = this.dataSourceDAO.selectList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)dataSourceResultList)) {
            datasourceDictionaryResponseList = dataSourceResultList.stream().map(dataSourceResult -> {
                DatasourceDictionaryResponse dictionaryResponse = new DatasourceDictionaryResponse();
                dictionaryResponse.setDatasourceId(dataSourceResult.getId());
                dictionaryResponse.setDatasourceName(dataSourceResult.getName());
                dictionaryResponse.setJdbcUrl(dataSourceResult.getJdbcUrl());
                return dictionaryResponse;
            }).collect(Collectors.toList());
        }
        return datasourceDictionaryResponseList;
    }

    public DatasourceDetailResponse getDatasource(Long datasourceId) {
        DataSourceSingleQueryParam queryParam = new DataSourceSingleQueryParam();
        queryParam.setId(datasourceId);
        DataSourceResult dataSourceResult = this.dataSourceDAO.selectSingle(queryParam);
        if (!Objects.isNull(dataSourceResult)) {
            DatasourceDetailResponse datasourceResponse = new DatasourceDetailResponse();
            datasourceResponse.setDatasourceId(dataSourceResult.getId());
            datasourceResponse.setDatasourceName(dataSourceResult.getName());
            datasourceResponse.setType(dataSourceResult.getType());
            datasourceResponse.setJdbcUrl(dataSourceResult.getJdbcUrl());
            datasourceResponse.setUsername(dataSourceResult.getUsername());
            return datasourceResponse;
        }
        return null;
    }

    public List<TagManageResponse> getDatasourceTags() {
        List tagManageResults = this.tagManageDAO.selectDataSourceTags();
        if (CollectionUtils.isNotEmpty((Collection)tagManageResults)) {
            return tagManageResults.stream().map(tagManageResult -> {
                TagManageResponse tagManageResponse = new TagManageResponse();
                tagManageResponse.setId(tagManageResult.getId());
                tagManageResponse.setTagName(tagManageResult.getTagName());
                return tagManageResponse;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Transactional(rollbackFor={Throwable.class})
    public void updateDatasourceTags(DataSourceUpdateTagsRequest tagsRequest) {
        List collect = tagsRequest.getTagNames().stream().filter(o -> o.length() > 64).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.DATASOURCE_MANAGE_TAG_ADD_VALID_ERROR, (Object)"\u6807\u7b7e\u957f\u5ea6\u8d85\u8fc764");
        }
        Long dataSourceId = tagsRequest.getDatasourceId();
        DataSourceSingleQueryParam queryParam = new DataSourceSingleQueryParam();
        queryParam.setId(dataSourceId);
        DataSourceResult dataSourceResult = this.dataSourceDAO.selectSingle(queryParam);
        if (dataSourceResult != null) {
            this.dataSourceTagRefDAO.deleteByDataSourceId(dataSourceId);
            if (CollectionUtils.isNotEmpty((Collection)tagsRequest.getTagNames())) {
                List tagManageParams = tagsRequest.getTagNames().stream().distinct().map(tagName -> {
                    TagManageParam tagManageParam = new TagManageParam();
                    tagManageParam.setTagName(tagName);
                    tagManageParam.setTagType(Integer.valueOf(1));
                    return tagManageParam;
                }).collect(Collectors.toList());
                List tagIds = this.tagManageDAO.addDatasourceTags(tagManageParams);
                this.dataSourceTagRefDAO.addDataSourceTagRef(tagIds, dataSourceId);
            }
        }
    }

    public String testConnection(DataSourceTestRequest testRequest) {
        try {
            Long currentTime = JdbcConnection.fetchCurrentTime((String)testRequest.getJdbcUrl(), (String)testRequest.getUsername(), (String)testRequest.getPassword(), (DataSourceVerifyTypeEnum)DataSourceVerifyTypeEnum.getTypeByCode((Integer)testRequest.getType()));
            if (Objects.isNull(currentTime)) {
                return "\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25!";
            }
        }
        catch (RuntimeException exception) {
            String message = exception.getMessage();
            if (message.indexOf("\uff0c") != -1) {
                message = message.split("\uff0c")[0];
            }
            log.warn("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25:{}", (Object)message);
            return "\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff1a" + message;
        }
        return "";
    }

    public List<String> getBizActivitiesName(Long datasourceId) {
        List businessActivityIdList;
        List businessLinkResults;
        LeakCheckConfigQueryParam checkConfigQueryParam = new LeakCheckConfigQueryParam();
        checkConfigQueryParam.setDatasourceIds(Arrays.asList(datasourceId));
        List checkConfigResults = this.checkConfigDAO.selectList(checkConfigQueryParam);
        if (CollectionUtils.isNotEmpty((Collection)checkConfigResults) && CollectionUtils.isNotEmpty((Collection)(businessLinkResults = this.businessLinkManageDAO.selectBussinessLinkByIdList(businessActivityIdList = checkConfigResults.stream().map(LeakCheckConfigResult::getBusinessActivityId).collect(Collectors.toList()))))) {
            return businessLinkResults.stream().map(BusinessLinkResult::getLinkName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Boolean checkConnection(String jdbcUrl, String username, String password, Integer type) {
        try {
            Long currentTime = JdbcConnection.fetchCurrentTime((String)jdbcUrl, (String)username, (String)password, (DataSourceVerifyTypeEnum)DataSourceVerifyTypeEnum.getTypeByCode((Integer)type));
            if (Objects.isNull(currentTime)) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (RuntimeException exception) {
            log.warn("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25:{}", (Object)exception.getMessage());
            return Boolean.FALSE;
        }
    }

    private Boolean checkIsExistName(String name) {
        DataSourceSingleQueryParam queryNameParam = new DataSourceSingleQueryParam();
        queryNameParam.setName(name);
        queryNameParam.setCustomerId(RestContext.getUser().getCustomerId());
        DataSourceResult nameResult = this.dataSourceDAO.selectSingle(queryNameParam);
        if (!Objects.isNull(nameResult)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean checkIsExistJdbcUrl(String jdbcUrl) {
        DataSourceSingleQueryParam queryJdbcParam = new DataSourceSingleQueryParam();
        queryJdbcParam.setJdbcUrl(jdbcUrl);
        queryJdbcParam.setCustomerId(RestContext.getUser().getCustomerId());
        DataSourceResult jdbcResult = this.dataSourceDAO.selectSingle(queryJdbcParam);
        if (!Objects.isNull(jdbcResult)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean checkIsExistDataSource(Long id) {
        DataSourceSingleQueryParam queryJdbcParam = new DataSourceSingleQueryParam();
        queryJdbcParam.setId(id);
        queryJdbcParam.setCustomerId(RestContext.getUser().getCustomerId());
        DataSourceResult jdbcResult = this.dataSourceDAO.selectSingle(queryJdbcParam);
        if (!Objects.isNull(jdbcResult)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean checkUpdatePermssion(Long userId) {
        List allowUpdateUserIdList = RestContext.getUpdateAllowUserIdList();
        if (CollectionUtils.isNotEmpty((Collection)allowUpdateUserIdList) && !allowUpdateUserIdList.contains(userId)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkDeletePermssion(List<Long> userIdList) {
        List allowDeleteUserIdList = RestContext.getDeleteAllowUserIdList();
        if (CollectionUtils.isNotEmpty((Collection)allowDeleteUserIdList) && !allowDeleteUserIdList.containsAll(userIdList)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean checkIsSupport(Integer code) {
        DataSourceVerifyTypeEnum typeEnum = DataSourceVerifyTypeEnum.getTypeByCode((Integer)code);
        if (Objects.isNull(typeEnum)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

