/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.constant.AppConfigSheetEnum;
import com.pamirs.tro.common.constant.AppSwitchEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.common.util.PageInfo;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.dao.simplify.TAppMiddlewareInfoMapper;
import com.pamirs.tro.entity.dao.user.TUserMapper;
import com.pamirs.tro.entity.domain.dto.ApplicationSwitchStatusDTO;
import com.pamirs.tro.entity.domain.dto.NodeUploadDataDTO;
import com.pamirs.tro.entity.domain.dto.config.ImportConfigDTO;
import com.pamirs.tro.entity.domain.dto.linkmanage.InterfaceVo;
import com.pamirs.tro.entity.domain.entity.ExceptionInfo;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import com.pamirs.tro.entity.domain.entity.simplify.TAppMiddlewareInfo;
import com.pamirs.tro.entity.domain.entity.user.User;
import com.pamirs.tro.entity.domain.query.ApplicationQueryParam;
import com.pamirs.tro.entity.domain.query.LinkGuardQueryParam;
import com.pamirs.tro.entity.domain.query.agent.AppMiddlewareQuery;
import com.pamirs.tro.entity.domain.vo.ApplicationVo;
import com.pamirs.tro.entity.domain.vo.JarVersionVo;
import com.pamirs.tro.entity.domain.vo.dsmanage.Configurations;
import com.pamirs.tro.entity.domain.vo.dsmanage.DataSource;
import com.pamirs.tro.entity.domain.vo.guardmanage.LinkGuardVo;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.web.app.cache.AgentConfigCacheManager;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.controller.openapi.response.application.ApplicationListResponse;
import io.shulie.tro.web.app.request.application.ApplicationDsCreateRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsUpdateRequest;
import io.shulie.tro.web.app.request.application.ShadowConsumerQueryRequest;
import io.shulie.tro.web.app.request.application.ShadowConsumerUpdateRequest;
import io.shulie.tro.web.app.response.application.ShadowConsumerResponse;
import io.shulie.tro.web.app.response.application.ShadowServerConfigurationResponse;
import io.shulie.tro.web.app.service.AppConfigEntityConvertService;
import io.shulie.tro.web.app.service.ApplicationService;
import io.shulie.tro.web.app.service.ConfCenterService;
import io.shulie.tro.web.app.service.ShadowConsumerService;
import io.shulie.tro.web.app.service.auth.TroAuthService;
import io.shulie.tro.web.app.service.dsManage.DsService;
import io.shulie.tro.web.app.service.linkManage.LinkGuardService;
import io.shulie.tro.web.app.service.linkManage.WhiteListService;
import io.shulie.tro.web.app.service.simplify.ShadowJobConfigService;
import io.shulie.tro.web.app.service.user.TroUserService;
import io.shulie.tro.web.app.service.user.TroWebUserService;
import io.shulie.tro.web.app.utils.DsManageUtil;
import io.shulie.tro.web.app.utils.PageUtils;
import io.shulie.tro.web.app.utils.WhiteListUtil;
import io.shulie.tro.web.app.utils.xlsx.ExcelUtils;
import io.shulie.tro.web.auth.api.ResourceService;
import io.shulie.tro.web.auth.api.UserService;
import io.shulie.tro.web.common.constant.WhiteListConstants;
import io.shulie.tro.web.common.enums.excel.BooleanEnum;
import io.shulie.tro.web.common.enums.shadow.ShadowMqConsumerType;
import io.shulie.tro.web.common.util.JsonUtil;
import io.shulie.tro.web.common.vo.application.ApplicationDsManageExportVO;
import io.shulie.tro.web.common.vo.excel.BlacklistExcelVO;
import io.shulie.tro.web.common.vo.excel.ExcelSheetVO;
import io.shulie.tro.web.common.vo.excel.LinkGuardExcelVO;
import io.shulie.tro.web.common.vo.excel.ShadowConsumerExcelVO;
import io.shulie.tro.web.common.vo.excel.ShadowJobExcelVO;
import io.shulie.tro.web.common.vo.excel.WhiteListExcelVO;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.dao.application.ApplicationDsManageDAO;
import io.shulie.tro.web.data.dao.application.ApplicationNodeDAO;
import io.shulie.tro.web.data.dao.application.LinkGuardDAO;
import io.shulie.tro.web.data.dao.application.ShadowJobConfigDAO;
import io.shulie.tro.web.data.dao.application.ShadowMqConsumerDAO;
import io.shulie.tro.web.data.dao.application.WhiteListDAO;
import io.shulie.tro.web.data.dao.application.WhitelistEffectiveAppDao;
import io.shulie.tro.web.data.dao.blacklist.BlackListDAO;
import io.shulie.tro.web.data.model.mysql.ApplicationDsManageEntity;
import io.shulie.tro.web.data.model.mysql.LinkGuardEntity;
import io.shulie.tro.web.data.model.mysql.ShadowJobConfigEntity;
import io.shulie.tro.web.data.model.mysql.ShadowMqConsumerEntity;
import io.shulie.tro.web.data.param.application.ApplicationNodeQueryParam;
import io.shulie.tro.web.data.param.blacklist.BlacklistSearchParam;
import io.shulie.tro.web.data.param.blacklist.BlacklistUpdateParam;
import io.shulie.tro.web.data.result.application.ApplicationDetailResult;
import io.shulie.tro.web.data.result.application.ApplicationNodeResult;
import io.shulie.tro.web.data.result.application.ApplicationResult;
import io.shulie.tro.web.data.result.blacklist.BlacklistResult;
import io.shulie.tro.web.data.result.whitelist.WhitelistEffectiveAppResult;
import io.shulie.tro.web.data.result.whitelist.WhitelistResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.DocumentException;
import org.mockito.internal.util.collections.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
@EnableScheduling
public class ApplicationServiceImpl
implements ApplicationService,
WhiteListConstants {
    private static final Logger log = LoggerFactory.getLogger(ApplicationServiceImpl.class);
    public static final String PRADAR_SEPERATE_FLAG = "_NEW_PRADAR_";
    public static final String PRADARNODE_SEPERATE_FLAG = "_PRADARNODE_";
    public static final String PRADARNODE_KEYSET = "_PRADARNODE_KEYSET";
    protected static final ScheduledExecutorService service = new ScheduledThreadPoolExecutor(1);
    private static final String FALSE_CORE = "0";
    private static final String NEED_VERIFY_USER_MAP = "NEED_VERIFY_USER_MAP";
    private static final String PRADAR_SWITCH_STATUS = "PRADAR_SWITCH_STATUS_";
    private static final String PRADAR_SWITCH_STATUS_VO = "PRADAR_SWITCH_STATUS_VO_";
    private static final String PRADAR_SWITCH_ERROR_INFO_UID = "PRADAR_SWITCH_ERROR_INFO_";
    @Autowired
    ResourceService resourceService;
    @Autowired
    TroAuthService troAuthService;
    @Autowired
    TroUserService troUserService;
    @Autowired
    TroWebUserService troWebUserService;
    @Autowired
    private ConfCenterService confCenterService;
    @Resource
    private TApplicationMntDao tApplicationMntDao;
    @Resource
    private TAppMiddlewareInfoMapper tAppMiddlewareInfoMapper;
    @Resource
    private TUserMapper TUserMapper;
    @Autowired
    private RedisTemplate redisTemplate;
    @Value(value="${pradar.switch.processing.wait.time:61}")
    private Integer pradarSwitchProcessingTime;
    @Autowired
    private ApplicationDAO applicationDAO;
    @Autowired
    private UserService userService;
    @Autowired
    private ApplicationNodeDAO applicationNodeDAO;
    @Autowired
    private AgentConfigCacheManager agentConfigCacheManager;
    @Autowired
    private WhiteListService whiteListService;
    @Autowired
    private ShadowJobConfigService shadowJobConfigService;
    @Autowired
    private LinkGuardService linkGuardService;
    @Autowired
    private ApplicationDsManageDAO applicationDsManageDao;
    @Autowired
    private WhitelistEffectiveAppDao whitelistEffectiveAppDao;
    @Autowired
    private ShadowConsumerService shadowConsumerService;
    @Autowired
    private AppConfigEntityConvertService appConfigEntityConvertService;
    @Autowired
    private DsService dsService;
    @Autowired
    private LinkGuardDAO linkGuardDAO;
    @Value(value="${fast.debug.upload.log.path:/data/app/config/}")
    private String configPath;
    @Value(value="${application.ds.config.is.new.version: false}")
    private Boolean isNewVersion;
    @Autowired
    private ShadowJobConfigDAO shadowJobConfigDAO;
    @Autowired
    private WhiteListDAO whiteListDAO;
    @Autowired
    private ShadowMqConsumerDAO shadowMqConsumerDAO;
    @Autowired
    private BlackListDAO blackListDAO;

    @Scheduled(fixedRate=30000L)
    public void configureTasks() {
        Map map = this.redisTemplate.opsForHash().entries((Object)NEED_VERIFY_USER_MAP);
        if (map != null && map.size() > 0) {
            Map data = map;
            log.info("\u5f53\u524d\u5f85\u6267\u884c\u7528\u6237\u6570\uff1a => " + map.size());
            data.entrySet().forEach(longEntry -> {
                if (System.currentTimeMillis() - (Long)longEntry.getValue() >= (long)(this.pradarSwitchProcessingTime * 1000)) {
                    Object key = longEntry.getKey();
                    Long uid = Long.valueOf(key.toString());
                    String switchStatus = this.getUserSwitchStatusForAgent(uid);
                    this.redisTemplate.opsForValue().set((Object)(PRADAR_SWITCH_STATUS_VO + uid), (Object)switchStatus);
                    this.redisTemplate.opsForHash().delete((Object)NEED_VERIFY_USER_MAP, new Object[]{String.valueOf(longEntry.getKey())});
                }
            });
        }
    }

    public List<ApplicationListResponse> getApplicationList(String appNames) {
        List results;
        ArrayList appNamesList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)appNames)) {
            appNamesList = Lists.newArrayList((Object[])appNames.split(","));
        }
        if ((results = this.applicationDAO.getApplications((List)appNamesList)) == null || results.size() == 0) {
            return Lists.newArrayList();
        }
        ApplicationNodeQueryParam param = new ApplicationNodeQueryParam();
        List nodeAppNames = results.stream().map(ApplicationDetailResult::getApplicationName).collect(Collectors.toList());
        param.setApplicationNames(nodeAppNames);
        param.setCurrent(0);
        param.setPageSize(Integer.valueOf(99999999));
        PagingList nodeResults = this.applicationNodeDAO.pageNodes(param);
        Map<String, List<ApplicationNodeResult>> nodeIpMap = nodeResults.getList().stream().collect(Collectors.groupingBy(ApplicationNodeResult::getAppName));
        return results.stream().map(result -> {
            ApplicationListResponse response = new ApplicationListResponse();
            BeanUtils.copyProperties((Object)result, (Object)response);
            if (nodeIpMap.get(result.getApplicationName()) != null && ((List)nodeIpMap.get(result.getApplicationName())).size() > 0) {
                response.setIpsList(((List)nodeIpMap.get(result.getApplicationName())).stream().map(ApplicationNodeResult::getNodeIp).collect(Collectors.toList()));
                response.setNodeNum(Integer.valueOf(((List)nodeIpMap.get(result.getApplicationName())).size()));
                if (!response.getNodeNum().equals(result.getNodeNum()) || ((List)nodeIpMap.get(result.getApplicationName())).stream().map(ApplicationNodeResult::getAgentVersion).distinct().count() > 1L) {
                    response.setAccessStatus(Integer.valueOf(3));
                }
            } else {
                response.setIpsList((List)Lists.newArrayList());
                response.setNodeNum(Integer.valueOf(0));
                response.setAccessStatus(Integer.valueOf(3));
            }
            return response;
        }).collect(Collectors.toList());
    }

    public Response<List<ApplicationVo>> getApplicationList(ApplicationQueryParam queryParam) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("applicationName", queryParam.getApplicationName());
        param.put("pageSize", queryParam.getPageSize());
        param.put("pageNum", queryParam.getCurrentPage());
        param.put("applicationIds", queryParam.getApplicationIds());
        User user = RestContext.getUser();
        PageInfo pageInfo = this.confCenterService.queryApplicationList(param);
        List list = pageInfo.getList();
        List applicationVoList = this.appEntryListToVoList(list);
        List userIds = applicationVoList.stream().map(ApplicationVo::getManagerId).filter(Objects::nonNull).collect(Collectors.toList());
        Map userMap = this.userService.getUserMapByIds(userIds);
        applicationVoList.forEach(data -> data.setManagerName(Optional.ofNullable(userMap.get(data.getManagerId())).map(User::getName).orElse("")));
        return Response.success((List)applicationVoList, (long)(CollectionUtils.isEmpty((Collection)applicationVoList) ? 0L : pageInfo.getTotal()));
    }

    public List<ApplicationVo> getApplicationListVo(ApplicationQueryParam queryParam) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("applicationName", queryParam.getApplicationName());
        param.put("pageSize", queryParam.getPageSize());
        param.put("pageNum", queryParam.getCurrentPage());
        param.put("applicationIds", queryParam.getApplicationIds());
        User user = RestContext.getUser();
        if (user == null) {
            String key = RestContext.getTenantUserKey();
            user = this.troWebUserService.queryUserByKey(key);
        }
        PageInfo pageInfo = this.confCenterService.queryApplicationList(param);
        List list = pageInfo.getList();
        List applicationVoList = this.appEntryListToVoList(list);
        List userIds = applicationVoList.stream().filter(data -> null != data.getManagerId()).map(ApplicationVo::getManagerId).collect(Collectors.toList());
        Map userMap = this.userService.getUserMapByIds(userIds);
        applicationVoList.stream().map(data -> {
            String userName = Optional.ofNullable(userMap.get(data.getManagerId())).map(u -> u.getName()).orElse("");
            data.setManagerName(userName);
            return data;
        }).collect(Collectors.toList());
        return applicationVoList;
    }

    public Response getApplicationList(ApplicationQueryParam param, Integer accessStatus) {
        if (accessStatus == null) {
            return this.getApplicationList(param);
        }
        Integer pageSize = param.getPageSize();
        Integer currentPage = param.getCurrentPage();
        param.setPageSize(Integer.valueOf(-1));
        Response response = this.getApplicationList(param);
        List voList = (List)response.getData();
        if (CollectionUtils.isEmpty((Collection)voList)) {
            return response;
        }
        currentPage = currentPage - 1;
        List filterData = voList.stream().filter(vo -> vo.getAccessStatus().equals(accessStatus)).collect(Collectors.toList());
        List page = PageUtils.getPage((Boolean)true, (Integer)currentPage, (Integer)pageSize, filterData);
        return Response.success((List)page, (long)(CollectionUtils.isEmpty(filterData) ? 0L : (long)filterData.size()));
    }

    public Response getApplicationList() {
        List<Object> applicationVoList = Lists.newArrayList();
        List userIdList = RestContext.getQueryAllowUserIdList();
        List applicationDetailResultList = this.applicationDAO.getApplicationListByUserIds(userIdList);
        if (CollectionUtils.isNotEmpty((Collection)applicationDetailResultList)) {
            applicationVoList = applicationDetailResultList.stream().map(applicationDetailResult -> {
                ApplicationVo applicationVo = new ApplicationVo();
                applicationVo.setId(String.valueOf(applicationDetailResult.getApplicationId()));
                applicationVo.setApplicationName(applicationDetailResult.getApplicationName());
                return applicationVo;
            }).collect(Collectors.toList());
        }
        return Response.success((Object)applicationVoList);
    }

    public Response getApplicationInfo(String id) {
        if (id == null) {
            return Response.fail((String)FALSE_CORE, (String)"\u5e94\u7528id\u4e0d\u80fd\u4e3anull", null);
        }
        TApplicationMnt tApplicationMnt = this.confCenterService.queryApplicationinfoById(Long.valueOf(id).longValue());
        if (tApplicationMnt == null) {
            return Response.success((Object)new ApplicationVo());
        }
        List applicationResultList = this.applicationDAO.getApplicationByName(Arrays.asList(tApplicationMnt.getApplicationName()));
        ApplicationResult applicationResult = CollectionUtils.isEmpty((Collection)applicationResultList) ? null : (ApplicationResult)applicationResultList.get(0);
        ApplicationNodeQueryParam queryParam = new ApplicationNodeQueryParam();
        queryParam.setCurrent(0);
        queryParam.setPageSize(Integer.valueOf(99999));
        queryParam.setApplicationNames(Arrays.asList(tApplicationMnt.getApplicationName()));
        PagingList applicationNodes = this.applicationNodeDAO.pageNodes(queryParam);
        List applicationNodeResultList = applicationNodes.getList();
        ApplicationVo vo = this.appEntryToVo(tApplicationMnt, applicationResult, applicationNodeResultList);
        return Response.success((Object)vo);
    }

    public Response getApplicationInfoForError(String id) {
        TApplicationMnt tApplicationMnt;
        if (id == null) {
            return Response.fail((String)FALSE_CORE, (String)"\u5e94\u7528id\u4e0d\u80fd\u4e3anull", null);
        }
        User user = RestContext.getUser();
        if (user == null) {
            user = this.troWebUserService.queryUserByKey(RestContext.getTenantUserKey());
        }
        if ((tApplicationMnt = this.confCenterService.queryApplicationinfoByIdAndRole(Long.valueOf(id).longValue())) == null) {
            Response.success();
        }
        return Response.success((Object)tApplicationMnt);
    }

    public Response addApplication(ApplicationVo param) {
        if (param == null) {
            return Response.fail((String)FALSE_CORE, (String)"\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        try {
            if (StringUtil.isEmpty((String)param.getSwitchStutus())) {
                param.setSwitchStutus(AppSwitchEnum.OPENED.getCode());
            }
            if (param.getNodeNum() == null) {
                param.setNodeNum(Integer.valueOf(1));
            }
            this.confCenterService.saveApplication(this.voToAppEntity(param));
        }
        catch (TROModuleException e) {
            OperationLogContextHolder.ignoreLog();
            return Response.fail((String)FALSE_CORE, (String)e.getErrorMessage(), (Object[])new Object[]{e.getErrorMessage()});
        }
        return Response.success();
    }

    public Response addAgentRegisteApplication(ApplicationVo param) {
        if (param == null) {
            return Response.fail((String)FALSE_CORE, (String)"\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        if (StringUtils.isBlank((CharSequence)param.getApplicationName())) {
            return Response.fail((String)FALSE_CORE, (String)"\u5e94\u7528\u540d\u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        try {
            if (StringUtil.isEmpty((String)param.getSwitchStutus())) {
                param.setSwitchStutus(AppSwitchEnum.OPENED.getCode());
            }
            if (param.getNodeNum() == null) {
                param.setNodeNum(Integer.valueOf(1));
            }
            this.confCenterService.saveAgentRegisteApplication(this.voToAppEntity(param));
        }
        catch (TROModuleException e) {
            OperationLogContextHolder.ignoreLog();
            return Response.fail((String)FALSE_CORE, (String)e.getErrorMessage(), (Object[])new Object[]{e.getErrorMessage()});
        }
        return Response.success();
    }

    public Response modifyApplication(ApplicationVo param) {
        if (param == null || StringUtil.isEmpty((String)param.getId())) {
            return Response.fail((String)FALSE_CORE, (String)"\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        try {
            Response applicationVoResponse = this.getApplicationInfo(param.getId());
            if (null == ((ApplicationVo)applicationVoResponse.getData()).getId()) {
                return Response.fail((String)"\u8be5\u5e94\u7528\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            }
            ApplicationVo applicationVo = (ApplicationVo)applicationVoResponse.getData();
            String applicationName = param.getApplicationName();
            if (!applicationVo.getNodeNum().equals(param.getNodeNum())) {
                applicationName = applicationName + "\uff5c\u8282\u70b9\u6570\u91cf\uff1a" + param.getNodeNum();
            } else if (applicationVo.getApplicationName().equals(param.getApplicationName())) {
                OperationLogContextHolder.ignoreLog();
            }
            if (StringUtil.isNotEmpty((String)param.getApplicationName())) {
                this.updateConfigAppName(param.getId(), param.getApplicationName());
            }
            OperationLogContextHolder.addVars((String)"application", (String)applicationName);
            this.confCenterService.updateApplicationinfo(this.voToAppEntity(param));
        }
        catch (TROModuleException e) {
            return Response.fail((String)FALSE_CORE, (String)e.getErrorMessage(), (Object[])new Object[]{e.getErrorMessage()});
        }
        return Response.success();
    }

    private void updateConfigAppName(String id, String appName) {
        this.shadowMqConsumerDAO.updateAppName(Long.valueOf(id), appName);
        this.linkGuardDAO.updateAppName(Long.valueOf(id), appName);
        this.applicationDsManageDao.updateAppName(Long.valueOf(id), appName);
    }

    public Response deleteApplication(String appId) {
        if (appId == null) {
            return Response.fail((String)FALSE_CORE, (String)"\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        this.confCenterService.deleteApplicationinfoByIds(appId);
        return Response.success();
    }

    public Response uploadAccessStatus(NodeUploadDataDTO param) {
        if (param == null || StringUtil.isEmpty((String)param.getApplicationName()) || StringUtil.isEmpty((String)param.getNodeKey())) {
            return Response.success((Object)"\u8282\u70b9\u552f\u4e00key|\u5e94\u7528\u540d\u79f0 \u4e0d\u80fd\u4e3a\u7a7a");
        }
        User user = this.troWebUserService.queryUserByKey(RestContext.getTenantUserKey());
        TApplicationMnt applicationMnt = this.tApplicationMntDao.queryApplicationInfoByNameAndTenant(param.getApplicationName(), user == null ? null : user.getId());
        if (applicationMnt != null) {
            if (param.getSwitchErrorMap().size() >= 0) {
                String key = applicationMnt.getApplicationId() + PRADAR_SEPERATE_FLAG + param.getAgentId();
                List nodeUploadDataDTOList = this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
                if (CollectionUtils.isEmpty((Collection)nodeUploadDataDTOList)) {
                    String nodeSetKey = applicationMnt.getApplicationId() + PRADARNODE_KEYSET;
                    this.redisTemplate.opsForSet().add((Object)nodeSetKey, new Object[]{key});
                    this.redisTemplate.expire((Object)nodeSetKey, 1L, TimeUnit.DAYS);
                    this.redisTemplate.opsForList().leftPush((Object)key, (Object)JSONObject.toJSONString((Object)param));
                    this.redisTemplate.expire((Object)key, 1L, TimeUnit.DAYS);
                } else {
                    this.redisTemplate.opsForList().leftPush((Object)key, (Object)JSONObject.toJSONString((Object)param));
                }
            }
            int status = 3;
            List applicationResultList = this.applicationDAO.getApplicationByName(Arrays.asList(param.getApplicationName()));
            if (!CollectionUtils.isEmpty((Collection)applicationResultList) && !((ApplicationResult)applicationResultList.get(0)).getAppIsException().booleanValue()) {
                status = 0;
            }
            this.modifyAccessStatus(String.valueOf(applicationMnt.getApplicationId()), Integer.valueOf(status), param.getSwitchErrorMap().toString());
        }
        return Response.success((Object)"\u4e0a\u4f20\u5e94\u7528\u72b6\u6001\u4fe1\u606f\u6210\u529f");
    }

    @Scheduled(cron="0/10 * *  * * ?")
    public void syncApplicationAccessStatus() {
        List applicationMntList = this.tApplicationMntDao.getAllApplicationByStatus(Arrays.asList(0, 1, 2, 3));
        if (!CollectionUtils.isEmpty((Collection)applicationMntList)) {
            List appNames = applicationMntList.stream().map(TApplicationMnt::getApplicationName).collect(Collectors.toList());
            List applicationResultList = this.applicationDAO.getApplicationByName(appNames);
            if (!CollectionUtils.isEmpty((Collection)applicationResultList)) {
                Set errorApplicationIdSet = Sets.newSet((Object[])new Long[0]);
                Set normalApplicationIdSet = Sets.newSet((Object[])new Long[0]);
                applicationMntList.forEach(applicationMnt -> {
                    String appName = applicationMnt.getApplicationName();
                    Optional<ApplicationResult> optional = applicationResultList.stream().filter(applicationResult -> applicationResult.getAppName().equals(appName)).findFirst();
                    if (optional.isPresent()) {
                        ApplicationResult applicationResult2 = optional.get();
                        Boolean appIsException = applicationResult2.getAppIsException();
                        if (appIsException.booleanValue()) {
                            if (applicationMnt.getAccessStatus() != 3) {
                                errorApplicationIdSet.add(applicationMnt.getApplicationId());
                            }
                        } else if (applicationMnt.getAccessStatus() != 0) {
                            normalApplicationIdSet.add(applicationMnt.getApplicationId());
                        }
                    }
                });
                if (errorApplicationIdSet.size() > 0) {
                    this.modifyAccessStatusWithoutAuth(new ArrayList(errorApplicationIdSet), Integer.valueOf(3));
                }
                if (normalApplicationIdSet.size() > 0) {
                    this.modifyAccessStatusWithoutAuth(new ArrayList(normalApplicationIdSet), Integer.valueOf(0));
                }
            }
        } else {
            log.debug("\u6682\u65e0\u5f85\u68c0\u6d4b\u5e94\u7528");
        }
    }

    public void modifyAccessStatus(String applicationId, Integer accessStatus, String exceptionInfo) {
        if (StringUtil.isNotEmpty((String)applicationId) && accessStatus != null) {
            ApplicationVo dbData = new ApplicationVo();
            dbData.setId(applicationId);
            dbData.setExceptionInfo(exceptionInfo);
            dbData.setAccessStatus(accessStatus);
            this.modifyApplication(dbData);
        }
    }

    public void modifyAccessStatusWithoutAuth(List<Long> applicationIds, Integer accessStatus) {
        if (CollectionUtils.isNotEmpty(applicationIds)) {
            this.tApplicationMntDao.updateApplicationStatus(applicationIds, accessStatus);
        }
    }

    public List<TApplicationMnt> getAllApplications() {
        return this.tApplicationMntDao.getAllApplications();
    }

    public List<TApplicationMnt> getApplicationsByUserIdList(List<Long> userIdList) {
        return this.tApplicationMntDao.getApplicationsByTenants(userIdList);
    }

    public String getIdByName(String applicationName) {
        return this.tApplicationMntDao.getIdByName(applicationName);
    }

    public Response uploadMiddleware(Map<String, String> requestMap) {
        return Response.success();
    }

    public Response calculateUserSwitch(Long uid) {
        if (uid == null) {
            User user = RestContext.getUser();
            if (user == null) {
                return Response.fail((String)FALSE_CORE, (String)"\u5f53\u524d\u7528\u6237\u4e3a\u7a7a", null);
            }
            uid = user.getId();
        }
        return Response.success();
    }

    public Response userAppPressureSwitch(Long uid, Boolean enable) {
        if (enable == null) {
            return Response.fail((String)FALSE_CORE, (String)"\u5f00\u5173\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        if (uid == null) {
            User user = RestContext.getUser();
            if (user == null) {
                return Response.fail((String)FALSE_CORE, (String)"\u5f53\u524d\u7528\u6237\u4e3a\u7a7a", null);
            }
            uid = user.getId();
        }
        String realStatus = this.getUserPressureSwitchFromRedis(uid);
        ApplicationVo vo = new ApplicationVo();
        String status = null;
        String voStatus = null;
        if (realStatus.equals(AppSwitchEnum.CLOSING.getCode()) || realStatus.equals(AppSwitchEnum.OPENING.getCode())) {
            vo.setSwitchStutus(realStatus);
            return Response.success((Object)realStatus);
        }
        status = (enable != false ? AppSwitchEnum.OPENED : AppSwitchEnum.CLOSED).getCode();
        voStatus = (enable != false ? AppSwitchEnum.OPENING : AppSwitchEnum.CLOSING).getCode();
        this.redisTemplate.opsForValue().set((Object)(PRADAR_SWITCH_STATUS + uid), (Object)status);
        this.redisTemplate.opsForValue().set((Object)(PRADAR_SWITCH_STATUS_VO + uid), (Object)voStatus);
        this.redisTemplate.opsForHash().put((Object)NEED_VERIFY_USER_MAP, (Object)String.valueOf(uid), (Object)System.currentTimeMillis());
        vo.setSwitchStutus(voStatus);
        this.agentConfigCacheManager.evictPressureSwitch();
        return Response.success((Object)vo);
    }

    public Response userAppSwitchInfo() {
        ApplicationSwitchStatusDTO result = new ApplicationSwitchStatusDTO();
        User user = RestContext.getUser();
        if (user == null) {
            String userAppKey = RestContext.getTenantUserKey();
            user = this.troWebUserService.queryUserByKey(userAppKey);
        }
        if (user == null) {
            return Response.fail((String)FALSE_CORE, (Object[])new Object[0]);
        }
        if (user.getRole() != null && user.getRole() == 1) {
            result.setSwitchStatus(AppSwitchEnum.OPENED.getCode());
        } else {
            result.setSwitchStatus(this.getUserSwitchStatusForVo(user.getId()));
        }
        return Response.success((Object)result);
    }

    public ApplicationSwitchStatusDTO agentGetUserSwitchInfo() {
        ApplicationSwitchStatusDTO result = new ApplicationSwitchStatusDTO();
        result.setSwitchStatus(this.getUserSwitchStatusForAgent(RestContext.getUser().getCustomerId()));
        return result;
    }

    private void reCalculateUserSwitch(Long uid) throws IllegalArgumentException {
        if (uid == null) {
            throw new IllegalArgumentException("uid can not by null !");
        }
        List tApplicationMnts = this.tApplicationMntDao.queryApplicationByTenant(uid);
        ArrayList<ApplicationVo> errorVoList = new ArrayList<ApplicationVo>();
        if (tApplicationMnts != null && tApplicationMnts.size() > 0) {
            for (TApplicationMnt app : tApplicationMnts) {
                ApplicationSwitchStatusDTO dto = this.judgeAppSwitchStatus(app, false);
                if (dto == null || dto.getErrorList().size() <= 0) continue;
                List errorList = dto.getErrorList();
                for (Object s : errorList) {
                    ApplicationVo vo = new ApplicationVo();
                    vo.setApplicationName(app.getApplicationName());
                    vo.setExceptionInfo(s.toString());
                    errorVoList.add(vo);
                }
            }
        }
        String oldStatus = this.getUserSwitchStatusForAgent(uid);
        String voStatus = null;
        String userStatus = null;
        if (errorVoList.size() > 0) {
            if (StringUtil.isNotEmpty((String)oldStatus) && oldStatus.equals(AppSwitchEnum.OPENED.getCode())) {
                voStatus = AppSwitchEnum.OPEN_FAILING.getCode();
            } else if (StringUtil.isNotEmpty((String)oldStatus) && oldStatus.equals(AppSwitchEnum.CLOSED.getCode())) {
                voStatus = AppSwitchEnum.CLOSE_FAILING.getCode();
            }
            userStatus = AppSwitchEnum.CLOSED.getCode();
        } else {
            voStatus = oldStatus;
            userStatus = oldStatus;
        }
        this.redisTemplate.opsForValue().set((Object)(PRADAR_SWITCH_STATUS + uid), (Object)userStatus);
        this.redisTemplate.opsForValue().set((Object)(PRADAR_SWITCH_STATUS_VO + uid), (Object)voStatus);
        this.redisTemplate.opsForValue().set((Object)(PRADAR_SWITCH_ERROR_INFO_UID + uid), errorVoList);
    }

    private String getUserSwitchStatusForAgent(Long uid) {
        if (uid == null) {
            return null;
        }
        Object o = this.redisTemplate.opsForValue().get((Object)(PRADAR_SWITCH_STATUS + uid));
        if (o == null) {
            this.redisTemplate.opsForValue().set((Object)(PRADAR_SWITCH_STATUS + uid), (Object)AppSwitchEnum.OPENED.getCode());
            return AppSwitchEnum.OPENED.getCode();
        }
        return (String)o;
    }

    public String getUserSwitchStatusForVo(Long uid) {
        if (uid == null) {
            return null;
        }
        Object o = this.redisTemplate.opsForValue().get((Object)(PRADAR_SWITCH_STATUS_VO + uid));
        if (o == null) {
            this.redisTemplate.opsForValue().set((Object)(PRADAR_SWITCH_STATUS_VO + uid), (Object)AppSwitchEnum.OPENED.getCode());
            return AppSwitchEnum.OPENED.getCode();
        }
        return (String)o;
    }

    public List<String> getApplicationName() {
        List userIdList = RestContext.getQueryAllowUserIdList();
        List applicationDetailResultList = this.applicationDAO.getApplicationListByUserIds(userIdList);
        if (CollectionUtils.isEmpty((Collection)applicationDetailResultList)) {
            return Lists.newArrayList();
        }
        List<String> dbAppNameList = applicationDetailResultList.stream().map(ApplicationDetailResult::getApplicationName).collect(Collectors.toList());
        return dbAppNameList;
    }

    public void exportApplicationConfig(HttpServletResponse response, Long applicationId) {
        ApplicationDetailResult application = this.applicationDAO.getApplicationById(applicationId);
        Assert.notNull((Object)application, (String)"\u5e94\u7528\u4e0d\u5b58\u5728!");
        ArrayList<ExcelSheetVO> sheets = new ArrayList<ExcelSheetVO>();
        sheets.add(this.getShadowSheet(applicationId));
        sheets.add(this.getLinkGuardSheet(applicationId));
        sheets.add(this.getJobSheet(applicationId));
        sheets.add(this.getWhiteListSheet(application));
        sheets.add(this.getShadowConsumerSheet(applicationId));
        sheets.add(this.getBlacklistSheet(applicationId));
        try {
            ExcelUtils.exportExcelManySheet((HttpServletResponse)response, (String)application.getApplicationName(), sheets);
        }
        catch (Exception e) {
            log.error("\u5e94\u7528\u914d\u7f6e\u5bfc\u51fa\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private ExcelSheetVO<?> getBlacklistSheet(Long applicationId) {
        BlacklistSearchParam param = new BlacklistSearchParam();
        param.setApplicationId(applicationId);
        List blacklistResults = this.blackListDAO.selectList(param);
        List excelModelList = this.blacklist2ExcelModel(blacklistResults);
        ExcelSheetVO blacklistSheet = new ExcelSheetVO();
        blacklistSheet.setData(excelModelList);
        blacklistSheet.setExcelModelClass(BlacklistExcelVO.class);
        blacklistSheet.setSheetName(AppConfigSheetEnum.BLACK.name());
        blacklistSheet.setSheetNum(Integer.valueOf(4));
        return blacklistSheet;
    }

    private List<BlacklistExcelVO> blacklist2ExcelModel(List<BlacklistResult> blacklistResults) {
        if (CollectionUtils.isEmpty(blacklistResults)) {
            return Collections.emptyList();
        }
        return blacklistResults.stream().map(result -> {
            BlacklistExcelVO model = new BlacklistExcelVO();
            model.setRedisKey(result.getRedisKey());
            model.setUseYn(result.getUseYn());
            return model;
        }).collect(Collectors.toList());
    }

    private ExcelSheetVO<?> getShadowSheet(Long applicationId) {
        List applicationDsManages = this.applicationDsManageDao.listByApplicationId(applicationId);
        ExcelSheetVO sheet = new ExcelSheetVO();
        sheet.setExcelModelClass(ApplicationDsManageExportVO.class);
        sheet.setSheetName(AppConfigSheetEnum.DADABASE.name());
        sheet.setSheetNum(AppConfigSheetEnum.DADABASE.getSheetNumber());
        if (applicationDsManages.isEmpty()) {
            sheet.setData(Collections.emptyList());
            return sheet;
        }
        List exportList = applicationDsManages.stream().map(ds -> {
            ApplicationDsManageExportVO dsExportVO = new ApplicationDsManageExportVO();
            BeanUtils.copyProperties((Object)ds, (Object)dsExportVO);
            if (StringUtils.isBlank((CharSequence)ds.getParseConfig())) {
                return dsExportVO;
            }
            if (!DsManageUtil.isNewVersionSchemaDsType((Integer)ds.getDsType(), (boolean)this.isNewVersion)) {
                return dsExportVO;
            }
            Configurations configurations = (Configurations)JsonUtil.json2bean((String)ds.getParseConfig(), Configurations.class);
            if (configurations == null) {
                return dsExportVO;
            }
            dsExportVO.setUserName(((DataSource)configurations.getDataSources().get(0)).getUsername());
            dsExportVO.setConfig("\u65e0");
            DataSource dsDataSource = (DataSource)configurations.getDataSources().get(1);
            dsExportVO.setShadowDbUrl(dsDataSource.getUrl());
            dsExportVO.setShadowDbUserName(dsDataSource.getUsername());
            dsExportVO.setShadowDbPassword(dsDataSource.getPassword());
            dsExportVO.setShadowDbMinIdle(dsDataSource.getMinIdle());
            dsExportVO.setShadowDbMaxActive(dsDataSource.getMaxActive());
            return dsExportVO;
        }).collect(Collectors.toList());
        sheet.setData(exportList);
        return sheet;
    }

    private ExcelSheetVO<ShadowConsumerExcelVO> getShadowConsumerSheet(Long applicationId) {
        List shadowMqConsumers = this.shadowMqConsumerDAO.listByApplicationId(applicationId);
        List excelModelList = this.shadowConsumer2ExcelModel(shadowMqConsumers);
        ExcelSheetVO shadowConsumerSheet = new ExcelSheetVO();
        shadowConsumerSheet.setData(excelModelList);
        shadowConsumerSheet.setExcelModelClass(ShadowConsumerExcelVO.class);
        shadowConsumerSheet.setSheetName(AppConfigSheetEnum.CONSUMER.name());
        shadowConsumerSheet.setSheetNum(Integer.valueOf(3));
        return shadowConsumerSheet;
    }

    public Response<String> buildExportDownLoadConfigUrl(String appId, HttpServletRequest request) {
        if (StringUtil.isEmpty((String)appId)) {
            return Response.success((Object)"");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("/application/center/app/config/export?id=");
        builder.append(appId);
        return Response.success((Object)builder.toString());
    }

    public Response<Boolean> appDsConfigIsNewVersion() {
        return Response.success((Object)this.isNewVersion);
    }

    private List<String> preCheck(Map<String, ArrayList<ArrayList<String>>> stringArrayListHashMap) {
        ArrayList<String> result = new ArrayList<String>();
        for (AppConfigSheetEnum sheetEnum : AppConfigSheetEnum.values()) {
            ArrayList<ArrayList<String>> arrayLists = stringArrayListHashMap.get(sheetEnum.name());
            if (CollectionUtils.isEmpty(arrayLists) || AppConfigSheetEnum.DADABASE.name().equals(sheetEnum.name())) continue;
            arrayLists.stream().filter(Objects::nonNull).forEach(strings -> {
                Integer columnNum = sheetEnum.getColumnNum();
                if (strings.size() < columnNum) {
                    String msg = sheetEnum.name() + strings.toString();
                    result.add(msg);
                }
            });
        }
        return result;
    }

    private void saveConfig2Db(Long applicationId, Map<String, ArrayList<ArrayList<String>>> configMap) {
        List shadowConsumerCreateRequests;
        ArrayList<ArrayList<String>> arrayLists;
        List tShadowJobConfigs;
        ArrayList<ArrayList<String>> guardList;
        List linkGuardVos;
        ApplicationDetailResult application = this.applicationDAO.getApplicationById(applicationId);
        Assert.notNull((Object)application, (String)"\u5e94\u7528\u4e0d\u5b58\u5728!");
        this.saveDsFromImport(applicationId, configMap.get(AppConfigSheetEnum.DADABASE.name()));
        if (configMap.containsKey(AppConfigSheetEnum.GUARD.name()) && CollectionUtils.isNotEmpty((Collection)(linkGuardVos = this.appConfigEntityConvertService.convertGuardSheet(guardList = configMap.get(AppConfigSheetEnum.GUARD.name()))))) {
            linkGuardVos.forEach(guard -> {
                guard.setApplicationName(application.getApplicationName());
                guard.setApplicationId(String.valueOf(application.getApplicationId()));
                LinkGuardQueryParam queryParam = new LinkGuardQueryParam();
                queryParam.setAppId(applicationId);
                queryParam.setMethodInfo(guard.getMethodInfo());
                Response response = this.linkGuardService.selectByExample(queryParam);
                if (CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
                    LinkGuardVo guardVo = (LinkGuardVo)((List)response.getData()).get(0);
                    guardVo.setGroovy(guard.getGroovy());
                    guardVo.setIsEnable(guard.getIsEnable());
                    guardVo.setUpdateTime(new Date());
                    guardVo.setRemark(guard.getRemark());
                    this.linkGuardService.updateGuard(guardVo);
                } else {
                    this.linkGuardService.addGuard(guard);
                }
            });
        }
        if (configMap.containsKey(AppConfigSheetEnum.JOB.name()) && CollectionUtils.isNotEmpty((Collection)(tShadowJobConfigs = this.appConfigEntityConvertService.convertJobSheet(arrayLists = configMap.get(AppConfigSheetEnum.JOB.name()))))) {
            tShadowJobConfigs.forEach(job -> {
                try {
                    job.setApplicationId(application.getApplicationId());
                    this.shadowJobConfigService.insert(job);
                }
                catch (DocumentException e) {
                    log.error(e.getMessage());
                }
            });
        }
        this.saveWhiteListFromImport(applicationId, configMap);
        this.saveBlacklistFromImport(applicationId, configMap);
        if (configMap.containsKey(AppConfigSheetEnum.CONSUMER.name()) && CollectionUtils.isNotEmpty((Collection)(shadowConsumerCreateRequests = this.appConfigEntityConvertService.converComsumerList(arrayLists = configMap.get(AppConfigSheetEnum.CONSUMER.name()))))) {
            shadowConsumerCreateRequests.forEach(request -> {
                request.setApplicationId(applicationId);
                try {
                    ShadowConsumerQueryRequest queryRequest = new ShadowConsumerQueryRequest();
                    queryRequest.setType(request.getType());
                    queryRequest.setTopicGroup(request.getTopicGroup());
                    queryRequest.setApplicationId(applicationId);
                    PagingList pagingList = this.shadowConsumerService.pageMqConsumers(queryRequest);
                    if (CollectionUtils.isNotEmpty((Collection)pagingList.getList())) {
                        ShadowConsumerResponse dbData = (ShadowConsumerResponse)pagingList.getList().get(0);
                        ShadowConsumerUpdateRequest updateRequest = new ShadowConsumerUpdateRequest();
                        BeanUtils.copyProperties((Object)request, (Object)updateRequest);
                        updateRequest.setId(dbData.getId());
                        this.shadowConsumerService.updateMqConsumers(updateRequest);
                    } else {
                        this.shadowConsumerService.createMqConsumers(request);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new RuntimeException("\u5f71\u5b50\u6d88\u8d39\u8005\u5bfc\u5165\u5931\u8d25!");
                }
            });
        }
    }

    private void saveBlacklistFromImport(Long applicationId, Map<String, ArrayList<ArrayList<String>>> configMap) {
        ArrayList<ArrayList<String>> importBlackLists = configMap.get(AppConfigSheetEnum.BLACK.name());
        if (importBlackLists == null) {
            return;
        }
        List whiteListCreateLists = this.appConfigEntityConvertService.converBlackList(importBlackLists, applicationId);
        if (CollectionUtils.isEmpty((Collection)whiteListCreateLists)) {
            return;
        }
        BlacklistSearchParam param = new BlacklistSearchParam();
        param.setApplicationId(applicationId);
        List results = this.blackListDAO.selectList(param);
        ArrayList createNewParams = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            Map<String, List<BlacklistResult>> blacklistMap = results.stream().collect(Collectors.groupingBy(BlacklistResult::getRedisKey));
            whiteListCreateLists.forEach(create -> {
                List list = (List)blacklistMap.get(create.getRedisKey());
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    list.forEach(updateResult -> {
                        BlacklistUpdateParam updateParam = new BlacklistUpdateParam();
                        BeanUtils.copyProperties((Object)updateResult, (Object)updateParam);
                        updateParam.setUseYn(create.getUseYn());
                        this.blackListDAO.update(updateParam);
                    });
                } else {
                    createNewParams.add(create);
                }
            });
        } else {
            createNewParams.addAll(whiteListCreateLists);
        }
        if (CollectionUtils.isNotEmpty((Collection)createNewParams)) {
            this.blackListDAO.batchInsert((List)createNewParams);
        }
    }

    private void saveWhiteListFromImport(Long applicationId, Map<String, ArrayList<ArrayList<String>>> configMap) {
        ArrayList<ArrayList<String>> importWhiteLists = configMap.get(AppConfigSheetEnum.WHITE.name());
        if (importWhiteLists == null) {
            return;
        }
        List inputs = this.appConfigEntityConvertService.converWhiteList(importWhiteLists);
        if (CollectionUtils.isEmpty((Collection)inputs)) {
            return;
        }
        inputs.forEach(vo -> vo.setApplicationId(applicationId));
        this.whiteListService.importWhiteListFromExcel(inputs);
    }

    private void saveDsFromImport(Long applicationId, ArrayList<ArrayList<String>> dsObjects) {
        if (CollectionUtils.isEmpty(dsObjects)) {
            return;
        }
        for (ArrayList<String> ds : dsObjects) {
            ApplicationDsCreateRequest dsCreateRequest = this.getApplicationDsCreateRequest(applicationId, ds);
            List applicationDsManages = this.applicationDsManageDao.listByApplicationIdAndDsType(applicationId, dsCreateRequest.getDsType());
            if (applicationDsManages.isEmpty()) {
                this.createDsFromImport(dsCreateRequest);
                continue;
            }
            ApplicationDsManageEntity applicationDsManage = applicationDsManages.stream().filter(item -> this.isSameFromImport(dsCreateRequest, item)).findFirst().orElse(null);
            if (applicationDsManage == null) {
                this.createDsFromImport(dsCreateRequest);
                continue;
            }
            this.updateDsFromImport(applicationDsManage, dsCreateRequest);
        }
    }

    private boolean isSameFromImport(ApplicationDsCreateRequest dsCreateRequest, ApplicationDsManageEntity applicationDsManage) {
        boolean same = false;
        if (DsManageUtil.isEsServerType((Integer)dsCreateRequest.getDsType())) {
            return this.compareImportEsConfig(dsCreateRequest, applicationDsManage);
        }
        if (DsManageUtil.isHbaseServerType((Integer)dsCreateRequest.getDsType())) {
            return this.compareImportEsConfig(dsCreateRequest, applicationDsManage);
        }
        if (DsManageUtil.isServerDsType((Integer)dsCreateRequest.getDsType())) {
            same = this.compareImportServerAndOriginServer(dsCreateRequest.getConfig(), applicationDsManage.getConfig());
        }
        if (DsManageUtil.isTableDsType((Integer)dsCreateRequest.getDsType())) {
            same = Objects.equals(applicationDsManage.getUrl(), dsCreateRequest.getUrl());
        }
        if (DsManageUtil.isSchemaDsType((Integer)dsCreateRequest.getDsType())) {
            same = this.isNewVersion != false ? Objects.equals(applicationDsManage.getUrl(), dsCreateRequest.getUrl()) : Objects.equals(applicationDsManage.getUrl(), this.dsService.parseShadowDbUrl(dsCreateRequest.getConfig()));
        }
        return same;
    }

    private boolean compareImportHbaseConfig(ApplicationDsCreateRequest dsCreateRequest, ApplicationDsManageEntity applicationDsManage) {
        return this.compareImportEsConfig(dsCreateRequest, applicationDsManage);
    }

    private boolean compareImportEsConfig(ApplicationDsCreateRequest dsCreateRequest, ApplicationDsManageEntity applicationDsManage) {
        String url = dsCreateRequest.getUrl();
        String exist = applicationDsManage.getUrl();
        boolean same = url.trim().equals(exist.trim());
        return same;
    }

    private void updateDsFromImport(ApplicationDsManageEntity applicationDsManage, ApplicationDsCreateRequest dsCreateRequest) {
        ApplicationDsUpdateRequest updateRequest = new ApplicationDsUpdateRequest();
        BeanUtils.copyProperties((Object)dsCreateRequest, (Object)updateRequest);
        updateRequest.setId(applicationDsManage.getId());
        updateRequest.setApplicationName(applicationDsManage.getApplicationName());
        Response response = this.dsService.dsUpdate(updateRequest);
        if (response.getError() != null && FALSE_CORE.equals(response.getError().getCode())) {
            throw new RuntimeException(response.getError().getMsg());
        }
    }

    private void createDsFromImport(ApplicationDsCreateRequest dsCreateRequest) {
        Response response = this.dsService.dsAdd(dsCreateRequest);
        if (response.getError() != null && FALSE_CORE.equals(response.getError().getCode())) {
            throw new RuntimeException(response.getError().getMsg());
        }
    }

    private boolean compareImportServerAndOriginServer(String importServerConfig, String originServerConfig) {
        ShadowServerConfigurationResponse importServerConfigResponse = (ShadowServerConfigurationResponse)JsonUtil.json2bean((String)importServerConfig, ShadowServerConfigurationResponse.class);
        ShadowServerConfigurationResponse originServerConfigResponse = (ShadowServerConfigurationResponse)JsonUtil.json2bean((String)originServerConfig, ShadowServerConfigurationResponse.class);
        return String.format("%s%s", importServerConfigResponse.getDataSourceBusiness().getMaster(), importServerConfigResponse.getDataSourceBusiness().getNodes()).equals(String.format("%s%s", originServerConfigResponse.getDataSourceBusiness().getMaster(), importServerConfigResponse.getDataSourceBusiness().getNodes()));
    }

    private ApplicationDsCreateRequest getApplicationDsCreateRequest(Long applicationId, ArrayList<String> ds) {
        Assert.isTrue((ds.size() >= 2 ? 1 : 0) != 0, (String)"\u7f3a\u5c11\u5fc5\u586b\u5b57\u6bb5!");
        ApplicationDsCreateRequest createRequest = new ApplicationDsCreateRequest();
        int index = 0;
        String dbTypeString = ds.get(index++);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dbTypeString), (String)"\u5b58\u50a8\u7c7b\u578b \u5fc5\u987b\u586b\u5199!");
        createRequest.setDbType(Integer.valueOf(dbTypeString));
        String dsTypeString = ds.get(index++);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dsTypeString), (String)"\u65b9\u6848\u7c7b\u578b \u5fc5\u987b\u586b\u5199!");
        Integer dsType = Integer.valueOf(dsTypeString);
        createRequest.setDsType(dsType);
        if (DsManageUtil.isNewVersionSchemaDsType((Integer)dsType, (boolean)this.isNewVersion)) {
            Assert.isTrue((ds.size() >= 9 ? 1 : 0) != 0, (String)"\u7f3a\u5c11\u5fc5\u586b\u5b57\u6bb5!");
        } else {
            Assert.isTrue((ds.size() >= 5 ? 1 : 0) != 0, (String)"\u7f3a\u5c11\u5fc5\u586b\u5b57\u6bb5!");
        }
        String url = ds.get(index++);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)url), (String)"url \u5fc5\u987b\u586b\u5199!");
        createRequest.setUrl(url);
        String statusString = ds.get(index++);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)statusString), (String)"\u72b6\u6001 \u5fc5\u987b\u586b\u5199!");
        createRequest.setStatus(Integer.valueOf(statusString));
        String config = ds.get(index++);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)config), (String)"xml \u5fc5\u987b\u586b\u5199!");
        createRequest.setConfig(config);
        createRequest.setOldVersion(this.isNewVersion == false);
        createRequest.setApplicationId(applicationId);
        if (DsManageUtil.isNewVersionSchemaDsType((Integer)dsType, (boolean)this.isNewVersion)) {
            createRequest.setConfig("");
            String userName = ds.get(index++);
            String shadowDbUrl = ds.get(index++);
            String shadowDbUserName = ds.get(index++);
            String shadowDbPassword = ds.get(index++);
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userName), (String)"\u7528\u6237\u540d \u5fc5\u987b\u586b\u5199!");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)shadowDbUrl), (String)"\u5f71\u5b50\u5e93url \u5fc5\u987b\u586b\u5199!");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)shadowDbUserName), (String)"\u5f71\u5b50\u5e93\u7528\u6237\u540d \u5fc5\u987b\u586b\u5199!");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)shadowDbPassword), (String)"\u5f71\u5b50\u5e93\u5bc6\u7801 \u5fc5\u987b\u586b\u5199!");
            createRequest.setUserName(userName);
            createRequest.setShadowDbUrl(shadowDbUrl);
            createRequest.setShadowDbUserName(shadowDbUserName);
            createRequest.setShadowDbPassword(shadowDbPassword);
            if (ds.size() > 9) {
                createRequest.setShadowDbMinIdle(ds.get(index++));
            }
            if (ds.size() > 10) {
                createRequest.setShadowDbMaxActive(ds.get(index));
            }
        }
        return createRequest;
    }

    private String getUrlFromImport(Integer dsType, String url, String config) {
        if (DsManageUtil.isServerDsType((Integer)dsType)) {
            ShadowServerConfigurationResponse serverConfig = (ShadowServerConfigurationResponse)JsonUtil.json2bean((String)config, ShadowServerConfigurationResponse.class);
            return serverConfig.getDataSourceBusiness().getNodes();
        }
        if (DsManageUtil.isSchemaDsType((Integer)dsType) && !this.isNewVersion.booleanValue()) {
            return this.dsService.parseShadowDbUrl(config);
        }
        return url;
    }

    @Transactional(rollbackFor={Throwable.class})
    public Response importApplicationConfig(MultipartFile file, Long applicationId) {
        String originalFilename = file.getOriginalFilename();
        if (StringUtils.isBlank((CharSequence)originalFilename)) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728!");
        }
        if (!originalFilename.endsWith(".xlsx")) {
            throw new RuntimeException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u4e3axlsx\u683c\u5f0f\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u5bfc\u51fa\u914d\u7f6e\u6587\u4ef6\uff01");
        }
        Map stringArrayListHashMap = ExcelUtils.readExcelForXlsx((MultipartFile)file, (Integer)0);
        if (CollectionUtils.isEmpty((Map)stringArrayListHashMap)) {
            return null;
        }
        List list = this.preCheck(stringArrayListHashMap);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ImportConfigDTO dto = new ImportConfigDTO();
            dto.setMsg(list);
            Response response = new Response((Object)dto);
            response.setSuccess(Boolean.valueOf(false));
            return response;
        }
        this.saveConfig2Db(applicationId, stringArrayListHashMap);
        return null;
    }

    private ExcelSheetVO<LinkGuardExcelVO> getLinkGuardSheet(Long applicationId) {
        List linkGuards = this.linkGuardDAO.listFromExportByApplicationId(applicationId);
        List linkGuardExcelModelList = this.linkGuard2ExcelModel(linkGuards);
        ExcelSheetVO guardExcelSheet = new ExcelSheetVO();
        guardExcelSheet.setData(linkGuardExcelModelList);
        guardExcelSheet.setExcelModelClass(LinkGuardExcelVO.class);
        guardExcelSheet.setSheetName(AppConfigSheetEnum.GUARD.name());
        guardExcelSheet.setSheetNum(Integer.valueOf(0));
        return guardExcelSheet;
    }

    private ExcelSheetVO<ShadowJobExcelVO> getJobSheet(Long applicationId) {
        List shadowJobConfigs = this.shadowJobConfigDAO.listByApplicationId(applicationId);
        List jobExcelModelList = this.job2ExcelJobModel(shadowJobConfigs);
        ExcelSheetVO jobSheet = new ExcelSheetVO();
        jobSheet.setData(jobExcelModelList);
        jobSheet.setExcelModelClass(ShadowJobExcelVO.class);
        jobSheet.setSheetName(AppConfigSheetEnum.JOB.name());
        jobSheet.setSheetNum(Integer.valueOf(1));
        return jobSheet;
    }

    private ExcelSheetVO<WhiteListExcelVO> getWhiteListSheet(ApplicationDetailResult application) {
        List whiteLists = this.whiteListDAO.listByApplicationId(application.getApplicationId());
        List whiteListsFromAmDb = this.whiteListService.getAllInterface(application.getApplicationName());
        List whiteListExcelModels = this.whiteList2ExcelModel(whiteLists, whiteListsFromAmDb);
        ExcelSheetVO whiteSheet = new ExcelSheetVO();
        whiteSheet.setData(whiteListExcelModels);
        whiteSheet.setExcelModelClass(WhiteListExcelVO.class);
        whiteSheet.setSheetName(AppConfigSheetEnum.WHITE.name());
        whiteSheet.setSheetNum(Integer.valueOf(2));
        return whiteSheet;
    }

    private List<ShadowConsumerExcelVO> shadowConsumer2ExcelModel(List<ShadowMqConsumerEntity> shadowMqConsumers) {
        if (CollectionUtils.isEmpty(shadowMqConsumers)) {
            return Collections.emptyList();
        }
        return shadowMqConsumers.stream().map(response -> {
            ShadowConsumerExcelVO model = new ShadowConsumerExcelVO();
            model.setTopicGroup(response.getTopicGroup());
            model.setType(ShadowMqConsumerType.of((String)response.getType()).name());
            model.setStatus(response.getStatus());
            return model;
        }).collect(Collectors.toList());
    }

    private List<WhiteListExcelVO> whiteList2ExcelModel(List<WhitelistResult> whiteLists, List<InterfaceVo> whiteListsFromAmDb) {
        List<Object> models = new ArrayList<WhiteListExcelVO>();
        if (CollectionUtils.isNotEmpty(whiteLists)) {
            List ids = whiteLists.stream().map(WhitelistResult::getWlistId).collect(Collectors.toList());
            List appResults = this.whitelistEffectiveAppDao.getListByWhiteIds(ids);
            Map<Long, List<WhitelistEffectiveAppResult>> appResultsMap = appResults.stream().collect(Collectors.groupingBy(WhitelistEffectiveAppResult::getWlistId));
            models = whiteLists.stream().map(whiteList -> {
                WhiteListExcelVO model = new WhiteListExcelVO();
                BeanUtils.copyProperties((Object)whiteList, (Object)model);
                model.setIsGlobal(whiteList.getIsGlobal() == null ? BooleanEnum.getByValue((Boolean)BooleanEnum.TRUE.getValue()) : BooleanEnum.getByValue((Boolean)whiteList.getIsGlobal()));
                model.setIsHandwork(whiteList.getIsHandwork() == null ? BooleanEnum.getByValue((Boolean)BooleanEnum.TRUE.getValue()) : BooleanEnum.getByValue((Boolean)whiteList.getIsHandwork()));
                List results = (List)appResultsMap.get(whiteList.getWlistId());
                model.setEffectAppNames(CollectionUtils.isNotEmpty((Collection)results) ? results.stream().map(WhitelistEffectiveAppResult::getEffectiveAppName).collect(Collectors.joining(",")) : "");
                return model;
            }).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(whiteListsFromAmDb)) {
            models.addAll(whiteListsFromAmDb.stream().map(whiteList -> {
                WhiteListExcelVO model = new WhiteListExcelVO();
                model.setInterfaceName(whiteList.getInterfaceName());
                model.setType(whiteList.getInterfaceType());
                model.setUseYn(Integer.valueOf(0));
                model.setDictType("ca888ed801664c81815d8c4f5b8dff0c");
                model.setIsGlobal(BooleanEnum.TRUE.getDesc());
                model.setIsHandwork(BooleanEnum.FALSE.getDesc());
                model.setEffectAppNames("");
                return model;
            }).collect(Collectors.toList()));
        }
        if (models.isEmpty()) {
            return models;
        }
        Map keyAboutWhiteList = models.stream().collect(Collectors.toMap(model -> WhiteListUtil.getInterfaceAndType((String)model.getInterfaceName(), (String)model.getType()), Function.identity(), (v1, v2) -> v1));
        return new ArrayList<WhiteListExcelVO>(keyAboutWhiteList.values());
    }

    private List<LinkGuardExcelVO> linkGuard2ExcelModel(List<LinkGuardEntity> linkGuardEntities) {
        ArrayList<LinkGuardExcelVO> result = new ArrayList<LinkGuardExcelVO>();
        if (CollectionUtils.isEmpty(linkGuardEntities)) {
            return result;
        }
        linkGuardEntities.forEach(source -> {
            LinkGuardExcelVO model = new LinkGuardExcelVO();
            BeanUtils.copyProperties((Object)source, (Object)model);
            model.setIsEnable(Boolean.valueOf(1 == source.getIsEnable()));
            result.add(model);
        });
        return result;
    }

    private List<ShadowJobExcelVO> job2ExcelJobModel(List<ShadowJobConfigEntity> shadowJobConfigs) {
        if (CollectionUtils.isEmpty(shadowJobConfigs)) {
            return Collections.emptyList();
        }
        return shadowJobConfigs.stream().map(source -> {
            ShadowJobExcelVO model = new ShadowJobExcelVO();
            BeanUtils.copyProperties((Object)source, (Object)model);
            return model;
        }).collect(Collectors.toList());
    }

    private String getUserPressureSwitchFromRedis(Long uid) {
        if (uid == null) {
            throw new RuntimeException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Object statusObj = this.redisTemplate.opsForValue().get((Object)(PRADAR_SWITCH_STATUS_VO + uid));
        if (statusObj != null) {
            return (String)statusObj;
        }
        this.redisTemplate.opsForValue().set((Object)(PRADAR_SWITCH_STATUS_VO + uid), (Object)AppSwitchEnum.OPENED.getCode());
        this.redisTemplate.opsForValue().set((Object)(PRADAR_SWITCH_STATUS + uid), (Object)AppSwitchEnum.OPENED.getCode());
        return AppSwitchEnum.OPENED.getCode();
    }

    private ApplicationSwitchStatusDTO judgeAppSwitchStatus(TApplicationMnt dbApp, boolean needCalculateNodeNum) {
        if (dbApp == null) {
            return null;
        }
        ApplicationSwitchStatusDTO result = new ApplicationSwitchStatusDTO();
        ArrayList<String> errorList = new ArrayList<String>();
        result.setErrorList(errorList);
        String appUniqueKey = dbApp.getApplicationId() + PRADARNODE_SEPERATE_FLAG;
        Set keys = this.redisTemplate.keys((Object)(appUniqueKey + "*"));
        String resultStatus = null;
        if (needCalculateNodeNum && (keys == null || keys.size() < dbApp.getNodeNum())) {
            int uploadNodeNum = keys == null ? 0 : keys.size();
            String errorMsg = "\u8282\u70b9\u5f02\u5e38:\u8bbe\u7f6e\u7684\u8282\u70b9\u6570\u548c\u5f00\u5173\u4e0a\u62a5\u8282\u70b9\u6570\u4e0d\u540c,\u8bbe\u7f6e\u8282\u70b9\u6570\uff1a" + dbApp.getNodeNum() + "; \u4e0a\u62a5\u8282\u70b9\u6570\uff1a " + uploadNodeNum;
            errorList.add(errorMsg);
        }
        for (String nodeKey : keys) {
            Map exceptionMap;
            NodeUploadDataDTO statusDTO = (NodeUploadDataDTO)this.redisTemplate.opsForValue().get((Object)nodeKey);
            if (statusDTO == null || (exceptionMap = statusDTO.getSwitchErrorMap()) == null || exceptionMap.size() <= 0) continue;
            for (Map.Entry entry : exceptionMap.entrySet()) {
                String key = (String)entry.getKey();
                String keySplit = key.contains(":") ? key.split(":")[0] : key;
                String message = String.valueOf(entry.getValue());
                if (message.contains("errorCode")) {
                    try {
                        ExceptionInfo exceptionInfo = (ExceptionInfo)JSONObject.parseObject((String)message, ExceptionInfo.class);
                        String errorMsg = keySplit + exceptionInfo.toString();
                        errorList.add(errorMsg);
                    }
                    catch (Exception e) {
                        log.error("\u5f02\u5e38\u8f6c\u6362\u5931\u8d25\uff1a", (Throwable)e);
                    }
                    continue;
                }
                String errorMsg = keySplit + ":" + message;
                errorList.add(errorMsg);
            }
        }
        result.setSwitchStatus(resultStatus);
        result.setApplicationName(dbApp.getApplicationName());
        result.setErrorList(errorList);
        return result;
    }

    public Response uploadMiddlewareStatus(Map<String, JarVersionVo> requestMap, String appName) {
        try {
            AppMiddlewareQuery query = new AppMiddlewareQuery();
            User user = this.TUserMapper.queryByKey(RestContext.getTenantUserKey());
            if (null == user) {
                return Response.fail((String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u76f8\u5173\u4fe1\u606f", (Object[])new Object[0]);
            }
            TApplicationMnt tApplicationMnt = null;
            if (1 == user.getRole()) {
                query.setUserId(user.getId());
                tApplicationMnt = this.tApplicationMntDao.queryApplicationinfoByNameTenant(appName, user.getId());
            } else {
                tApplicationMnt = this.tApplicationMntDao.queryApplicationinfoByName(appName);
            }
            if (null == tApplicationMnt) {
                return Response.fail((String)"\u672a\u67e5\u8be2\u5230\u5e94\u7528\u76f8\u5173\u6570\u636e", (Object[])new Object[0]);
            }
            query.setApplicationId(Long.valueOf(tApplicationMnt.getApplicationId()));
            List tAppMiddlewareInfos = this.tAppMiddlewareInfoMapper.selectList(query);
            if (null != tAppMiddlewareInfos && tAppMiddlewareInfos.size() > 0) {
                List ids = tAppMiddlewareInfos.stream().map(TAppMiddlewareInfo::getId).collect(Collectors.toList());
                this.tAppMiddlewareInfoMapper.deleteBatch(ids);
            }
            for (Map.Entry<String, JarVersionVo> entry : requestMap.entrySet()) {
                JarVersionVo entryValue = entry.getValue();
                TAppMiddlewareInfo info = new TAppMiddlewareInfo();
                info.setActive(Boolean.valueOf(entryValue.isActive()));
                info.setApplicationId(Long.valueOf(tApplicationMnt.getApplicationId()));
                info.setJarName(entryValue.getJarName());
                info.setPluginName(entryValue.getPluginName());
                info.setJarType(entryValue.getJarType());
                info.setUserId(user.getId());
                info.setHidden(entryValue.getHidden());
                this.tAppMiddlewareInfoMapper.insert(info);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)e.getMessage(), (Object[])new Object[0]);
        }
        return Response.success();
    }

    List<ApplicationVo> appEntryListToVoList(List<TApplicationMnt> tApplicationMnts) {
        ArrayList<ApplicationVo> voList;
        block7: {
            voList = new ArrayList<ApplicationVo>();
            if (!CollectionUtils.isNotEmpty(tApplicationMnts)) break block7;
            List appNameList = tApplicationMnts.stream().map(TApplicationMnt::getApplicationName).collect(Collectors.toList());
            List applicationResultList = this.applicationDAO.getApplicationByName(appNameList);
            ApplicationNodeQueryParam queryParam = new ApplicationNodeQueryParam();
            queryParam.setCurrent(0);
            queryParam.setPageSize(Integer.valueOf(99999));
            queryParam.setApplicationNames(appNameList);
            PagingList applicationNodes = this.applicationNodeDAO.pageNodes(queryParam);
            List applicationNodeResultList = applicationNodes.getList();
            HashMap applicationNodeResultMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty((Collection)applicationNodeResultList)) {
                for (TApplicationMnt tApplicationMnt : tApplicationMnts) {
                    List currentApplicationNodeResultList = applicationNodeResultList.stream().filter(applicationNodeResult -> tApplicationMnt.getApplicationName().equals(applicationNodeResult.getAppName())).collect(Collectors.toList());
                    if (!CollectionUtils.isNotEmpty(currentApplicationNodeResultList)) continue;
                    applicationNodeResultMap.put(tApplicationMnt.getApplicationId(), currentApplicationNodeResultList);
                }
            }
            if (CollectionUtils.isEmpty((Collection)applicationResultList)) {
                for (TApplicationMnt param : tApplicationMnts) {
                    List applicationNodeResults = (List)applicationNodeResultMap.get(param.getApplicationId());
                    voList.add(this.appEntryToVo(param, null, applicationNodeResults));
                }
            } else {
                for (TApplicationMnt param : tApplicationMnts) {
                    String applicationName = param.getApplicationName();
                    Optional<ApplicationResult> optional = applicationResultList.stream().filter(applicationResult -> applicationResult.getAppName().equals(applicationName)).findFirst();
                    List applicationNodeResults = (List)applicationNodeResultMap.get(param.getApplicationId());
                    if (optional.isPresent()) {
                        voList.add(this.appEntryToVo(param, optional.get(), applicationNodeResults));
                        continue;
                    }
                    voList.add(this.appEntryToVo(param, null, applicationNodeResults));
                }
            }
        }
        return voList;
    }

    ApplicationVo appEntryToVo(TApplicationMnt param, ApplicationResult applicationResult, List<ApplicationNodeResult> applicationNodeResultList) {
        List allowDeleteUserIdList;
        ApplicationVo vo = new ApplicationVo();
        vo.setId(String.valueOf(param.getApplicationId()));
        vo.setApplicationName(param.getApplicationName());
        vo.setUpdateTime(param.getUpdateTime());
        vo.setApplicationDesc(param.getApplicationDesc());
        vo.setBasicScriptPath(param.getBasicScriptPath());
        vo.setCacheScriptPath(param.getCacheScriptPath());
        vo.setCleanScriptPath(param.getCleanScriptPath());
        vo.setDdlScriptPath(param.getDdlScriptPath());
        vo.setReadyScriptPath(param.getReadyScriptPath());
        vo.setNodeNum(param.getNodeNum());
        vo.setSwitchStutus(param.getSwitchStatus());
        vo.setManagerId(param.getUserId());
        if (Objects.isNull(applicationResult) || !applicationResult.getInstanceInfo().getInstanceOnlineAmount().equals(param.getNodeNum()) || CollectionUtils.isEmpty(applicationNodeResultList) || applicationNodeResultList.stream().map(ApplicationNodeResult::getAgentVersion).distinct().count() > 1L) {
            vo.setAccessStatus(Integer.valueOf(3));
            vo.setExceptionInfo("agent\u72b6\u6001:" + param.getAccessStatus() + ",\u8282\u70b9\u72b6\u6001: 3");
        } else {
            vo.setAccessStatus(param.getAccessStatus());
            String exceptionMsg = "agent\u72b6\u6001:" + param.getAccessStatus();
            if (!applicationResult.getInstanceInfo().getInstanceOnlineAmount().equals(param.getNodeNum()) || CollectionUtils.isEmpty(applicationNodeResultList) || applicationNodeResultList.stream().map(ApplicationNodeResult::getAgentVersion).distinct().count() > 1L) {
                exceptionMsg = exceptionMsg + ",\u8282\u70b9\u72b6\u6001: 3";
            }
            vo.setExceptionInfo(exceptionMsg);
        }
        List allowUpdateUserIdList = RestContext.getUpdateAllowUserIdList();
        if (CollectionUtils.isNotEmpty((Collection)allowUpdateUserIdList)) {
            vo.setCanEdit(Boolean.valueOf(allowUpdateUserIdList.contains(param.getUserId())));
        }
        if (CollectionUtils.isNotEmpty((Collection)(allowDeleteUserIdList = RestContext.getDeleteAllowUserIdList()))) {
            vo.setCanRemove(Boolean.valueOf(allowDeleteUserIdList.contains(param.getUserId())));
        }
        return vo;
    }

    TApplicationMnt voToAppEntity(ApplicationVo param) {
        TApplicationMnt dbData = new TApplicationMnt();
        if (StringUtil.isNotEmpty((String)param.getId())) {
            dbData.setApplicationId(Long.valueOf(param.getId()).longValue());
        }
        dbData.setApplicationName(param.getApplicationName());
        dbData.setApplicationDesc(param.getApplicationDesc());
        dbData.setBasicScriptPath(param.getBasicScriptPath());
        dbData.setCacheScriptPath(param.getCacheScriptPath());
        dbData.setCleanScriptPath(param.getCleanScriptPath());
        dbData.setDdlScriptPath(param.getDdlScriptPath());
        dbData.setReadyScriptPath(param.getReadyScriptPath());
        dbData.setNodeNum(param.getNodeNum());
        dbData.setAccessStatus(param.getAccessStatus());
        dbData.setExceptionInfo(param.getExceptionInfo());
        dbData.setSwitchStatus(param.getSwitchStutus());
        if (param.getAccessStatus() == null) {
            dbData.setAccessStatus(Integer.valueOf(1));
        } else {
            dbData.setAccessStatus(param.getAccessStatus());
        }
        return dbData;
    }
}

