/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.impl;

import com.pamirs.tro.entity.domain.entity.user.User;
import com.pamirs.tro.entity.domain.vo.scenemanage.SceneBusinessActivityRefVO;
import com.pamirs.tro.entity.domain.vo.scenemanage.SceneManageWrapperVO;
import com.pamirs.tro.entity.domain.vo.scenemanage.TimeVO;
import io.shulie.tro.cloud.common.redis.RedisClientUtils;
import io.shulie.tro.cloud.open.api.scenetask.CloudTaskApi;
import io.shulie.tro.cloud.open.req.scenemanage.SceneBusinessActivityRefOpen;
import io.shulie.tro.cloud.open.req.scenemanage.SceneManageWrapperReq;
import io.shulie.tro.cloud.open.req.scenetask.TaskFlowDebugStartReq;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.common.beans.response.ResponseResult;
import io.shulie.tro.utils.string.StringUtil;
import io.shulie.tro.web.amdb.api.NotifyClient;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.constant.BusinessActivityRedisKeyConstant;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.output.report.ReportDetailOutput;
import io.shulie.tro.web.app.request.activity.ActivityCreateRequest;
import io.shulie.tro.web.app.request.activity.ActivityQueryRequest;
import io.shulie.tro.web.app.request.activity.ActivityUpdateRequest;
import io.shulie.tro.web.app.request.activity.ActivityVerifyRequest;
import io.shulie.tro.web.app.request.application.ApplicationEntranceTopologyQueryRequest;
import io.shulie.tro.web.app.response.activity.ActivityListResponse;
import io.shulie.tro.web.app.response.activity.ActivityResponse;
import io.shulie.tro.web.app.response.activity.ActivityVerifyResponse;
import io.shulie.tro.web.app.response.scriptmanage.ScriptManageDeployDetailResponse;
import io.shulie.tro.web.app.service.ActivityService;
import io.shulie.tro.web.app.service.LinkTopologyService;
import io.shulie.tro.web.app.service.report.ReportService;
import io.shulie.tro.web.app.service.scenemanage.SceneManageService;
import io.shulie.tro.web.app.service.scriptmanage.ScriptManageService;
import io.shulie.tro.web.auth.api.UserService;
import io.shulie.tro.web.common.constant.RemoteConstant;
import io.shulie.tro.web.common.domain.WebResponse;
import io.shulie.tro.web.common.util.ActivityUtil;
import io.shulie.tro.web.data.dao.activity.ActivityDAO;
import io.shulie.tro.web.data.param.activity.ActivityCreateParam;
import io.shulie.tro.web.data.param.activity.ActivityExistsQueryParam;
import io.shulie.tro.web.data.param.activity.ActivityQueryParam;
import io.shulie.tro.web.data.param.activity.ActivityUpdateParam;
import io.shulie.tro.web.data.result.activity.ActivityListResult;
import io.shulie.tro.web.data.result.activity.ActivityResult;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ActivityServiceImpl
implements ActivityService {
    private static final Logger log = LoggerFactory.getLogger(ActivityServiceImpl.class);
    @Autowired
    RedisClientUtils redisClientUtils;
    @Autowired
    private NotifyClient notifyClient;
    @Autowired
    private ActivityDAO activityDAO;
    @Autowired
    private UserService userService;
    @Autowired
    private LinkTopologyService linkTopologyService;
    @Autowired
    private ReportService reportService;
    @Value(value="${link.flow.check.enable:false}")
    private Boolean enableLinkFlowCheck;
    @Autowired
    private CloudTaskApi cloudTaskApi;
    @Autowired
    private ScriptManageService scriptManageService;
    @Autowired
    private SceneManageService sceneManageService;

    @Transactional(rollbackFor={Throwable.class})
    public void createActivity(ActivityCreateRequest request) {
        ActivityExistsQueryParam param = new ActivityExistsQueryParam();
        param.setType(request.getType());
        param.setActivityName(request.getActivityName());
        List exists = this.activityDAO.exists(param);
        if (CollectionUtils.isNotEmpty((Collection)exists)) {
            throw new RuntimeException(String.format("\u4fdd\u5b58\u5931\u8d25\uff0c[\u540d\u79f0:%s] \u5df2\u88ab\u4f7f\u7528", request.getActivityName()));
        }
        param = new ActivityExistsQueryParam();
        param.setType(request.getType());
        param.setEntranceName(request.getServiceName());
        param.setApplicationName(request.getApplicationName());
        param.setExtend(request.getExtend());
        param.setMethod(request.getMethod());
        param.setRpcType(request.getRpcType());
        param.setServiceName(request.getServiceName());
        exists = this.activityDAO.exists(param);
        if (CollectionUtils.isNotEmpty((Collection)exists)) {
            throw new RuntimeException(String.format("\u4fdd\u5b58\u5931\u8d25\uff0c[\u5e94\u7528\u540d:%s,\u7c7b\u578b:%s,\u5165\u53e3:%s]\u5df2\u5b58\u5728", request.getApplicationName(), request.getType().getType(), request.getServiceName()));
        }
        ActivityCreateParam createParam = new ActivityCreateParam();
        createParam.setActivityName(request.getActivityName());
        createParam.setEntranceName(request.getServiceName());
        createParam.setIsChange(Boolean.valueOf(false));
        createParam.setApplicationName(param.getApplicationName());
        createParam.setType(param.getType());
        createParam.setUserId(RestContext.getUser().getId());
        createParam.setCustomerId(RestContext.getUser().getCustomerId());
        createParam.setActivityLevel(request.getActivityLevel());
        createParam.setIsCore(request.getIsCore());
        createParam.setBusinessDomain(request.getBusinessDomain());
        createParam.setRpcType(request.getRpcType());
        createParam.setMethod(request.getMethod());
        createParam.setServiceName(request.getServiceName());
        createParam.setExtend(request.getExtend());
        this.activityDAO.createActivity(createParam);
        this.notifyClient.startApplicationEntrancesCalculate(request.getApplicationName(), request.getServiceName(), request.getMethod(), request.getRpcType(), request.getExtend());
    }

    @Transactional(rollbackFor={Throwable.class})
    public void updateActivity(ActivityUpdateRequest request) {
        Optional<Long> any;
        List exists;
        ActivityResult oldActivity = this.activityDAO.getActivityById(request.getActivityId());
        if (oldActivity == null) {
            throw new RuntimeException(String.format("\u4fee\u6539\u5931\u8d25\uff0cID:[%s]\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u5b58\u5728", request.getActivityId()));
        }
        ActivityExistsQueryParam param = new ActivityExistsQueryParam();
        if (request.getActivityName() != null) {
            param.setActivityName(request.getActivityName());
            exists = this.activityDAO.exists(param);
            if (CollectionUtils.isNotEmpty((Collection)exists) && (any = exists.stream().filter(item -> !item.equals(request.getActivityId())).findAny()).isPresent()) {
                throw new RuntimeException(String.format("\u4fdd\u5b58\u5931\u8d25\uff0c\u4e1a\u52a1\u6d3b\u52a8[%s]\u5df2\u88ab\u4f7f\u7528\uff0c\u5bf9\u5e94\u7684ID\u4e3a\uff1a%s", request.getActivityName(), any.get()));
            }
        }
        if (request.getServiceName() != null && request.getRpcType() != null && request.getApplicationName() != null) {
            param = new ActivityExistsQueryParam();
            param.setEntranceName(request.getServiceName());
            param.setApplicationName(request.getApplicationName());
            param.setType(request.getType());
            param.setExtend(request.getExtend());
            param.setMethod(request.getMethod());
            param.setRpcType(request.getRpcType());
            param.setServiceName(request.getServiceName());
            exists = this.activityDAO.exists(param);
            if (CollectionUtils.isNotEmpty((Collection)exists) && (any = exists.stream().filter(item -> !item.equals(request.getActivityId())).findAny()).isPresent()) {
                throw new RuntimeException(String.format("\u4fdd\u5b58\u5931\u8d25\uff0c\u5165\u53e3\u5df2[\u5e94\u7528\u540d\u79f0\uff1a%s\uff0c\u7c7b\u578b\uff1a%s\uff0c\u5165\u53e3\uff1a%s]\u5df2\u88ab\u4f7f\u7528\uff0c\u5bf9\u5e94\u7684ID\u4e3a\uff1a%s", request.getActivityName(), request.getType().getType(), request.getServiceName(), any.get()));
            }
        }
        OperationLogContextHolder.addVars((String)"entryApplication", (String)request.getApplicationName());
        OperationLogContextHolder.addVars((String)"interface", (String)request.getServiceName());
        ActivityUpdateParam updateParam = new ActivityUpdateParam();
        updateParam.setActivityId(request.getActivityId());
        updateParam.setActivityName(request.getActivityName());
        updateParam.setApplicationName(request.getApplicationName());
        updateParam.setEntranceName(request.getServiceName());
        updateParam.setType(request.getType());
        updateParam.setUserId(RestContext.getUser().getId());
        updateParam.setCustomerId(RestContext.getUser().getCustomerId());
        updateParam.setIsChange(Boolean.valueOf(this.isChange(oldActivity, request)));
        updateParam.setChangeBefore(oldActivity.getChangeAfter());
        updateParam.setActivityLevel(request.getActivityLevel());
        updateParam.setBusinessDomain(request.getBusinessDomain());
        updateParam.setIsCore(request.getIsCore());
        updateParam.setRpcType(request.getRpcType());
        updateParam.setMethod(request.getMethod());
        updateParam.setServiceName(request.getServiceName());
        updateParam.setExtend(request.getExtend());
        this.activityDAO.updateActivity(updateParam);
        this.notifyClient.stopApplicationEntrancesCalculate(oldActivity.getApplicationName(), request.getServiceName(), request.getMethod(), request.getRpcType(), request.getExtend());
        this.notifyClient.startApplicationEntrancesCalculate(request.getApplicationName(), request.getServiceName(), request.getMethod(), request.getRpcType(), request.getExtend());
    }

    @Transactional(rollbackFor={Throwable.class})
    public void deleteActivity(Long activityId) {
        ActivityResult oldActivity = this.activityDAO.getActivityById(activityId);
        if (oldActivity == null) {
            throw new RuntimeException(String.format("\u5220\u9664\u5931\u8d25\uff0cID:[%s]\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u5b58\u5728", activityId));
        }
        OperationLogContextHolder.operationType((String)"\u5220\u9664");
        OperationLogContextHolder.addVars((String)"businessActivity", (String)oldActivity.getActivityName());
        OperationLogContextHolder.addVars((String)"entranceType", (String)oldActivity.getType().name());
        OperationLogContextHolder.addVars((String)"applicationName", (String)oldActivity.getApplicationName());
        OperationLogContextHolder.addVars((String)"serviceName", (String)oldActivity.getServiceName());
        this.activityDAO.deleteActivity(activityId);
        this.notifyClient.stopApplicationEntrancesCalculate(oldActivity.getApplicationName(), oldActivity.getServiceName(), oldActivity.getMethod(), oldActivity.getRpcType(), oldActivity.getExtend());
    }

    public PagingList<ActivityListResponse> pageActivities(ActivityQueryRequest request) {
        ActivityQueryParam param = new ActivityQueryParam();
        param.setActivityName(request.getActivityName());
        param.setDomain(request.getDomain());
        param.setIsChange(request.getIsChange());
        param.setCurrent(request.getCurrent());
        param.setPageSize(Integer.valueOf(request.getPageSize()));
        param.setUserIdList(RestContext.getQueryAllowUserIdList());
        PagingList activityListResultPagingList = this.activityDAO.pageActivities(param);
        List userIds = activityListResultPagingList.getList().stream().map(ActivityListResult::getUserId).filter(Objects::nonNull).collect(Collectors.toList());
        Map userMap = this.userService.getUserMapByIds(userIds);
        List responses = activityListResultPagingList.getList().stream().map(result -> {
            List allowUpdateUserIdList;
            ActivityListResponse response = new ActivityListResponse();
            response.setActivityId(result.getActivityId());
            response.setActivityName(result.getActivityName());
            response.setIsChange(result.getIsChange());
            response.setIsCore(String.valueOf(result.getIsCore()));
            response.setIsDeleted(result.getIsDeleted());
            response.setUserId(result.getUserId());
            response.setCreateTime(result.getCreateTime());
            response.setUpdateTime(result.getUpdateTime());
            response.setCanDelete(result.getCanDelete());
            response.setBusinessDomain(result.getBusinessDomain());
            response.setActivityLevel(result.getActivityLevel());
            User user = (User)userMap.get(result.getUserId());
            if (user != null) {
                response.setManagerName(user.getName());
            }
            if (CollectionUtils.isNotEmpty((Collection)(allowUpdateUserIdList = RestContext.getUpdateAllowUserIdList()))) {
                response.setCanEdit(Boolean.valueOf(allowUpdateUserIdList.contains(result.getManagerId())));
            } else {
                response.setCanEdit(Boolean.valueOf(true));
            }
            List allowDeleteUserIdList = RestContext.getDeleteAllowUserIdList();
            if (CollectionUtils.isNotEmpty((Collection)allowDeleteUserIdList)) {
                response.setCanRemove(Boolean.valueOf(allowDeleteUserIdList.contains(result.getManagerId())));
            } else {
                response.setCanRemove(Boolean.valueOf(true));
            }
            return response;
        }).collect(Collectors.toList());
        return PagingList.of(responses, (long)activityListResultPagingList.getTotal());
    }

    public ActivityResponse getActivityById(Long id) {
        Map userMap;
        ActivityResult result = this.activityDAO.getActivityById(id);
        if (result == null) {
            log.warn("\u67e5\u8be2{}\u5bf9\u5e94\u7684\u4e1a\u52a1\u6d3b\u52a8\u4e0d\u5b58\u5728", (Object)id);
            throw new RuntimeException(String.format("%s\u5bf9\u5e94\u7684\u4e1a\u52a1\u6d3b\u52a8\u4e0d\u5b58\u5728", id));
        }
        ActivityResponse activityResponse = new ActivityResponse();
        activityResponse.setActivityId(result.getActivityId());
        activityResponse.setActivityName(result.getActivityName());
        activityResponse.setApplicationName(result.getApplicationName());
        activityResponse.setEntranceName(ActivityUtil.serviceNameLabel((String)result.getServiceName(), (String)result.getMethod()));
        activityResponse.setType(result.getType());
        activityResponse.setChangeBefore(result.getChangeBefore());
        activityResponse.setChangeAfter(result.getChangeAfter());
        activityResponse.setIsChange(result.getIsChange());
        activityResponse.setUserId(result.getUserId());
        if (result.getUserId() != null && MapUtils.isNotEmpty((Map)(userMap = this.userService.getUserMapByIds(Arrays.asList(result.getUserId()))))) {
            activityResponse.setManager(((User)userMap.get(result.getUserId())).getName());
        }
        activityResponse.setExtend(result.getExtend());
        activityResponse.setMethod(result.getMethod());
        activityResponse.setRpcType(result.getRpcType());
        activityResponse.setServiceName(result.getServiceName());
        activityResponse.setActivityLevel(result.getActivityLevel());
        activityResponse.setIsCore(String.valueOf(result.getIsCore()));
        activityResponse.setBusinessDomain(result.getBusinessDomain());
        activityResponse.setLinkId(ActivityUtil.createLinkId((String)result.getServiceName(), (String)result.getMethod(), (String)result.getApplicationName(), (String)result.getRpcType(), (String)result.getExtend()));
        ApplicationEntranceTopologyQueryRequest request = new ApplicationEntranceTopologyQueryRequest();
        request.setApplicationName(result.getApplicationName());
        request.setLinkId(activityResponse.getLinkId());
        request.setMethod(result.getMethod());
        request.setRpcType(result.getRpcType());
        request.setExtend(result.getExtend());
        request.setServiceName(result.getServiceName());
        request.setType(result.getType());
        activityResponse.setTopology(this.linkTopologyService.getApplicationEntrancesTopology(request));
        activityResponse.setEnableLinkFlowCheck(this.enableLinkFlowCheck.booleanValue());
        Integer verifyStatus = this.getVerifyStatus(id).getVerifyStatus();
        activityResponse.setVerifyStatus(verifyStatus);
        activityResponse.setVerifiedFlag(Boolean.valueOf(verifyStatus.equals(BusinessActivityRedisKeyConstant.ACTIVITY_VERIFY_VERIFIED)));
        return activityResponse;
    }

    public ActivityVerifyResponse verifyActivity(ActivityVerifyRequest request) {
        Integer verifyStatus;
        Long activityId = request.getActivityId();
        Long scriptId = request.getScriptId();
        ActivityVerifyResponse response = new ActivityVerifyResponse();
        response.setActivityId(activityId);
        response.setScriptId(scriptId);
        String reportId = this.redisClientUtils.getString("activity_verify:" + request.getActivityId());
        if (!StringUtil.isBlank((CharSequence)reportId) && !(verifyStatus = this.getVerifyStatus(activityId).getVerifyStatus()).equals(BusinessActivityRedisKeyConstant.ACTIVITY_VERIFY_VERIFIED)) {
            response.setVerifyStatus(verifyStatus);
            response.setTaskStatus(Boolean.valueOf(true));
            response.setVerifiedFlag(Boolean.valueOf(false));
            return response;
        }
        ActivityResult activityResult = this.activityDAO.getActivityById(request.getActivityId());
        ScriptManageDeployDetailResponse scriptManageDeployDetail = this.scriptManageService.getScriptManageDeployDetail(scriptId);
        SceneManageWrapperVO vo = new SceneManageWrapperVO();
        vo.setScriptId(request.getScriptId());
        vo.setPressureTestSceneName(activityResult.getActivityName() + "-FlowVerify");
        vo.setIpNum(BusinessActivityRedisKeyConstant.ACTIVITY_VERIFY_DEFAULT_IP_NUM);
        vo.setPressureTestTime(new TimeVO(Long.valueOf(1L), "m"));
        vo.setStopCondition(new ArrayList());
        vo.setScriptType(scriptManageDeployDetail.getType());
        vo.setConfigType(BusinessActivityRedisKeyConstant.ACTIVITY_VERIFY_DEFAULT_CONFIG_TYPE);
        SceneBusinessActivityRefVO sceneBusinessActivityRefVO = new SceneBusinessActivityRefVO();
        sceneBusinessActivityRefVO.setBusinessActivityId(activityId);
        sceneBusinessActivityRefVO.setBusinessActivityName(activityResult.getActivityName());
        sceneBusinessActivityRefVO.setScriptId(scriptId);
        vo.setBusinessActivityConfig(Collections.singletonList(sceneBusinessActivityRefVO));
        SceneManageWrapperReq req = new SceneManageWrapperReq();
        WebResponse webResponse = this.sceneManageService.buildSceneForFlowVerify(vo, req, null);
        if (!webResponse.getSuccess().booleanValue()) {
            response.setTaskStatus(Boolean.valueOf(false));
            return response;
        }
        TaskFlowDebugStartReq taskFlowDebugStartReq = new TaskFlowDebugStartReq();
        List businessActivityConfig = vo.getBusinessActivityConfig().stream().map(data -> {
            SceneBusinessActivityRefOpen sceneBusinessActivityRefOpen = new SceneBusinessActivityRefOpen();
            sceneBusinessActivityRefOpen.setBusinessActivityId(data.getBusinessActivityId());
            sceneBusinessActivityRefOpen.setBusinessActivityName(data.getBusinessActivityName());
            sceneBusinessActivityRefOpen.setApplicationIds(data.getApplicationIds());
            sceneBusinessActivityRefOpen.setBindRef(data.getBindRef());
            sceneBusinessActivityRefOpen.setTargetRT(BusinessActivityRedisKeyConstant.ACTIVITY_VERIFY_DEFAULT_TARGET_RT);
            sceneBusinessActivityRefOpen.setTargetTPS(BusinessActivityRedisKeyConstant.ACTIVITY_VERIFY_DEFAULT_TARGET_TPS);
            sceneBusinessActivityRefOpen.setTargetSA(new BigDecimal(BusinessActivityRedisKeyConstant.ACTIVITY_VERIFY_DEFAULT_TARGET_RT));
            sceneBusinessActivityRefOpen.setTargetSuccessRate(new BigDecimal(BusinessActivityRedisKeyConstant.ACTIVITY_VERIFY_DEFAULT_TARGET_RT));
            return sceneBusinessActivityRefOpen;
        }).collect(Collectors.toList());
        taskFlowDebugStartReq.setBusinessActivityConfig(businessActivityConfig);
        taskFlowDebugStartReq.setScriptId(scriptId);
        taskFlowDebugStartReq.setScriptType(scriptManageDeployDetail.getType());
        taskFlowDebugStartReq.setUploadFile(req.getUploadFile());
        List pluginConfigDetailResponseList = scriptManageDeployDetail.getPluginConfigDetailResponseList();
        if (CollectionUtils.isNotEmpty((Collection)pluginConfigDetailResponseList)) {
            List pluginIds = pluginConfigDetailResponseList.stream().map(o -> Long.parseLong(o.getName())).collect(Collectors.toList());
            taskFlowDebugStartReq.setEnginePluginIds(pluginIds);
        }
        taskFlowDebugStartReq.setFeatures(req.getFeatures());
        taskFlowDebugStartReq.setLicense(RemoteConstant.LICENSE_VALUE);
        log.info("\u6d41\u91cf\u9a8c\u8bc1\u53c2\u6570\uff1a{}", (Object)taskFlowDebugStartReq.toString());
        ResponseResult longResponseResult = this.cloudTaskApi.startFlowDebugTask(taskFlowDebugStartReq);
        log.info("\u6d41\u91cf\u9a8c\u8bc1\u53d1\u8d77\u7ed3\u679c\uff1a{}", (Object)longResponseResult.toString());
        response.setTaskStatus(longResponseResult.getSuccess());
        if (!longResponseResult.getSuccess().booleanValue()) {
            return response;
        }
        response.setVerifiedFlag(Boolean.valueOf(false));
        response.setVerifyStatus(BusinessActivityRedisKeyConstant.ACTIVITY_VERIFY_VERIFYING);
        this.redisClientUtils.setString("activity_verify:" + activityId, String.valueOf(longResponseResult.getData()), BusinessActivityRedisKeyConstant.ACTIVITY_VERIFY_KEY_EXPIRE.intValue(), TimeUnit.SECONDS);
        response.setScriptId(scriptId);
        return response;
    }

    public ActivityVerifyResponse getVerifyStatus(Long activityId) {
        WebResponse webResponse;
        ActivityVerifyResponse response = new ActivityVerifyResponse();
        response.setActivityId(activityId);
        response.setVerifyStatus(BusinessActivityRedisKeyConstant.ACTIVITY_VERIFY_UNVERIFIED);
        String reportId = this.redisClientUtils.getString("activity_verify:" + activityId);
        if (!StringUtil.isBlank((CharSequence)reportId) && Objects.nonNull(webResponse = this.reportService.getReportByReportId(Long.valueOf(reportId))) && Objects.nonNull(webResponse.getData())) {
            ReportDetailOutput reportDetailOutput = (ReportDetailOutput)webResponse.getData();
            Integer verifyStatus = reportDetailOutput.getTaskStatus();
            response.setVerifyStatus(verifyStatus);
            response.setVerifiedFlag(Boolean.valueOf(verifyStatus.equals(BusinessActivityRedisKeyConstant.ACTIVITY_VERIFY_VERIFIED)));
        }
        return response;
    }

    private boolean isChange(ActivityResult oldActivity, ActivityUpdateRequest newActivity) {
        return false;
    }
}

