/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.fastdebug;

import com.pamirs.tro.common.constant.LogLevelEnum;
import io.shulie.tro.web.app.service.fastdebug.FastDebugStackInfoService;
import io.shulie.tro.web.data.dao.fastdebug.FastDebugStackInfoDao;
import io.shulie.tro.web.data.param.fastdebug.FastDebugStackInfoQueryParam;
import io.shulie.tro.web.data.result.fastdebug.FastDebugStackInfoResult;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FastDebugStackInfoServiceImpl
implements FastDebugStackInfoService {
    @Autowired
    private FastDebugStackInfoDao fastDebugStackInfoDao;

    public String getStackLog(String traceId, String rpcId, Integer logType, LogLevelEnum type) {
        FastDebugStackInfoQueryParam param = new FastDebugStackInfoQueryParam();
        param.setTraceId(traceId);
        param.setRpcId(rpcId);
        param.setType((Integer)Optional.ofNullable(logType).orElse(null));
        if (null != type) {
            param.setLogLevel(type.getName());
        }
        List fastDebugStackInfoResults = this.fastDebugStackInfoDao.selectByExample(param);
        StringBuilder builder = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)fastDebugStackInfoResults)) {
            for (FastDebugStackInfoResult result : fastDebugStackInfoResults) {
                builder.append(result.getContent());
                builder.append(System.lineSeparator());
            }
        }
        return builder.toString();
    }

    public void clearHistory(Date beforeDate) {
        this.fastDebugStackInfoDao.clearHistoryData(beforeDate);
    }
}

