/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.fastdebug;

import io.shulie.tro.web.app.response.fastdebug.FastDebugMachinePerformanceResponse;
import io.shulie.tro.web.app.service.fastdebug.FastDebugMachinePerformanceService;
import io.shulie.tro.web.app.utils.UnitConvertor;
import io.shulie.tro.web.data.dao.fastdebug.FastDebugMachinePerformanceDao;
import io.shulie.tro.web.data.result.fastdebug.FastDebugMachinePerformanceResult;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FastDebugMachinePerformanceServiceImpl
implements FastDebugMachinePerformanceService {
    private static final Logger log = LoggerFactory.getLogger(FastDebugMachinePerformanceServiceImpl.class);
    @Autowired
    private FastDebugMachinePerformanceDao fastDebugMachinePerformanceDao;

    public List<FastDebugMachinePerformanceResponse> getMachinePerformance(String traceId, String rpcId, Integer logType) {
        List machineList = this.fastDebugMachinePerformanceDao.getByRpcId(traceId, rpcId, logType);
        return this.assembleMachineData(machineList);
    }

    public void clearHistoryData(Date beforeDate) {
        if (beforeDate == null) {
            return;
        }
        this.fastDebugMachinePerformanceDao.clearHistoryData(beforeDate);
    }

    private List<FastDebugMachinePerformanceResponse> assembleMachineData(List<FastDebugMachinePerformanceResult> machineList) {
        FastDebugMachinePerformanceResponse cpuUsage = new FastDebugMachinePerformanceResponse();
        FastDebugMachinePerformanceResponse cpuLoad = new FastDebugMachinePerformanceResponse();
        FastDebugMachinePerformanceResponse memoryUsage = new FastDebugMachinePerformanceResponse();
        FastDebugMachinePerformanceResponse memoryTotal = new FastDebugMachinePerformanceResponse();
        FastDebugMachinePerformanceResponse ioWait = new FastDebugMachinePerformanceResponse();
        FastDebugMachinePerformanceResponse youngGcCount = new FastDebugMachinePerformanceResponse();
        FastDebugMachinePerformanceResponse youngGcTime = new FastDebugMachinePerformanceResponse();
        FastDebugMachinePerformanceResponse oldGcCount = new FastDebugMachinePerformanceResponse();
        FastDebugMachinePerformanceResponse oldGcTime = new FastDebugMachinePerformanceResponse();
        cpuUsage.setType("CPU\u5229\u7528\u7387");
        cpuLoad.setType("CPU\u8d1f\u8f7d");
        memoryUsage.setType("\u5185\u5b58\u5229\u7528\u7387");
        memoryTotal.setType("\u5806\u5185\u5b58\u603b\u548c");
        ioWait.setType("IO");
        youngGcCount.setType("YoungGC\u6b21\u6570");
        youngGcTime.setType("YoungGC\u8017\u65f6");
        oldGcCount.setType("OldGC\u6b21\u6570");
        oldGcTime.setType("OldGC\u8017\u65f6");
        ArrayList<FastDebugMachinePerformanceResponse> responseList = new ArrayList<FastDebugMachinePerformanceResponse>();
        responseList.add(cpuUsage);
        responseList.add(cpuLoad);
        responseList.add(memoryUsage);
        responseList.add(memoryTotal);
        responseList.add(ioWait);
        responseList.add(youngGcCount);
        responseList.add(youngGcTime);
        responseList.add(oldGcCount);
        responseList.add(oldGcTime);
        for (FastDebugMachinePerformanceResult result : machineList) {
            if (null == result || StringUtils.isBlank((CharSequence)result.getIndex())) continue;
            switch (result.getIndex()) {
                case "beforeFirst": {
                    cpuUsage.setBeforeIn((Object)result.getCpuUsage());
                    cpuLoad.setBeforeIn((Object)result.getCpuLoad());
                    memoryUsage.setBeforeIn((Object)result.getMemoryUsage());
                    memoryTotal.setBeforeIn((Object)UnitConvertor.byteToMb((BigDecimal)result.getMemoryTotal()));
                    ioWait.setBeforeIn((Object)result.getIoWait());
                    youngGcCount.setBeforeIn((Object)result.getYoungGcCount());
                    youngGcTime.setBeforeIn((Object)result.getYoungGcTime());
                    oldGcCount.setBeforeIn((Object)result.getOldGcCount());
                    oldGcTime.setBeforeIn((Object)result.getOldGcTime());
                    break;
                }
                case "beforeLast": {
                    cpuUsage.setBeforeAfter((Object)result.getCpuUsage());
                    cpuLoad.setBeforeAfter((Object)result.getCpuLoad());
                    memoryUsage.setBeforeAfter((Object)result.getMemoryUsage());
                    memoryTotal.setBeforeAfter((Object)UnitConvertor.byteToMb((BigDecimal)result.getMemoryTotal()));
                    ioWait.setBeforeAfter((Object)result.getIoWait());
                    youngGcCount.setBeforeAfter((Object)result.getYoungGcCount());
                    youngGcTime.setBeforeAfter((Object)result.getYoungGcTime());
                    oldGcCount.setBeforeAfter((Object)result.getOldGcCount());
                    oldGcTime.setBeforeAfter((Object)result.getOldGcTime());
                    break;
                }
                case "exceptionFirst": {
                    cpuUsage.setExceptionIn((Object)result.getCpuUsage());
                    cpuLoad.setExceptionIn((Object)result.getCpuLoad());
                    memoryUsage.setExceptionIn((Object)result.getMemoryUsage());
                    memoryTotal.setExceptionIn((Object)UnitConvertor.byteToMb((BigDecimal)result.getMemoryTotal()));
                    ioWait.setExceptionIn((Object)result.getIoWait());
                    youngGcCount.setExceptionIn((Object)result.getYoungGcCount());
                    youngGcTime.setExceptionIn((Object)result.getYoungGcTime());
                    oldGcCount.setExceptionIn((Object)result.getOldGcCount());
                    oldGcTime.setExceptionIn((Object)result.getOldGcTime());
                    break;
                }
                case "exceptionLast": {
                    cpuUsage.setExceptionOut((Object)result.getCpuUsage());
                    cpuLoad.setExceptionOut((Object)result.getCpuLoad());
                    memoryUsage.setExceptionOut((Object)result.getMemoryUsage());
                    memoryTotal.setExceptionOut((Object)UnitConvertor.byteToMb((BigDecimal)result.getMemoryTotal()));
                    ioWait.setExceptionOut((Object)result.getIoWait());
                    youngGcCount.setExceptionOut((Object)result.getYoungGcCount());
                    youngGcTime.setExceptionOut((Object)result.getYoungGcTime());
                    oldGcCount.setExceptionOut((Object)result.getOldGcCount());
                    oldGcTime.setExceptionOut((Object)result.getOldGcTime());
                    break;
                }
                case "afterFirst": {
                    cpuUsage.setAfterIn((Object)result.getCpuUsage());
                    cpuLoad.setAfterIn((Object)result.getCpuLoad());
                    memoryUsage.setAfterIn((Object)result.getMemoryUsage());
                    memoryTotal.setAfterIn((Object)UnitConvertor.byteToMb((BigDecimal)result.getMemoryTotal()));
                    ioWait.setAfterIn((Object)result.getIoWait());
                    youngGcCount.setAfterIn((Object)result.getYoungGcCount());
                    youngGcTime.setAfterIn((Object)result.getYoungGcTime());
                    oldGcCount.setAfterIn((Object)result.getOldGcCount());
                    oldGcTime.setAfterIn((Object)result.getOldGcTime());
                    break;
                }
                case "afterLast": {
                    cpuUsage.setAfterOut((Object)result.getCpuUsage());
                    cpuLoad.setAfterOut((Object)result.getCpuLoad());
                    memoryUsage.setAfterOut((Object)result.getMemoryUsage());
                    memoryTotal.setAfterOut((Object)UnitConvertor.byteToMb((BigDecimal)result.getMemoryTotal()));
                    ioWait.setAfterOut((Object)result.getIoWait());
                    youngGcCount.setAfterOut((Object)result.getYoungGcCount());
                    youngGcTime.setAfterOut((Object)result.getYoungGcTime());
                    oldGcCount.setAfterOut((Object)result.getOldGcCount());
                    oldGcTime.setAfterOut((Object)result.getOldGcTime());
                }
            }
        }
        return responseList;
    }
}

