/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.fastdebug;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.pamirs.tro.common.constant.LogPullStatusEnum;
import io.shulie.tro.channel.bean.CommandResponse;
import io.shulie.tro.cloud.common.redis.RedisClientUtils;
import io.shulie.tro.web.app.agent.AgentCommandEnum;
import io.shulie.tro.web.app.agent.AgentCommandFactory;
import io.shulie.tro.web.app.agent.CommandSendDTO;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.constant.FastDebugLogPathFactory;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.request.fastdebug.FastDebugAgentLogRequest;
import io.shulie.tro.web.app.request.fastdebug.FastDebugAppLogRequest;
import io.shulie.tro.web.app.response.fastdebug.AgentLogNamesResponse;
import io.shulie.tro.web.app.response.fastdebug.FastDebugLogResponse;
import io.shulie.tro.web.app.service.fastdebug.FastDebugLogService;
import io.shulie.tro.web.app.utils.FileUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FastDebugLogServiceImpl
implements FastDebugLogService {
    private static final Logger log = LoggerFactory.getLogger(FastDebugLogServiceImpl.class);
    @Value(value="${fast.debug.upload.log.path:/data/fastdebug/log/}")
    private String prePath;
    @Autowired
    private FastDebugLogPathFactory pathFactory;
    @Autowired
    private RedisClientUtils redisClientUtils;
    @Autowired
    private AgentCommandFactory agentCommandFactory;

    public FastDebugLogResponse getAppLog(FastDebugAppLogRequest logRequest) throws Exception {
        String path = logRequest.getFilePath();
        if (!path.contains("/") || path.endsWith("/")) {
            throw new RuntimeException("\u8f93\u5165\u8def\u5f84\u4e0d\u5408\u6cd5\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        Long customerId = RestContext.getUser().getCustomerId();
        String isExist = this.redisClientUtils.getString(this.pathFactory.appLogIsExistKey(customerId, logRequest.getAgentId(), logRequest.getFilePath()));
        if (StringUtils.isNotBlank((CharSequence)isExist) && isExist.equals("false")) {
            throw new RuntimeException("\u65e5\u5fd7\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u8def\u5f84");
        }
        FastDebugLogResponse response = new FastDebugLogResponse();
        String logPullStatus = this.getAppLogPullStatus(logRequest);
        response.setLogPullStatus(logPullStatus);
        if (logPullStatus == null) {
            String filePath = logRequest.getFilePath();
            String fileName = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.length());
            String appLogPullStatusKey = this.pathFactory.appLogPullStatusKey(customerId, logRequest.getAppName(), logRequest.getAgentId(), logRequest.getTraceId(), filePath, fileName);
            this.redisClientUtils.setString(appLogPullStatusKey, LogPullStatusEnum.PULLING.name(), 1, TimeUnit.MINUTES);
            this.sendPullLogCommand(this.buildPullAppCommand(logRequest.getAppName(), logRequest.getAgentId(), logRequest.getTraceId(), logRequest.getFilePath()));
            response.setTotalCount(0L);
            response.setLogPullStatus(LogPullStatusEnum.PULLING.getName());
            return response;
        }
        if (logPullStatus.equals(LogPullStatusEnum.PULLING.getName()) || logPullStatus.equals(LogPullStatusEnum.TIMEOUT.name())) {
            response.setTotalCount(0L);
            return response;
        }
        int currentPage = logRequest.getCurrent();
        int pageSize = logRequest.getPageSize();
        int startLine = currentPage * pageSize;
        String fileNameOld = logRequest.getFilePath();
        String fileName = fileNameOld.substring(fileNameOld.lastIndexOf("/") + 1, fileNameOld.length());
        String filePath = this.pathFactory.appLogPath(customerId, logRequest.getAppName(), logRequest.getAgentId(), logRequest.getTraceId(), this.replacePath(logRequest.getFilePath()), fileName);
        FastDebugLogResponse result = this.assembleLogResp(filePath, startLine, pageSize, currentPage);
        if (result != null && result.getNeedPull().booleanValue()) {
            try {
                this.sendPullLogCommand(this.buildPullAppCommand(logRequest.getAppName(), logRequest.getAgentId(), logRequest.getTraceId(), logRequest.getFilePath()));
            }
            catch (Exception e) {
                log.error("\u62c9\u53d6\u4e0b\u4e00\u9875\u5e94\u7528\u65e5\u5fd7\u5931\u8d25 ...; message:{}", (Object)e.getMessage());
            }
        }
        return result;
    }

    String replacePath(String oldPath) {
        return oldPath.replace("/", "-");
    }

    public AgentLogNamesResponse getAgentLogNames(String appName, String agentId, String traceId) throws Exception {
        String status = this.getAgentLogNameStatus(appName, agentId, traceId);
        AgentLogNamesResponse response = new AgentLogNamesResponse();
        response.setFileNames((List)Lists.newArrayList());
        response.setStatus(status);
        if (status == null) {
            this.redisClientUtils.setString(this.pathFactory.getAgentLogNamesStatus(RestContext.getCustomerId(), appName, agentId, traceId), LogPullStatusEnum.PULLING.name(), 1, TimeUnit.MINUTES);
            this.sendPullLogCommand(this.buildPullAgentCommand(appName, agentId, traceId, null));
            response.setStatus(LogPullStatusEnum.PULLING.name());
            return response;
        }
        if (status.equals(LogPullStatusEnum.PULLING.getName()) || status.equals(LogPullStatusEnum.TIMEOUT.name())) {
            return response;
        }
        response.setFileNames(FileUtils.getFileNames((String)this.pathFactory.agentLogDir(RestContext.getCustomerId(), appName, agentId, traceId)));
        response.setStatus(LogPullStatusEnum.PULLED.getName());
        return response;
    }

    public FastDebugLogResponse getAgentLog(FastDebugAgentLogRequest request) throws Exception {
        FastDebugLogResponse response = new FastDebugLogResponse();
        response.setLogPullStatus(LogPullStatusEnum.PULLING.getName());
        String agentLogPullStatus = this.getAgentLogPullStatus(request);
        if (agentLogPullStatus == null) {
            this.sendPullLogCommand(this.buildPullAgentCommand(request.getAppName(), request.getAgentId(), request.getTraceId(), request.getFileName()));
            this.redisClientUtils.setString(this.pathFactory.agentLogPullStatusKey(RestContext.getCustomerId(), request.getAppName(), request.getAgentId(), request.getTraceId(), request.getFileName()), LogPullStatusEnum.PULLING.getName(), 1, TimeUnit.MINUTES);
            return response;
        }
        if (agentLogPullStatus.equals(LogPullStatusEnum.PULLING.getName())) {
            return response;
        }
        int currentPage = request.getCurrent();
        int pageSize = request.getPageSize();
        int startLine = currentPage * pageSize;
        String filePath = this.pathFactory.agentLogPath(RestContext.getCustomerId(), request.getAppName(), request.getAgentId(), request.getTraceId(), request.getFileName());
        FastDebugLogResponse result = this.assembleLogResp(filePath, startLine, pageSize, currentPage);
        if (result != null && result.getNeedPull().booleanValue()) {
            try {
                this.sendPullLogCommand(this.buildPullAgentCommand(request.getAppName(), request.getAgentId(), request.getTraceId(), request.getFileName()));
            }
            catch (Exception e) {
                log.error("\u62c9\u53d6\u4e0b\u4e00\u9875\u5931\u8d25 ...");
            }
        }
        return result;
    }

    public FastDebugLogResponse assembleLogResp(String filePath, int startLine, int pageSize, int currentPage) {
        FastDebugLogResponse response = new FastDebugLogResponse();
        JSONObject json = FileUtils.readLine((String)filePath, (int)startLine, (int)pageSize);
        List list = (List)json.getObject("list", List.class);
        Long lineNum = json.getLong("lineNum");
        if (this.isLastPage(Integer.valueOf(currentPage), Integer.valueOf(lineNum.intValue()), Integer.valueOf(pageSize))) {
            response.setNeedPull(Boolean.valueOf(true));
        }
        StringBuilder builder = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                builder.append((String)list.get(i));
                if (i + 1 >= size) continue;
                builder.append(System.lineSeparator());
            }
        }
        response.setContent(builder.toString());
        response.setTotalCount(lineNum.longValue());
        response.setLogPullStatus(LogPullStatusEnum.PULLED.getName());
        return response;
    }

    public boolean nextPageHasSended(String nextPageKey) {
        String hasPulled = this.redisClientUtils.getString(nextPageKey);
        if (StringUtil.isNotEmpty((String)hasPulled)) {
            return true;
        }
        this.redisClientUtils.setString(nextPageKey, LogPullStatusEnum.PULLED.name(), 30, TimeUnit.SECONDS);
        return false;
    }

    public String getAgentLogNameStatus(String appName, String agentId, String traceId) {
        String agentLogDir = this.pathFactory.agentLogDir(RestContext.getCustomerId(), appName, agentId, traceId);
        List fileNames = FileUtils.getFileNames((String)agentLogDir);
        if (CollectionUtils.isEmpty((Collection)fileNames)) {
            String agentLogNamesStatusKey = this.pathFactory.getAgentLogNamesStatus(RestContext.getCustomerId(), appName, agentId, traceId);
            return this.redisClientUtils.getString(agentLogNamesStatusKey);
        }
        return LogPullStatusEnum.PULLED.getName();
    }

    public String getAppLogPullStatus(FastDebugAppLogRequest request) {
        String filePath = request.getFilePath();
        String fileName = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.length());
        String existfilePath = this.pathFactory.appLogPath(RestContext.getCustomerId(), request.getAppName(), request.getAgentId(), request.getTraceId(), this.replacePath(request.getFilePath()), fileName);
        if (!FileUtils.existFile((String)existfilePath)) {
            this.redisClientUtils.delete(this.pathFactory.appLogUploadLastLineKey(RestContext.getCustomerId(), request.getAgentId(), request.getTraceId(), request.getFilePath()));
            String appLogPullStatusKey = this.pathFactory.appLogPullStatusKey(RestContext.getCustomerId(), request.getAppName(), request.getAgentId(), request.getTraceId(), filePath, fileName);
            String cacheTime = this.redisClientUtils.getString(appLogPullStatusKey);
            if (StringUtils.isNotBlank((CharSequence)cacheTime)) {
                return cacheTime;
            }
            return null;
        }
        this.redisClientUtils.setString(this.pathFactory.appLogPullStatusKey(RestContext.getCustomerId(), request.getAppName(), request.getAgentId(), request.getTraceId(), filePath, fileName), LogPullStatusEnum.PULLED.getName(), 3, TimeUnit.MINUTES);
        return LogPullStatusEnum.PULLED.getName();
    }

    public String getAgentLogPullStatus(FastDebugAgentLogRequest request) {
        String existfilePath = this.pathFactory.agentLogPath(RestContext.getCustomerId(), request.getAppName(), request.getAgentId(), request.getTraceId(), request.getFileName());
        if (!FileUtils.existFile((String)existfilePath)) {
            this.redisClientUtils.delete(this.pathFactory.agentLogUploadLastLineKey(RestContext.getCustomerId(), request.getAgentId(), request.getTraceId(), request.getFileName()));
            return null;
        }
        this.redisClientUtils.setString(this.pathFactory.agentLogPullStatusKey(RestContext.getCustomerId(), request.getAppName(), request.getAgentId(), request.getTraceId(), request.getFileName()), LogPullStatusEnum.PULLED.name(), 15, TimeUnit.DAYS);
        return LogPullStatusEnum.PULLED.name();
    }

    public boolean isLastPage(Integer currentPage, Integer totalLine, Integer pageSize) {
        int i = totalLine / pageSize;
        return currentPage + 1 >= i;
    }

    public CommandSendDTO buildPullAppCommand(String appName, String agentId, String traceId, String filePath) {
        Integer lineStart = null;
        String lastLine = this.redisClientUtils.getString(this.pathFactory.appLogUploadLastLineKey(RestContext.getCustomerId(), agentId, traceId, filePath));
        if (lastLine != null) {
            lineStart = Integer.valueOf(lastLine);
        }
        CommandSendDTO commandSend = new CommandSendDTO();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("appName", appName);
        param.put("agentId", agentId);
        param.put("filePath", filePath);
        param.put("lineStart", lineStart);
        param.put("batchLines", 500);
        param.put("traceId", traceId);
        commandSend.setAgentId(agentId);
        commandSend.setParam(param);
        commandSend.setAgentCommandEnum(AgentCommandEnum.PULL_APP_LOG_COMMAND);
        if (this.nextPageHasSended(this.pathFactory.appNextPageHasSendedKey(appName, agentId, traceId, filePath, lineStart))) {
            return null;
        }
        return commandSend;
    }

    public CommandSendDTO buildPullAgentCommand(String appName, String agentId, String traceId, String fileName) {
        String lastLine;
        Integer lineStart = null;
        if (StringUtils.isNotBlank((CharSequence)fileName) && (lastLine = this.redisClientUtils.getString(this.pathFactory.agentLogUploadLastLineKey(RestContext.getCustomerId(), agentId, traceId, fileName))) != null) {
            lineStart = Integer.valueOf(lastLine);
        }
        CommandSendDTO commandSend = new CommandSendDTO();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("appName", appName);
        param.put("agentId", agentId);
        param.put("fileName", fileName);
        param.put("lineStart", lineStart);
        param.put("batchLines", 500);
        param.put("traceId", traceId);
        commandSend.setAgentId(agentId);
        commandSend.setParam(param);
        commandSend.setAgentCommandEnum(AgentCommandEnum.PULL_AGENT_LOG_COMMAND);
        if (this.nextPageHasSended(this.pathFactory.agentNextPageHasSendedKey(appName, agentId, traceId, fileName, lineStart))) {
            return null;
        }
        return commandSend;
    }

    public void sendPullLogCommand(CommandSendDTO send) throws Exception {
        log.info("send command: {}", (Object)JSON.toJSONString((Object)send, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        try {
            CommandResponse response = this.agentCommandFactory.send(send.getAgentCommandEnum(), send.getAgentId(), send.getParam());
            if (response != null && !response.isSuccess()) {
                log.error("\u53d1\u9001\u62c9\u53d6\u65e5\u5fd7\u547d\u4ee4\u5931\u8d25...");
            }
        }
        catch (TroWebException e) {
            String msg = e.getSource() == null ? "" : e.getSource().toString();
            log.error(msg);
            throw new RuntimeException("\u6b63\u5728\u62c9\u53d6\u4e2d\uff0c\u8bf7\u7a0d\u7b49...");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

