/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.elasticjoblite;

import com.alibaba.fastjson.JSON;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.constant.VerifyResultStatusEnum;
import com.pamirs.tro.common.constant.VerifyTypeEnum;
import com.pamirs.tro.common.util.JdbcConnection;
import com.pamirs.tro.common.util.SpringUtil;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.request.leakverify.LeakVerifyTaskJobParameter;
import io.shulie.tro.web.app.request.leakverify.VerifyTaskConfig;
import io.shulie.tro.web.app.service.VerifyTaskService;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyJob
implements SimpleJob {
    private static final Logger logger = LoggerFactory.getLogger(VerifyJob.class);

    public void execute(ShardingContext shardingContext) {
        logger.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u68c0\u6d4b:[{}],\u5f53\u524d\u65f6\u95f4:[{}],\u5b9a\u65f6\u4efb\u52a1ID:[{}]", new Object[]{shardingContext.getJobName(), new Date(), shardingContext.getTaskId()});
        String jobParameterString = shardingContext.getJobParameter();
        LeakVerifyTaskJobParameter jobParameter = (LeakVerifyTaskJobParameter)JSON.parseObject((String)jobParameterString, LeakVerifyTaskJobParameter.class);
        Integer refType = jobParameter.getRefType();
        Long refId = jobParameter.getRefId();
        VerifyTypeEnum typeEnum = VerifyTypeEnum.getTypeByCode((Integer)refType);
        logger.info("\u5f00\u59cb\u6267\u884c\u9a8c\u8bc1\u4efb\u52a1[refType:{},refId:{}]", (Object)Objects.requireNonNull(typeEnum).name(), (Object)refId);
        logger.info(shardingContext.toString());
        List taskConfigs = jobParameter.getVerifyTaskConfigList();
        Map resultMap = this.verify(refType, refId, taskConfigs);
        logger.info("\u9a8c\u8bc1\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u9a8c\u8bc1\u7ed3\u679c\u5165\u5e93:[refType:{},refId:{}]", (Object)typeEnum.name(), (Object)refId);
        VerifyTaskService verifyTaskService = (VerifyTaskService)SpringUtil.getBean((String)"verifyTaskServiceImpl");
        verifyTaskService.saveVerifyResult(jobParameter, resultMap);
    }

    public Map<Integer, Integer> run(LeakVerifyTaskJobParameter jobParameter) {
        Integer refType = jobParameter.getRefType();
        Long refId = jobParameter.getRefId();
        VerifyTypeEnum typeEnum = VerifyTypeEnum.getTypeByCode((Integer)refType);
        logger.info("\u5f00\u59cb\u8fd0\u884c\u9a8c\u8bc1\u4efb\u52a1[refType:{},refId:{}]", (Object)Objects.requireNonNull(typeEnum).name(), (Object)refId);
        logger.info("\u4efb\u52a1\u53c2\u6570:[{}]", (Object)JSON.toJSONString((Object)jobParameter));
        List taskConfigs = jobParameter.getVerifyTaskConfigList();
        return this.verify(refType, refId, taskConfigs);
    }

    private Map<Integer, Integer> verify(Integer refType, Long refId, List<VerifyTaskConfig> taskConfigs) {
        HashMap resultMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(taskConfigs)) {
            taskConfigs.forEach(taskConfig -> {
                String jdbcUrl = taskConfig.getJdbcUrl();
                String username = taskConfig.getUsername();
                String password = taskConfig.getPassword();
                Long datasourceId = taskConfig.getDatasourceId();
                List sqls = taskConfig.getSqls();
                Connection connection = null;
                try {
                    connection = JdbcConnection.generateConnection((String)jdbcUrl, (String)username, (String)password);
                    if (Objects.isNull(connection)) {
                        throw new TroWebException((ExceptionReadable)ExceptionCode.VERIFY_TASK_RUN_FAILED, (Object)"\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25");
                    }
                }
                catch (ClassNotFoundException | SQLException e) {
                    logger.error("Verify job run error:", (Throwable)e);
                }
                try {
                    Connection finalConnection = connection;
                    sqls.forEach(sql -> {
                        String keyString = (long)refType.intValue() + refId + datasourceId + sql;
                        Integer key = keyString.hashCode();
                        try {
                            Statement statement = finalConnection.createStatement();
                            statement.setQueryTimeout(30);
                            ResultSet resultSet = statement.executeQuery((String)sql);
                            Integer count = resultSet.next() ? VerifyResultStatusEnum.LEAKED.getCode() : VerifyResultStatusEnum.NORMAL.getCode();
                            logger.info("sql\u6f0f\u6570\u9a8c\u8bc1\u7ed3\u679c:[jdbcUrl:{},sql:{},count:{}]", new Object[]{jdbcUrl, sql, count});
                            resultMap.put(key, count);
                            resultSet.close();
                            statement.close();
                        }
                        catch (SQLException throwables) {
                            resultMap.put(key, VerifyResultStatusEnum.FAILED.getCode());
                            logger.error("Verify job run error:", (Throwable)throwables);
                        }
                    });
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e) {
                            logger.error("error:", (Throwable)e);
                        }
                    }
                }
            });
        } else {
            logger.warn("\u6f0f\u6570\u9a8c\u8bc1\u914d\u7f6e\u4e3a\u7a7a\uff0c\u4e0d\u4e88\u68c0\u6d4b");
        }
        return resultMap;
    }
}

