/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.dsManage.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.pamirs.tro.common.constant.AppAccessTypeEnum;
import com.pamirs.tro.common.enums.ds.DsTypeEnum;
import com.pamirs.tro.entity.dao.simplify.TAppBusinessTableInfoMapper;
import com.pamirs.tro.entity.dao.user.TUserMapper;
import io.shulie.tro.web.app.cache.AgentConfigCacheManager;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.init.sync.ConfigSyncService;
import io.shulie.tro.web.app.request.application.ApplicationDsCreateRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsDeleteRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsEnableRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsUpdateRequest;
import io.shulie.tro.web.app.response.application.ApplicationDsDetailResponse;
import io.shulie.tro.web.app.service.ApplicationService;
import io.shulie.tro.web.app.service.dsManage.AbstractDsService;
import io.shulie.tro.web.app.service.dsManage.impl.ShadowDbServiceImpl;
import io.shulie.tro.web.app.utils.DsManageUtil;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.dao.application.ApplicationDsDAO;
import io.shulie.tro.web.data.param.application.ApplicationDsCreateParam;
import io.shulie.tro.web.data.param.application.ApplicationDsDeleteParam;
import io.shulie.tro.web.data.param.application.ApplicationDsEnableParam;
import io.shulie.tro.web.data.param.application.ApplicationDsQueryParam;
import io.shulie.tro.web.data.param.application.ApplicationDsUpdateParam;
import io.shulie.tro.web.data.result.application.ApplicationDetailResult;
import io.shulie.tro.web.data.result.application.ApplicationDsResult;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ShadowTableServiceImpl
extends AbstractDsService {
    private Logger logger = LoggerFactory.getLogger(ShadowDbServiceImpl.class);
    @Autowired
    private ApplicationService applicationService;
    @Resource
    private TAppBusinessTableInfoMapper TAppBusinessTableInfoMapper;
    @Resource
    private TUserMapper TUserMapper;
    @Autowired
    private ConfigSyncService configSyncService;
    @Autowired
    private ApplicationDsDAO applicationDsDAO;
    @Autowired
    private ApplicationDAO applicationDAO;
    @Autowired
    private AgentConfigCacheManager agentConfigCacheManager;

    public Response dsAdd(ApplicationDsCreateRequest createRequest) {
        ApplicationDetailResult applicationDetailResult = this.applicationDAO.getApplicationById(createRequest.getApplicationId());
        Response response = this.validator(applicationDetailResult, createRequest);
        if (response != null) {
            return response;
        }
        ApplicationDsCreateParam createParam = new ApplicationDsCreateParam();
        this.addParserConfig(createRequest, createParam);
        createParam.setApplicationId(createRequest.getApplicationId());
        createParam.setApplicationName(applicationDetailResult.getApplicationName());
        createParam.setDbType(createRequest.getDbType());
        createParam.setDsType(Integer.valueOf(Integer.parseInt(String.valueOf(createRequest.getDsType()))));
        createParam.setCustomerId(applicationDetailResult.getCustomerId());
        createParam.setUserId(applicationDetailResult.getUserId());
        createParam.setStatus(createRequest.getStatus());
        this.syncInfo(applicationDetailResult.getApplicationId(), createParam.getApplicationName());
        this.applicationDsDAO.insert(createParam);
        return Response.success();
    }

    private void addParserConfig(ApplicationDsCreateRequest createRequest, ApplicationDsCreateParam createParam) {
        String url = DsManageUtil.parseShadowTableUrl((String)createRequest.getUrl());
        String config = createRequest.getConfig();
        String parsedConfig = this.parseShadowTableConfig(config);
        createParam.setUrl(url);
        createParam.setConfig(parsedConfig);
        createParam.setParseConfig(parsedConfig);
    }

    private void syncInfo(Long applicationId, String applicationName) {
        this.configSyncService.syncShadowDB(RestContext.getUser().getKey(), applicationId.longValue(), null);
        this.applicationService.modifyAccessStatus(String.valueOf(applicationId), AppAccessTypeEnum.UNUPLOAD.getValue(), null);
        this.agentConfigCacheManager.evictShadowDb(applicationName);
    }

    private Response validator(ApplicationDetailResult applicationDetailResult, ApplicationDsCreateRequest createRequest) {
        if (applicationDetailResult == null) {
            return Response.fail((String)"0", (String)"\u5e94\u7528\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        }
        Assert.notNull((Object)applicationDetailResult, (String)"\u5e94\u7528\u4e0d\u5b58\u5728!");
        ApplicationDsQueryParam queryCurrentParam = new ApplicationDsQueryParam();
        queryCurrentParam.setApplicationId(createRequest.getApplicationId());
        queryCurrentParam.setIsDeleted(Integer.valueOf(0));
        List applicationDsResultList = this.applicationDsDAO.queryList(queryCurrentParam);
        List<Object> dsTypeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)applicationDsResultList)) {
            dsTypeList = applicationDsResultList.stream().map(ApplicationDsResult::getDsType).map(String::valueOf).map(Integer::parseInt).distinct().collect(Collectors.toList());
        }
        if (dsTypeList.contains(DsTypeEnum.SHADOW_DB.getCode())) {
            return Response.fail((String)"0", (String)"\u521b\u5efa\u5f71\u5b50\u5e93\u8868\u914d\u7f6e\u5931\u8d25, \u4e0d\u80fd\u51fa\u73b0\u4e0d\u540c\u7c7b\u578b(\u5e93/\u8868)", (Object[])new Object[0]);
        }
        String url = DsManageUtil.parseShadowTableUrl((String)createRequest.getUrl());
        ApplicationDsQueryParam queryParam = new ApplicationDsQueryParam();
        queryParam.setApplicationId(createRequest.getApplicationId());
        queryParam.setUrl(url);
        List currentDsResultList = this.applicationDsDAO.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)currentDsResultList)) {
            return Response.fail((String)"0", (String)"\u5f71\u5b50\u8868\u914d\u7f6e\u5df2\u5b58\u5728", (Object[])new Object[0]);
        }
        return null;
    }

    public Response dsUpdate(ApplicationDsUpdateRequest updateRequest) {
        ApplicationDsResult dsResult = this.applicationDsDAO.queryByPrimaryKey(updateRequest.getId());
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"0", (String)"\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationDsUpdateParam updateParam = new ApplicationDsUpdateParam();
        this.updateParserConfig(updateRequest, updateParam);
        updateParam.setId(updateRequest.getId());
        updateParam.setStatus(updateRequest.getStatus());
        this.syncInfo(dsResult.getApplicationId(), dsResult.getApplicationName());
        this.applicationDsDAO.update(updateParam);
        return Response.success();
    }

    private void updateParserConfig(ApplicationDsUpdateRequest updateRequest, ApplicationDsUpdateParam updateParam) {
        String config = updateRequest.getConfig();
        String parsedConfig = this.parseShadowTableConfig(config);
        updateParam.setUrl(DsManageUtil.parseShadowTableUrl((String)updateRequest.getUrl()));
        updateParam.setConfig(parsedConfig);
    }

    public Response<ApplicationDsDetailResponse> dsQueryDetail(Long dsId, boolean isOldVersion) {
        ApplicationDsResult dsResult = this.applicationDsDAO.queryByPrimaryKey(dsId);
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"\u8be5\u5f71\u5b50\u5e93\u8868\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationDsDetailResponse dsDetailResponse = new ApplicationDsDetailResponse();
        dsDetailResponse.setId(dsResult.getId());
        dsDetailResponse.setApplicationId(dsResult.getApplicationId());
        dsDetailResponse.setApplicationName(dsResult.getApplicationName());
        dsDetailResponse.setDbType(dsResult.getDbType());
        dsDetailResponse.setDsType(dsResult.getDsType());
        dsDetailResponse.setUrl(dsResult.getUrl());
        this.queryParserConfig(dsResult, dsDetailResponse);
        return Response.success((Object)dsDetailResponse);
    }

    private void queryParserConfig(ApplicationDsResult dsResult, ApplicationDsDetailResponse dsDetailResponse) {
        String config = dsResult.getConfig();
        String configStr = dsResult.getConfig();
        if (StringUtils.isNotBlank((CharSequence)configStr)) {
            String[] configItems;
            StringBuilder rawConfigBuilder = new StringBuilder();
            for (String item : configItems = configStr.split(",")) {
                String table = item.trim();
                table = table.toUpperCase();
                table = "PT_" + table;
                rawConfigBuilder.append(table);
                rawConfigBuilder.append(",");
            }
            config = rawConfigBuilder.substring(0, rawConfigBuilder.length() - 1);
        }
        dsDetailResponse.setConfig(config);
    }

    public Response enableConfig(ApplicationDsEnableRequest enableRequest) {
        ApplicationDsResult dsResult = this.applicationDsDAO.queryByPrimaryKey(enableRequest.getId());
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"0", (String)"\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationDsEnableParam enableParam = new ApplicationDsEnableParam();
        enableParam.setId(enableRequest.getId());
        enableParam.setStatus(enableRequest.getStatus());
        this.applicationDsDAO.enable(enableParam);
        this.syncInfo(dsResult.getApplicationId(), dsResult.getApplicationName());
        return Response.success();
    }

    public Response dsDelete(ApplicationDsDeleteRequest dsDeleteRequest) {
        ApplicationDsResult dsResult = this.applicationDsDAO.queryByPrimaryKey(dsDeleteRequest.getId());
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"0", (String)"\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationDsDeleteParam deleteParam = new ApplicationDsDeleteParam();
        deleteParam.setIdList(Collections.singletonList(dsDeleteRequest.getId()));
        this.applicationDsDAO.delete(deleteParam);
        this.syncInfo(dsResult.getApplicationId(), dsResult.getApplicationName());
        return Response.success();
    }

    private String parseShadowTableConfig(String config) {
        String[] configItems;
        StringBuilder parsedConfigBuilder = new StringBuilder();
        for (String item : configItems = config.split(",")) {
            String table = item.trim();
            if ((table = table.toUpperCase()).startsWith("`")) {
                table = table.substring(1);
            }
            if (table.endsWith("`")) {
                table = table.substring(0, table.length() - 1);
            }
            if (table.startsWith("pt_") || table.startsWith("PT_")) {
                table = table.substring(3);
            }
            parsedConfigBuilder.append(table);
            parsedConfigBuilder.append(",");
        }
        String parsedConfig = parsedConfigBuilder.toString();
        if (parsedConfig.endsWith(",")) {
            parsedConfig.substring(0, parsedConfigBuilder.length() - 1);
        }
        return parsedConfig;
    }
}

