/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.dsManage.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.pamirs.tro.common.constant.AppAccessTypeEnum;
import com.pamirs.tro.common.enums.ds.DsTypeEnum;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.dao.simplify.TAppBusinessTableInfoMapper;
import com.pamirs.tro.entity.dao.user.TUserMapper;
import com.pamirs.tro.entity.domain.entity.DsModelWithBLOBs;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import com.pamirs.tro.entity.domain.entity.user.User;
import io.shulie.tro.web.app.cache.AgentConfigCacheManager;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.init.sync.ConfigSyncService;
import io.shulie.tro.web.app.request.application.ApplicationDsCreateRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsDeleteRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsEnableRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsUpdateRequest;
import io.shulie.tro.web.app.response.application.ApplicationDsDetailResponse;
import io.shulie.tro.web.app.response.application.ShadowServerConfigurationResponse;
import io.shulie.tro.web.app.response.application.SingleServerConfiguration;
import io.shulie.tro.web.app.service.ApplicationService;
import io.shulie.tro.web.app.service.dsManage.AbstractDsService;
import io.shulie.tro.web.app.service.dsManage.impl.ShadowDbServiceImpl;
import io.shulie.tro.web.app.utils.DsManageUtil;
import io.shulie.tro.web.common.util.JsonUtil;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.dao.application.ApplicationDsDAO;
import io.shulie.tro.web.data.param.application.ApplicationDsCreateParam;
import io.shulie.tro.web.data.param.application.ApplicationDsDeleteParam;
import io.shulie.tro.web.data.param.application.ApplicationDsEnableParam;
import io.shulie.tro.web.data.param.application.ApplicationDsQueryParam;
import io.shulie.tro.web.data.param.application.ApplicationDsUpdateParam;
import io.shulie.tro.web.data.result.application.ApplicationDetailResult;
import io.shulie.tro.web.data.result.application.ApplicationDsResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ShadowRedisServerServiceImpl
extends AbstractDsService {
    private Logger logger = LoggerFactory.getLogger(ShadowDbServiceImpl.class);
    @Autowired
    private ApplicationService applicationService;
    @Resource
    private TApplicationMntDao applicationMntDao;
    @Resource
    private TAppBusinessTableInfoMapper TAppBusinessTableInfoMapper;
    @Resource
    private TUserMapper TUserMapper;
    @Autowired
    private ConfigSyncService configSyncService;
    @Autowired
    private ApplicationDsDAO applicationDsDAO;
    @Autowired
    private ApplicationDAO applicationDAO;
    @Autowired
    private AgentConfigCacheManager agentConfigCacheManager;

    public Response dsAdd(ApplicationDsCreateRequest createRequest) {
        ApplicationDetailResult applicationDetailResult = this.applicationDAO.getApplicationById(createRequest.getApplicationId());
        Assert.notNull((Object)applicationDetailResult, (String)"\u5e94\u7528\u4e0d\u5b58\u5728!");
        ApplicationDsQueryParam queryCurrentParam = new ApplicationDsQueryParam();
        queryCurrentParam.setApplicationId(createRequest.getApplicationId());
        queryCurrentParam.setIsDeleted(Integer.valueOf(0));
        List applicationDsResultList = this.applicationDsDAO.queryList(queryCurrentParam);
        List<Object> dsTypeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)applicationDsResultList)) {
            dsTypeList = applicationDsResultList.stream().map(ApplicationDsResult::getDsType).map(String::valueOf).map(Integer::parseInt).distinct().collect(Collectors.toList());
        }
        ApplicationDsCreateParam createParam = new ApplicationDsCreateParam();
        String url = this.parseShadowServerUrl(createRequest.getConfig());
        String parsedConfig = this.parseShadowServerConfig(createRequest.getConfig());
        createParam.setUrl(url);
        createParam.setParseConfig(parsedConfig);
        createParam.setConfig(createRequest.getConfig());
        createParam.setApplicationId(createRequest.getApplicationId());
        createParam.setApplicationName(applicationDetailResult.getApplicationName());
        createParam.setDbType(createRequest.getDbType());
        createParam.setDsType(Integer.valueOf(Integer.parseInt(String.valueOf(createRequest.getDsType()))));
        createParam.setCustomerId(applicationDetailResult.getCustomerId());
        createParam.setUserId(applicationDetailResult.getUserId());
        this.configSyncService.syncShadowDB(RestContext.getUser().getKey(), createParam.getApplicationId().longValue(), null);
        this.applicationService.modifyAccessStatus(String.valueOf(createParam.getApplicationId()), AppAccessTypeEnum.UNUPLOAD.getValue(), null);
        this.agentConfigCacheManager.evictShadowServer(applicationDetailResult.getApplicationName());
        createParam.setStatus(createRequest.getStatus());
        this.applicationDsDAO.insert(createParam);
        return Response.success();
    }

    public Response dsUpdate(ApplicationDsUpdateRequest updateRequest) {
        ApplicationDsResult dsResult = this.applicationDsDAO.queryByPrimaryKey(updateRequest.getId());
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"0", (String)"\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationDsUpdateParam updateParam = new ApplicationDsUpdateParam();
        String config = updateRequest.getConfig();
        config = this.getOriginConfigFromServer(config, dsResult.getConfig());
        updateParam.setUrl(this.parseShadowServerUrl(config));
        updateParam.setConfig(config);
        updateParam.setParseConfig(this.parseShadowServerConfig(config));
        this.configSyncService.syncShadowDB(RestContext.getUser().getKey(), dsResult.getApplicationId().longValue(), dsResult.getApplicationName());
        this.agentConfigCacheManager.evictShadowServer(dsResult.getApplicationName());
        updateParam.setId(updateRequest.getId());
        updateParam.setStatus(updateRequest.getStatus());
        this.applicationDsDAO.update(updateParam);
        return Response.success();
    }

    public Response<ApplicationDsDetailResponse> dsQueryDetail(Long dsId, boolean isOldVersion) {
        ApplicationDsResult dsResult = this.applicationDsDAO.queryByPrimaryKey(dsId);
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"\u8be5\u5f71\u5b50\u5e93\u8868\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationDsDetailResponse dsDetailResponse = new ApplicationDsDetailResponse();
        dsDetailResponse.setId(dsResult.getId());
        dsDetailResponse.setApplicationId(dsResult.getApplicationId());
        dsDetailResponse.setApplicationName(dsResult.getApplicationName());
        dsDetailResponse.setDbType(dsResult.getDbType());
        dsDetailResponse.setDsType(dsResult.getDsType());
        dsDetailResponse.setUrl(dsResult.getUrl());
        String config = dsResult.getConfig();
        config = this.getSafeConfigFromServer(config);
        dsDetailResponse.setConfig(config);
        return Response.success((Object)dsDetailResponse);
    }

    public Response enableConfig(ApplicationDsEnableRequest enableRequest) {
        ApplicationDsResult dsResult = this.applicationDsDAO.queryByPrimaryKey(enableRequest.getId());
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"0", (String)"\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationDsEnableParam enableParam = new ApplicationDsEnableParam();
        enableParam.setId(enableRequest.getId());
        enableParam.setStatus(enableRequest.getStatus());
        this.applicationDsDAO.enable(enableParam);
        this.configSyncService.syncShadowDB(RestContext.getUser().getKey(), dsResult.getApplicationId().longValue(), dsResult.getApplicationName());
        this.agentConfigCacheManager.evictShadowServer(dsResult.getApplicationName());
        return Response.success();
    }

    public Response dsDelete(ApplicationDsDeleteRequest dsDeleteRequest) {
        ApplicationDsResult dsResult = this.applicationDsDAO.queryByPrimaryKey(dsDeleteRequest.getId());
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"0", (String)"\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationDsDeleteParam deleteParam = new ApplicationDsDeleteParam();
        deleteParam.setIdList(Collections.singletonList(dsDeleteRequest.getId()));
        this.applicationDsDAO.delete(deleteParam);
        this.configSyncService.syncShadowDB(RestContext.getUser().getKey(), dsResult.getApplicationId().longValue(), dsResult.getApplicationName());
        this.agentConfigCacheManager.evictShadowServer(dsResult.getApplicationName());
        return Response.success();
    }

    public List<ShadowServerConfigurationResponse> getShadowServerConfigs(String appName) {
        ArrayList<ShadowServerConfigurationResponse> responseList = new ArrayList<ShadowServerConfigurationResponse>();
        String userAppKey = RestContext.getTenantUserKey();
        User user = this.TUserMapper.selectByKey(userAppKey);
        TApplicationMnt applicationMnt = this.applicationMntDao.queryApplicationInfoByNameAndTenant(appName, user == null ? null : user.getId());
        if (applicationMnt != null) {
            List dsModels = this.applicationDsDAO.selectByAppIdForAgent(Long.valueOf(applicationMnt.getApplicationId()));
            if (CollectionUtils.isNotEmpty((Collection)dsModels)) {
                dsModels = dsModels.stream().filter(dsModel -> dsModel.getDsType().equals(new Byte(String.valueOf(DsTypeEnum.SHADOW_REDIS_SERVER.getCode())))).collect(Collectors.toList());
            }
            for (DsModelWithBLOBs dsModel2 : dsModels) {
                ShadowServerConfigurationResponse configurationResponse = (ShadowServerConfigurationResponse)JSON.parseObject((String)dsModel2.getParseConfig(), ShadowServerConfigurationResponse.class);
                responseList.add(configurationResponse);
            }
        }
        return responseList;
    }

    private String getOriginConfigFromServer(String json, String originJson) {
        String safePasswordField;
        if (StringUtils.isBlank((CharSequence)json) || !json.contains(safePasswordField = DsManageUtil.getSafePasswordFieldAboutJson())) {
            return json;
        }
        ShadowServerConfigurationResponse response = (ShadowServerConfigurationResponse)JsonUtil.json2bean((String)originJson, ShadowServerConfigurationResponse.class);
        String password = response.getDataSourceBusinessPerformanceTest().getPassword();
        String originPasswordField = DsManageUtil.getOriginPasswordFieldAboutJson((String)password);
        return json.replace(safePasswordField, originPasswordField);
    }

    public String parseShadowServerUrl(String config) {
        ShadowServerConfigurationResponse configurations = this.parseJsonConfigurations(config);
        SingleServerConfiguration singleServerConfiguration = configurations.getDataSourceBusinessPerformanceTest();
        return singleServerConfiguration.getNodes();
    }

    private String parseShadowServerConfig(String config) {
        ShadowServerConfigurationResponse configurations = this.parseJsonConfigurations(config);
        return JSON.toJSONString((Object)configurations);
    }

    public ShadowServerConfigurationResponse parseJsonConfigurations(String jsonStr) {
        ShadowServerConfigurationResponse shadowServerConfigurationResponse = new ShadowServerConfigurationResponse();
        Object object = JSONObject.parse((String)jsonStr);
        Object dataSourceBusinessObj = ((JSONObject)object).get((Object)"dataSourceBusiness");
        SingleServerConfiguration dataSourceBusiness = new SingleServerConfiguration();
        dataSourceBusiness.setNodes(String.valueOf(((JSONObject)dataSourceBusinessObj).get((Object)"nodes")));
        Object tmpMaster = ((JSONObject)dataSourceBusinessObj).get((Object)"master");
        if (tmpMaster != null) {
            dataSourceBusiness.setMaster(String.valueOf(tmpMaster));
        }
        shadowServerConfigurationResponse.setDataSourceBusiness(dataSourceBusiness);
        Object dataSourceBusinessPerformanceTestObj = ((JSONObject)object).get((Object)"dataSourceBusinessPerformanceTest");
        SingleServerConfiguration dataSourceBusinessPerformanceTest = new SingleServerConfiguration();
        dataSourceBusinessPerformanceTest.setNodes(String.valueOf(((JSONObject)dataSourceBusinessPerformanceTestObj).get((Object)"nodes")));
        dataSourceBusinessPerformanceTest.setDatabase(String.valueOf(((JSONObject)dataSourceBusinessPerformanceTestObj).get((Object)"database")));
        dataSourceBusinessPerformanceTest.setPassword(String.valueOf(((JSONObject)dataSourceBusinessPerformanceTestObj).get((Object)"password")));
        Object tmpTestMaster = ((JSONObject)dataSourceBusinessPerformanceTestObj).get((Object)"master");
        if (tmpTestMaster != null) {
            dataSourceBusinessPerformanceTest.setMaster(String.valueOf(tmpTestMaster));
        }
        shadowServerConfigurationResponse.setDataSourceBusinessPerformanceTest(dataSourceBusinessPerformanceTest);
        return shadowServerConfigurationResponse;
    }

    private String getSafeConfigFromServer(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return "";
        }
        ShadowServerConfigurationResponse response = (ShadowServerConfigurationResponse)JsonUtil.json2bean((String)json, ShadowServerConfigurationResponse.class);
        SingleServerConfiguration dataSourceBusinessPerformanceTest = response.getDataSourceBusinessPerformanceTest();
        if (dataSourceBusinessPerformanceTest.getPassword() == null) {
            return json;
        }
        String originPasswordField = DsManageUtil.getOriginPasswordFieldAboutJson((String)dataSourceBusinessPerformanceTest.getPassword());
        String newPasswordField = DsManageUtil.getSafePasswordFieldAboutJson();
        return json.replace(originPasswordField, newPasswordField);
    }
}

