/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.dsManage.impl;

import com.alibaba.fastjson.JSON;
import com.pamirs.tro.common.constant.AppAccessTypeEnum;
import io.shulie.tro.web.app.cache.AgentConfigCacheManager;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.request.application.ApplicationDsCreateRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsDeleteRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsEnableRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsUpdateRequest;
import io.shulie.tro.web.app.response.application.ApplicationDsDetailResponse;
import io.shulie.tro.web.app.service.ApplicationService;
import io.shulie.tro.web.app.service.dsManage.AbstractDsService;
import io.shulie.tro.web.app.service.dsManage.impl.ShadowDbServiceImpl;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.dao.application.ApplicationDsDAO;
import io.shulie.tro.web.data.param.application.ApplicationDsCreateParam;
import io.shulie.tro.web.data.param.application.ApplicationDsDeleteParam;
import io.shulie.tro.web.data.param.application.ApplicationDsEnableParam;
import io.shulie.tro.web.data.param.application.ApplicationDsUpdateParam;
import io.shulie.tro.web.data.result.application.ApplicationDetailResult;
import io.shulie.tro.web.data.result.application.ApplicationDsResult;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShadowEsServiceImpl
extends AbstractDsService {
    private Logger logger = LoggerFactory.getLogger(ShadowDbServiceImpl.class);
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApplicationDsDAO applicationDsDAO;
    @Autowired
    private ApplicationDAO applicationDAO;
    @Autowired
    private AgentConfigCacheManager agentConfigCacheManager;

    public Response dsAdd(ApplicationDsCreateRequest createRequest) {
        ApplicationDetailResult applicationDetailResult = this.applicationDAO.getApplicationById(createRequest.getApplicationId());
        Response fail = this.validator(createRequest, applicationDetailResult);
        if (fail != null) {
            return fail;
        }
        ApplicationDsCreateParam createParam = new ApplicationDsCreateParam();
        this.addParserConfig(createRequest, createParam);
        createParam.setApplicationId(createRequest.getApplicationId());
        createParam.setApplicationName(applicationDetailResult.getApplicationName());
        createParam.setDbType(createRequest.getDbType());
        createParam.setDsType(Integer.valueOf(Integer.parseInt(String.valueOf(createRequest.getDsType()))));
        createParam.setCustomerId(applicationDetailResult.getCustomerId());
        createParam.setUserId(applicationDetailResult.getUserId());
        createParam.setStatus(createRequest.getStatus());
        this.syncInfo(createRequest.getApplicationId(), applicationDetailResult.getApplicationName());
        this.applicationDsDAO.insert(createParam);
        return Response.success();
    }

    private void addParserConfig(ApplicationDsCreateRequest createRequest, ApplicationDsCreateParam createParam) {
        String config = createRequest.getConfig();
        Map map = this.parseConfig(config);
        String businessNodes = (String)map.get("businessNodes");
        createParam.setUrl(businessNodes);
        createParam.setConfig(config);
        createParam.setParseConfig(createRequest.getConfig());
    }

    private Response validator(ApplicationDsCreateRequest createRequest, ApplicationDetailResult applicationDetailResult) {
        this.logger.warn("\u5e94\u7528\u4e0d\u5b58\u5728! id:{}", (Object)createRequest.getApplicationId());
        if (applicationDetailResult == null) {
            return Response.fail((String)"\u5e94\u7528\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        }
        return null;
    }

    private void syncInfo(Long applicationId, String applicationName) {
        this.applicationService.modifyAccessStatus(String.valueOf(applicationId), AppAccessTypeEnum.UNUPLOAD.getValue(), null);
        this.syncShadowEsConfig(applicationId);
        this.clearCache(applicationName);
    }

    private void syncShadowEsConfig(Long applicationId) {
    }

    public Response dsUpdate(ApplicationDsUpdateRequest updateRequest) {
        ApplicationDsResult dsResult = this.getApplicationDsResult(updateRequest.getId());
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"0", (String)"\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationDsUpdateParam updateParam = new ApplicationDsUpdateParam();
        this.updateParserConfig(updateRequest, updateParam);
        updateParam.setId(updateRequest.getId());
        updateParam.setStatus(updateRequest.getStatus());
        this.syncInfo(dsResult.getApplicationId(), dsResult.getApplicationName());
        this.applicationDsDAO.update(updateParam);
        return Response.success();
    }

    private void updateParserConfig(ApplicationDsUpdateRequest updateRequest, ApplicationDsUpdateParam updateParam) {
        String config = updateRequest.getConfig();
        Map map = this.parseConfig(config);
        String businessNodes = (String)map.get("businessNodes");
        updateParam.setUrl(businessNodes);
        updateParam.setConfig(config);
        updateParam.setParseConfig(config);
    }

    private Map<String, String> parseConfig(String config) {
        return (Map)JSON.parseObject((String)config, Map.class);
    }

    public Response<ApplicationDsDetailResponse> dsQueryDetail(Long dsId, boolean isOldVersion) {
        ApplicationDsResult dsResult = this.getApplicationDsResult(dsId);
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"\u8be5\u5f71\u5b50\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationDsDetailResponse dsDetailResponse = new ApplicationDsDetailResponse();
        dsDetailResponse.setId(dsResult.getId());
        dsDetailResponse.setApplicationId(dsResult.getApplicationId());
        dsDetailResponse.setApplicationName(dsResult.getApplicationName());
        dsDetailResponse.setDbType(dsResult.getDbType());
        dsDetailResponse.setDsType(dsResult.getDsType());
        this.queryParserConfig(dsResult, dsDetailResponse);
        return Response.success((Object)dsDetailResponse);
    }

    private void queryParserConfig(ApplicationDsResult dsResult, ApplicationDsDetailResponse dsDetailResponse) {
        dsDetailResponse.setUrl(dsResult.getUrl());
        String config = dsResult.getConfig();
        dsDetailResponse.setConfig(config);
    }

    public Response enableConfig(ApplicationDsEnableRequest enableRequest) {
        ApplicationDsResult dsResult = this.getApplicationDsResult(enableRequest.getId());
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"0", (String)"\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationDsEnableParam enableParam = new ApplicationDsEnableParam();
        enableParam.setId(enableRequest.getId());
        enableParam.setStatus(enableRequest.getStatus());
        this.applicationDsDAO.enable(enableParam);
        this.syncInfo(dsResult.getApplicationId(), dsResult.getApplicationName());
        return Response.success();
    }

    public Response dsDelete(ApplicationDsDeleteRequest dsDeleteRequest) {
        ApplicationDsResult dsResult = this.getApplicationDsResult(dsDeleteRequest.getId());
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"0", (String)"\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationDsDeleteParam deleteParam = new ApplicationDsDeleteParam();
        deleteParam.setIdList(Collections.singletonList(dsDeleteRequest.getId()));
        this.applicationDsDAO.delete(deleteParam);
        this.syncInfo(dsResult.getApplicationId(), dsResult.getApplicationName());
        return Response.success();
    }

    private void clearCache(String applicationName) {
        this.agentConfigCacheManager.evictShadowEsServers(applicationName);
    }

    private ApplicationDsResult getApplicationDsResult(Long id) {
        return this.applicationDsDAO.queryByPrimaryKey(id);
    }
}

