/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.dsManage.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.pamirs.tro.common.constant.AppAccessTypeEnum;
import com.pamirs.tro.common.enums.ds.DsTypeEnum;
import com.pamirs.tro.entity.domain.vo.dsmanage.Configurations;
import com.pamirs.tro.entity.domain.vo.dsmanage.DataSource;
import com.pamirs.tro.entity.domain.vo.dsmanage.DatasourceMediator;
import io.shulie.tro.web.app.cache.AgentConfigCacheManager;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.init.sync.ConfigSyncService;
import io.shulie.tro.web.app.request.application.ApplicationDsCreateRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsDeleteRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsEnableRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsUpdateRequest;
import io.shulie.tro.web.app.response.application.ApplicationDsDetailResponse;
import io.shulie.tro.web.app.service.ApplicationService;
import io.shulie.tro.web.app.service.dsManage.AbstractDsService;
import io.shulie.tro.web.app.utils.DsManageUtil;
import io.shulie.tro.web.common.util.JsonUtil;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.dao.application.ApplicationDsDAO;
import io.shulie.tro.web.data.param.application.ApplicationDsCreateParam;
import io.shulie.tro.web.data.param.application.ApplicationDsDeleteParam;
import io.shulie.tro.web.data.param.application.ApplicationDsEnableParam;
import io.shulie.tro.web.data.param.application.ApplicationDsQueryParam;
import io.shulie.tro.web.data.param.application.ApplicationDsUpdateParam;
import io.shulie.tro.web.data.result.application.ApplicationDetailResult;
import io.shulie.tro.web.data.result.application.ApplicationDsResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ShadowDbServiceImpl
extends AbstractDsService {
    private Logger logger = LoggerFactory.getLogger(ShadowDbServiceImpl.class);
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ConfigSyncService configSyncService;
    @Autowired
    private ApplicationDsDAO applicationDsDAO;
    @Autowired
    private ApplicationDAO applicationDAO;
    @Autowired
    private AgentConfigCacheManager agentConfigCacheManager;

    public Response dsAdd(ApplicationDsCreateRequest createRequest) {
        ApplicationDetailResult applicationDetailResult = this.applicationDAO.getApplicationById(createRequest.getApplicationId());
        Response fail = this.validator(createRequest, applicationDetailResult);
        if (fail != null) {
            return fail;
        }
        ApplicationDsCreateParam createParam = this.addParseConfig(createRequest);
        createParam.setApplicationId(createRequest.getApplicationId());
        createParam.setApplicationName(applicationDetailResult.getApplicationName());
        createParam.setDbType(createRequest.getDbType());
        createParam.setDsType(Integer.valueOf(Integer.parseInt(String.valueOf(createRequest.getDsType()))));
        createParam.setCustomerId(applicationDetailResult.getCustomerId());
        createParam.setUserId(applicationDetailResult.getUserId());
        createParam.setStatus(createRequest.getStatus());
        this.syncInfo(applicationDetailResult.getApplicationId(), createParam.getApplicationName());
        this.applicationDsDAO.insert(createParam);
        return Response.success();
    }

    private void syncInfo(Long applicationId, String applicationName) {
        this.configSyncService.syncShadowDB(RestContext.getUser().getKey(), applicationId.longValue(), null);
        this.applicationService.modifyAccessStatus(String.valueOf(applicationId), AppAccessTypeEnum.UNUPLOAD.getValue(), null);
        this.agentConfigCacheManager.evictShadowDb(applicationName);
    }

    private ApplicationDsCreateParam addParseConfig(ApplicationDsCreateRequest createRequest) {
        ApplicationDsCreateParam createParam = new ApplicationDsCreateParam();
        createParam.setConfig(createRequest.getConfig());
        if (createRequest.isOldVersion()) {
            createParam.setUrl(this.parseShadowDbUrl(createRequest.getConfig()));
            createParam.setParseConfig(this.parseShadowDbConfigOld(createRequest.getConfig()));
        } else {
            createParam.setUrl(createRequest.getUrl());
            createParam.setParseConfig(this.parseShadowDbCreateConfig(createRequest));
        }
        return createParam;
    }

    private Response validator(ApplicationDsCreateRequest createRequest, ApplicationDetailResult applicationDetailResult) {
        if (applicationDetailResult == null) {
            return Response.fail((String)"0", (String)"\u5e94\u7528\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        }
        ApplicationDsQueryParam queryCurrentParam = new ApplicationDsQueryParam();
        queryCurrentParam.setApplicationId(createRequest.getApplicationId());
        queryCurrentParam.setIsDeleted(Integer.valueOf(0));
        List applicationDsResultList = this.applicationDsDAO.queryList(queryCurrentParam);
        List<Object> dsTypeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)applicationDsResultList)) {
            dsTypeList = applicationDsResultList.stream().map(ApplicationDsResult::getDsType).map(String::valueOf).map(Integer::parseInt).distinct().collect(Collectors.toList());
        }
        if (dsTypeList.contains(DsTypeEnum.SHADOW_TABLE.getCode())) {
            return Response.fail((String)"0", (String)"\u521b\u5efa\u5f71\u5b50\u5e93\u8868\u914d\u7f6e\u5931\u8d25, \u4e0d\u80fd\u51fa\u73b0\u4e0d\u540c\u7c7b\u578b(\u5e93/\u8868)", (Object[])new Object[0]);
        }
        return null;
    }

    public Response dsUpdate(ApplicationDsUpdateRequest updateRequest) {
        ApplicationDsResult dsResult = this.applicationDsDAO.queryByPrimaryKey(updateRequest.getId());
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"0", (String)"\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationDsUpdateParam updateParam = new ApplicationDsUpdateParam();
        String config = updateRequest.getConfig();
        this.updateParserConfig(updateRequest, dsResult, updateParam, config);
        updateParam.setId(updateRequest.getId());
        updateParam.setStatus(updateRequest.getStatus());
        this.syncInfo(dsResult.getApplicationId(), dsResult.getApplicationName());
        this.applicationDsDAO.update(updateParam);
        return Response.success();
    }

    private void updateParserConfig(ApplicationDsUpdateRequest updateRequest, ApplicationDsResult dsResult, ApplicationDsUpdateParam updateParam, String config) {
        config = this.getOriginConfigFromSchema(config, dsResult.getConfig());
        if (updateRequest.isOldVersion()) {
            updateParam.setUrl(this.parseShadowDbUrl(config));
            updateParam.setConfig(config);
            updateParam.setParseConfig(this.parseShadowDbConfig(config));
        } else {
            updateParam.setUrl(updateRequest.getUrl());
            BeanUtils.copyProperties((Object)updateRequest, (Object)updateParam);
            updateParam.setConfig(config);
            updateParam.setParseConfig(this.parseShadowDbUpdateConfig(updateRequest));
        }
    }

    public Response<ApplicationDsDetailResponse> dsQueryDetail(Long dsId, boolean isOldVersion) {
        ApplicationDsResult dsResult = this.applicationDsDAO.queryByPrimaryKey(dsId);
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"\u8be5\u5f71\u5b50\u5e93\u8868\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationDsDetailResponse dsDetailResponse = new ApplicationDsDetailResponse();
        dsDetailResponse.setId(dsResult.getId());
        dsDetailResponse.setApplicationId(dsResult.getApplicationId());
        dsDetailResponse.setApplicationName(dsResult.getApplicationName());
        dsDetailResponse.setDbType(dsResult.getDbType());
        dsDetailResponse.setDsType(dsResult.getDsType());
        dsDetailResponse.setUrl(dsResult.getUrl());
        this.queryParseConfig(isOldVersion, dsResult, dsDetailResponse);
        return Response.success((Object)dsDetailResponse);
    }

    private void queryParseConfig(boolean isOldVersion, ApplicationDsResult dsResult, ApplicationDsDetailResponse dsDetailResponse) {
        String config = dsResult.getConfig();
        if (!isOldVersion) {
            this.dsParseConfig2Resp(dsDetailResponse, dsResult.getParseConfig());
        }
        config = this.getSafeConfigFromSchema(config);
        dsDetailResponse.setConfig(config);
    }

    public Response enableConfig(ApplicationDsEnableRequest enableRequest) {
        ApplicationDsResult dsResult = this.applicationDsDAO.queryByPrimaryKey(enableRequest.getId());
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"0", (String)"\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationDsEnableParam enableParam = new ApplicationDsEnableParam();
        enableParam.setId(enableRequest.getId());
        enableParam.setStatus(enableRequest.getStatus());
        this.applicationDsDAO.enable(enableParam);
        this.syncInfo(dsResult.getApplicationId(), dsResult.getApplicationName());
        return Response.success();
    }

    public Response dsDelete(ApplicationDsDeleteRequest dsDeleteRequest) {
        ApplicationDsResult dsResult = this.applicationDsDAO.queryByPrimaryKey(dsDeleteRequest.getId());
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"0", (String)"\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationDsDeleteParam deleteParam = new ApplicationDsDeleteParam();
        deleteParam.setIdList(Collections.singletonList(dsDeleteRequest.getId()));
        this.applicationDsDAO.delete(deleteParam);
        this.syncInfo(dsResult.getApplicationId(), dsResult.getApplicationName());
        return Response.success();
    }

    public String parseShadowDbUrl(String config) {
        String buUrl = "";
        Configurations configurations = DsManageUtil.getConfigurationsByXml((String)config);
        if (configurations == null) {
            return buUrl;
        }
        DataSource dataSource = ShadowDbServiceImpl.findDatasource((List)configurations.getDataSources(), (String)configurations.getDatasourceMediator().getDataSourceBusiness());
        if (dataSource != null && dataSource.getUrl() != null && (buUrl = dataSource.getUrl()).contains("?")) {
            buUrl = buUrl.substring(0, buUrl.indexOf("?"));
        }
        return buUrl;
    }

    private String parseShadowDbConfigOld(String config) {
        String parsedConfig = "";
        Configurations configurations = DsManageUtil.getConfigurationsByXml((String)config);
        if (configurations == null) {
            return parsedConfig;
        }
        Map verifyResult = this.verifyConfigurations(configurations);
        if (verifyResult.get("result") != null && Boolean.parseBoolean(String.valueOf(verifyResult.get("result")))) {
            parsedConfig = JSON.toJSONString((Object)configurations);
        }
        return parsedConfig;
    }

    private String parseShadowDbConfig(String config) {
        String parsedConfig = "";
        Configurations configurations = DsManageUtil.getConfigurationsByXml((String)config);
        if (configurations == null) {
            return parsedConfig;
        }
        Map verifyResult = this.verifyConfigurations(configurations);
        if (verifyResult.get("result") != null && Boolean.parseBoolean(String.valueOf(verifyResult.get("result")))) {
            parsedConfig = JSON.toJSONString((Object)configurations);
        }
        return parsedConfig;
    }

    private String parseShadowDbCreateConfig(ApplicationDsCreateRequest config) {
        String parsedConfig = "";
        Configurations configurations = null;
        configurations = this.assembleConfigurations(config);
        Map verifyResult = this.verifyConfigurations(configurations);
        parsedConfig = JSON.toJSONString((Object)configurations);
        if (verifyResult.get("result") == null || Boolean.parseBoolean(String.valueOf(verifyResult.get("result")))) {
            // empty if block
        }
        return parsedConfig;
    }

    public Configurations assembleConfigurations(ApplicationDsCreateRequest config) {
        Configurations result = new Configurations();
        result.setDatasourceMediator(new DatasourceMediator("dataSourceBusiness", "dataSourcePerformanceTest"));
        ArrayList<DataSource> dataSourceList = new ArrayList<DataSource>();
        result.setDataSources(dataSourceList);
        DataSource businessDataSource = new DataSource();
        DataSource performanceTestDataSource = new DataSource();
        dataSourceList.add(businessDataSource);
        dataSourceList.add(performanceTestDataSource);
        businessDataSource.setId("dataSourceBusiness");
        businessDataSource.setUrl(config.getUrl());
        businessDataSource.setUsername(config.getUserName());
        performanceTestDataSource.setId("dataSourcePerformanceTest");
        performanceTestDataSource.setUrl(config.getShadowDbUrl());
        performanceTestDataSource.setUsername(config.getShadowDbUserName());
        performanceTestDataSource.setPassword(config.getShadowDbPassword());
        performanceTestDataSource.setMinIdle(config.getShadowDbMinIdle());
        performanceTestDataSource.setMaxActive(config.getShadowDbMaxActive());
        return result;
    }

    private String parseShadowDbUpdateConfig(ApplicationDsUpdateRequest config) {
        String parsedConfig = "";
        Configurations configurations = null;
        configurations = this.assembleUpdateConfigurations(config);
        Map verifyResult = this.verifyConfigurations(configurations);
        if (verifyResult.get("result") == null || !Boolean.parseBoolean(String.valueOf(verifyResult.get("result")))) {
            throw new RuntimeException((String)verifyResult.get("message"));
        }
        parsedConfig = JSON.toJSONString((Object)configurations);
        return parsedConfig;
    }

    public Map<String, Object> verifyConfigurations(Configurations configurations) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (configurations == null) {
            result.put("result", false);
            result.put("message", "configurations is null!");
            return result;
        }
        DatasourceMediator mediator = configurations.getDatasourceMediator();
        List dataSourceList = configurations.getDataSources();
        if (mediator == null) {
            result.put("result", false);
            result.put("message", "datasourceMediator is null!");
            return result;
        }
        if (dataSourceList == null || dataSourceList.isEmpty()) {
            result.put("result", false);
            result.put("message", "dataSourceList is null or empty!");
            return result;
        }
        String datasourceBusinessId = mediator.getDataSourceBusiness();
        String dataSourcePerformanceTestId = mediator.getDataSourcePerformanceTest();
        if (datasourceBusinessId == null || datasourceBusinessId.isEmpty()) {
            result.put("result", false);
            result.put("message", "datasourceBusiness id for datasourceMediator is null or empty!");
            return result;
        }
        if (dataSourcePerformanceTestId == null || dataSourcePerformanceTestId.isEmpty()) {
            result.put("result", false);
            result.put("message", "dataSourcePerformanceTest id for datasourceMediator is null or empty!");
            return result;
        }
        DataSource dataSourceBusiness = ShadowDbServiceImpl.findDatasource((List)dataSourceList, (String)datasourceBusinessId);
        if (dataSourceBusiness == null) {
            result.put("result", false);
            result.put("message", "datasourceBusiness config not found for datasourceMediator, id: " + datasourceBusinessId);
            return result;
        }
        DataSource dataSourcePerformanceTest = ShadowDbServiceImpl.findDatasource((List)dataSourceList, (String)dataSourcePerformanceTestId);
        if (dataSourcePerformanceTest == null) {
            result.put("result", false);
            result.put("message", "dataSourcePerformanceTest config not found for datasourceMediator, id: " + dataSourcePerformanceTestId);
            return result;
        }
        if (dataSourceBusiness.getUrl() == null || dataSourceBusiness.getUrl().isEmpty() || dataSourceBusiness.getUsername() == null || dataSourceBusiness.getUsername().isEmpty()) {
            result.put("result", false);
            result.put("message", "url and username should not be null or empty for dataSourceBusiness config");
            return result;
        }
        if (dataSourcePerformanceTest.getUrl() == null || dataSourcePerformanceTest.getUrl().isEmpty() || dataSourcePerformanceTest.getUsername() == null || dataSourcePerformanceTest.getUsername().isEmpty()) {
            result.put("result", false);
            result.put("message", "url and username should not be null or empty for dataSourcePerformanceTest config");
            return result;
        }
        result.put("result", true);
        result.put("message", "Verify passed");
        return result;
    }

    private static DataSource findDatasource(List<DataSource> dataSourceList, String id) {
        for (DataSource dataSource : dataSourceList) {
            if (!id.equals(dataSource.getId())) continue;
            return dataSource;
        }
        return null;
    }

    public Configurations assembleUpdateConfigurations(ApplicationDsUpdateRequest config) {
        Configurations result = new Configurations();
        result.setDatasourceMediator(new DatasourceMediator("dataSourceBusiness", "dataSourcePerformanceTest"));
        ArrayList<DataSource> dataSourceList = new ArrayList<DataSource>();
        result.setDataSources(dataSourceList);
        DataSource businessDataSource = new DataSource();
        DataSource performanceTestDataSource = new DataSource();
        dataSourceList.add(businessDataSource);
        dataSourceList.add(performanceTestDataSource);
        businessDataSource.setId("dataSourceBusiness");
        businessDataSource.setUrl(config.getUrl());
        businessDataSource.setUsername(config.getUserName());
        performanceTestDataSource.setId("dataSourcePerformanceTest");
        performanceTestDataSource.setUrl(config.getShadowDbUrl());
        performanceTestDataSource.setUsername(config.getShadowDbUserName());
        performanceTestDataSource.setPassword(config.getShadowDbPassword());
        performanceTestDataSource.setMinIdle(config.getShadowDbMinIdle());
        performanceTestDataSource.setMaxActive(config.getShadowDbMaxActive());
        return result;
    }

    private String getOriginConfigFromSchema(String xml, String originXml) {
        String safePasswordElement;
        if (StringUtils.isBlank((CharSequence)xml) || !xml.contains(safePasswordElement = DsManageUtil.getSafePasswordElementAboutXml())) {
            return xml;
        }
        Configurations configurations = DsManageUtil.getConfigurationsByXml((String)originXml);
        if (configurations == null) {
            return xml;
        }
        String password = ((DataSource)configurations.getDataSources().get(1)).getPassword();
        String originPasswordElement = DsManageUtil.getOriginPasswordElementAboutXml((String)password);
        return xml.replace(safePasswordElement, originPasswordElement);
    }

    public void dsParseConfig2Resp(ApplicationDsDetailResponse ds, String source) {
        Configurations config = (Configurations)JsonUtil.json2bean((String)source, Configurations.class);
        if (config == null) {
            return;
        }
        DataSource dataSource = (DataSource)config.getDataSources().get(1);
        DataSource business = (DataSource)config.getDataSources().get(0);
        ds.setShadowDbUrl(dataSource.getUrl());
        ds.setUserName(business.getUsername());
        ds.setShadowDbUserName(dataSource.getUsername());
        ds.setShadowDbPassword("********");
        ds.setShadowDbMinIdle(dataSource.getMinIdle());
        ds.setShadowDbMaxActive(dataSource.getMaxActive());
    }

    private String getSafeConfigFromSchema(String xml) {
        if (StringUtils.isBlank((CharSequence)xml)) {
            return "";
        }
        Configurations configurations = DsManageUtil.getConfigurationsByXml((String)xml);
        if (configurations == null) {
            return "";
        }
        DataSource dataSource = (DataSource)configurations.getDataSources().get(1);
        String password = dataSource.getPassword();
        String originPasswordElement = DsManageUtil.getOriginPasswordElementAboutXml((String)password);
        String newPasswordElement = DsManageUtil.getSafePasswordElementAboutXml();
        return xml.replace(originPasswordElement, newPasswordElement);
    }
}

