/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.dsManage.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.pamirs.tro.common.enums.ds.DbTypeEnum;
import com.pamirs.tro.common.enums.ds.DsTypeEnum;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.dao.simplify.TAppBusinessTableInfoMapper;
import com.pamirs.tro.entity.dao.user.TUserMapper;
import com.pamirs.tro.entity.domain.entity.DsModelWithBLOBs;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import com.pamirs.tro.entity.domain.entity.simplify.AppBusinessTableInfo;
import com.pamirs.tro.entity.domain.entity.user.User;
import com.pamirs.tro.entity.domain.query.agent.AppBusinessTableQuery;
import com.pamirs.tro.entity.domain.vo.dsmanage.Configurations;
import com.pamirs.tro.entity.domain.vo.dsmanage.DsAgentVO;
import com.pamirs.tro.entity.domain.vo.dsmanage.DsServerVO;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.request.application.ApplicationDsCreateRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsDeleteRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsEnableRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsUpdateRequest;
import io.shulie.tro.web.app.response.application.ApplicationDsDetailResponse;
import io.shulie.tro.web.app.response.application.ApplicationDsResponse;
import io.shulie.tro.web.app.response.application.DbTypeResponse;
import io.shulie.tro.web.app.response.application.DsTypeResponse;
import io.shulie.tro.web.app.response.application.ShadowServerConfigurationResponse;
import io.shulie.tro.web.app.service.dsManage.AbstractDsService;
import io.shulie.tro.web.app.service.dsManage.DsService;
import io.shulie.tro.web.app.service.dsManage.impl.ShadowDbServiceImpl;
import io.shulie.tro.web.app.service.dsManage.impl.ShadowEsServiceImpl;
import io.shulie.tro.web.app.service.dsManage.impl.ShadowHbaseServiceImpl;
import io.shulie.tro.web.app.service.dsManage.impl.ShadowKafkaServiceImpl;
import io.shulie.tro.web.app.service.dsManage.impl.ShadowRedisServerServiceImpl;
import io.shulie.tro.web.app.service.dsManage.impl.ShadowTableServiceImpl;
import io.shulie.tro.web.data.dao.application.ApplicationDsDAO;
import io.shulie.tro.web.data.param.application.ApplicationDsQueryParam;
import io.shulie.tro.web.data.param.application.ApplicationDsUpdateParam;
import io.shulie.tro.web.data.result.application.ApplicationDsResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DsServiceImpl
implements DsService {
    private static final Logger log = LoggerFactory.getLogger(DsServiceImpl.class);
    @Resource
    private TApplicationMntDao applicationMntDao;
    @Resource
    private TAppBusinessTableInfoMapper TAppBusinessTableInfoMapper;
    @Resource
    private TUserMapper TUserMapper;
    @Autowired
    private ApplicationDsDAO applicationDsDAO;
    private Map<DsTypeEnum, AbstractDsService> map;
    @Autowired
    private ShadowDbServiceImpl shadowDbService;
    @Autowired
    private ShadowTableServiceImpl shadowTableService;
    @Autowired
    private ShadowRedisServerServiceImpl shadowRedisServerService;
    @Autowired
    private ShadowEsServiceImpl shadowEsService;
    @Autowired
    private ShadowHbaseServiceImpl shadowHbaseService;
    @Autowired
    private ShadowKafkaServiceImpl shadowKafkaService;
    @Resource
    private TUserMapper tUserMapper;

    @PostConstruct
    public void init() {
        this.map = new HashMap(6);
        this.map.put(DsTypeEnum.SHADOW_DB, this.shadowDbService);
        this.map.put(DsTypeEnum.SHADOW_TABLE, this.shadowTableService);
        this.map.put(DsTypeEnum.SHADOW_REDIS_SERVER, this.shadowRedisServerService);
        this.map.put(DsTypeEnum.SHADOW_ES_SERVER, this.shadowEsService);
        this.map.put(DsTypeEnum.SHADOW_HBASE_SERVER, this.shadowHbaseService);
        this.map.put(DsTypeEnum.SHADOW_KAFKA_CLUSTER, this.shadowKafkaService);
    }

    public Response dsUpdate(ApplicationDsUpdateRequest updateRequest) {
        if (updateRequest == null) {
            return Response.fail((String)"updateRequest obj is null", (Object[])new Object[0]);
        }
        AbstractDsService dsService = this.getAbstractDsService(Integer.valueOf(updateRequest.getDsType()));
        if (dsService == null) {
            return Response.fail((String)"dsService obj is null", (Object[])new Object[0]);
        }
        return dsService.dsUpdate(updateRequest);
    }

    public Response dsQuery(Long applicationId) {
        if (null == applicationId) {
            return Response.fail((String)"0", (String)"\u53c2\u6570\u7f3a\u5931", (Object[])new Object[0]);
        }
        ApplicationDsQueryParam queryParam = new ApplicationDsQueryParam();
        queryParam.setApplicationId(applicationId);
        queryParam.setIsDeleted(Integer.valueOf(0));
        queryParam.setUserIdList(RestContext.getQueryAllowUserIdList());
        List dsResultList = this.applicationDsDAO.queryList(queryParam);
        List<Object> dsResponseList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dsResultList)) {
            dsResponseList = dsResultList.stream().map(dsResult -> {
                ApplicationDsResponse dsResponse = new ApplicationDsResponse();
                dsResponse.setId(dsResult.getId());
                dsResponse.setApplicationId(dsResult.getApplicationId());
                DbTypeResponse dbTypeResponse = new DbTypeResponse();
                dbTypeResponse.setLabel(DbTypeEnum.getDescByCode((Integer)dsResult.getDbType()));
                dbTypeResponse.setValue(dsResult.getDbType());
                dsResponse.setDbType(dbTypeResponse);
                DsTypeResponse dsTypeResponse = new DsTypeResponse();
                dsTypeResponse.setLabel(DsTypeEnum.getDescByCode((Integer)dsResult.getDsType()));
                dsTypeResponse.setValue(dsResult.getDsType());
                dsResponse.setDsType(dsTypeResponse);
                dsResponse.setUrl(dsResult.getUrl());
                dsResponse.setStatus(dsResult.getStatus());
                dsResponse.setUpdateTime(dsResult.getUpdateTime());
                dsResponse.setPermissionUserId(dsResult.getUserId());
                return dsResponse;
            }).collect(Collectors.toList());
        }
        return Response.success((Object)dsResponseList);
    }

    public Response<ApplicationDsDetailResponse> dsQueryDetail(Long dsId, boolean isOldVersion) {
        ApplicationDsResult dsResult = this.applicationDsDAO.queryByPrimaryKey(dsId);
        if (dsResult == null) {
            return Response.fail((String)"dataSource obj is null", (Object[])new Object[0]);
        }
        AbstractDsService dsService = this.getAbstractDsService(dsResult.getDsType());
        if (dsService == null) {
            return Response.fail((String)"dsService obj is null", (Object[])new Object[0]);
        }
        return dsService.dsQueryDetail(dsId, isOldVersion);
    }

    public Response enableConfig(ApplicationDsEnableRequest enableRequest) {
        ApplicationDsResult dsResult = this.applicationDsDAO.queryByPrimaryKey(enableRequest.getId());
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"0", (String)"\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        AbstractDsService dsService = this.getAbstractDsService(dsResult.getDsType());
        if (dsService == null) {
            return Response.fail((String)"dsService obj is null", (Object[])new Object[0]);
        }
        return dsService.enableConfig(enableRequest);
    }

    private AbstractDsService getAbstractDsService(Integer code) {
        DsTypeEnum dsTypeEnum = DsTypeEnum.getEnumByCode((Integer)code);
        return (AbstractDsService)this.map.get(dsTypeEnum);
    }

    public List<DsAgentVO> getConfigs(String appName) {
        List dsModels;
        TApplicationMnt applicationMnt;
        ArrayList<DsAgentVO> dsAgentVOList = new ArrayList<DsAgentVO>();
        User user = RestContext.getUser();
        if (user == null) {
            String userAppKey = RestContext.getTenantUserKey();
            user = this.TUserMapper.selectByKey(userAppKey);
        }
        if ((applicationMnt = this.applicationMntDao.queryApplicationInfoByNameAndTenant(appName, user == null ? null : user.getId())) != null && CollectionUtils.isNotEmpty((Collection)(dsModels = this.applicationDsDAO.selectByAppIdForAgent(Long.valueOf(applicationMnt.getApplicationId()))))) {
            dsModels = dsModels.stream().filter(dsModel -> dsModel.getDsType().equals(new Byte(String.valueOf(DsTypeEnum.SHADOW_DB.getCode()))) || dsModel.getDsType().equals(new Byte(String.valueOf(DsTypeEnum.SHADOW_TABLE.getCode())))).collect(Collectors.toList());
            for (DsModelWithBLOBs dsModel2 : dsModels) {
                DsAgentVO vo = new DsAgentVO();
                vo.setApplicationName(dsModel2.getApplicationName());
                vo.setDsType(dsModel2.getDsType());
                vo.setStatus(dsModel2.getStatus());
                vo.setUrl(dsModel2.getUrl());
                if (dsModel2.getDsType() == 0) {
                    if (dsModel2.getParseConfig() != null && !dsModel2.getParseConfig().isEmpty()) {
                        vo.setShadowDbConfig((Configurations)JSON.parseObject((String)dsModel2.getParseConfig(), Configurations.class));
                    }
                } else if (dsModel2.getDsType() == 1) {
                    vo.setShadowTableConfig(dsModel2.getConfig());
                }
                dsAgentVOList.add(vo);
            }
        }
        return dsAgentVOList;
    }

    public List<ShadowServerConfigurationResponse> getShadowServerConfigs(String appName) {
        return this.shadowRedisServerService.getShadowServerConfigs(appName);
    }

    public List<DsServerVO> getShadowDsServerConfigs(String namespace, DsTypeEnum dsServer) {
        ArrayList<DsServerVO> responseList = new ArrayList<DsServerVO>();
        String userAppKey = RestContext.getTenantUserKey();
        User user = this.tUserMapper.selectByKey(userAppKey);
        TApplicationMnt applicationMnt = this.applicationMntDao.queryApplicationInfoByNameAndTenant(namespace, user == null ? null : user.getId());
        if (applicationMnt != null) {
            List dsModels = this.applicationDsDAO.selectByAppIdForAgent(Long.valueOf(applicationMnt.getApplicationId()));
            if (CollectionUtils.isNotEmpty((Collection)dsModels)) {
                dsModels = dsModels.stream().filter(dsModel -> dsModel.getDsType().equals(new Byte(String.valueOf(dsServer.getCode())))).collect(Collectors.toList());
            }
            for (DsModelWithBLOBs dsModel2 : dsModels) {
                DsServerVO serverVO = new DsServerVO();
                BeanUtils.copyProperties((Object)dsModel2, (Object)serverVO);
                serverVO.setStatus(Integer.valueOf(0));
                responseList.add(serverVO);
            }
        }
        return responseList;
    }

    public void addBusiness(AppBusinessTableInfo info) {
        AppBusinessTableInfo query = new AppBusinessTableInfo();
        query.setUrl(info.getUrl());
        query.setUserId(info.getUserId());
        Long count = this.TAppBusinessTableInfoMapper.selectCountByUserIdAndUrl(query);
        if (count == 1L) {
            AppBusinessTableInfo updateInfo = this.TAppBusinessTableInfoMapper.selectByUserIdAndUrl(query);
            if (null != updateInfo) {
                info.setId(updateInfo.getId());
                this.TAppBusinessTableInfoMapper.update(info);
            }
        } else if (count < 1L) {
            this.TAppBusinessTableInfoMapper.insert(info);
        } else {
            throw new IllegalArgumentException(String.format("count:%s, url : %s Url\u5927\u4e8e 1", count, info.getUrl()));
        }
    }

    public Response queryPageBusiness(AppBusinessTableQuery query) {
        User user = RestContext.getUser();
        if (1 == user.getRole()) {
            query.setUserId(user.getId());
        }
        PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        List list = this.TAppBusinessTableInfoMapper.selectList(query);
        PageInfo page = new PageInfo(list);
        page.getList().stream().forEach(info -> {
            int index = info.getUrl().indexOf("?");
            if (-1 != index) {
                String substring = info.getUrl().substring(0, index);
                info.setUrl(substring);
            }
        });
        return Response.success((List)page.getList(), (long)page.getTotal());
    }

    public List<DsModelWithBLOBs> getAllEnabledDbConfig(Long applicationId) {
        return this.applicationDsDAO.getAllEnabledDbConfig(applicationId);
    }

    public Response secureInit() {
        ApplicationDsQueryParam param = new ApplicationDsQueryParam();
        List applicationDsResults = this.applicationDsDAO.queryList(param);
        applicationDsResults.stream().forEach(applicationDsResult -> {
            ApplicationDsUpdateParam update = new ApplicationDsUpdateParam();
            BeanUtils.copyProperties((Object)applicationDsResult, (Object)update);
            this.applicationDsDAO.update(update);
        });
        return Response.success();
    }

    public String parseShadowDbUrl(String config) {
        return this.shadowDbService.parseShadowDbUrl(config);
    }

    public Response dsAdd(ApplicationDsCreateRequest createRequest) {
        if (Objects.isNull(createRequest)) {
            return Response.fail((String)"0", (String)"\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        AbstractDsService dsService = this.getAbstractDsService(createRequest.getDsType());
        if (dsService == null) {
            return Response.fail((String)"dsService obj is null", (Object[])new Object[0]);
        }
        return dsService.dsAdd(createRequest);
    }

    public Response dsDelete(ApplicationDsDeleteRequest dsDeleteRequest) {
        ApplicationDsResult dsResult = this.applicationDsDAO.queryByPrimaryKey(dsDeleteRequest.getId());
        if (Objects.isNull(dsResult)) {
            return Response.fail((String)"0", (String)"\u8be5\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        AbstractDsService dsService = this.getAbstractDsService(dsResult.getDsType());
        if (dsService == null) {
            return Response.fail((String)"dsService obj is null", (Object[])new Object[0]);
        }
        return dsService.dsDelete(dsDeleteRequest);
    }
}

