/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.config.impl;

import com.pamirs.tro.entity.domain.entity.TBaseConfig;
import com.pamirs.tro.entity.domain.entity.user.User;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.constant.SwitchKeyFactory;
import io.shulie.tro.web.app.init.sync.ConfigSyncService;
import io.shulie.tro.web.app.service.BaseConfigService;
import io.shulie.tro.web.app.service.config.ConfigService;
import io.shulie.tro.web.config.sync.api.SwitchSyncService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class ConfigServiceImpl
implements ConfigService {
    private static final Logger log = LoggerFactory.getLogger(ConfigServiceImpl.class);
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private SwitchSyncService switchSyncService;
    @Autowired
    private BaseConfigService baseConfigService;
    @Autowired
    private ConfigSyncService configSyncService;

    public void updateClusterTestSwitch(String userAppKey, Boolean value) {
        if (value == null) {
            return;
        }
        this.redisTemplate.opsForValue().set((Object)SwitchKeyFactory.getClusterTestSwitchRedisKey((String)userAppKey), (Object)value);
        User user = RestContext.getUser();
        this.configSyncService.syncClusterTestSwitch(user.getKey());
    }

    public boolean getClusterTestSwitch(String userAppKey) {
        Object o = this.redisTemplate.opsForValue().get((Object)SwitchKeyFactory.getClusterTestSwitchRedisKey((String)userAppKey));
        if (!(o instanceof Boolean)) {
            return true;
        }
        return (Boolean)o;
    }

    public void updateAllowListSwitch(String userAppKey, Boolean value) {
        if (value == null) {
            return;
        }
        try {
            this.baseConfigService.checkExistAndInsert("WHITE_LIST_SWITCH");
            TBaseConfig config = new TBaseConfig();
            config.setConfigCode("WHITE_LIST_SWITCH");
            config.setConfigValue(value != false ? "1" : "0");
            this.baseConfigService.updateBaseConfig(config);
        }
        catch (Exception e) {
            log.error("\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        User user = RestContext.getUser();
        this.redisTemplate.opsForValue().set((Object)SwitchKeyFactory.getAllowListSwitchRedisKey((String)userAppKey), (Object)value);
        this.configSyncService.syncAllowListSwitch(user.getKey());
    }

    public boolean getAllowListSwitch(String userAppKey) {
        Object o;
        TBaseConfig tBaseConfig = this.baseConfigService.queryByConfigCode("WHITE_LIST_SWITCH");
        boolean dbResult = false;
        if (tBaseConfig != null) {
            dbResult = "1".equals(tBaseConfig.getConfigValue());
        }
        if (!((o = this.redisTemplate.opsForValue().get((Object)SwitchKeyFactory.getAllowListSwitchRedisKey((String)userAppKey))) instanceof Boolean)) {
            return dbResult;
        }
        return (Boolean)o & dbResult;
    }
}

