/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.blacklist;

import com.google.common.collect.Lists;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.dao.user.TUserMapper;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import com.pamirs.tro.entity.domain.entity.user.User;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.init.sync.ConfigSyncService;
import io.shulie.tro.web.app.input.blacklist.BlacklistCreateInput;
import io.shulie.tro.web.app.input.blacklist.BlacklistSearchInput;
import io.shulie.tro.web.app.input.blacklist.BlacklistUpdateInput;
import io.shulie.tro.web.app.output.blacklist.BlacklistOutput;
import io.shulie.tro.web.app.service.blacklist.BlacklistService;
import io.shulie.tro.web.app.service.linkManage.impl.WhiteListFileService;
import io.shulie.tro.web.common.enums.blacklist.BlacklistTypeEnum;
import io.shulie.tro.web.common.vo.blacklist.BlacklistVO;
import io.shulie.tro.web.data.dao.blacklist.BlackListDAO;
import io.shulie.tro.web.data.param.blacklist.BlacklistCreateNewParam;
import io.shulie.tro.web.data.param.blacklist.BlacklistSearchParam;
import io.shulie.tro.web.data.param.blacklist.BlacklistUpdateParam;
import io.shulie.tro.web.data.result.blacklist.BlacklistResult;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlacklistServiceImpl
implements BlacklistService {
    @Autowired
    private BlackListDAO blackListDAO;
    @Autowired
    private ConfigSyncService configSyncService;
    @Resource
    private TUserMapper TUserMapper;
    @Autowired
    private WhiteListFileService whiteListFileService;
    @Resource
    private TApplicationMntDao applicationMntDao;

    public void insert(BlacklistCreateInput input) {
        BlacklistSearchParam searchParam = new BlacklistSearchParam();
        searchParam.setApplicationId(input.getApplicationId());
        searchParam.setRedisKey(input.getRedisKey());
        List results = this.blackListDAO.selectList(searchParam);
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.BLACKLIST_ADD_ERROR, (Object)"\u4e0d\u5141\u8bb8\u91cd\u590d\u9ed1\u540d\u5355");
        }
        BlacklistCreateNewParam param = new BlacklistCreateNewParam();
        BeanUtils.copyProperties((Object)input, (Object)param);
        User user = RestContext.getUser();
        if (user != null) {
            param.setCustomerId(RestContext.getCustomerId());
            param.setUserId(user.getId());
        }
        param.setType(BlacklistTypeEnum.REDIS.getType());
        param.setUseYn(Integer.valueOf(1));
        this.blackListDAO.newInsert(param);
        this.updateAgentData(input.getApplicationId());
    }

    public void update(BlacklistUpdateInput input) {
        BlacklistResult result = this.blackListDAO.selectById(input.getBlistId());
        if (result == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.BLACKLIST_UPDATE_ERROR, (Object)"\u672a\u67e5\u5230\u8be5id");
        }
        BlacklistSearchParam searchParam = new BlacklistSearchParam();
        searchParam.setApplicationId(result.getApplicationId());
        searchParam.setRedisKey(input.getRedisKey());
        List results = this.blackListDAO.selectList(searchParam);
        if (!result.getRedisKey().equals(input.getRedisKey()) && CollectionUtils.isNotEmpty((Collection)results)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.BLACKLIST_UPDATE_ERROR, (Object)"\u4e0d\u5141\u8bb8\u91cd\u590d\u9ed1\u540d\u5355");
        }
        BlacklistUpdateParam param = new BlacklistUpdateParam();
        BeanUtils.copyProperties((Object)input, (Object)param);
        this.blackListDAO.update(param);
        this.updateAgentData(result.getApplicationId());
    }

    public void enable(BlacklistUpdateInput input) {
        BlacklistResult result = this.blackListDAO.selectById(input.getBlistId());
        if (result == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.BLACKLIST_UPDATE_ERROR, (Object)"\u672a\u67e5\u5230\u8be5id");
        }
        BlacklistUpdateParam param = new BlacklistUpdateParam();
        BeanUtils.copyProperties((Object)input, (Object)param);
        this.blackListDAO.update(param);
        this.updateAgentData(result.getApplicationId());
    }

    private void updateAgentData(Long applicationId) {
        TApplicationMnt tApplicationMnt = this.applicationMntDao.queryApplicationinfoById(applicationId.longValue());
        User appUser = this.TUserMapper.selectById(tApplicationMnt.getUserId());
        this.whiteListFileService.writeWhiteListFile();
        this.configSyncService.syncAllowList(appUser.getKey(), applicationId.longValue(), tApplicationMnt.getApplicationName());
    }

    public void batchEnable(List<Long> ids, Integer useYn) {
        List results = this.blackListDAO.selectByIds(ids);
        if (CollectionUtils.isEmpty((Collection)results)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.BLACKLIST_DELETE_ERROR, (Object)"\u6279\u91cf\u66f4\u65b0\u5931\u8d25");
        }
        OperationLogContextHolder.addVars((String)"blacklistValue", (String)results.stream().map(BlacklistResult::getRedisKey).collect(Collectors.joining(",")));
        ids.forEach(id -> {
            BlacklistUpdateParam param = new BlacklistUpdateParam();
            param.setBlistId(id);
            param.setUseYn(useYn);
            this.blackListDAO.update(param);
        });
        this.updateAgentData(((BlacklistResult)results.get(0)).getApplicationId());
    }

    public void delete(Long id) {
        BlacklistResult result = this.blackListDAO.selectById(id);
        if (result == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.BLACKLIST_DELETE_ERROR, (Object)"\u672a\u67e5\u5230\u8be5id");
        }
        OperationLogContextHolder.addVars((String)"blacklistValue", (String)result.getRedisKey());
        OperationLogContextHolder.addVars((String)"blacklistType", (String)BlacklistTypeEnum.getDescByType((Integer)result.getType()));
        this.blackListDAO.delete(id);
        this.updateAgentData(result.getApplicationId());
    }

    public void batchDelete(List<Long> ids) {
        List results = this.blackListDAO.selectByIds(ids);
        if (CollectionUtils.isEmpty((Collection)results)) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.BLACKLIST_DELETE_ERROR, (Object)"\u6279\u91cf\u5220\u9664\u5931\u8d25");
        }
        OperationLogContextHolder.addVars((String)"blacklistValue", (String)results.stream().map(BlacklistResult::getRedisKey).collect(Collectors.joining(",")));
        this.blackListDAO.batchDelete(ids);
        this.updateAgentData(((BlacklistResult)results.get(0)).getApplicationId());
    }

    public PagingList<BlacklistVO> pageList(BlacklistSearchInput input) {
        PagingList pagingList;
        BlacklistSearchParam param = new BlacklistSearchParam();
        BeanUtils.copyProperties((Object)input, (Object)param);
        User user = RestContext.getUser();
        if (user != null) {
            param.setCustomerId(RestContext.getCustomerId());
            param.setUserId(user.getId());
        }
        if ((pagingList = this.blackListDAO.pageList(param)).isEmpty()) {
            return PagingList.empty();
        }
        for (BlacklistVO vo : pagingList.getList()) {
            List allowEnableDisableUserIdList;
            List allowUpdateUserIdList = RestContext.getUpdateAllowUserIdList();
            if (CollectionUtils.isEmpty((Collection)allowUpdateUserIdList)) {
                vo.setCanEdit(Boolean.valueOf(true));
            } else {
                vo.setCanEdit(Boolean.valueOf(allowUpdateUserIdList.contains(vo.getUserId())));
            }
            List allowDeleteUserIdList = RestContext.getDeleteAllowUserIdList();
            if (CollectionUtils.isEmpty((Collection)allowDeleteUserIdList)) {
                vo.setCanRemove(Boolean.valueOf(true));
            } else {
                vo.setCanRemove(Boolean.valueOf(allowDeleteUserIdList.contains(vo.getUserId())));
            }
            if (!CollectionUtils.isNotEmpty((Collection)(allowEnableDisableUserIdList = RestContext.getEnableDisableAllowUserIdList()))) continue;
            vo.setCanEnableDisable(Boolean.valueOf(allowEnableDisableUserIdList.contains(vo.getUserId())));
        }
        return pagingList;
    }

    public List<BlacklistOutput> selectList(BlacklistSearchInput input) {
        List results;
        BlacklistSearchParam param = new BlacklistSearchParam();
        BeanUtils.copyProperties((Object)input, (Object)param);
        User user = RestContext.getUser();
        if (user != null) {
            param.setCustomerId(RestContext.getCustomerId());
            param.setUserId(user.getId());
        }
        if (CollectionUtils.isEmpty((Collection)(results = this.blackListDAO.selectList(param)))) {
            return Lists.newArrayList();
        }
        return results.stream().map(result -> {
            BlacklistOutput output = new BlacklistOutput();
            BeanUtils.copyProperties((Object)result, (Object)output);
            return output;
        }).collect(Collectors.toList());
    }

    public BlacklistOutput selectById(Long id) {
        BlacklistResult result = this.blackListDAO.selectById(id);
        if (result == null) {
            return null;
        }
        BlacklistOutput output = new BlacklistOutput();
        BeanUtils.copyProperties((Object)result, (Object)output);
        return output;
    }
}

