/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.auth.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pamirs.tro.entity.domain.entity.auth.Dept;
import com.pamirs.tro.entity.domain.entity.auth.TreeConvertUtil;
import com.pamirs.tro.entity.domain.entity.auth.TreeDeptModel;
import com.pamirs.tro.entity.domain.entity.user.DeptUser;
import com.pamirs.tro.entity.domain.entity.user.DeptUserQueryParam;
import com.pamirs.tro.entity.domain.entity.user.User;
import com.pamirs.tro.entity.domain.vo.user.UserLoginParam;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.convert.user.UserConverter;
import io.shulie.tro.web.app.input.user.UserQueryInput;
import io.shulie.tro.web.app.output.user.UserQueryOutput;
import io.shulie.tro.web.app.request.user.ResourceActionDeleteRequest;
import io.shulie.tro.web.app.request.user.ResourceActionQueryRequest;
import io.shulie.tro.web.app.request.user.ResourceActionUpdateRequest;
import io.shulie.tro.web.app.request.user.ResourceScopeQueryRequest;
import io.shulie.tro.web.app.request.user.ResourceScopeUpdateRequest;
import io.shulie.tro.web.app.response.user.ResourceActionResponse;
import io.shulie.tro.web.app.response.user.ResourceScopeResponse;
import io.shulie.tro.web.app.response.user.SingleActionResponse;
import io.shulie.tro.web.app.response.user.SingleScopeResponse;
import io.shulie.tro.web.app.service.auth.TroAuthService;
import io.shulie.tro.web.app.utils.MapOrderByUtils;
import io.shulie.tro.web.app.utils.ServletUtils;
import io.shulie.tro.web.auth.api.AuthService;
import io.shulie.tro.web.auth.api.DeptService;
import io.shulie.tro.web.auth.api.ResourceService;
import io.shulie.tro.web.auth.api.UserService;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.shulie.tro.web.auth.api.enums.DataTypeEnum;
import io.shulie.tro.web.auth.api.exception.TroLoginException;
import io.shulie.tro.web.common.constant.TroClientAuthConstant;
import io.shulie.tro.web.data.param.user.ResourceMenuQueryParam;
import io.shulie.tro.web.data.param.user.RoleResourceAuthDeleteParam;
import io.shulie.tro.web.data.param.user.RoleResourceAuthQueryParam;
import io.shulie.tro.web.data.param.user.RoleResourceAuthUpdateParam;
import io.shulie.tro.web.data.param.user.UserDeptConditionQueryParam;
import io.shulie.tro.web.data.param.user.UserDeptQueryParam;
import io.shulie.tro.web.data.param.user.UserQueryParam;
import io.shulie.tro.web.data.param.user.UserRoleRelationBatchQueryParam;
import io.shulie.tro.web.data.result.user.ResourceAuthResult;
import io.shulie.tro.web.data.result.user.ResourceMenuResult;
import io.shulie.tro.web.data.result.user.UserDeptConditionResult;
import io.shulie.tro.web.data.result.user.UserDeptResult;
import io.shulie.tro.web.data.result.user.UserRoleRelationResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TroAuthServiceImpl
implements TroAuthService {
    private static final Logger log = LoggerFactory.getLogger(TroAuthServiceImpl.class);
    public static List<Dept> deptTotalList = Lists.newArrayList();
    @Autowired
    private DeptService deptService;
    @Autowired
    private UserService userService;
    @Autowired
    private AuthService authService;
    @Autowired
    private ResourceService resourceService;

    @PostConstruct
    public void init() {
        deptTotalList = this.deptService.getAllDepts("");
    }

    public PagingList<UserQueryOutput> selectUserByCondition(UserQueryInput input) {
        UserQueryParam param = new UserQueryParam();
        BeanUtils.copyProperties((Object)input, (Object)param);
        param.setCustomerId(RestContext.getCustomerId());
        PagingList pagingList = this.userService.selectUserByCondition(param);
        return UserConverter.INSTANCE.toOutputPagingList(pagingList);
    }

    public List<TreeDeptModel> getDeptTree(String deptName) {
        return this.deptService.getDeptTree(deptName);
    }

    public PageInfo<DeptUser> getDeptUser(DeptUserQueryParam param) {
        return this.userService.getSimpleUserList(param);
    }

    public List<ResourceActionResponse> getResourceAction(ResourceActionQueryRequest queryRequest) {
        List resourceMenuResultList = this.authService.selectAuthConfigMenu();
        RoleResourceAuthQueryParam roleResourceAuthQueryParam = new RoleResourceAuthQueryParam();
        roleResourceAuthQueryParam.setRoleIdList(Arrays.asList(queryRequest.getRoleId()));
        List authResultList = this.authService.selectList(roleResourceAuthQueryParam);
        if (CollectionUtils.isEmpty((Collection)authResultList)) {
            ArrayList resourceActionResponseList = Lists.newArrayList();
            resourceMenuResultList.sort(Comparator.comparingInt(ResourceMenuResult::getSequence));
            resourceMenuResultList.forEach(menuResult -> {
                ResourceActionResponse actionResponse = new ResourceActionResponse();
                actionResponse.setId(menuResult.getId());
                actionResponse.setKey(menuResult.getCode());
                actionResponse.setTitle(menuResult.getName());
                actionResponse.setChecked(Boolean.FALSE);
                ArrayList groupList = Lists.newArrayList();
                List actionList = menuResult.getActionList();
                if (CollectionUtils.isNotEmpty((Collection)actionList)) {
                    actionList.forEach(action -> {
                        SingleActionResponse singleActionResponse = new SingleActionResponse();
                        singleActionResponse.setValue(String.valueOf(action));
                        singleActionResponse.setLabel(ActionTypeEnum.getCnameByCode((Integer)action));
                        singleActionResponse.setChecked(Boolean.FALSE);
                        groupList.add(singleActionResponse);
                    });
                }
                actionResponse.setGroupList((List)groupList);
                resourceActionResponseList.add(actionResponse);
            });
            return resourceActionResponseList;
        }
        ArrayList resourceActionResponseList = Lists.newArrayList();
        resourceMenuResultList.sort(Comparator.comparingInt(ResourceMenuResult::getSequence));
        resourceMenuResultList.forEach(menuResult -> {
            ResourceActionResponse actionResponse = new ResourceActionResponse();
            actionResponse.setId(menuResult.getId());
            actionResponse.setKey(menuResult.getCode());
            actionResponse.setTitle(menuResult.getName());
            Optional<ResourceAuthResult> optional = authResultList.stream().filter(authResult -> authResult.getResoureId().equals(menuResult.getId())).findFirst();
            if (optional.isPresent()) {
                ResourceAuthResult authResult2 = optional.get();
                actionResponse.setChecked(authResult2.getStatus());
                List authedActionList = authResult2.getActionList();
                List allActionList = menuResult.getActionList();
                ArrayList groupList = Lists.newArrayList();
                allActionList.forEach(action -> {
                    SingleActionResponse singleActionResponse = new SingleActionResponse();
                    singleActionResponse.setValue(String.valueOf(action));
                    singleActionResponse.setLabel(ActionTypeEnum.getCnameByCode((Integer)action));
                    if (authedActionList.contains(action)) {
                        singleActionResponse.setChecked(Boolean.TRUE);
                    } else {
                        singleActionResponse.setChecked(Boolean.FALSE);
                    }
                    groupList.add(singleActionResponse);
                });
                actionResponse.setGroupList((List)groupList);
                resourceActionResponseList.add(actionResponse);
            } else {
                actionResponse.setChecked(Boolean.FALSE);
                ArrayList groupList = Lists.newArrayList();
                List actionList = menuResult.getActionList();
                if (CollectionUtils.isNotEmpty((Collection)actionList)) {
                    actionList.forEach(action -> {
                        SingleActionResponse singleActionResponse = new SingleActionResponse();
                        singleActionResponse.setValue(String.valueOf(action));
                        singleActionResponse.setLabel(ActionTypeEnum.getCnameByCode((Integer)action));
                        singleActionResponse.setChecked(Boolean.FALSE);
                        groupList.add(singleActionResponse);
                    });
                }
                actionResponse.setGroupList((List)groupList);
                resourceActionResponseList.add(actionResponse);
            }
        });
        for (ResourceActionResponse resourceActionResponse : resourceActionResponseList) {
            if (!resourceActionResponse.getKey().equals("configCenter_pressureMeasureSwitch") && !resourceActionResponse.getKey().equals("configCenter_whitelistSwitch")) continue;
            for (SingleActionResponse singleActionResponse : resourceActionResponse.getGroupList()) {
                if (!ActionTypeEnum.ENABLE_DISABLE.getCode().equals(Integer.parseInt(singleActionResponse.getValue()))) continue;
                singleActionResponse.setLabel("\u5f00\u542f\u5173\u95ed");
            }
        }
        return resourceActionResponseList;
    }

    public Response updateResourceAction(ResourceActionUpdateRequest updateRequest) {
        Long roleId = updateRequest.getRoleId();
        List<ResourceActionResponse> resourceActionResponseList = updateRequest.getFuncPermissionList();
        if (CollectionUtils.isNotEmpty((Collection)resourceActionResponseList)) {
            List<ResourceActionResponse> deleteActionResponseList;
            List disableActionResponseList;
            ArrayList updateActionResponseList = Lists.newArrayList();
            List checkedActionResponseList = resourceActionResponseList.stream().filter(ResourceActionResponse::getChecked).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(checkedActionResponseList)) {
                updateActionResponseList.addAll(checkedActionResponseList);
            }
            if (CollectionUtils.isNotEmpty(disableActionResponseList = resourceActionResponseList.stream().filter(resourceActionResponse -> resourceActionResponse.getChecked() == false && CollectionUtils.isNotEmpty((Collection)resourceActionResponse.getGroupList()) && resourceActionResponse.getGroupList().stream().anyMatch(SingleActionResponse::getChecked)).collect(Collectors.toList()))) {
                updateActionResponseList.addAll(disableActionResponseList);
            }
            ArrayList updateParamList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)updateActionResponseList)) {
                updateActionResponseList.forEach(resourceActionResponse -> {
                    RoleResourceAuthUpdateParam updateParam = new RoleResourceAuthUpdateParam();
                    updateParam.setRoleId(roleId);
                    updateParam.setResoureId(resourceActionResponse.getId());
                    updateParam.setStatus(Integer.valueOf(resourceActionResponse.getChecked() != false ? 0 : 1));
                    List groupList = resourceActionResponse.getGroupList();
                    if (CollectionUtils.isEmpty((Collection)groupList)) {
                        updateParam.setActionList((List)Lists.newArrayList());
                    } else {
                        List actionList = groupList.stream().filter(SingleActionResponse::getChecked).map(SingleActionResponse::getValue).map(Integer::parseInt).sorted().collect(Collectors.toList());
                        updateParam.setActionList(actionList);
                    }
                    updateParamList.add(updateParam);
                });
                this.authService.updateRoleAuth((List)updateParamList);
            }
            if (!CollectionUtils.isEmpty((Collection)updateParamList)) {
                List resourceIdList = updateParamList.stream().map(RoleResourceAuthUpdateParam::getResoureId).collect(Collectors.toList());
                deleteActionResponseList = resourceActionResponseList.stream().filter(resourceActionResponse -> !resourceIdList.contains(resourceActionResponse.getId())).collect(Collectors.toList());
            } else {
                deleteActionResponseList = resourceActionResponseList;
            }
            if (CollectionUtils.isNotEmpty((Collection)deleteActionResponseList)) {
                ArrayList deleteRequestList = Lists.newArrayList();
                deleteActionResponseList.forEach(deleteActionResponse -> {
                    ResourceActionDeleteRequest deleteRequest = new ResourceActionDeleteRequest();
                    deleteRequest.setRoleId(roleId);
                    deleteRequest.setResoureId(deleteActionResponse.getId());
                    deleteRequestList.add(deleteRequest);
                });
                this.deleteResourceAction((List)deleteRequestList);
            }
        }
        return Response.success((Object)"\u914d\u7f6e\u6210\u529f");
    }

    public List<ResourceScopeResponse> getResourceScope(ResourceScopeQueryRequest queryRequest) {
        ArrayList resourceScopeResponseList = Lists.newArrayList();
        List resourceMenuResultList = this.authService.selectAuthConfigMenu();
        RoleResourceAuthQueryParam roleResourceAuthQueryParam = new RoleResourceAuthQueryParam();
        roleResourceAuthQueryParam.setRoleIdList(Arrays.asList(queryRequest.getRoleId()));
        roleResourceAuthQueryParam.setStatus(Boolean.TRUE);
        List authResultList = this.authService.selectList(roleResourceAuthQueryParam);
        if (CollectionUtils.isNotEmpty((Collection)authResultList)) {
            authResultList.forEach(authResult -> {
                Optional<ResourceMenuResult> optional = resourceMenuResultList.stream().filter(menuResult -> menuResult.getId().equals(authResult.getResoureId())).findFirst();
                if (optional.isPresent()) {
                    ResourceMenuResult menuResult2 = optional.get();
                    if (menuResult2.getCode().equals("configCenter_authorityConfig") || menuResult2.getCode().equals("configCenter_whitelistSwitch") || menuResult2.getCode().equals("configCenter_pressureMeasureSwitch") || menuResult2.getCode().equals("flowAccount") || menuResult2.getCode().equals("configCenter_operationLog")) {
                        return;
                    }
                    ResourceScopeResponse scopeResponse = new ResourceScopeResponse();
                    scopeResponse.setId(menuResult2.getId());
                    scopeResponse.setTitle(menuResult2.getName());
                    scopeResponse.setKey(menuResult2.getCode());
                    ArrayList groupList = Lists.newArrayList();
                    List scopeList = authResult.getScopeList();
                    if (CollectionUtils.isEmpty((Collection)scopeList)) {
                        scopeResponse.setChecked(DataTypeEnum.NONE.getCode());
                        for (DataTypeEnum dataTypeEnum : DataTypeEnum.values()) {
                            if (dataTypeEnum.getCode().equals(DataTypeEnum.NONE.getCode())) continue;
                            SingleScopeResponse singleScopeResponse = new SingleScopeResponse();
                            singleScopeResponse.setValue(dataTypeEnum.getCode());
                            singleScopeResponse.setLabel(dataTypeEnum.getCname());
                            groupList.add(singleScopeResponse);
                        }
                    } else {
                        Integer scope = (Integer)scopeList.get(0);
                        for (DataTypeEnum dataTypeEnum : DataTypeEnum.values()) {
                            if (dataTypeEnum.getCode().equals(scope)) {
                                scopeResponse.setChecked(scope);
                            }
                            if (dataTypeEnum.getCode().equals(DataTypeEnum.NONE.getCode())) continue;
                            SingleScopeResponse singleScopeResponse = new SingleScopeResponse();
                            singleScopeResponse.setValue(dataTypeEnum.getCode());
                            singleScopeResponse.setLabel(dataTypeEnum.getCname());
                            groupList.add(singleScopeResponse);
                        }
                    }
                    scopeResponse.setGroupList((List)groupList);
                    resourceScopeResponseList.add(scopeResponse);
                }
            });
        }
        return resourceScopeResponseList;
    }

    public Response updateResourceScope(ResourceScopeUpdateRequest updateRequest) {
        Long roleId = updateRequest.getRoleId();
        List resourceScopeResponseList = updateRequest.getDataPermissionList();
        if (CollectionUtils.isNotEmpty((Collection)resourceScopeResponseList)) {
            ArrayList updateParamList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)resourceScopeResponseList)) {
                resourceScopeResponseList.forEach(resourceScopeResponse -> {
                    RoleResourceAuthUpdateParam updateParam = new RoleResourceAuthUpdateParam();
                    updateParam.setRoleId(roleId);
                    updateParam.setResoureId(resourceScopeResponse.getId());
                    if (resourceScopeResponse.getChecked().equals(DataTypeEnum.NONE.getCode())) {
                        updateParam.setScopeList((List)Lists.newArrayList());
                    } else {
                        List<Integer> scopeList = Collections.singletonList(resourceScopeResponse.getChecked());
                        updateParam.setScopeList(scopeList);
                    }
                    updateParamList.add(updateParam);
                });
                this.authService.updateRoleAuth((List)updateParamList);
            }
        }
        return Response.success((Object)"\u914d\u7f6e\u6210\u529f");
    }

    public void deleteResourceAction(List<ResourceActionDeleteRequest> deleteRequestList) {
        ArrayList deleteParamList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(deleteRequestList)) {
            deleteRequestList.forEach(deleteRequest -> {
                RoleResourceAuthDeleteParam deleteParam = new RoleResourceAuthDeleteParam();
                deleteParam.setRoleId(deleteRequest.getRoleId());
                deleteParam.setResoureId(deleteRequest.getResoureId());
                deleteParamList.add(deleteParam);
            });
            this.authService.deleteRoleAuth((List)deleteParamList);
        }
    }

    public Map<String, Boolean> getUserMenu() {
        List resourceList;
        LinkedHashMap userResourceMap = Maps.newLinkedHashMap();
        User user = RestContext.getUser();
        if (Objects.isNull(user)) {
            log.error("\u83b7\u53d6\u7528\u6237\u83dc\u5355\u5931\u8d25\uff1a\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
            return Maps.newHashMap();
        }
        if (user.getUserType() == 0) {
            resourceList = this.authService.selectMenu(new ResourceMenuQueryParam());
        } else {
            List allResourceList = this.authService.selectMenu(new ResourceMenuQueryParam());
            List authResultList = this.getUserAuth(String.valueOf(user.getId()));
            if (CollectionUtils.isEmpty((Collection)authResultList)) {
                log.error("\u83b7\u53d6\u7528\u6237\u83dc\u5355\u5931\u8d25\uff1a\u8be5\u7528\u6237\u4e0b\u6682\u65e0\u8d44\u6e90\u4fe1\u606f");
                return Maps.newHashMap();
            }
            List resourceIdList = authResultList.stream().map(ResourceAuthResult::getResoureId).collect(Collectors.toList());
            ResourceMenuQueryParam resourceMenuQueryParam = new ResourceMenuQueryParam();
            resourceMenuQueryParam.setResourceIdList(resourceIdList);
            resourceList = this.authService.selectMenu(resourceMenuQueryParam);
            if (CollectionUtils.isEmpty((Collection)resourceList)) {
                log.error("\u83b7\u53d6\u7528\u6237\u83dc\u5355\u5931\u8d25\uff1a\u672a\u627e\u5230\u8d44\u6e90\u4fe1\u606f");
                return Maps.newHashMap();
            }
            TreeConvertUtil.getParentResourceByResourceIdList((List)allResourceList, (List)resourceList);
        }
        resourceList = resourceList.stream().sorted(Comparator.comparing(ResourceMenuResult::getSequence)).collect(Collectors.toList());
        for (ResourceMenuResult menuResult : resourceList) {
            userResourceMap.put(menuResult.getCode(), Boolean.TRUE);
        }
        HttpServletResponse response = ServletUtils.getResponse();
        response.addHeader("x-user-type", String.valueOf(RestContext.getUser().getUserType()));
        response.addHeader("x-expire", String.valueOf(TroClientAuthConstant.isExpire));
        return userResourceMap;
    }

    public Map<String, Boolean> getUserAction() {
        List resourceMenuResultList = this.authService.selectAuthConfigMenu();
        LinkedHashMap actionMap = Maps.newLinkedHashMap();
        User user = RestContext.getUser();
        if (!Objects.isNull(user)) {
            if (user.getUserType() == 0) {
                resourceMenuResultList.forEach(menuResult -> {
                    List actionList = menuResult.getActionList();
                    if (CollectionUtils.isNotEmpty((Collection)actionList)) {
                        actionList.forEach(action -> {
                            String key = menuResult.getCode() + "_" + action + "_" + Objects.requireNonNull(ActionTypeEnum.getNameByCode((Integer)action)).toLowerCase();
                            if (!actionMap.containsKey(key)) {
                                actionMap.put(key, Boolean.TRUE);
                            }
                        });
                    }
                });
            } else {
                List authResultList = this.getUserAuth(String.valueOf(user.getId()));
                if (CollectionUtils.isNotEmpty((Collection)authResultList)) {
                    authResultList.forEach(authResult -> {
                        Optional<ResourceMenuResult> optional = resourceMenuResultList.stream().filter(resourceMenuResult -> resourceMenuResult.getId().equals(authResult.getResoureId())).findFirst();
                        if (optional.isPresent()) {
                            ResourceMenuResult resourceMenuResult2 = optional.get();
                            List actionList = authResult.getActionList();
                            actionList.add(ActionTypeEnum.QUERY.getCode());
                            actionList.forEach(action -> {
                                String key = resourceMenuResult2.getCode() + "_" + action + "_" + Objects.requireNonNull(ActionTypeEnum.getNameByCode((Integer)action)).toLowerCase();
                                if (!actionMap.containsKey(key)) {
                                    actionMap.put(key, Boolean.TRUE);
                                }
                            });
                        } else {
                            log.error("\u83dc\u5355\u4e0d\u5b58\u5728:[{}]", (Object)authResult.getResoureId());
                        }
                    });
                } else {
                    log.error("\u7528\u6237\u6743\u9650\u4e3a\u7a7a\uff0c\u67e5\u8be2\u64cd\u4f5c\u6743\u9650\u5931\u8d25:[{}]", (Object)user.getId());
                }
            }
        } else {
            log.error("\u7528\u6237\u4e3a\u7a7a\uff0c\u67e5\u8be2\u89d2\u8272\u5931\u8d25");
        }
        if (actionMap.size() > 0) {
            return MapOrderByUtils.orderByKey((Map)actionMap, (boolean)false);
        }
        return actionMap;
    }

    public Map<String, List<Integer>> getUserData() {
        HashMap scopeMap = Maps.newHashMap();
        User user = RestContext.getUser();
        if (!Objects.isNull(user)) {
            if (user.getUserType() == 0) {
                return null;
            }
            List authResultList = this.getUserAuth(String.valueOf(user.getId()));
            if (CollectionUtils.isNotEmpty((Collection)authResultList)) {
                authResultList.forEach(authResult -> {
                    List actionList = authResult.getActionList();
                    actionList.add(ActionTypeEnum.QUERY.getCode());
                    for (Integer action : actionList) {
                        String key = authResult.getResourceCode() + "_" + action + "_" + Objects.requireNonNull(ActionTypeEnum.getNameByCode((Integer)action)).toLowerCase();
                        if (!scopeMap.containsKey(key)) {
                            ArrayList tmpScopeList = Lists.newArrayList();
                            if (!CollectionUtils.isNotEmpty((Collection)authResult.getScopeList())) continue;
                            tmpScopeList.addAll(authResult.getScopeList());
                            scopeMap.put(key, tmpScopeList);
                            continue;
                        }
                        List scopeList = (List)scopeMap.get(key);
                        if (CollectionUtils.isNotEmpty((Collection)authResult.getScopeList())) {
                            scopeList.addAll(authResult.getScopeList());
                        }
                        List withoutDuplicateScopeList = scopeList.stream().distinct().collect(Collectors.toList());
                        scopeMap.put(key, withoutDuplicateScopeList);
                    }
                });
            }
        }
        return scopeMap;
    }

    private List<ResourceAuthResult> getUserAuth(String userId) {
        UserRoleRelationBatchQueryParam userRoleRelationBatchQueryParam = new UserRoleRelationBatchQueryParam();
        userRoleRelationBatchQueryParam.setUserIdList(Arrays.asList(userId));
        List roleResultList = this.authService.selectUserRoleRelationBatch(userRoleRelationBatchQueryParam);
        if (CollectionUtils.isNotEmpty((Collection)roleResultList)) {
            List roleIdList = roleResultList.stream().map(UserRoleRelationResult::getRoleId).map(Long::parseLong).distinct().collect(Collectors.toList());
            RoleResourceAuthQueryParam roleResourceAuthQueryParam = new RoleResourceAuthQueryParam();
            roleResourceAuthQueryParam.setRoleIdList(roleIdList);
            roleResourceAuthQueryParam.setStatus(Boolean.TRUE);
            List authResultList = this.authService.selectList(roleResourceAuthQueryParam);
            return authResultList;
        }
        log.error("\u7528\u6237\u89d2\u8272\u4e3a\u7a7a\uff0c\u67e5\u8be2\u6743\u9650\u5931\u8d25:[{}]", (Object)userId);
        return Lists.newArrayList();
    }

    public List<String> getUserMenuResource(User user) {
        List resourceList;
        if (Objects.isNull(user)) {
            return Lists.newArrayList();
        }
        if (user.getUserType() == 0) {
            resourceList = this.authService.selectMenu(new ResourceMenuQueryParam());
        } else {
            List authResultList = this.getUserAuth(String.valueOf(user.getId()));
            if (CollectionUtils.isEmpty((Collection)authResultList)) {
                return Lists.newArrayList();
            }
            List resourceIdList = authResultList.stream().map(ResourceAuthResult::getResoureId).collect(Collectors.toList());
            ResourceMenuQueryParam resourceMenuQueryParam = new ResourceMenuQueryParam();
            resourceMenuQueryParam.setResourceIdList(resourceIdList);
            resourceList = this.authService.selectMenu(resourceMenuQueryParam);
        }
        if (CollectionUtils.isEmpty((Collection)resourceList)) {
            return Lists.newArrayList();
        }
        HashSet urlSet = Sets.newHashSet();
        for (ResourceMenuResult menuResult : resourceList) {
            if (!StringUtils.isNotBlank((CharSequence)menuResult.getValue())) continue;
            String urlStr = menuResult.getValue();
            JSONArray array = JSON.parseArray((String)urlStr);
            for (Object object : array) {
                urlSet.add(object.toString());
            }
        }
        return new ArrayList<String>(urlSet);
    }

    public List<UserDeptResult> selectList(UserDeptQueryParam queryParam) {
        return this.authService.selectList(queryParam);
    }

    public List<UserDeptConditionResult> selectUserByDeptIds(UserDeptConditionQueryParam queryParam) {
        return this.authService.selectUserByDeptIds(queryParam);
    }

    public User login(HttpServletRequest request, UserLoginParam user) throws TroLoginException {
        return this.authService.login(request, user);
    }

    public String logout(HttpServletRequest request, HttpServletResponse response) {
        return this.authService.logout(request, response);
    }

    public void redirect(String redirectUrl, HttpServletRequest request, HttpServletResponse response) {
        this.authService.redirect(redirectUrl, request, response);
    }

    public void loginSuccess(User user) {
        this.authService.loginSuccess(user);
    }

    public User check(HttpServletRequest request, HttpServletResponse response) {
        return this.authService.check(request, response);
    }

    public void checkFail(HttpServletResponse response) {
        this.authService.checkFail(response);
    }

    public boolean hasPermissionUrl(User user, String url) {
        return this.authService.hasPermissionUrl(user, url);
    }
}

