/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.async;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.util.http.DateUtil;
import com.pamirs.tro.entity.domain.dto.report.ReportDetailDTO;
import io.shulie.tro.cloud.common.bean.RuleBean;
import io.shulie.tro.cloud.common.redis.RedisClientUtils;
import io.shulie.tro.cloud.open.req.report.WarnCreateReq;
import io.shulie.tro.cloud.open.req.scenemanage.SceneManageIdReq;
import io.shulie.tro.cloud.open.resp.scenemanage.SceneManageWrapperResp;
import io.shulie.tro.web.app.service.async.AsyncService;
import io.shulie.tro.web.app.service.report.impl.ReportApplicationService;
import io.shulie.tro.web.data.dao.baseserver.BaseServerDao;
import io.shulie.tro.web.data.dao.perfomanceanaly.PerformanceBaseDataDAO;
import io.shulie.tro.web.data.param.baseserver.BaseServerParam;
import io.shulie.tro.web.data.param.perfomanceanaly.PerformanceBaseDataParam;
import io.shulie.tro.web.data.result.baseserver.BaseServerResult;
import io.shulie.tro.web.diff.api.scenetask.SceneTaskApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AsyncServiceImpl
implements AsyncService {
    private static final Logger log = LoggerFactory.getLogger(AsyncServiceImpl.class);
    @Autowired
    private PerformanceBaseDataDAO performanceBaseDataDAO;
    @Autowired
    private ReportApplicationService reportApplicationService;
    @Autowired
    private BaseServerDao baseServerDao;
    @Autowired
    private SceneTaskApi sceneTaskApi;
    @Autowired
    private RedisClientUtils redisClientUtils;

    @Async(value="agentDataThreadPool")
    public void savePerformanceBaseData(PerformanceBaseDataParam param) {
        if (this.redisClientUtils.hmget("pting.application:hmset").size() == 0) {
            return;
        }
        Map map = this.redisClientUtils.hmget("pting.application:hmset");
        ArrayList applications = Lists.newArrayList();
        map.values().forEach(value -> applications.addAll((List)value));
        if (applications.contains(param.getAppName())) {
            this.performanceBaseDataDAO.insert(param);
        }
    }

    @Async(value="backgroundMonitorThreadPool")
    public void monitorCpuMemory(Long sceneId, Long reportId, List<String> appNames, List<SceneManageWrapperResp.SceneSlaRefResp> stopSla, List<SceneManageWrapperResp.SceneSlaRefResp> warnSla) {
        try {
            ReportDetailDTO reportDetail = this.reportApplicationService.getDetail(reportId);
            Long startTime = io.shulie.tro.web.app.service.risk.util.DateUtil.parseSecondFormatter((String)reportDetail.getStartTime()).getTime();
            while (reportDetail.getEndTime() == null && reportDetail.getTaskStatus() == 1) {
                Long warnMax;
                List baseList = this.getAllBaseData(appNames, startTime, Long.valueOf(System.currentTimeMillis()));
                Long stopMax = this.groupCompare(sceneId, reportId, baseList, stopSla, Boolean.valueOf(true));
                if (stopMax != null) {
                    Long l = startTime = startTime < stopMax ? stopMax : startTime;
                }
                if ((warnMax = this.groupCompare(sceneId, reportId, baseList, warnSla, Boolean.valueOf(false))) != null) {
                    startTime = startTime < warnMax ? warnMax : startTime;
                }
                Thread.sleep(5000L);
                reportDetail = this.reportApplicationService.getDetail(reportId);
            }
        }
        catch (Exception e) {
            log.error("backgroundMonitorThreadPool error, sceneId={}, reportId={}, errmsg={}", new Object[]{sceneId, reportId, e.getMessage(), e});
        }
    }

    private List<BaseServerResult> getAllBaseData(List<String> appNames, Long startTime, Long endTime) {
        ArrayList dataList = Lists.newArrayList();
        BaseServerParam param = new BaseServerParam();
        param.setStartTime(this.formatTimestamp(startTime.longValue()));
        param.setEndTime(this.formatTimestamp(endTime.longValue()));
        appNames.forEach(data -> {
            param.setApplicationName(data);
            Collection temp = this.baseServerDao.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)temp)) {
                dataList.addAll(temp);
            }
        });
        return dataList;
    }

    private Long groupCompare(Long sceneId, Long reportId, List<BaseServerResult> baseList, List<SceneManageWrapperResp.SceneSlaRefResp> slaList, Boolean stop) {
        if (CollectionUtils.isEmpty(baseList) || CollectionUtils.isEmpty(slaList)) {
            return null;
        }
        Map<String, List<BaseServerResult>> dataMap = baseList.stream().collect(Collectors.groupingBy(data -> data.getAppName() + "|" + data.getAppIp()));
        ArrayList timeList = Lists.newArrayList();
        dataMap.forEach((key, value) -> slaList.forEach(data -> timeList.add(this.getMatchList(sceneId, reportId, key, value, data, stop))));
        Collections.sort(timeList);
        return (Long)timeList.get(0);
    }

    private Long getMatchList(Long sceneId, Long reportId, String prefix, List<BaseServerResult> baseList, SceneManageWrapperResp.SceneSlaRefResp sla, Boolean stop) {
        Long maxNormalTime;
        block6: {
            HashMap resultMap;
            int current;
            int limit;
            RuleBean ruleBean;
            block7: {
                ruleBean = sla.getRule();
                limit = ruleBean.getTimes();
                current = 0;
                maxNormalTime = 0L;
                resultMap = Maps.newHashMap();
                if (ruleBean.getIndexInfo() != 4) break block7;
                for (int i = 0; i < baseList.size(); ++i) {
                    this.matchCompare((Map)resultMap, baseList.get(i).getCpuRate(), ruleBean.getDuring(), ruleBean.getCondition());
                    if (Boolean.TRUE.equals(resultMap.get("result"))) {
                        if (++current < limit) continue;
                        if (stop.booleanValue()) {
                            this.stop(baseList.get(i), sceneId);
                            break block6;
                        }
                        String value = prefix + "|" + baseList.get(i).getExtTime();
                        if (this.redisClientUtils.zsetAdd("report:warn:" + reportId, value) == 0L) continue;
                        this.warn(baseList.get(i), sla, "cpu\u5229\u7528\u7387", reportId, (Map)resultMap, Long.valueOf(baseList.get(i).getExtTime()));
                        continue;
                    }
                    current = 0;
                    maxNormalTime = baseList.get(i).getExtTime();
                }
                break block6;
            }
            if (ruleBean.getIndexInfo() != 5) break block6;
            for (int i = 0; i < baseList.size(); ++i) {
                this.matchCompare((Map)resultMap, baseList.get(i).getMemRate(), ruleBean.getDuring(), ruleBean.getCondition());
                if (Boolean.TRUE.equals(resultMap.get("result"))) {
                    if (++current < limit) continue;
                    if (stop.booleanValue()) {
                        this.stop(baseList.get(i), sceneId);
                        break;
                    }
                    String value = prefix + "|" + baseList.get(i).getExtTime();
                    if (this.redisClientUtils.zsetAdd("report:warn:" + reportId, value) == 0L) continue;
                    this.warn(baseList.get(i), sla, "\u5185\u5b58\u4f7f\u7528\u7387", reportId, (Map)resultMap, Long.valueOf(baseList.get(i).getExtTime()));
                    continue;
                }
                current = 0;
                maxNormalTime = baseList.get(i).getExtTime();
            }
        }
        return maxNormalTime;
    }

    private void matchCompare(Map<String, Object> resultMap, Double realValue, BigDecimal goalValue, Integer compareType) {
        if (realValue == null) {
            realValue = 0.0;
        }
        resultMap.clear();
        switch (compareType) {
            case 0: {
                resultMap.put("compare", ">=");
                resultMap.put("real", realValue);
                resultMap.put("result", new BigDecimal(realValue).compareTo(goalValue) >= 0);
                break;
            }
            case 1: {
                resultMap.put("compare", ">");
                resultMap.put("real", realValue);
                resultMap.put("result", new BigDecimal(realValue).compareTo(goalValue) > 0);
                break;
            }
            case 2: {
                resultMap.put("compare", "=");
                resultMap.put("real", realValue);
                resultMap.put("result", new BigDecimal(realValue).compareTo(goalValue) == 0);
                break;
            }
            case 3: {
                resultMap.put("compare", "<=");
                resultMap.put("real", realValue);
                resultMap.put("result", new BigDecimal(realValue).compareTo(goalValue) <= 0);
                break;
            }
            case 4: {
                resultMap.put("compare", "<");
                resultMap.put("real", realValue);
                resultMap.put("result", new BigDecimal(realValue).compareTo(goalValue) < 0);
                break;
            }
            default: {
                resultMap.put("result", false);
            }
        }
    }

    private void stop(BaseServerResult baseData, Long sceneId) {
        SceneManageIdReq req = new SceneManageIdReq();
        req.setId(sceneId);
        this.sceneTaskApi.stopTask(req);
        log.warn("\u89e6\u53d1SLA\u7ec8\u6b62\u538b\u6d4b\uff0csceneId={}, appName={}, appIp={}", new Object[]{sceneId, baseData.getAppName(), baseData.getAppIp()});
    }

    private void warn(BaseServerResult baseData, SceneManageWrapperResp.SceneSlaRefResp sla, String type, Long reportId, Map<String, Object> resultMap, Long timestamp) {
        WarnCreateReq warnDetail = new WarnCreateReq();
        warnDetail.setPtId(reportId);
        warnDetail.setSlaId(sla.getId());
        warnDetail.setSlaName(sla.getRuleName());
        warnDetail.setBusinessActivityId(Long.valueOf(0L));
        warnDetail.setBusinessActivityName(baseData.getAppName() + "|" + baseData.getAppIp());
        StringBuffer sb = new StringBuffer();
        sb.append(type);
        sb.append(resultMap.get("compare"));
        sb.append(sla.getRule().getDuring());
        sb.append("%");
        sb.append(", \u8fde\u7eed");
        sb.append(sla.getRule().getTimes());
        sb.append("\u6b21");
        warnDetail.setWarnContent(sb.toString());
        warnDetail.setWarnTime(DateUtil.formatTime((long)timestamp));
        warnDetail.setRealValue((Double)resultMap.get("real"));
        this.sceneTaskApi.addWarn(warnDetail);
    }

    private long formatTimestamp(long timestamp) {
        String temp = timestamp + "000000";
        return Long.parseLong(temp);
    }
}

