/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.application.impl;

import com.pamirs.tro.entity.domain.vo.ApplicationVo;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.request.application.ApplicationNodeDashBoardQueryRequest;
import io.shulie.tro.web.app.request.application.ApplicationNodeQueryRequest;
import io.shulie.tro.web.app.response.application.ApplicationNodeDashBoardResponse;
import io.shulie.tro.web.app.response.application.ApplicationNodeResponse;
import io.shulie.tro.web.app.service.ApplicationService;
import io.shulie.tro.web.app.service.application.ApplicationNodeService;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.dao.application.ApplicationNodeDAO;
import io.shulie.tro.web.data.param.application.ApplicationNodeQueryParam;
import io.shulie.tro.web.data.result.application.ApplicationNodeResult;
import io.shulie.tro.web.data.result.application.ApplicationResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApplicationNodeServiceImpl
implements ApplicationNodeService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationNodeServiceImpl.class);
    @Autowired
    private ApplicationNodeDAO applicationNodeDAO;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApplicationDAO applicationDAO;

    public PagingList<ApplicationNodeResponse> pageNodes(ApplicationNodeQueryRequest request) {
        ApplicationNodeQueryParam queryParam = new ApplicationNodeQueryParam();
        Response applicationVoResponse = this.applicationService.getApplicationInfo(String.valueOf(request.getApplicationId()));
        ApplicationVo applicationVo = (ApplicationVo)applicationVoResponse.getData();
        if (Objects.isNull(applicationVo)) {
            return PagingList.empty();
        }
        queryParam.setCurrent(request.getCurrent());
        queryParam.setPageSize(Integer.valueOf(request.getPageSize()));
        queryParam.setApplicationNames(Arrays.asList(applicationVo.getApplicationName()));
        queryParam.setIp(request.getIp());
        PagingList applicationNodes = this.applicationNodeDAO.pageNodes(queryParam);
        if (applicationNodes.isEmpty()) {
            return PagingList.empty();
        }
        List responseNodes = applicationNodes.getList().stream().map(instance -> {
            ApplicationNodeResponse response = new ApplicationNodeResponse();
            BeanUtils.copyProperties((Object)instance, (Object)response);
            return response;
        }).collect(Collectors.toList());
        responseNodes.sort(Comparator.comparing(ApplicationNodeResponse::getAgentId));
        return PagingList.of(responseNodes, (long)applicationNodes.getTotal());
    }

    public ApplicationNodeResponse getNodeByAgentId(String agentId) {
        ApplicationNodeResult applicationNode = this.applicationNodeDAO.getNodeByAgentId(agentId);
        ApplicationNodeResponse response = new ApplicationNodeResponse();
        BeanUtils.copyProperties((Object)applicationNode, (Object)response);
        return response;
    }

    public ApplicationNodeDashBoardResponse getApplicationNodeAmount(ApplicationNodeDashBoardQueryRequest request) {
        Long count;
        ApplicationNodeDashBoardResponse response = new ApplicationNodeDashBoardResponse();
        response.setNodeTotalCount(Integer.valueOf(0));
        response.setNodeOnlineCount(Integer.valueOf(0));
        Response applicationVoResponse = this.applicationService.getApplicationInfo(String.valueOf(request.getApplicationId()));
        ApplicationVo applicationVo = (ApplicationVo)applicationVoResponse.getData();
        if (Objects.isNull(applicationVo.getId())) {
            return response;
        }
        String applicationName = applicationVo.getApplicationName();
        List applicationResultList = this.applicationDAO.getApplicationByName(Arrays.asList(applicationName));
        response.setNodeTotalCount(applicationVo.getNodeNum());
        if (CollectionUtils.isEmpty((Collection)applicationResultList)) {
            response.setErrorMsg("\u5728\u7ebf\u8282\u70b9\u6570\u4e0e\u8282\u70b9\u603b\u6570\u4e0d\u4e00\u81f4");
            return response;
        }
        response.setNodeOnlineCount(((ApplicationResult)applicationResultList.get(0)).getInstanceInfo().getInstanceOnlineAmount());
        if (!response.getNodeOnlineCount().equals(response.getNodeTotalCount())) {
            response.setErrorMsg("\u5728\u7ebf\u8282\u70b9\u6570\u4e0e\u8282\u70b9\u603b\u6570\u4e0d\u4e00\u81f4");
            return response;
        }
        ApplicationNodeQueryParam queryParam = new ApplicationNodeQueryParam();
        queryParam.setCurrent(0);
        queryParam.setPageSize(Integer.valueOf(99999));
        queryParam.setApplicationNames(Arrays.asList(applicationVo.getApplicationName()));
        PagingList applicationNodes = this.applicationNodeDAO.pageNodes(queryParam);
        List applicationNodeResultList = applicationNodes.getList();
        if (CollectionUtils.isNotEmpty((Collection)applicationNodeResultList) && (count = Long.valueOf(applicationNodeResultList.stream().map(ApplicationNodeResult::getAgentVersion).distinct().count())) > 1L) {
            response.setErrorMsg("agent\u7248\u672c\u4e0d\u4e00\u81f4");
        }
        return response;
    }
}

