/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.application.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.pamirs.tro.common.util.DateUtils;
import com.pamirs.tro.entity.domain.dto.NodeUploadDataDTO;
import com.pamirs.tro.entity.domain.entity.ExceptionInfo;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.output.application.ApplicationExceptionOutput;
import io.shulie.tro.web.app.request.application.ApplicationErrorQueryRequest;
import io.shulie.tro.web.app.response.application.ApplicationErrorResponse;
import io.shulie.tro.web.app.service.ApplicationService;
import io.shulie.tro.web.app.service.application.ApplicationErrorService;
import io.shulie.tro.web.common.enums.application.AppExceptionCodeEnum;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.dao.application.ApplicationNodeDAO;
import io.shulie.tro.web.data.result.application.ApplicationResult;
import io.shulie.tro.web.data.result.application.InstanceInfoResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class ApplicationErrorServiceImpl
implements ApplicationErrorService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationErrorServiceImpl.class);
    @Autowired
    private ApplicationNodeDAO applicationNodeDAO;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApplicationDAO applicationDAO;
    @Autowired
    private RedisTemplate redisTemplate;

    public List<ApplicationErrorResponse> list(ApplicationErrorQueryRequest queryRequest) {
        ArrayList responseList = Lists.newArrayList();
        Response applicationMntResponse = this.applicationService.getApplicationInfoForError(String.valueOf(queryRequest.getApplicationId()));
        TApplicationMnt tApplicationMnt = (TApplicationMnt)applicationMntResponse.getData();
        if (Objects.isNull(tApplicationMnt)) {
            return responseList;
        }
        String applicationName = tApplicationMnt.getApplicationName();
        List applicationResultList = this.applicationDAO.getApplicationByName(Arrays.asList(applicationName));
        Integer totalNodeCount = tApplicationMnt.getNodeNum();
        if (CollectionUtils.isEmpty((Collection)applicationResultList) || !totalNodeCount.equals(((ApplicationResult)applicationResultList.get(0)).getInstanceInfo().getInstanceOnlineAmount())) {
            ApplicationErrorResponse applicationErrorResponse = new ApplicationErrorResponse();
            applicationErrorResponse.setExceptionId("-");
            applicationErrorResponse.setAgentIdList(Arrays.asList("-"));
            applicationErrorResponse.setDescription("\u5728\u7ebf\u8282\u70b9\u6570\u4e0e\u8282\u70b9\u603b\u6570\u4e0d\u4e00\u81f4");
            applicationErrorResponse.setTime(DateUtils.getNowDateStr());
            Integer onlineNodeNum = 0;
            if (!CollectionUtils.isEmpty((Collection)applicationResultList)) {
                onlineNodeNum = ((ApplicationResult)applicationResultList.get(0)).getInstanceInfo().getInstanceOnlineAmount();
            }
            applicationErrorResponse.setDetail("\u8bbe\u7f6e\u8282\u70b9\u6570\uff1a" + totalNodeCount + "\uff0c\u4e0a\u62a5\u7684\u8282\u70b9\u6570\uff1a" + onlineNodeNum);
            responseList.add(applicationErrorResponse);
        }
        String appUniqueKey = queryRequest.getApplicationId() + "_PRADARNODE_KEYSET";
        Set keys = this.redisTemplate.opsForSet().members((Object)appUniqueKey);
        if (keys == null || keys.size() == 0) {
            return responseList;
        }
        for (String nodeKey : keys) {
            List nodeUploadDataDTOList;
            if (!this.redisTemplate.hasKey((Object)nodeKey).booleanValue() || CollectionUtils.isEmpty((Collection)(nodeUploadDataDTOList = this.redisTemplate.opsForList().range((Object)nodeKey, 0L, -1L)))) continue;
            nodeUploadDataDTOList.forEach(n -> {
                NodeUploadDataDTO nodeUploadDataDTO = (NodeUploadDataDTO)JSONObject.parseObject((String)n, NodeUploadDataDTO.class);
                Map exceptionMap = nodeUploadDataDTO.getSwitchErrorMap();
                if (exceptionMap != null && exceptionMap.size() > 0) {
                    for (Map.Entry entry : exceptionMap.entrySet()) {
                        String message = String.valueOf(entry.getValue());
                        if (!message.contains("errorCode")) continue;
                        try {
                            ExceptionInfo exceptionInfo = (ExceptionInfo)JSONObject.parseObject((String)message, ExceptionInfo.class);
                            ApplicationErrorResponse applicationErrorResponse = new ApplicationErrorResponse();
                            applicationErrorResponse.setExceptionId(exceptionInfo.getErrorCode());
                            applicationErrorResponse.setAgentIdList(Arrays.asList(nodeUploadDataDTO.getAgentId()));
                            applicationErrorResponse.setDescription(exceptionInfo.getMessage());
                            applicationErrorResponse.setDetail(exceptionInfo.getDetail());
                            applicationErrorResponse.setTime(nodeUploadDataDTO.getExceptionTime());
                            responseList.add(applicationErrorResponse);
                        }
                        catch (Exception e) {
                            log.error(message);
                            log.error("\u5f02\u5e38\u8f6c\u6362\u5931\u8d25\uff1a", (Throwable)e);
                        }
                    }
                }
            });
        }
        return responseList;
    }

    public List<ApplicationExceptionOutput> getAppException(List<String> appNames) {
        ArrayList outputs = Lists.newArrayList();
        List applicationResultList = this.applicationDAO.getApplicationByName(appNames);
        applicationResultList.forEach(app -> {
            String appUniqueKey;
            Set keys;
            InstanceInfoResult result = app.getInstanceInfo();
            if (!result.getInstanceAmount().equals(result.getInstanceOnlineAmount())) {
                ApplicationExceptionOutput output = new ApplicationExceptionOutput();
                output.setApplicationName(app.getAppName());
                output.setAgentIds(Arrays.asList("-"));
                output.setCode(AppExceptionCodeEnum.EPC0001.getCode());
                output.setDescription(AppExceptionCodeEnum.EPC0001.getDesc());
                output.setTime(DateUtils.getNowDateStr());
                outputs.add(output);
            }
            if ((keys = this.redisTemplate.keys((Object)((appUniqueKey = app.getAppId() + "_NEW_PRADAR_") + "*"))) != null) {
                for (String nodeKey : keys) {
                    List nodeUploadDataDTOList = this.redisTemplate.opsForList().range((Object)nodeKey, 0L, -1L);
                    if (CollectionUtils.isEmpty((Collection)nodeUploadDataDTOList)) continue;
                    nodeUploadDataDTOList.forEach(n -> {
                        NodeUploadDataDTO nodeUploadDataDTO = (NodeUploadDataDTO)JSONObject.parseObject((String)n, NodeUploadDataDTO.class);
                        Map exceptionMap = nodeUploadDataDTO.getSwitchErrorMap();
                        if (exceptionMap != null && exceptionMap.size() > 0) {
                            for (Map.Entry entry : exceptionMap.entrySet()) {
                                String message = String.valueOf(entry.getValue());
                                if (!message.contains("errorCode")) continue;
                                try {
                                    ExceptionInfo exceptionInfo = (ExceptionInfo)JSONObject.parseObject((String)message, ExceptionInfo.class);
                                    ApplicationExceptionOutput output = new ApplicationExceptionOutput();
                                    output.setApplicationName(app.getAppName());
                                    output.setAgentIds(Arrays.asList(nodeUploadDataDTO.getAgentId()));
                                    output.setCode(exceptionInfo.getErrorCode());
                                    output.setDescription(exceptionInfo.getMessage());
                                    output.setTime(nodeUploadDataDTO.getExceptionTime());
                                    outputs.add(output);
                                }
                                catch (Exception e) {
                                    log.error(message);
                                    log.error("\u5f02\u5e38\u8f6c\u6362\u5931\u8d25\uff1a", (Throwable)e);
                                }
                            }
                        }
                    });
                }
            }
        });
        return outputs;
    }
}

