/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service.agent.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.pamirs.tro.entity.domain.entity.linkmanage.figure.MiddleWareEnum;
import io.shulie.tro.web.app.response.application.AgentPluginSupportResponse;
import io.shulie.tro.web.app.response.linkmanage.MiddleWareResponse;
import io.shulie.tro.web.app.response.linkmanage.SupportStatusResponse;
import io.shulie.tro.web.app.service.agent.AgentPluginSupportService;
import io.shulie.tro.web.data.dao.agent.AgentPluginDAO;
import io.shulie.tro.web.data.dao.agent.AgentPluginLibSupportDAO;
import io.shulie.tro.web.data.result.agent.AgentPluginLibSupportResult;
import io.shulie.tro.web.data.result.agent.AgentPluginResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AgentPluginSupportServiceImpl
implements AgentPluginSupportService {
    private static final Logger log = LoggerFactory.getLogger(AgentPluginSupportServiceImpl.class);
    @Resource
    private AgentPluginDAO agentPluginDAO;
    @Resource
    private AgentPluginLibSupportDAO libSupportDAO;

    public List<AgentPluginSupportResponse> queryAgentPluginSupportList() {
        ArrayList pluginSupportResponseList = Lists.newArrayList();
        List agentPluginResultList = this.agentPluginDAO.getAgentPluginList();
        List libSupportResultList = this.libSupportDAO.getAgentPluginLibSupportList();
        if (CollectionUtils.isEmpty((Collection)agentPluginResultList) || CollectionUtils.isEmpty((Collection)libSupportResultList)) {
            return pluginSupportResponseList;
        }
        for (AgentPluginLibSupportResult agentPluginLibSupportResult : libSupportResultList) {
            Optional<AgentPluginResult> optional = agentPluginResultList.stream().filter(agentPluginResult -> agentPluginResult.getId().equals(agentPluginLibSupportResult.getPluginId())).findFirst();
            if (optional.isPresent()) {
                AgentPluginResult agentPluginResult2 = optional.get();
                AgentPluginSupportResponse supportResponse = new AgentPluginSupportResponse();
                supportResponse.setPluginId(agentPluginResult2.getId());
                supportResponse.setPluginType(agentPluginResult2.getPluginType());
                supportResponse.setPluginName(agentPluginResult2.getPluginName());
                supportResponse.setIsIgnore(agentPluginLibSupportResult.getIsIgnore());
                supportResponse.setLibName(agentPluginLibSupportResult.getLibName());
                JSONArray regExpArray = JSON.parseArray((String)agentPluginLibSupportResult.getLibVersionRegexp());
                List patternList = regExpArray.stream().map(r -> {
                    Pattern pattern = Pattern.compile(r.toString());
                    return pattern;
                }).collect(Collectors.toList());
                supportResponse.setRegexpList(patternList);
                pluginSupportResponseList.add(supportResponse);
                continue;
            }
            return pluginSupportResponseList;
        }
        return pluginSupportResponseList;
    }

    public Boolean isSupportLib(List<AgentPluginSupportResponse> supportList, String libName) {
        String tempLibName = libName;
        String tempLibVersion = libName;
        tempLibName = tempLibName.substring(0, tempLibName.lastIndexOf("-"));
        tempLibVersion = tempLibVersion.substring(tempLibVersion.lastIndexOf("-") + 1);
        String finalTempLibName = tempLibName;
        Optional optional = supportList.stream().filter(s -> s.getLibName().equalsIgnoreCase(finalTempLibName)).collect(Collectors.toList()).stream().findFirst();
        if (!optional.isPresent()) {
            return Boolean.FALSE;
        }
        AgentPluginSupportResponse agentPluginSupportResponse = (AgentPluginSupportResponse)optional.get();
        ArrayList patternListAll = Lists.newArrayList();
        patternListAll.addAll(agentPluginSupportResponse.getRegexpList());
        if (CollectionUtils.isEmpty((Collection)patternListAll)) {
            return Boolean.FALSE;
        }
        for (Pattern pattern : patternListAll) {
            Matcher matcher = pattern.matcher(tempLibVersion);
            if (!matcher.matches()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public MiddleWareResponse convertLibInfo(List<AgentPluginSupportResponse> supportList, String libName) {
        MiddleWareResponse middleWareResponse = new MiddleWareResponse();
        String tempLibName = libName;
        String tempLibVersion = libName;
        if (!libName.contains("-")) {
            middleWareResponse.setPluginType(MiddleWareEnum.getMiddleWareTypeValue((String)""));
            middleWareResponse.setPluginName("-");
            middleWareResponse.setLibName(libName);
            middleWareResponse.setStatusResponse(SupportStatusResponse.buildStatus((Integer)1));
            return middleWareResponse;
        }
        tempLibName = tempLibName.substring(0, tempLibName.lastIndexOf("-"));
        tempLibVersion = tempLibVersion.substring(tempLibVersion.lastIndexOf("-") + 1);
        try {
            tempLibVersion = tempLibVersion.substring(0, tempLibVersion.indexOf(".jar"));
        }
        catch (Exception e) {
            if (tempLibVersion.contains(".jar")) {
                tempLibVersion = tempLibVersion.substring(0, tempLibVersion.indexOf(".jar"));
            }
            if (tempLibVersion.contains(".war")) {
                tempLibVersion = tempLibVersion.substring(0, tempLibVersion.indexOf(".war"));
            }
            log.error("\u89e3\u6790\u5e94\u7528\u7248\u672c\u53f7\u51fa\u9519\uff0c\u6570\u636e\u4e3a\uff1a{}", (Object)libName);
        }
        String finalTempLibName = tempLibName;
        Optional optional = supportList.stream().filter(s -> s.getLibName().equalsIgnoreCase(finalTempLibName)).collect(Collectors.toList()).stream().findFirst();
        if (!optional.isPresent()) {
            middleWareResponse.setPluginType(MiddleWareEnum.getMiddleWareTypeValue((String)""));
            middleWareResponse.setPluginName("-");
            middleWareResponse.setLibName(libName);
            middleWareResponse.setStatusResponse(SupportStatusResponse.buildStatus((Integer)1));
        } else {
            AgentPluginSupportResponse agentPluginSupportResponse = (AgentPluginSupportResponse)optional.get();
            middleWareResponse.setPluginName(agentPluginSupportResponse.getPluginName());
            String typeName = MiddleWareEnum.getMiddleWareTypeValue((String)agentPluginSupportResponse.getPluginType());
            middleWareResponse.setPluginType(typeName);
            middleWareResponse.setLibName(libName);
            if (agentPluginSupportResponse.getIsIgnore().booleanValue()) {
                middleWareResponse.setStatusResponse(SupportStatusResponse.buildStatus((Integer)3));
                return middleWareResponse;
            }
            ArrayList patternListAll = Lists.newArrayList();
            patternListAll.addAll(agentPluginSupportResponse.getRegexpList());
            if (CollectionUtils.isEmpty((Collection)patternListAll)) {
                middleWareResponse.setStatusResponse(SupportStatusResponse.buildStatus((Integer)0));
                return middleWareResponse;
            }
            for (Pattern pattern : patternListAll) {
                Matcher matcher = pattern.matcher(tempLibVersion);
                if (!matcher.matches()) continue;
                middleWareResponse.setStatusResponse(SupportStatusResponse.buildStatus((Integer)2));
                return middleWareResponse;
            }
            middleWareResponse.setStatusResponse(SupportStatusResponse.buildStatus((Integer)0));
        }
        return middleWareResponse;
    }
}

