/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service;

import com.pamirs.tro.common.constant.Constants;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.common.redis.RedisKey;
import com.pamirs.tro.common.redis.UploadInterfaceKeyMaker;
import com.pamirs.tro.entity.dao.confcenter.TUploadInterfaceDataDao;
import com.pamirs.tro.entity.domain.entity.TUploadInterfaceData;
import com.pamirs.tro.entity.domain.vo.TUploadInterfaceDetailVo;
import com.pamirs.tro.entity.domain.vo.TUploadInterfaceVo;
import com.pamirs.tro.entity.domain.vo.TUploadNeedVo;
import io.shulie.tro.web.app.common.CommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UploadInterfaceService
extends CommonService {
    @Autowired
    private TUploadInterfaceDataDao uploadInterfaceDataDao;

    public boolean executeNeedUploadInterface(TUploadNeedVo uploadNeedVo) throws TROModuleException {
        if (uploadNeedVo == null || StringUtils.isEmpty((CharSequence)uploadNeedVo.getAppName())) {
            return false;
        }
        String key = UploadInterfaceKeyMaker.getUploadKey((String)uploadNeedVo.getAppName());
        Optional value = this.redisManager.valueGet(key);
        if (value.isPresent()) {
            if (Integer.parseInt(value.get().toString()) == uploadNeedVo.getSize()) {
                return false;
            }
            this.redisManager.removeKey(key);
            return true;
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public int saveUploadInterfaceData(TUploadInterfaceVo uploadInterfaceVo) throws TROModuleException {
        if (uploadInterfaceVo == null || StringUtils.isEmpty((CharSequence)uploadInterfaceVo.getAppName()) || CollectionUtils.isEmpty((Collection)uploadInterfaceVo.getAppDetails())) {
            return 0;
        }
        String key = UploadInterfaceKeyMaker.getUploadKey((String)uploadInterfaceVo.getAppName());
        RedisKey redisKey = new RedisKey(key, 1800L);
        if (!this.redisManager.acquireLock(redisKey)) {
            return 0;
        }
        this.uploadInterfaceDataDao.deleteByAppName(uploadInterfaceVo.getAppName());
        ArrayList<TUploadInterfaceData> saveDataList = new ArrayList<TUploadInterfaceData>();
        for (TUploadInterfaceDetailVo appDetail : uploadInterfaceVo.getAppDetails()) {
            TUploadInterfaceData tempDate = new TUploadInterfaceData();
            tempDate.setAppName(uploadInterfaceVo.getAppName());
            tempDate.setId(Long.valueOf(this.snowflake.next()));
            tempDate.setInterfaceValue(appDetail.getInterfaceName());
            if ("dubbo".equalsIgnoreCase(appDetail.getType())) {
                tempDate.setInterfaceType(Constants.UPLOAD_DATA_DBTYPE_DUBBO);
            } else {
                if (!"job".equalsIgnoreCase(appDetail.getType())) continue;
                tempDate.setInterfaceType(Constants.UPLOAD_DATA_DBTYPE_JOB);
            }
            saveDataList.add(tempDate);
            if (saveDataList.size() <= 500) continue;
            this.uploadInterfaceDataDao.insertList(saveDataList);
            saveDataList = new ArrayList();
        }
        if (CollectionUtils.isNotEmpty(saveDataList)) {
            this.uploadInterfaceDataDao.insertList(saveDataList);
        }
        this.redisManager.valuePut(redisKey, (Object)(System.currentTimeMillis() + 180000L));
        return uploadInterfaceVo.getAppDetails().size();
    }
}

