/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pamirs.tro.common.constant.Constants;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.common.util.PageInfo;
import com.pamirs.tro.common.util.RequestPradarUtil;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import com.pamirs.tro.entity.domain.entity.TShadowTableConfig;
import com.pamirs.tro.entity.domain.entity.TShadowTableDataSource;
import com.pamirs.tro.entity.domain.vo.TPradarShadowTable;
import com.pamirs.tro.entity.domain.vo.TPradarShadowTableConfig;
import com.pamirs.tro.entity.domain.vo.TShadowTableConfigVo;
import com.pamirs.tro.entity.domain.vo.TShadowTableDatasourceVo;
import io.shulie.tro.web.app.common.CommonService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class ShadowTableConfigService
extends CommonService {
    public static final int BATCH_SIZE = 200;

    public Map<String, Set<String>> agentGetShadowTable(String appName) {
        HashMap appShadowTableMap = Maps.newHashMapWithExpectedSize((int)10);
        if (StringUtils.isEmpty((CharSequence)appName)) {
            appShadowTableMap.put("N|N|N", null);
            return appShadowTableMap;
        }
        TApplicationMnt applicationMnt = this.tApplicationMntDao.queryApplicationinfoByName(appName = appName.trim());
        if (applicationMnt == null) {
            appShadowTableMap.put("N|N|N", null);
            return appShadowTableMap;
        }
        List shadowTableDataSourceList = this.tShadowTableDataSourceDao.queryShadowDataSourceByApplicationId(Long.valueOf(applicationMnt.getApplicationId()));
        if (CollectionUtils.isEmpty((Collection)shadowTableDataSourceList)) {
            appShadowTableMap.put("N|N|N", null);
            return appShadowTableMap;
        }
        List shadowTableConfigList = this.tShadowTableConfigDao.queryShawdowTableConfigByShadowDatasourceIdList(shadowTableDataSourceList.stream().map(TShadowTableDataSource::getShadowDatasourceId).collect(Collectors.toList()));
        shadowTableDataSourceList.forEach(shadowTableDataSource -> {
            boolean needShadowTable = false;
            StringBuilder sb = new StringBuilder();
            if (Constants.INTEGER_USE.equals(shadowTableDataSource.getUseShadowTable())) {
                sb.append("Y");
                needShadowTable = true;
            } else {
                sb.append("N");
            }
            sb.append("|").append(shadowTableDataSource.getDatabaseIpport()).append("|").append(shadowTableDataSource.getDatabaseName());
            String shadowTableMapKey = sb.toString();
            appShadowTableMap.put(sb.toString(), Sets.newHashSetWithExpectedSize((int)1));
            if (needShadowTable) {
                shadowTableConfigList.forEach(shadowTable -> {
                    if (shadowTable.getShadowDatasourceId().equals(shadowTableDataSource.getShadowDatasourceId())) {
                        if (appShadowTableMap.get(shadowTableMapKey) != null) {
                            ((Set)appShadowTableMap.get(shadowTableMapKey)).add(shadowTable.getShadowTableName());
                        } else {
                            HashSet shadowTableNameSet = Sets.newHashSetWithExpectedSize((int)50);
                            shadowTableNameSet.add(shadowTable.getShadowTableName());
                            appShadowTableMap.put(shadowTableMapKey, shadowTableNameSet);
                        }
                    }
                });
            }
        });
        return appShadowTableMap;
    }

    public void getShadowTableFromPradarList(String applicationIdList) throws TROModuleException {
        String[] applicationIds;
        for (String applicationId : applicationIds = applicationIdList.split(",")) {
            this.getShadowTableFromPradar(Long.valueOf(Long.parseLong(applicationId)));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    protected void getShadowTableFromPradar(Long applicationId) throws TROModuleException {
        TApplicationMnt applicationMnt = this.tApplicationMntDao.queryApplicationinfoById(applicationId.longValue());
        if (applicationMnt == null) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_QUERY_APPLICATION_EXCEPTION);
        }
        Map pradarInitParams = RequestPradarUtil.initPrada();
        pradarInitParams.put("appName", applicationMnt.getApplicationName());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        pradarInitParams.forEach((arg_0, arg_1) -> ShadowTableConfigService.lambda$getShadowTableFromPradar$2((MultiValueMap)params, arg_0, arg_1));
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        Map responseMap = null;
        try {
            responseMap = (Map)this.restTemplate.postForObject(this.getPradarUrl() + "/PamirsDatabaseInfo", (Object)httpEntity, Map.class, new Object[0]);
        }
        catch (Exception e) {
            this.LOGGER.error("\u8c03\u7528pradar\u8bfb\u53d6\u6570\u636e\u5f02\u5e38{}", (Throwable)e);
            return;
        }
        String resultFlag = MapUtils.getString((Map)responseMap, (Object)"resultFlag");
        String resultMsg = MapUtils.getString((Map)responseMap, (Object)"resultMsg");
        if ("false".equals(resultFlag)) {
            this.LOGGER.error("ConfCenterService.getShadowTableFromPradar  " + resultMsg);
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_SHADOWCONFIG_GET_FROM_PRADAR_EXCEPTION);
        }
        String json = JSON.toJSONString(responseMap.get("data"));
        List shadowTableConfigList = (List)JSON.parseObject((String)json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (CollectionUtils.isEmpty((Collection)shadowTableConfigList)) {
            return;
        }
        List shadowDataSourceList = this.tShadowTableDataSourceDao.queryShadowDataSourceByApplicationId(applicationId);
        HashMap shadowDatasourceMap = Maps.newHashMapWithExpectedSize((int)shadowTableConfigList.size());
        ArrayList needSaveList = Lists.newArrayListWithExpectedSize((int)shadowTableConfigList.size());
        this.getNeedSaveShadowDatasource(applicationId, shadowTableConfigList, shadowDataSourceList, (Map)shadowDatasourceMap, (List)needSaveList);
        if (CollectionUtils.isNotEmpty((Collection)needSaveList)) {
            this.tShadowTableDataSourceDao.insertList((List)needSaveList);
        }
        for (TPradarShadowTableConfig tableConfig : shadowTableConfigList) {
            if (StringUtils.isEmpty((CharSequence)tableConfig.getName()) || StringUtils.isEmpty((CharSequence)tableConfig.getName()) || CollectionUtils.isEmpty((Collection)tableConfig.getTables())) continue;
            TShadowTableDataSource shadowTableDataSource = (TShadowTableDataSource)shadowDatasourceMap.get(tableConfig.getUrl() + tableConfig.getName().toUpperCase());
            if (tableConfig.getTables().size() > 200) {
                int i = 1;
                boolean loop = true;
                do {
                    List subList = null;
                    if (tableConfig.getTables().size() > i * 200) {
                        subList = tableConfig.getTables().subList((i - 1) * 200, i * 200);
                    } else {
                        subList = tableConfig.getTables().subList((i - 1) * 200, tableConfig.getTables().size());
                        loop = false;
                    }
                    ++i;
                    this.saveShadowTableConfig(shadowTableDataSource, subList);
                } while (loop);
                continue;
            }
            this.saveShadowTableConfig(shadowTableDataSource, tableConfig.getTables());
        }
    }

    private void getNeedSaveShadowDatasource(Long applicationId, List<TPradarShadowTableConfig> shadowTableConfigList, List<TShadowTableDataSource> shadowDataSourceList, Map<String, TShadowTableDataSource> shadowDatasourceMap, List<TShadowTableDataSource> needSaveList) {
        if (CollectionUtils.isNotEmpty(shadowDataSourceList)) {
            for (TPradarShadowTableConfig tableConfig : shadowTableConfigList) {
                boolean pradarDatasourceExist = false;
                for (TShadowTableDataSource dataSource : shadowDataSourceList) {
                    if (!dataSource.getDatabaseIpport().equalsIgnoreCase(tableConfig.getUrl()) || !dataSource.getDatabaseName().equalsIgnoreCase(tableConfig.getName())) continue;
                    pradarDatasourceExist = true;
                    shadowDatasourceMap.put(dataSource.getDatabaseIpport() + dataSource.getDatabaseName(), dataSource);
                    break;
                }
                if (pradarDatasourceExist) continue;
                TShadowTableDataSource tShadowTableDataSource = new TShadowTableDataSource();
                tShadowTableDataSource.setShadowDatasourceId(Long.valueOf(this.snowflake.next()));
                tShadowTableDataSource.setDatabaseIpport(tableConfig.getUrl());
                tShadowTableDataSource.setDatabaseName(tableConfig.getName().toUpperCase());
                tShadowTableDataSource.setApplicationId(applicationId);
                tShadowTableDataSource.setUseShadowTable(Constants.INTEGER_NOT_USE);
                shadowDatasourceMap.put(tShadowTableDataSource.getDatabaseIpport() + tShadowTableDataSource.getDatabaseName().toUpperCase(), tShadowTableDataSource);
                needSaveList.add(tShadowTableDataSource);
            }
        } else {
            for (TPradarShadowTableConfig tableConfig : shadowTableConfigList) {
                TShadowTableDataSource tShadowTableDataSource = new TShadowTableDataSource();
                tShadowTableDataSource.setShadowDatasourceId(Long.valueOf(this.snowflake.next()));
                tShadowTableDataSource.setDatabaseIpport(tableConfig.getUrl());
                tShadowTableDataSource.setDatabaseName(tableConfig.getName().toUpperCase());
                tShadowTableDataSource.setApplicationId(applicationId);
                tShadowTableDataSource.setUseShadowTable(Constants.INTEGER_NOT_USE);
                shadowDatasourceMap.put(tShadowTableDataSource.getDatabaseIpport() + tShadowTableDataSource.getDatabaseName().toUpperCase(), tShadowTableDataSource);
                needSaveList.add(tShadowTableDataSource);
            }
        }
    }

    private void saveShadowTableConfig(TShadowTableDataSource shadowTableDataSource, List<TPradarShadowTable> shadowTables) {
        ArrayList tableNameList = Lists.newArrayListWithExpectedSize((int)shadowTables.size());
        shadowTables.forEach(table -> tableNameList.add(table.getTableName().toUpperCase()));
        List existTableConfigs = this.tShadowTableConfigDao.queryShadowTableByDatasourceId(shadowTableDataSource.getShadowDatasourceId(), (List)tableNameList);
        ArrayList saveList = new ArrayList();
        shadowTables.forEach(table -> {
            boolean exist = false;
            for (TShadowTableConfig existTable : existTableConfigs) {
                if (!existTable.getShadowTableName().equalsIgnoreCase(table.getTableName())) continue;
                exist = true;
                break;
            }
            if (!exist) {
                TShadowTableConfig saveTable = new TShadowTableConfig(Long.valueOf(this.snowflake.next()), shadowTableDataSource.getShadowDatasourceId(), table.getTableName().toUpperCase(), Constants.INTEGER_NOT_USE);
                for (String opType : table.getOpType()) {
                    if (!Constants.SQL_DDL_OPERTYPE.contains(opType)) continue;
                    saveTable.setEnableStatus(Constants.INTEGER_USE);
                    break;
                }
                saveList.add(saveTable);
            }
        });
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.tShadowTableConfigDao.insertList(saveList);
        }
    }

    public PageInfo<TShadowTableConfigVo> queryShadowTableConfigPage(Map<String, Object> paramMap) {
        PageHelper.startPage((int)PageInfo.getPageNum(paramMap), (int)PageInfo.getPageSize(paramMap));
        List tableConfigVoList = this.tShadowTableConfigDao.queryShadowTableConfigPage(paramMap);
        return new PageInfo(CollectionUtils.isEmpty((Collection)tableConfigVoList) ? Lists.newArrayList() : tableConfigVoList);
    }

    public void updateShadowTableConfig(TShadowTableConfigVo shadowTableConfigVo) throws TROModuleException {
        if (StringUtils.isEmpty((CharSequence)shadowTableConfigVo.getId()) || StringUtils.isEmpty((CharSequence)shadowTableConfigVo.getShadowTableName()) || shadowTableConfigVo.getEnableStatus() == null || StringUtils.isEmpty((CharSequence)shadowTableConfigVo.getShadowDatasourceId())) {
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_SHADOWCONFIG_UPDATE_PARAM_EXCEPTION);
        }
        if (shadowTableConfigVo.getShadowTableName().length() > 127) {
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_SHADOWCONFIG_TABLENAME_LONG_EXCEPTION);
        }
        TShadowTableConfig queryShadowTableConfig = this.tShadowTableConfigDao.selectByPrimaryKey(Long.valueOf(Long.parseLong(shadowTableConfigVo.getId())));
        if (queryShadowTableConfig == null) {
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_SHADOWCONFIG_QUERY_ID_EXCEPTION);
        }
        TShadowTableDataSource queryShadowDatasource = this.tShadowTableDataSourceDao.selectByPrimaryKey(Long.valueOf(Long.parseLong(shadowTableConfigVo.getShadowDatasourceId())));
        if (queryShadowDatasource == null) {
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_SHADOWCONFIG_DATASOURCE_ID_EXCEPTION);
        }
        List existTableConfigs = this.tShadowTableConfigDao.queryShadowTableByDatasourceId(queryShadowDatasource.getShadowDatasourceId(), Arrays.asList(shadowTableConfigVo.getShadowTableName().toUpperCase()));
        if (CollectionUtils.isNotEmpty((Collection)existTableConfigs) && !((TShadowTableConfig)existTableConfigs.get(0)).getId().equals(Long.parseLong(shadowTableConfigVo.getId()))) {
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_SHADOWCONFIG_UPDATE_SAME_EXCEPTION);
        }
        TShadowTableConfig shadowTableConfig = new TShadowTableConfig();
        BeanUtils.copyProperties((Object)shadowTableConfigVo, (Object)shadowTableConfig);
        shadowTableConfig.setId(Long.valueOf(Long.parseLong(shadowTableConfigVo.getId())));
        shadowTableConfig.setShadowDatasourceId(Long.valueOf(Long.parseLong(shadowTableConfigVo.getShadowDatasourceId())));
        shadowTableConfig.setShadowTableName(shadowTableConfigVo.getShadowTableName().toUpperCase());
        this.tShadowTableConfigDao.updateByPrimaryKeySelective(shadowTableConfig);
    }

    public void deleteShadowTableByIdList(String idList) throws TROModuleException {
        if (StringUtils.isEmpty((CharSequence)idList)) {
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_SHADOWCONFIG_DELETE_EXCEPTION);
        }
        this.tShadowTableConfigDao.deleteByIdList(Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)idList));
    }

    public List<TShadowTableConfigVo> queryApplicationDatabaseIpPortAndName(String applicationId) {
        return this.tShadowTableDataSourceDao.queryDatabaseIpPortAndName(applicationId);
    }

    public void saveShadowTableConfig(TShadowTableConfigVo shadowTableConfigVo) throws TROModuleException {
        if (StringUtils.isEmpty((CharSequence)shadowTableConfigVo.getShadowDatasourceId()) || StringUtils.isEmpty((CharSequence)shadowTableConfigVo.getShadowTableName()) || shadowTableConfigVo.getEnableStatus() == null) {
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_SHADOWCONFIG_ADD_PARAM_EXCEPTION);
        }
        TShadowTableDataSource queryShadowDatasource = this.tShadowTableDataSourceDao.selectByPrimaryKey(Long.valueOf(Long.parseLong(shadowTableConfigVo.getShadowDatasourceId())));
        if (queryShadowDatasource == null) {
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_SHADOWCONFIG_DATASOURCE_ID_EXCEPTION);
        }
        String[] talbeNames = shadowTableConfigVo.getShadowTableName().split(",");
        ArrayList<TShadowTableConfig> tableConfigList = new ArrayList<TShadowTableConfig>(talbeNames.length);
        ArrayList<String> tableNameList = new ArrayList<String>(talbeNames.length);
        for (String tableName : talbeNames) {
            if (tableName.length() > 127) {
                throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_SHADOWCONFIG_TABLENAME_LONG_EXCEPTION);
            }
            tableNameList.add(tableName.toUpperCase());
        }
        List existTableConfigList = this.tShadowTableConfigDao.queryShadowTableByDatasourceId(queryShadowDatasource.getShadowDatasourceId(), tableNameList);
        for (String tableName : talbeNames) {
            boolean existTableName = false;
            for (TShadowTableConfig existTable : existTableConfigList) {
                if (!existTable.getShadowTableName().equalsIgnoreCase(tableName)) continue;
                existTableName = true;
                break;
            }
            if (existTableName) continue;
            TShadowTableConfig tableConfig = new TShadowTableConfig(Long.valueOf(this.snowflake.next()), queryShadowDatasource.getShadowDatasourceId(), tableName.toUpperCase(), shadowTableConfigVo.getEnableStatus());
            tableConfigList.add(tableConfig);
        }
        if (CollectionUtils.isNotEmpty(tableConfigList)) {
            this.tShadowTableConfigDao.insertList(tableConfigList);
        }
    }

    public List<String> queryDatabaseIpPortList(String applicationId, String dbName) {
        return this.tShadowTableDataSourceDao.queryDatabaseIpPortList(applicationId, dbName);
    }

    public List<Map<String, Object>> queryDatabaseNameList(String applicationId, String ipPort) {
        List maps = this.tShadowTableDataSourceDao.queryDatabaseNameList(applicationId, ipPort);
        return maps;
    }

    public PageInfo<TShadowTableConfigVo> queryShadowDBApplicationList(Map<String, Object> paramMap) {
        if (!StringUtils.equals((CharSequence)"-1", (CharSequence)MapUtils.getString(paramMap, (Object)"pageSize"))) {
            PageHelper.startPage((int)PageInfo.getPageNum(paramMap), (int)PageInfo.getPageSize(paramMap));
        }
        List shadowTableConfigVoList = this.tShadowTableDataSourceDao.queryShadowDBApplicationList(paramMap);
        return new PageInfo(shadowTableConfigVoList);
    }

    public void saveShadowDatasource(TShadowTableDatasourceVo shadowDatasourceVo) throws TROModuleException {
        if (StringUtils.isEmpty((CharSequence)shadowDatasourceVo.getApplicationId()) || StringUtils.isEmpty((CharSequence)shadowDatasourceVo.getDatabaseIpport()) || StringUtils.isEmpty((CharSequence)shadowDatasourceVo.getDatabaseName()) || shadowDatasourceVo.getUseShadowTable() == null) {
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_SHADOW_DATASOURCE_SAVE_EXCEPTION);
        }
        shadowDatasourceVo.setDatabaseName(shadowDatasourceVo.getDatabaseName().toUpperCase());
        Long datasourceId = this.tShadowTableDataSourceDao.queryShadowTableDatasourceId(Long.valueOf(Long.parseLong(shadowDatasourceVo.getApplicationId())), shadowDatasourceVo.getDatabaseName(), shadowDatasourceVo.getDatabaseIpport());
        if (datasourceId != null) {
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_SHADOW_DATASOURCE_EXIST_EXCEPTION);
        }
        TShadowTableDataSource shadowTableDataSource = new TShadowTableDataSource();
        BeanUtils.copyProperties((Object)shadowDatasourceVo, (Object)shadowTableDataSource);
        shadowTableDataSource.setShadowDatasourceId(Long.valueOf(this.snowflake.next()));
        shadowTableDataSource.setApplicationId(Long.valueOf(Long.parseLong(shadowDatasourceVo.getApplicationId())));
        this.tShadowTableDataSourceDao.insert(shadowTableDataSource);
    }

    public void updateShadowDatasource(TShadowTableDatasourceVo shadowDatasourceVo) throws TROModuleException {
        Long datasourceId;
        if (StringUtils.isEmpty((CharSequence)shadowDatasourceVo.getShadowDatasourceId())) {
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_SHADOW_DATASOURCE_EXIST_EXCEPTION);
        }
        if (StringUtils.isNotEmpty((CharSequence)shadowDatasourceVo.getApplicationId()) && StringUtils.isNotEmpty((CharSequence)shadowDatasourceVo.getDatabaseName()) && StringUtils.isNotEmpty((CharSequence)shadowDatasourceVo.getDatabaseIpport()) && (datasourceId = this.tShadowTableDataSourceDao.queryShadowTableDatasourceId(Long.valueOf(Long.parseLong(shadowDatasourceVo.getApplicationId())), shadowDatasourceVo.getDatabaseName().toUpperCase(), shadowDatasourceVo.getDatabaseIpport())) != null && !datasourceId.toString().equals(shadowDatasourceVo.getShadowDatasourceId())) {
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_SHADOW_DATASOURCE_EXIST_EXCEPTION);
        }
        TShadowTableDataSource shadowTableDataSource = new TShadowTableDataSource();
        BeanUtils.copyProperties((Object)shadowDatasourceVo, (Object)shadowTableDataSource);
        shadowTableDataSource.setShadowDatasourceId(Long.valueOf(Long.parseLong(shadowDatasourceVo.getShadowDatasourceId())));
        if (StringUtils.isNotEmpty((CharSequence)shadowDatasourceVo.getDatabaseName())) {
            shadowTableDataSource.setDatabaseName(shadowDatasourceVo.getDatabaseName().toUpperCase());
        }
        if (StringUtils.isNotEmpty((CharSequence)shadowDatasourceVo.getApplicationId())) {
            shadowTableDataSource.setApplicationId(Long.valueOf(Long.parseLong(shadowDatasourceVo.getApplicationId())));
        }
        this.tShadowTableDataSourceDao.updateByPrimaryKeySelective(shadowTableDataSource);
    }

    public List<Map<String, Object>> getDatasourceApplication(String useShadowTable) {
        return (List)this.transferElementToString((Object)this.tShadowTableDataSourceDao.queryDatasourceApplicationdata(useShadowTable));
    }

    private static /* synthetic */ void lambda$getShadowTableFromPradar$2(MultiValueMap params, String s, Object o) {
        params.add((Object)s, (Object)(o + ""));
    }
}

