/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service;

import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.entity.dao.transparentflow.TPressureTimeRecordDao;
import com.pamirs.tro.entity.domain.entity.TPressureTimeRecord;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PressureTimeRecordService {
    @Autowired
    private TPressureTimeRecordDao tPressureTimeRecordDao;

    public void savePressureTimeRecord(TPressureTimeRecord pressureTimeRecord) throws TROModuleException {
        String startTime = pressureTimeRecord.getStartTime();
        if (startTime == null) {
            throw new TROModuleException(TROErrorEnum.PRESSURE_TIME_RECORD_SAVE_PARAM_EXCEPTION);
        }
        TPressureTimeRecord record = this.tPressureTimeRecordDao.queryLatestPressureTime();
        if (record != null && StringUtils.isNotEmpty((CharSequence)record.getStartTime())) {
            throw new TROModuleException(TROErrorEnum.PRESSURE_TIME_RECORD_EXIST_EXCEPTION);
        }
        this.tPressureTimeRecordDao.insert(startTime);
    }

    public void updatePressureTimeRecord(TPressureTimeRecord pressureTimeRecord) throws TROModuleException {
        String recordId = pressureTimeRecord.getRecordId();
        String endTime = pressureTimeRecord.getEndTime();
        if (StringUtils.isEmpty((CharSequence)recordId) || StringUtils.isEmpty((CharSequence)endTime)) {
            throw new TROModuleException(TROErrorEnum.PRESSURE_TIME_RECORD_UPDATE_PARAM_EXCEPTION);
        }
        this.tPressureTimeRecordDao.updateByPrimaryKey(recordId, endTime);
    }

    public TPressureTimeRecord queryLatestPressureTime() throws TROModuleException {
        return this.tPressureTimeRecordDao.queryLatestPressureTime();
    }
}

