/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service;

import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.constant.PressureOperateEnum;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.common.util.DateUtils;
import com.pamirs.tro.common.util.PageInfo;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.dao.pressureready.TLinkDetectionDao;
import com.pamirs.tro.entity.domain.vo.TDataBuild;
import com.pamirs.tro.entity.domain.vo.TLinkDetection;
import io.shulie.tro.web.app.common.CommonService;
import io.shulie.tro.web.app.service.PressureReadyService;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class PressureReadyService
extends CommonService {
    public static void main(String[] args) {
        String url = "https://192.168.122.26:9090/sto-web-taobaotrack/track/taoBaoTrack!trackForJson.action";
        String newUrl = "";
        if (url.startsWith("http://")) {
            newUrl = url.substring(0, 7);
            url = url.substring(7);
        } else if (url.startsWith("https://")) {
            newUrl = url.substring(0, 8);
            url = url.substring(8);
        }
        int index = -1;
        index = url.indexOf("/");
        if (index != -1) {
            String ip = url.substring(0, url.indexOf("/"));
            System.out.println(newUrl + ip);
        }
    }

    public static int appearNumber(String srcText, String findText) {
        int count = 0;
        Pattern p = Pattern.compile(findText);
        Matcher m = p.matcher(srcText);
        while (m.find()) {
            ++count;
        }
        return count;
    }

    public void debugSwitch(List<Map<String, Object>> switchList, PressureOperateEnum pressureOperateEnum) throws TROModuleException {
        if (switchList.isEmpty()) {
            throw new TROModuleException(TROErrorEnum.BUILDDATA_DEBUG_SWITCH_PARAMLACK);
        }
        ConcurrentMap<String, List<Map>> debugSwitch = switchList.stream().distinct().collect(Collectors.groupingByConcurrent(map -> map.get("debugSwitch").toString()));
        debugSwitch.forEach((debugSwitchString, mapList) -> {
            HashMap paramMap = Maps.newHashMap();
            paramMap.put("applicationIdLists", mapList.stream().map(map -> map.get("applicationId").toString()).collect(Collectors.toList()));
            if ("on".equals(debugSwitchString)) {
                paramMap.put("status", "2");
            } else if ("off".equals(debugSwitchString)) {
                paramMap.put("status", "0");
            }
            switch (4.$SwitchMap$com$pamirs$tro$common$constant$PressureOperateEnum[pressureOperateEnum.ordinal()]) {
                case 1: {
                    this.TDataBuildDao.debugSwitchUpdate((Map)paramMap);
                    return;
                }
                case 2: {
                    this.TLinkDetectionDao.debugSwitchUpdateByCheck((Map)paramMap);
                    return;
                }
            }
        });
    }

    public PageInfo<TDataBuild> queryBuildinfo(Map<String, Object> paramMap) {
        PageHelper.startPage((int)PageInfo.getPageNum(paramMap), (int)PageInfo.getPageSize(paramMap));
        List queryBuildinfo = this.TDataBuildDao.queryBuildinfo(paramMap);
        return new PageInfo(queryBuildinfo.isEmpty() ? Lists.newArrayList() : queryBuildinfo);
    }

    public void updateScriptExcuteStatus(Map<String, Object> map) {
        this.TDataBuildDao.updateScriptExcuteStatus(map);
    }

    public Map<String, Object> queryScriptExcuteStatus(String applicationId, String scriptType) {
        Map queryScriptExcuteStatus = this.TDataBuildDao.queryScriptExcuteStatus(applicationId, scriptType);
        String lastSuccessTime = MapUtils.getString((Map)queryScriptExcuteStatus, (Object)this.switchFunLastSuccessTime(scriptType));
        Date transferTime = DateUtils.transferTime((String)lastSuccessTime);
        queryScriptExcuteStatus.put(this.switchFunLastSuccessTime(scriptType), lastSuccessTime);
        return this.switchCaseFromMap(queryScriptExcuteStatus);
    }

    private String switchFunLastSuccessTime(String scriptType) {
        switch (scriptType) {
            case "1": {
                return "DDL_LAST_SUCCESS_TIME";
            }
            case "2": {
                return "CACHE_LAST_SUCCESS_TIME";
            }
            case "3": {
                return "READY_LAST_SUCCESS_TIME";
            }
            case "4": {
                return "BASIC_LAST_SUCCESS_TIME";
            }
            case "5": {
                return "CLEAN_LAST_SUCCESS_TIME";
            }
        }
        return scriptType;
    }

    public void executeScriptPreCheck(Map<String, Object> paraMap) throws TROModuleException {
        String applicationId = MapUtils.getString(paraMap, (Object)"applicationId");
        String scriptType = MapUtils.getString(paraMap, (Object)"scriptType");
        if (StringUtils.isEmpty((CharSequence)applicationId) && StringUtils.isEmpty((CharSequence)scriptType)) {
            throw new TROModuleException(TROErrorEnum.BUILDDATA_EXECUTE_SCRIPT_PARAMLACK);
        }
        Map cacheExpTimeMap = this.tApplicationMntDao.queryCacheExpTime(applicationId);
        if ("0".equals(MapUtils.getString((Map)cacheExpTimeMap, (Object)"cacheExpTime")) && "2".equals(scriptType)) {
            throw new TROModuleException(TROErrorEnum.BUILDDATA_EXECUTE_SCRIPTPATH_NOTCACHE);
        }
        this.updateScriptStatus(applicationId, scriptType, "1");
        this.runShellTaskExecutor.execute(this.executeScript(applicationId, scriptType));
    }

    public Runnable executeScript(String applicationId, String scriptType) {
        String scriptPath = this.tApplicationMntDao.selectScriptPath(applicationId, scriptType);
        String applicationName = this.tApplicationMntDao.selectApplicationName(applicationId);
        return () -> {
            if (StringUtils.isEmpty((CharSequence)scriptPath)) {
                this.updateScriptStatus(applicationId, scriptType, "3");
            } else {
                this.asynExecuteScriptThreadPool.execute(this.asyncExcuteScript(scriptPath, applicationId, scriptType));
            }
        };
    }

    private void updateScriptStatus(String applicationId, String scriptType, String resultStatus) {
        HashMap scriptStatusMap = Maps.newHashMap();
        scriptStatusMap.put("applicationId", applicationId);
        scriptStatusMap.put("resultStatus", resultStatus);
        scriptStatusMap.put("scriptType", scriptType);
        this.TDataBuildDao.updateScriptExcuteStatus((Map)scriptStatusMap);
    }

    public Runnable asyncExcuteScript(String scriptPath, String applicationId, String scriptType) {
        return () -> {
            ByteArrayOutputStream bytes;
            InputStream inputStream;
            Process ps;
            block5: {
                ps = null;
                inputStream = null;
                bytes = null;
                try {
                    ps = Runtime.getRuntime().exec(this.getBasePath() + scriptPath);
                    ps.waitFor();
                    inputStream = ps.getErrorStream();
                    bytes = new ByteArrayOutputStream();
                    byte[] bs = new byte[1024];
                    int len = 0;
                    while ((len = inputStream.read(bs)) > 0) {
                        bytes.write(bs, 0, len);
                    }
                    this.LOGGER.info("ERROR INFO : " + new String(bytes.toByteArray()));
                    String result = new String(bytes.toByteArray());
                    if (!StringUtils.isBlank((CharSequence)result)) break block5;
                    this.updateScriptStatus(applicationId, scriptType, "2");
                }
                catch (Exception e) {
                    try {
                        HashMap scriptParamMap = Maps.newHashMap();
                        scriptParamMap.put("resultStatus", "3");
                        scriptParamMap.put("scriptType", scriptType);
                        scriptParamMap.put("applicationId", applicationId);
                        this.TDataBuildDao.updateScriptExcuteStatus((Map)scriptParamMap);
                        this.LOGGER.error("\u5f02\u6b65\u7ebf\u7a0b\u6267\u884c\u811a\u672c\u5f02\u5e38", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        this.closeAll(null, inputStream, bytes, new Process[]{ps});
                        throw throwable;
                    }
                    this.closeAll(null, inputStream, bytes, new Process[]{ps});
                }
            }
            this.closeAll(null, inputStream, bytes, new Process[]{ps});
        };
    }

    public void batchClean(String applicationIds) {
        Arrays.stream(applicationIds.split(",")).filter(e -> StringUtils.isNotEmpty((CharSequence)e)).distinct().forEach(applicationId -> this.runShellTaskExecutor.execute(this.executeScript(applicationId, "5")));
    }

    public Map<String, Object> pressureTestCheck(String applicationId) {
        return this.TLinkDetectionDao.pressureTestCheck(applicationId);
    }

    public PageInfo<TLinkDetection> queryChecklist(Map<String, Object> paramMap) {
        PageHelper.startPage((int)PageInfo.getPageNum(paramMap), (int)PageInfo.getPageSize(paramMap));
        List checklist = this.TLinkDetectionDao.queryChecklist(paramMap);
        return new PageInfo(checklist.isEmpty() ? Lists.newArrayList() : checklist);
    }

    public Callable<Map<String, Object>> queryCheckShadowlib(String applicationId) {
        Map shadowLibMap = this.TDataBuildDao.queryCheckShadowlib(applicationId);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Callable<Map<String, Object>> queryCheckWList(String applicationId) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Callable<Map<String, Object>> queryCheckCache(String applicationId) {
        Map cacheStatusMap = this.TDataBuildDao.queryCacheStatus(applicationId);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Map<String, Object> batchCheck(String applicationIds) throws TROModuleException, Exception {
        HashMap resultMap = Maps.newHashMap();
        Collection<Callable> shadowlibWorkTasks = Collections.synchronizedCollection(new ArrayList());
        Collection<Callable> cacheWorkTasks = Collections.synchronizedCollection(new ArrayList());
        Collection<Callable> wListWorkTasks = Collections.synchronizedCollection(new ArrayList());
        List applicationIdsList = Arrays.stream(applicationIds.split(",")).filter(e -> StringUtils.isNotEmpty((CharSequence)e)).distinct().collect(Collectors.toList());
        for (String applicationId : applicationIdsList) {
            shadowlibWorkTasks.add(this.queryCheckShadowlib(applicationId));
            cacheWorkTasks.add(this.queryCheckCache(applicationId));
            wListWorkTasks.add(this.queryCheckWList(applicationId));
        }
        List shadowlibWorktask = this.executeWorktask((Executor)this.runShellTaskExecutor, shadowlibWorkTasks);
        List cacheWorktask = this.executeWorktask((Executor)this.runShellTaskExecutor, cacheWorkTasks);
        List wListWorktask = this.executeWorktask((Executor)this.runShellTaskExecutor, wListWorkTasks);
        boolean flag = true;
        for (Map shadowlibWorkMap : shadowlibWorktask) {
            if (!shadowlibWorkMap.containsValue("N")) continue;
            flag = false;
            break;
        }
        for (Map cacheWorkMap : cacheWorktask) {
            if (!cacheWorkMap.containsValue("N")) continue;
            flag = false;
            break;
        }
        for (Map wlistWorkMap : wListWorktask) {
            if (!wlistWorkMap.containsValue("N")) continue;
            flag = false;
            break;
        }
        if (flag) {
            HashMap newHashMap = Maps.newHashMap();
            newHashMap.put("success", "Y");
            return newHashMap;
        }
        resultMap.put("shadowlibCheck", shadowlibWorktask);
        resultMap.put("cacheCheck", cacheWorktask);
        resultMap.put("wlistCheck", wListWorktask);
        resultMap.put("success", "N");
        return resultMap;
    }

    static /* synthetic */ TLinkDetectionDao access$000(PressureReadyService x0) {
        return x0.TLinkDetectionDao;
    }

    static /* synthetic */ TLinkDetectionDao access$100(PressureReadyService x0) {
        return x0.TLinkDetectionDao;
    }

    static /* synthetic */ TLinkDetectionDao access$200(PressureReadyService x0) {
        return x0.TLinkDetectionDao;
    }

    static /* synthetic */ TLinkDetectionDao access$300(PressureReadyService x0) {
        return x0.TLinkDetectionDao;
    }

    static /* synthetic */ TLinkDetectionDao access$400(PressureReadyService x0) {
        return x0.TLinkDetectionDao;
    }

    static /* synthetic */ RestTemplate access$500(PressureReadyService x0) {
        return x0.restTemplate;
    }

    static /* synthetic */ RestTemplate access$600(PressureReadyService x0) {
        return x0.restTemplate;
    }

    static /* synthetic */ RestTemplate access$700(PressureReadyService x0) {
        return x0.restTemplate;
    }

    static /* synthetic */ RestTemplate access$800(PressureReadyService x0) {
        return x0.restTemplate;
    }

    static /* synthetic */ RestTemplate access$900(PressureReadyService x0) {
        return x0.restTemplate;
    }

    static /* synthetic */ RestTemplate access$1000(PressureReadyService x0) {
        return x0.restTemplate;
    }

    static /* synthetic */ TLinkDetectionDao access$1100(PressureReadyService x0) {
        return x0.TLinkDetectionDao;
    }

    static /* synthetic */ TLinkDetectionDao access$1200(PressureReadyService x0) {
        return x0.TLinkDetectionDao;
    }

    static /* synthetic */ TLinkDetectionDao access$1300(PressureReadyService x0) {
        return x0.TLinkDetectionDao;
    }

    static /* synthetic */ TLinkDetectionDao access$1400(PressureReadyService x0) {
        return x0.TLinkDetectionDao;
    }

    static /* synthetic */ TApplicationMntDao access$1500(PressureReadyService x0) {
        return x0.tApplicationMntDao;
    }

    static /* synthetic */ TLinkDetectionDao access$1600(PressureReadyService x0) {
        return x0.TLinkDetectionDao;
    }

    static /* synthetic */ TLinkDetectionDao access$1700(PressureReadyService x0) {
        return x0.TLinkDetectionDao;
    }

    static /* synthetic */ TLinkDetectionDao access$1800(PressureReadyService x0) {
        return x0.TLinkDetectionDao;
    }
}

