/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.constant.MQEnum;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.common.util.ProcessUtils;
import com.pamirs.tro.entity.dao.assist.mqproducer.TEbmProducerDao;
import com.pamirs.tro.entity.dao.assist.mqproducer.TRocketmqProducerDao;
import com.pamirs.tro.entity.domain.entity.TEbmProducer;
import com.pamirs.tro.entity.domain.entity.TRocketmqProducer;
import io.shulie.tro.web.app.common.CommonService;
import io.shulie.tro.web.app.service.MqProducerWithScriptService;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MqProducerWithScriptService
extends CommonService {
    private static List<String> mqTypeList = null;
    @Autowired
    public TRocketmqProducerDao TRocketmqProducerDao;
    @Autowired
    private TEbmProducerDao tEbmProducerDao;

    public void executeStartEbmScript(Map<String, Object> paraMap) throws TROModuleException {
        String mqtype = MapUtils.getString(paraMap, (Object)"msgType");
        if (!mqTypeList.contains(mqtype)) {
            throw new TROModuleException(TROErrorEnum.ASSIST_START_CONSUMER_PARAMERROR);
        }
        String tepId = MapUtils.getString(paraMap, (Object)"tepId");
        TEbmProducer tEbmProducer = this.tEbmProducerDao.selectEbmMsgById(Long.valueOf(Long.parseLong(tepId)));
        if (tEbmProducer == null) {
            throw new TROModuleException(TROErrorEnum.ASSIST_MQPRODUCER_EBM_MSG_NOTFOUND);
        }
        TEbmProducer originEbmProducer = tEbmProducer;
        tEbmProducer.setProduceStartTime(new Date());
        tEbmProducer.setLastProduceTime(tEbmProducer.getProduceEndTime());
        tEbmProducer.setProduceStatus("1");
        this.tEbmProducerDao.updateEbmStatus(tEbmProducer);
        this.runShellTaskExecutor.execute(this.asyncStarProduceScript(paraMap, MQEnum.ESB.toString().equals(mqtype) ? MQEnum.ESB : MQEnum.IBM));
    }

    public void executeStartRocketmqScript(Map<String, Object> paraMap) throws TROModuleException {
        String mqtype = MapUtils.getString(paraMap, (Object)"msgType");
        if (!mqTypeList.contains(mqtype)) {
            throw new TROModuleException(TROErrorEnum.ASSIST_START_CONSUMER_PARAMERROR);
        }
        String trpId = MapUtils.getString(paraMap, (Object)"trpId");
        TRocketmqProducer tRocketmqProducer = this.TRocketmqProducerDao.selectRocketMqMsgById(Long.parseLong(trpId));
        if (tRocketmqProducer == null) {
            throw new TROModuleException(TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_MSG_NOTFOUND);
        }
        TRocketmqProducer originEbmProducer = tRocketmqProducer;
        tRocketmqProducer.setProduceStartTime(new Date());
        tRocketmqProducer.setLastProduceTime(tRocketmqProducer.getProduceEndTime());
        tRocketmqProducer.setProduceStatus("1");
        this.TRocketmqProducerDao.updateRocketMqStatus(tRocketmqProducer);
        this.runShellTaskExecutor.execute(this.asyncStarProduceScript(paraMap, MQEnum.ROCKETMQ.toString().equals(mqtype) ? MQEnum.ROCKETMQ : MQEnum.DPBOOT_ROCKETMQ));
    }

    public Runnable asyncStarProduceScript(Map<String, Object> paraMap, MQEnum mqEnum) {
        String hostName = MapUtils.getString(paraMap, (Object)"msgHost");
        String port = MapUtils.getString(paraMap, (Object)"msgPort");
        String queueManager = MapUtils.getString(paraMap, (Object)"queueManager");
        String channel = MapUtils.getString(paraMap, (Object)"queueChannel");
        String CCSID = MapUtils.getString(paraMap, (Object)"ccsid");
        String esbcode = MapUtils.getString(paraMap, (Object)"esbcode");
        String requestComout = MapUtils.getString(paraMap, (Object)"requestComout");
        String tepId = MapUtils.getString(paraMap, (Object)"tepId");
        String topic = MapUtils.getString(paraMap, (Object)"topic");
        String groupName = MapUtils.getString(paraMap, (Object)"groupName");
        String clusterIp = MapUtils.getString(paraMap, (Object)"msgIp");
        String trpId = MapUtils.getString(paraMap, (Object)"trpId");
        String threadCount = MapUtils.getString(paraMap, (Object)"threadCount");
        String msgCount = MapUtils.getString(paraMap, (Object)"msgCount");
        String messageSize = MapUtils.getString(paraMap, (Object)"messageSize");
        String sleepTime = MapUtils.getString(paraMap, (Object)"sleepTime");
        String shStrPath = this.getBasePath() + this.getMqProducerScriptName();
        this.LOGGER.info("========================shStrPath===============" + shStrPath);
        return () -> {
            Process ps = null;
            Process process = null;
            InputStream inputStream = null;
            ByteArrayOutputStream bytes = null;
            try {
                String cmd = "";
                switch (1.$SwitchMap$com$pamirs$tro$common$constant$MQEnum[mqEnum.ordinal()]) {
                    case 1: {
                        cmd = shStrPath + " " + mqEnum.toString() + " " + hostName + " " + port + " " + queueManager + " " + channel + " " + CCSID + " " + esbcode + " " + requestComout + " " + threadCount + " " + msgCount + " " + messageSize + " " + sleepTime;
                        break;
                    }
                    case 2: {
                        cmd = shStrPath + " " + mqEnum.toString() + " " + hostName + " " + port + " " + queueManager + " " + channel + " " + CCSID + " " + esbcode + " " + requestComout + " " + threadCount + " " + msgCount + " " + messageSize + " " + sleepTime;
                        break;
                    }
                    case 3: {
                        cmd = shStrPath + " " + mqEnum.toString() + " " + topic + " " + groupName + " " + clusterIp + " " + threadCount + " " + msgCount + " " + messageSize + " " + sleepTime;
                        break;
                    }
                    case 4: {
                        cmd = shStrPath + " " + mqEnum.toString() + " " + topic + " " + groupName + " " + clusterIp + " " + threadCount + " " + msgCount + " " + messageSize + " " + sleepTime;
                        break;
                    }
                }
                ProcessBuilder builder = new ProcessBuilder("/bin/chmod", "755", shStrPath);
                ps = builder.start();
                ps.waitFor();
                this.LOGGER.info("\u811a\u672c\u7684\u547d\u4ee4\u4e3a: " + cmd);
                process = Runtime.getRuntime().exec(cmd);
                process.waitFor();
            }
            catch (Exception e) {
                try {
                    this.LOGGER.error("MqProducerWithScriptService.asyncStarProduceScript \u542f\u52a8\u6d88\u606f\u9519\u8bef{}", (Throwable)e);
                    this.updateFailedStatus(mqEnum, tepId, trpId);
                }
                catch (Throwable throwable) {
                    this.closeAll(null, inputStream, bytes, new Process[]{ps, process});
                    throw throwable;
                }
                this.closeAll(null, inputStream, bytes, new Process[]{ps, process});
            }
            this.closeAll(null, inputStream, bytes, new Process[]{ps, process});
        };
    }

    private void updateFailedStatus(MQEnum mqEnum, String tepId, String trpId) {
        boolean isRocketMq;
        boolean isEbm;
        boolean bl = isEbm = StringUtils.isNotEmpty((CharSequence)tepId) && (MQEnum.ESB.toString().equals(mqEnum.toString()) || MQEnum.IBM.toString().equals(mqEnum.toString()));
        if (isEbm) {
            this.tEbmProducerDao.updateEbmProduceStatus("3", null, null, tepId);
            return;
        }
        boolean bl2 = isRocketMq = StringUtils.isNotEmpty((CharSequence)trpId) && (MQEnum.ROCKETMQ.toString().equals(mqEnum.toString()) || MQEnum.DPBOOT_ROCKETMQ.toString().equals(mqEnum.toString()));
        if (isRocketMq) {
            this.TRocketmqProducerDao.updateRocketMqProduceStatus("3", null, null, trpId);
        }
    }

    public void stopMq(String mqType, String id) {
        HashMap paramMap = Maps.newHashMap();
        if ("1".equals(mqType) || "2".equals(mqType)) {
            TEbmProducer tEbmProducer = this.tEbmProducerDao.selectEbmMsgById(Long.valueOf(Long.parseLong(id)));
            paramMap.put("tepId", id);
            paramMap.put("msgType", "1".equals(mqType) ? MQEnum.ESB.toString() : MQEnum.IBM.toString());
            paramMap.put("msgHost", tEbmProducer.getMsgHost());
            paramMap.put("msgPort", tEbmProducer.getMsgPort());
            paramMap.put("queueManager", tEbmProducer.getQueueManager());
            paramMap.put("queueChannel", tEbmProducer.getQueueChannel());
            paramMap.put("ccsid", tEbmProducer.getCcsid());
            paramMap.put("esbcode", tEbmProducer.getEsbcode());
            paramMap.put("requestComout", tEbmProducer.getRequestComout());
            paramMap.put("threadCount", tEbmProducer.getThreadCount());
            paramMap.put("msgCount", tEbmProducer.getMsgCount());
            paramMap.put("messageSize", tEbmProducer.getMessageSize());
            paramMap.put("sleepTime", tEbmProducer.getSleepTime());
        }
        if ("3".equals(mqType) || "4".equals(mqType)) {
            TRocketmqProducer tRocketmqProducer = this.TRocketmqProducerDao.selectRocketMqMsgById(Long.parseLong(id));
            paramMap.put("trpId", id);
            paramMap.put("msgType", "3".equals(mqType) ? MQEnum.ROCKETMQ.toString() : MQEnum.DPBOOT_ROCKETMQ.toString());
            paramMap.put("topic", tRocketmqProducer.getTopic());
            paramMap.put("groupName", tRocketmqProducer.getGroupName());
            paramMap.put("msgIp", tRocketmqProducer.getMsgIp());
            paramMap.put("threadCount", tRocketmqProducer.getThreadCount());
            paramMap.put("msgCount", tRocketmqProducer.getMsgCount());
            paramMap.put("messageSize", tRocketmqProducer.getMessageSize());
            paramMap.put("sleepTime", tRocketmqProducer.getSleepTime());
        }
        this.executeStopProduceScript((Map)paramMap);
    }

    public void executeStopProduceScript(Map<String, Object> paraMap) {
        List piDs = this.getPIDs(paraMap);
        String mqtype = MapUtils.getString(paraMap, (Object)"msgType");
        if (MQEnum.ROCKETMQ.toString().equals(mqtype) || MQEnum.DPBOOT_ROCKETMQ.toString().equals(mqtype)) {
            this.killRocketmqProcess(piDs, MapUtils.getString(paraMap, (Object)"trpId"));
        } else {
            this.killEbmProcess(piDs, MapUtils.getString(paraMap, (Object)"tepId"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPIDs(Map<String, Object> paraMap) {
        Process process;
        StringBuffer sb;
        BufferedReader reader;
        block16: {
            String mqtype = MapUtils.getString(paraMap, (Object)"msgType");
            MQEnum mqEnum = null;
            if (MQEnum.ESB.toString().equals(mqtype)) {
                mqEnum = MQEnum.ESB;
            }
            if (MQEnum.IBM.toString().equals(mqtype)) {
                mqEnum = MQEnum.IBM;
            }
            if (MQEnum.ROCKETMQ.toString().equals(mqtype)) {
                mqEnum = MQEnum.ROCKETMQ;
            }
            if (MQEnum.DPBOOT_ROCKETMQ.toString().equals(mqtype)) {
                mqEnum = MQEnum.DPBOOT_ROCKETMQ;
            }
            String hostName = MapUtils.getString(paraMap, (Object)"msgHost");
            String port = MapUtils.getString(paraMap, (Object)"msgPort");
            String queueManager = MapUtils.getString(paraMap, (Object)"queueManager");
            String channel = MapUtils.getString(paraMap, (Object)"queueChannel");
            String CCSID = MapUtils.getString(paraMap, (Object)"ccsid");
            String esbcode = MapUtils.getString(paraMap, (Object)"esbcode");
            String requestComout = MapUtils.getString(paraMap, (Object)"requestComout");
            String tepId = MapUtils.getString(paraMap, (Object)"tepId");
            String topic = MapUtils.getString(paraMap, (Object)"topic");
            String groupName = MapUtils.getString(paraMap, (Object)"groupName");
            String clusterIp = MapUtils.getString(paraMap, (Object)"msgIp");
            String trpId = MapUtils.getString(paraMap, (Object)"trpId");
            String threatCount = MapUtils.getString(paraMap, (Object)"threadCount");
            String msgCount = MapUtils.getString(paraMap, (Object)"msgCount");
            String messageSize = MapUtils.getString(paraMap, (Object)"messageSize");
            String sleepTime = MapUtils.getString(paraMap, (Object)"sleepTime");
            String cmd = "";
            switch (1.$SwitchMap$com$pamirs$tro$common$constant$MQEnum[mqEnum.ordinal()]) {
                case 1: {
                    cmd = mqEnum.toString() + " " + hostName + " " + port + " " + queueManager + " " + channel + " " + CCSID + " " + esbcode + " " + requestComout + " " + threatCount + " " + msgCount + " " + messageSize + " " + sleepTime;
                    break;
                }
                case 2: {
                    cmd = mqEnum.toString() + " " + hostName + " " + port + " " + queueManager + " " + channel + " " + CCSID + " " + esbcode + " " + requestComout + " " + threatCount + " " + msgCount + " " + messageSize + " " + sleepTime;
                    break;
                }
                case 3: {
                    cmd = mqEnum.toString() + " " + topic + " " + groupName + " " + clusterIp + " " + threatCount + " " + msgCount + " " + messageSize + " " + sleepTime;
                    break;
                }
                case 4: {
                    cmd = mqEnum.toString() + " " + topic + " " + groupName + " " + clusterIp + " " + threatCount + " " + msgCount + " " + messageSize + " " + sleepTime;
                    break;
                }
            }
            cmd = " ps -ef | grep MqServerMain | grep \"" + cmd + "\" | grep -v grep";
            this.LOGGER.info("\u751f\u4ea7\u6d88\u606f\u505c\u6b62\u811a\u672c\u7684\u547d\u4ee4\u4e3a{} " + cmd);
            reader = null;
            BufferedReader brReader = null;
            sb = new StringBuffer();
            process = null;
            try {
                process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                int exit = process.waitFor();
                this.LOGGER.info("stop pid exit info ----->" + exit);
                if (exit == 0) break block16;
                brReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                StringBuilder errorDesc = new StringBuilder();
                String str = brReader.readLine();
                while (str != null) {
                    errorDesc.append(str);
                    str = brReader.readLine();
                }
                brReader.close();
                this.LOGGER.error("MqProducerWithScriptService.getPIDs \u6267\u884c\u811a\u672c\u9519\u8bef\u4fe1\u606f{}", (Object)errorDesc);
                this.updateFailedStatus(mqEnum, tepId, trpId);
            }
            catch (Exception e) {
                try {
                    this.LOGGER.error("MqProducerWithScriptService.getPIDs \u83b7\u53d6\u8fdb\u7a0b\u53f7\u6267\u884c\u811a\u672c\u5f02\u5e38{}", (Throwable)e);
                    this.updateFailedStatus(mqEnum, tepId, trpId);
                }
                catch (Throwable throwable) {
                    this.closeAll(reader, null, null, new Process[]{process});
                    throw throwable;
                }
                this.closeAll(reader, null, null, new Process[]{process});
            }
        }
        this.closeAll(reader, null, null, new Process[]{process});
        this.LOGGER.info("produce\u8fdb\u7a0b\u53f7\u96c6\u5408\u4e3a{}" + ProcessUtils.getPIdsList((String)sb.toString()));
        return ProcessUtils.getPIdsList((String)sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killRocketmqProcess(List<String> processStrs, String trpId) {
        BufferedReader brReader;
        Process process;
        block6: {
            process = null;
            brReader = null;
            TRocketmqProducer tRocketmqProducer = this.TRocketmqProducerDao.selectRocketMqMsgById(Long.parseLong(trpId));
            String pids = Joiner.on((String)" ").join(processStrs);
            try {
                process = Runtime.getRuntime().exec("kill -9 " + pids);
                int produceExit = process.waitFor();
                this.LOGGER.info("stop produceExit info ----->" + produceExit);
                if (produceExit == 0) {
                    tRocketmqProducer.setProduceStatus("2");
                    tRocketmqProducer.setProduceEndTime(new Date());
                    this.TRocketmqProducerDao.updateRocketMqStatus(tRocketmqProducer);
                    break block6;
                }
                brReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                StringBuilder errorDesc = new StringBuilder();
                String str = brReader.readLine();
                while (str != null) {
                    errorDesc.append(str);
                    str = brReader.readLine();
                }
                this.LOGGER.error("MqProducerWithScriptService.getPIDs \u6267\u884c\u811a\u672c\u9519\u8bef\u4fe1\u606f{}", (Object)errorDesc);
                this.TRocketmqProducerDao.updateRocketMqProduceStatus("3", null, null, trpId);
            }
            catch (Exception e) {
                try {
                    this.LOGGER.info("MqProducerWithScriptService.killRocketmqProcess \u6740\u6389\u8fdb\u7a0b\u5f02\u5e38{}", (Throwable)e);
                    this.TRocketmqProducerDao.updateRocketMqProduceStatus("3", null, null, trpId);
                }
                catch (Throwable throwable) {
                    this.closeAll(brReader, null, null, new Process[]{process});
                    throw throwable;
                }
                this.closeAll(brReader, null, null, new Process[]{process});
            }
        }
        this.closeAll(brReader, null, null, new Process[]{process});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killEbmProcess(List<String> processStrs, String tepId) {
        BufferedReader brReader;
        Process process;
        block6: {
            process = null;
            brReader = null;
            TEbmProducer tEbmProducer = this.tEbmProducerDao.selectEbmMsgById(Long.valueOf(Long.parseLong(tepId)));
            String pids = Joiner.on((String)" ").join(processStrs);
            try {
                process = Runtime.getRuntime().exec("kill -9 " + pids);
                int ebmExit = process.waitFor();
                if (ebmExit == 0) {
                    tEbmProducer.setProduceStatus("2");
                    tEbmProducer.setProduceEndTime(new Date());
                    this.tEbmProducerDao.updateEbmStatus(tEbmProducer);
                    break block6;
                }
                brReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                StringBuilder errorDesc = new StringBuilder();
                String str = brReader.readLine();
                while (str != null) {
                    errorDesc.append(str);
                    str = brReader.readLine();
                }
                this.LOGGER.error("MqProducerWithScriptService.getPIDs \u6267\u884c\u811a\u672c\u9519\u8bef\u4fe1\u606f{}", (Object)errorDesc);
                this.tEbmProducerDao.updateEbmProduceStatus("3", null, null, tepId);
            }
            catch (Exception e) {
                try {
                    this.LOGGER.info("MqProducerWithScriptService.killEbmProcess \u6740\u6389\u8fdb\u7a0b\u5f02\u5e38{}", (Throwable)e);
                    this.tEbmProducerDao.updateEbmProduceStatus("3", null, null, tepId);
                }
                catch (Throwable throwable) {
                    this.closeAll(brReader, null, null, new Process[]{process});
                    throw throwable;
                }
                this.closeAll(brReader, null, null, new Process[]{process});
            }
        }
        this.closeAll(brReader, null, null, new Process[]{process});
    }

    static {
        mqTypeList = Lists.newArrayList((Object[])MQEnum.values()).stream().map(mqEnum -> mqEnum.toString()).collect(Collectors.toList());
    }
}

