/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service;

import com.github.pagehelper.PageHelper;
import com.google.common.base.Splitter;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.common.util.PageInfo;
import com.pamirs.tro.entity.dao.assist.mqproducer.TEbmProducerDao;
import com.pamirs.tro.entity.dao.assist.mqproducer.TRocketmqProducerDao;
import com.pamirs.tro.entity.domain.entity.TEbmProducer;
import com.pamirs.tro.entity.domain.entity.TRocketmqProducer;
import io.shulie.tro.web.app.common.CommonService;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MqProducerService
extends CommonService {
    @Autowired
    public TRocketmqProducerDao TRocketmqProducerDao;
    @Autowired
    private TEbmProducerDao tEbmProducerDao;

    public void addRocketmq(TRocketmqProducer tRocketmqProducer) throws TROModuleException {
        int rocketmqExist = this.TRocketmqProducerDao.isRocketmqExist(tRocketmqProducer);
        if (rocketmqExist > 0) {
            throw new TROModuleException(TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_SAVE_DUPICATE);
        }
        tRocketmqProducer.setTrpId(Long.valueOf(this.snowflake.next()));
        tRocketmqProducer.setProduceStatus("0");
        String regex = "^[1-9]+[0-9]*$";
        Pattern p = Pattern.compile(regex);
        Matcher m1 = p.matcher(tRocketmqProducer.getSleepTime());
        Matcher m2 = p.matcher(tRocketmqProducer.getMsgCount());
        if (!m1.find() || !m2.find()) {
            throw new TROModuleException(TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_SAVE_EXCEPTION);
        }
        this.TRocketmqProducerDao.insert(tRocketmqProducer);
    }

    public void updateRocketmq(TRocketmqProducer tRocketmqProducer) throws TROModuleException {
        Long rocketmqExist = tRocketmqProducer.getTrpId();
        TRocketmqProducer rocketmqExistById = this.TRocketmqProducerDao.isRocketmqExistById(rocketmqExist);
        if (rocketmqExistById != null) {
            String regex = "^[1-9]+[0-9]*$";
            Pattern p = Pattern.compile(regex);
            Matcher m1 = p.matcher(tRocketmqProducer.getSleepTime());
            Matcher m2 = p.matcher(tRocketmqProducer.getMsgCount());
            if (m1.find() && m2.find()) {
                this.TRocketmqProducerDao.update(tRocketmqProducer);
            }
        } else {
            throw new TROModuleException(TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_UPDATE_EXCEPTION);
        }
    }

    public void saveEbm(TEbmProducer tEbmProducer) throws TROModuleException {
        int exist = this.tEbmProducerDao.selectEbmExist(tEbmProducer);
        if (exist > 0) {
            throw new TROModuleException(TROErrorEnum.ASSIST_MQPRODUCER_EBM_SAVE_DUPICATE);
        }
        tEbmProducer.setTepId(Long.valueOf(this.snowflake.next()));
        tEbmProducer.setProduceStatus("0");
        tEbmProducer.setEsbcode(this.filterIllegalCharacters(tEbmProducer.getEsbcode()));
        this.tEbmProducerDao.saveEbm(tEbmProducer);
    }

    public void updateEbm(TEbmProducer tEbmProducer) throws TROModuleException {
        TEbmProducer ebmProducer = this.tEbmProducerDao.selectEbmMsgById(tEbmProducer.getTepId());
        if (ebmProducer == null) {
            throw new TROModuleException(TROErrorEnum.ASSIST_MQPRODUCER_EBM_NOT_FOUNT_EXCEPTION);
        }
        this.tEbmProducerDao.updateEbm(tEbmProducer);
    }

    public PageInfo<TRocketmqProducer> queryRocketmqList(Map<String, Object> paramMap) {
        PageHelper.startPage((int)PageInfo.getPageNum(paramMap), (int)PageInfo.getPageSize(paramMap));
        List rocketmqProducerList = this.TRocketmqProducerDao.queryRocketmqList(paramMap);
        return new PageInfo(rocketmqProducerList);
    }

    public void deteletRocketMq(String trpIds) {
        List trpIdList = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)trpIds);
        this.TRocketmqProducerDao.batchDeleteRocketMq(trpIdList);
        List tRocketmqProducers = this.TRocketmqProducerDao.queryRocketMqListByIds(trpIdList);
    }

    public TRocketmqProducer queryRocketeMqDetail(String trpId) {
        TRocketmqProducer tRocketmqProducer = this.TRocketmqProducerDao.queryRocketmqDetail(trpId);
        return tRocketmqProducer;
    }

    public TEbmProducer queryEsbOrIbmDetail(String tepId) {
        TEbmProducer tEbmProducer = this.tEbmProducerDao.selectEbmMsgById(Long.valueOf(Long.parseLong(tepId)));
        return tEbmProducer;
    }

    public PageInfo<TEbmProducer> queryEsbAndIbmList(Map<String, Object> paramMap) {
        PageHelper.startPage((int)PageInfo.getPageNum(paramMap), (int)PageInfo.getPageSize(paramMap));
        List ebmProducerList = this.tEbmProducerDao.queryEsbAndIbmList(paramMap);
        return new PageInfo(ebmProducerList);
    }

    public void deteletEsbOrIbm(String tepIds) {
        List tepIdList = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)tepIds);
        this.tEbmProducerDao.batchDeleteEsbAndIbm(tepIdList);
        List tEbmProducers = this.tEbmProducerDao.queryEBMProduceListByIds(tepIdList);
    }
}

