/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service;

import com.github.pagehelper.PageHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.pamirs.tro.common.constant.MQEnum;
import com.pamirs.tro.common.constant.TRODictTypeEnum;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.common.util.PageInfo;
import com.pamirs.tro.common.util.ProcessUtils;
import com.pamirs.tro.entity.dao.assist.mqconsumer.TMqMsgDao;
import com.pamirs.tro.entity.domain.entity.TMqMsg;
import io.shulie.tro.web.app.common.CommonService;
import io.shulie.tro.web.app.service.ConfCenterService;
import io.shulie.tro.web.app.service.MqConsumerService;
import io.shulie.tro.web.app.utils.GlobalVariableUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MqConsumerService
extends CommonService {
    private static List<String> mqTypeList = null;
    @Autowired
    public TMqMsgDao TMqMsgDao;
    @Autowired
    private ConfCenterService confCenterService;

    public void executeStartConsumerScript(Map<String, Object> paraMap) throws TROModuleException {
        TMqMsg tMqMsg;
        String mqtype = MapUtils.getString(paraMap, (Object)"msgType");
        if (!mqTypeList.contains(mqtype)) {
            throw new TROModuleException(TROErrorEnum.ASSIST_START_CONSUMER_PARAMERROR);
        }
        String msgId = MapUtils.getString(paraMap, (Object)"msgId");
        TMqMsg originMqMsg = tMqMsg = this.TMqMsgDao.selectMqMsgById(Long.valueOf(Long.parseLong(msgId)));
        if (tMqMsg == null) {
            throw new TROModuleException(TROErrorEnum.ASSIST_START_CONSUMER_MSG_NOTFOUND);
        }
        tMqMsg.setConsumeStartTime(new Date());
        tMqMsg.setLastConsumeTime(tMqMsg.getConsumeEndTime());
        tMqMsg.setConsumeStatus("1");
        this.TMqMsgDao.updateByPrimaryKey(tMqMsg);
        MQEnum mqEnum = this.getMqEnum(mqtype);
        this.runShellTaskExecutor.execute(this.asyncStartConsumerScript(paraMap, mqEnum));
    }

    public Runnable asyncStartConsumerScript(Map<String, Object> paraMap, MQEnum mqEnum) {
        String queueManager = MapUtils.getString(paraMap, (Object)"queueManager");
        String hostName = MapUtils.getString(paraMap, (Object)"msgHost");
        String channel = MapUtils.getString(paraMap, (Object)"queueChannel");
        String port = MapUtils.getString(paraMap, (Object)"msgPort");
        String clusterIp = MapUtils.getString(paraMap, (Object)"msgIp");
        String transporttype = MapUtils.getString(paraMap, (Object)"transportType");
        String CCSID = MapUtils.getString(paraMap, (Object)"ccsid");
        String baseQueueName = MapUtils.getString(paraMap, (Object)"baseQueueName");
        String esbcode = MapUtils.getString(paraMap, (Object)"esbcode");
        String msgId = MapUtils.getString(paraMap, (Object)"msgId");
        String topic = MapUtils.getString(paraMap, (Object)"topic");
        String groupName = MapUtils.getString(paraMap, (Object)"groupName");
        String shStrPath = this.getBasePath() + this.getMqScriptName();
        return () -> {
            Process ps = null;
            Process process = null;
            InputStream inputStream = null;
            ByteArrayOutputStream bytes = null;
            try {
                String cmd = "";
                switch (2.$SwitchMap$com$pamirs$tro$common$constant$MQEnum[mqEnum.ordinal()]) {
                    case 1: {
                        cmd = shStrPath + " " + mqEnum.toString() + " " + queueManager + " " + hostName + " " + channel + " " + port + " " + CCSID + " " + baseQueueName + " " + transporttype + " " + esbcode;
                        break;
                    }
                    case 2: {
                        cmd = shStrPath + " " + mqEnum.toString() + " " + queueManager + " " + hostName + " " + channel + " " + port + " " + transporttype + " " + esbcode;
                        break;
                    }
                    case 3: {
                        cmd = shStrPath + " " + mqEnum.toString() + " " + topic + " " + groupName + " " + clusterIp;
                        break;
                    }
                    case 4: {
                        cmd = shStrPath + " " + mqEnum.toString() + " " + topic + " " + groupName + " " + clusterIp;
                        break;
                    }
                }
                ProcessBuilder builder = new ProcessBuilder("/bin/chmod", "755", shStrPath);
                ps = builder.start();
                ps.waitFor();
                this.LOGGER.info("\u811a\u672c\u7684\u547d\u4ee4\u4e3a: " + cmd);
                process = Runtime.getRuntime().exec(cmd);
                process.waitFor();
            }
            catch (Exception e) {
                try {
                    this.TMqMsgDao.updateConsumeStatusById(msgId, "3");
                    this.LOGGER.error("PressureMeasurementAssistService.asyncStartConsumerScript \u542f\u52a8\u6d88\u606f\u9519\u8bef{}", (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.closeAll(null, inputStream, bytes, new Process[]{ps, process});
                    throw throwable;
                }
                this.closeAll(null, inputStream, bytes, new Process[]{ps, process});
            }
            this.closeAll(null, inputStream, bytes, new Process[]{ps, process});
        };
    }

    public void asyncStopConsumerScript(Map<String, Object> paraMap) {
        List piDs = this.getPIDs(paraMap);
        this.killLinuxProcess(piDs, MapUtils.getString(paraMap, (Object)"msgId"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPIDs(Map<String, Object> paraMap) {
        Process process;
        ByteArrayOutputStream bytes;
        InputStream inputStream;
        StringBuffer sb;
        BufferedReader reader;
        block11: {
            String mqtype = MapUtils.getString(paraMap, (Object)"msgType");
            MQEnum mqEnum = this.getMqEnum(mqtype);
            String msgId = MapUtils.getString(paraMap, (Object)"msgId");
            String queueManager = MapUtils.getString(paraMap, (Object)"queueManager");
            String hostName = MapUtils.getString(paraMap, (Object)"msgHost");
            String channel = MapUtils.getString(paraMap, (Object)"queueChannel");
            String port = MapUtils.getString(paraMap, (Object)"msgPort");
            String clusterIp = MapUtils.getString(paraMap, (Object)"msgIp");
            String transporttype = MapUtils.getString(paraMap, (Object)"transportType");
            String CCSID = MapUtils.getString(paraMap, (Object)"ccsid");
            String baseQueueName = MapUtils.getString(paraMap, (Object)"baseQueueName");
            String esbcode = MapUtils.getString(paraMap, (Object)"esbcode");
            String topic = MapUtils.getString(paraMap, (Object)"topic");
            String groupName = MapUtils.getString(paraMap, (Object)"groupName");
            String cmd = "";
            switch (2.$SwitchMap$com$pamirs$tro$common$constant$MQEnum[mqEnum.ordinal()]) {
                case 1: {
                    cmd = mqEnum.toString() + " " + queueManager + " " + hostName + " " + channel + " " + port + " " + CCSID + " " + baseQueueName + " " + transporttype + " " + esbcode;
                    break;
                }
                case 2: {
                    cmd = mqEnum.toString() + " " + queueManager + " " + hostName + " " + channel + " " + port + " " + transporttype + " " + esbcode;
                    break;
                }
                case 3: {
                    cmd = mqEnum.toString() + " " + topic + " " + groupName + " " + clusterIp;
                    break;
                }
                case 4: {
                    cmd = mqEnum.toString() + " " + topic + " " + groupName + " " + clusterIp;
                    break;
                }
            }
            cmd = " ps -ef | grep MqConsumeMain | grep \"" + cmd + "\" | grep -v grep";
            this.LOGGER.info("\u505c\u6b62\u811a\u672c\u7684\u547d\u4ee4\u4e3a: " + cmd);
            reader = null;
            Object brReader = null;
            sb = new StringBuffer();
            inputStream = null;
            bytes = null;
            process = null;
            try {
                process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                inputStream = process.getErrorStream();
                String errorStr = this.printOutContent(inputStream, bytes = new ByteArrayOutputStream());
                if (!StringUtils.isNotEmpty((CharSequence)errorStr)) break block11;
                this.TMqMsgDao.updateConsumeStatusById(msgId, "3");
            }
            catch (Exception e) {
                try {
                    this.TMqMsgDao.updateConsumeStatusById(msgId, "3");
                    this.LOGGER.error("MqConsumerService.getPIDs \u83b7\u53d6\u8fdb\u7a0b\u53f7\u6267\u884c\u811a\u672c\u5f02\u5e38{}", (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.closeAll(reader, inputStream, bytes, new Process[]{process});
                    throw throwable;
                }
                this.closeAll(reader, inputStream, bytes, new Process[]{process});
            }
        }
        this.closeAll(reader, inputStream, bytes, new Process[]{process});
        this.LOGGER.info("consume\u8fdb\u7a0b\u53f7\u96c6\u5408\u4e3a{}" + ProcessUtils.getPIdsList((String)sb.toString()));
        return ProcessUtils.getPIdsList((String)sb.toString());
    }

    private MQEnum getMqEnum(String mqtype) {
        MQEnum mqEnum = null;
        if (MQEnum.ESB.toString().equals(mqtype)) {
            mqEnum = MQEnum.ESB;
        }
        if (MQEnum.IBM.toString().equals(mqtype)) {
            mqEnum = MQEnum.IBM;
        }
        if (MQEnum.ROCKETMQ.toString().equals(mqtype)) {
            mqEnum = MQEnum.ROCKETMQ;
        }
        if (MQEnum.DPBOOT_ROCKETMQ.toString().equals(mqtype)) {
            mqEnum = MQEnum.DPBOOT_ROCKETMQ;
        }
        return mqEnum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killLinuxProcess(List<String> processStrs, String msgId) {
        BufferedReader brReader;
        Process process;
        block6: {
            process = null;
            brReader = null;
            TMqMsg tMqMsg = this.TMqMsgDao.selectMqMsgById(Long.valueOf(Long.parseLong(msgId)));
            String pids = Joiner.on((String)" ").join(processStrs);
            try {
                process = Runtime.getRuntime().exec("kill -9 " + pids);
                int exit = process.waitFor();
                if (exit == 0) {
                    tMqMsg.setConsumeEndTime(new Date());
                    tMqMsg.setConsumeStatus("2");
                    this.TMqMsgDao.updateByPrimaryKey(tMqMsg);
                    break block6;
                }
                brReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                StringBuilder errorDesc = new StringBuilder();
                String str = brReader.readLine();
                while (str != null) {
                    errorDesc.append(str);
                    str = brReader.readLine();
                }
                this.LOGGER.error("MqConsumerService.killLinuxProcess \u6267\u884c\u811a\u672c\u9519\u8bef\u4fe1\u606f{}", (Object)errorDesc);
                this.TMqMsgDao.updateConsumeStatusById(msgId, "3");
            }
            catch (Exception e) {
                try {
                    this.LOGGER.info("MqConsumerService.killLinuxProcess \u6740\u6389\u8fdb\u7a0b\u5f02\u5e38{}", (Throwable)e);
                    this.TMqMsgDao.updateConsumeStatusById(msgId, "3");
                }
                catch (Throwable throwable) {
                    this.closeAll(brReader, null, null, new Process[]{process});
                    throw throwable;
                }
                this.closeAll(brReader, null, null, new Process[]{process});
            }
        }
        this.closeAll(brReader, null, null, new Process[]{process});
    }

    private String printOutContent(InputStream inputStream, ByteArrayOutputStream bytes) throws IOException {
        byte[] bs = new byte[1024];
        int len = 0;
        while ((len = inputStream.read(bs)) > 0) {
            bytes.write(bs, 0, len);
        }
        this.LOGGER.info("EXCUTE SHELL ERROR INFO : " + new String(bytes.toByteArray()));
        return new String(bytes.toByteArray());
    }

    public int addMqMsg(TMqMsg tMqMsg) throws TROModuleException {
        Object dicList;
        Map mqMsgMap;
        int mqMsgExist = this.TMqMsgDao.mqMsgExist(tMqMsg);
        if (mqMsgExist > 0) {
            throw new TROModuleException(TROErrorEnum.ASSIST_SAVE_MQ_DUPICATE);
        }
        String msgType = tMqMsg.getMsgType();
        if (MQEnum.IBM.toString().equals(msgType) && StringUtils.contains((CharSequence)tMqMsg.getEsbcode(), (CharSequence)"|")) {
            throw new TROModuleException(TROErrorEnum.ASSIST_SAVE_MQ_PARAMERROR);
        }
        if (MQEnum.ESB.toString().equals(msgType) || MQEnum.IBM.toString().equals(msgType)) {
            tMqMsg.setTransportType("1");
        }
        if ((mqMsgMap = GlobalVariableUtil.getValue((TRODictTypeEnum)TRODictTypeEnum.MQMSG)) == null || mqMsgMap.isEmpty()) {
            mqMsgMap = this.queryDicList(TRODictTypeEnum.MQMSG);
            if (mqMsgMap == null) {
                throw new TROModuleException(TROErrorEnum.ASSIST_NOT_FOUND_MQTYPE_EXCEPTION);
            }
            GlobalVariableUtil.setValue((TRODictTypeEnum)TRODictTypeEnum.MQMSG, (Map)mqMsgMap);
        }
        if (!Objects.isNull(dicList = mqMsgMap.get("dicList")) && dicList instanceof Map) {
            Map dicMap = (Map)dicList;
            Map<Object, String> newDicMap = dicMap.entrySet().stream().collect(Collectors.toMap(key -> key.getValue(), value -> (String)value.getKey()));
            String valueOrder = MapUtils.getString(newDicMap, (Object)tMqMsg.getMsgType());
            tMqMsg.setMsgType(valueOrder);
        }
        tMqMsg.setDictType(String.valueOf(mqMsgMap.get("dictType")));
        tMqMsg.setMsgId(Long.valueOf(this.snowflake.next()));
        tMqMsg.setEsbcode(this.filterIllegalCharacters(tMqMsg.getEsbcode()));
        int insert = this.TMqMsgDao.insert(tMqMsg);
        return insert;
    }

    public void updateMqMsg(TMqMsg tMqMsg) throws TROModuleException {
        Object dicList;
        TMqMsg mqMsg = this.TMqMsgDao.selectMqMsgById(tMqMsg.getMsgId());
        if (mqMsg == null) {
            throw new TROModuleException(TROErrorEnum.ASSIST_MQMSG_NOT_FOUNT_EXCEPTION);
        }
        TMqMsg originMqMsg = mqMsg;
        String msgType = tMqMsg.getMsgType();
        if (MQEnum.IBM.toString().equals(msgType) && StringUtils.contains((CharSequence)tMqMsg.getEsbcode(), (CharSequence)"|")) {
            throw new TROModuleException(TROErrorEnum.ASSIST_SAVE_MQ_PARAMERROR);
        }
        Map mqMsgMap = GlobalVariableUtil.getValue((TRODictTypeEnum)TRODictTypeEnum.MQMSG);
        if (mqMsgMap == null || mqMsgMap.isEmpty()) {
            mqMsgMap = this.queryDicList(TRODictTypeEnum.MQMSG);
            if (mqMsgMap == null) {
                throw new TROModuleException(TROErrorEnum.ASSIST_NOT_FOUND_MQTYPE_EXCEPTION);
            }
            GlobalVariableUtil.setValue((TRODictTypeEnum)TRODictTypeEnum.MQMSG, (Map)mqMsgMap);
        }
        if (!Objects.isNull(dicList = mqMsgMap.get("dicList")) && dicList instanceof Map) {
            Map dicMap = (Map)dicList;
            Map<Object, String> newDicMap = dicMap.entrySet().stream().collect(Collectors.toMap(key -> key.getValue(), value -> (String)value.getKey()));
            String valueOrder = MapUtils.getString(newDicMap, (Object)tMqMsg.getMsgType());
            tMqMsg.setMsgType(valueOrder);
        }
        tMqMsg.setDictType(String.valueOf(mqMsgMap.get("dictType")));
        tMqMsg.setEsbcode(this.filterIllegalCharacters(tMqMsg.getEsbcode()));
        this.TMqMsgDao.updateByPrimaryKeySelective(tMqMsg);
    }

    private Map<String, Object> getDictMap(String dictContent, TRODictTypeEnum dictTypeEnum) {
        Map map = this.confCenterService.queryDicList(dictTypeEnum);
        Map dictMap = (Map)map.get("dicList");
        String newDictContent = dictMap.keySet().stream().filter(dictKey -> dictContent.equals(dictMap.get(dictKey))).findFirst().orElse("");
        if (StringUtils.isEmpty((CharSequence)newDictContent)) {
            return null;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public int deleteMqMsg(String msgId) {
        return this.TMqMsgDao.deleteByPrimaryKey(Long.valueOf(Long.parseLong(msgId)));
    }

    public void batchDeleteMqMsg(String msgIdList) {
        List msgIds = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)msgIdList);
        List tMqMsgs = this.TMqMsgDao.queryConsumeListByIds(msgIds);
        this.TMqMsgDao.batchDeleteMqMsg(msgIds);
    }

    public PageInfo<TMqMsg> queryMqMsgList(Map<String, Object> paramMap) {
        String msgType;
        String pageSize = MapUtils.getString(paramMap, (Object)"pageSize");
        if (!StringUtils.equals((CharSequence)"-1", (CharSequence)pageSize)) {
            PageHelper.startPage((int)PageInfo.getPageNum(paramMap), (int)PageInfo.getPageSize(paramMap));
        }
        if ("3".equals(msgType = MapUtils.getString(paramMap, (Object)"msgType"))) {
            List mqMsgList = this.TMqMsgDao.selectRocketMqMsgList(paramMap);
            return new PageInfo(mqMsgList);
        }
        List mqMsgList = this.TMqMsgDao.selectMqMsgList(paramMap);
        return new PageInfo(mqMsgList);
    }

    public TMqMsg queryMqMsgDetail(String msgId) {
        TMqMsg tMqMsg = this.TMqMsgDao.selectMqMsgById(Long.valueOf(Long.parseLong(msgId)));
        return tMqMsg;
    }

    static {
        mqTypeList = Lists.newArrayList((Object[])MQEnum.values()).stream().map(mqEnum -> mqEnum.toString()).collect(Collectors.toList());
    }
}

