/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.util.MD5Util;
import io.shulie.amdb.common.dto.link.topology.LinkEdgeDTO;
import io.shulie.amdb.common.dto.link.topology.LinkNodeDTO;
import io.shulie.amdb.common.dto.link.topology.LinkTopologyDTO;
import io.shulie.amdb.common.dto.link.topology.NodeExtendInfoBaseDTO;
import io.shulie.amdb.common.dto.link.topology.NodeExtendInfoForCacheDTO;
import io.shulie.amdb.common.dto.link.topology.NodeExtendInfoForDBDTO;
import io.shulie.amdb.common.dto.link.topology.NodeExtendInfoForMQDTO;
import io.shulie.amdb.common.dto.link.topology.NodeExtendInfoForOSSDTO;
import io.shulie.amdb.common.dto.link.topology.NodeExtendInfoForSearchDTO;
import io.shulie.amdb.common.enums.NodeTypeEnum;
import io.shulie.amdb.common.enums.NodeTypeGroupEnum;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.web.amdb.api.ApplicationClient;
import io.shulie.tro.web.amdb.api.ApplicationEntranceClient;
import io.shulie.tro.web.amdb.bean.query.application.ApplicationNodeQueryDTO;
import io.shulie.tro.web.amdb.bean.result.application.ApplicationNodeDTO;
import io.shulie.tro.web.app.common.CommonService;
import io.shulie.tro.web.app.request.application.ApplicationEntranceTopologyQueryRequest;
import io.shulie.tro.web.app.response.application.ApplicationEntranceTopologyResponse;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.result.application.ApplicationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LinkTopologyService
extends CommonService {
    @Autowired
    private ApplicationClient applicationClient;
    @Autowired
    private ApplicationDAO applicationDAO;
    @Autowired
    private ApplicationEntranceClient applicationEntranceClient;

    public ApplicationEntranceTopologyResponse getApplicationEntrancesTopology(ApplicationEntranceTopologyQueryRequest request) {
        LinkTopologyDTO applicationEntrancesTopology = this.applicationEntranceClient.getApplicationEntrancesTopology(request.getApplicationName(), request.getLinkId(), request.getServiceName(), request.getMethod(), request.getRpcType(), request.getExtend());
        ApplicationEntranceTopologyResponse applicationEntranceTopologyResponse = new ApplicationEntranceTopologyResponse();
        if (applicationEntrancesTopology != null) {
            Map<Object, Object> nodeMap = Maps.newHashMap();
            Map<Object, Object> providerEdgeMap = Maps.newHashMap();
            Map<Object, Object> callEdgeMap = Maps.newHashMap();
            Map managerMap = Maps.newHashMap();
            Map appNodeMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)applicationEntrancesTopology.getNodes())) {
                nodeMap = applicationEntrancesTopology.getNodes().stream().collect(Collectors.toMap(LinkNodeDTO::getNodeId, self -> self));
                managerMap = this.getManagers(applicationEntrancesTopology.getNodes());
                appNodeMap = this.getAppNodes(applicationEntrancesTopology.getNodes());
            }
            if (CollectionUtils.isNotEmpty((Collection)applicationEntrancesTopology.getEdges())) {
                providerEdgeMap = applicationEntrancesTopology.getEdges().stream().collect(Collectors.groupingBy(LinkEdgeDTO::getTargetId));
                callEdgeMap = applicationEntrancesTopology.getEdges().stream().collect(Collectors.groupingBy(LinkEdgeDTO::getSourceId));
            }
            applicationEntranceTopologyResponse.setNodes(this.convertNodes(applicationEntrancesTopology, (Map)nodeMap, (Map)providerEdgeMap, (Map)callEdgeMap, managerMap, appNodeMap));
            applicationEntranceTopologyResponse.setEdges(this.convertEdges(applicationEntrancesTopology, (Map)nodeMap, (Map)providerEdgeMap, (Map)callEdgeMap, request));
            applicationEntranceTopologyResponse.setExceptions(this.convertExceptions(applicationEntranceTopologyResponse, applicationEntrancesTopology, (Map)nodeMap, (Map)providerEdgeMap, (Map)callEdgeMap));
        } else {
            applicationEntranceTopologyResponse.setNodes((List)Lists.newArrayList());
            applicationEntranceTopologyResponse.setEdges((List)Lists.newArrayList());
            applicationEntranceTopologyResponse.setExceptions((List)Lists.newArrayList());
        }
        return applicationEntranceTopologyResponse;
    }

    private Map<String, List<ApplicationNodeDTO>> getAppNodes(List<LinkNodeDTO> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return Maps.newHashMap();
        }
        List appNames = nodes.stream().map(LinkNodeDTO::getNodeName).collect(Collectors.toList());
        ApplicationNodeQueryDTO applicationNodeQueryDTO = new ApplicationNodeQueryDTO();
        applicationNodeQueryDTO.setPageSize(Integer.valueOf(9999));
        applicationNodeQueryDTO.setAppNames(StringUtils.join(appNames, (String)","));
        PagingList applicationNodeDTOPagingList = this.applicationClient.pageApplicationNodes(applicationNodeQueryDTO);
        if (applicationNodeDTOPagingList.getTotal() == 0L) {
            return Maps.newHashMap();
        }
        return applicationNodeDTOPagingList.getList().stream().collect(Collectors.groupingBy(ApplicationNodeDTO::getAppName));
    }

    private Map<String, String> getManagers(List<LinkNodeDTO> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return Maps.newHashMap();
        }
        List applicationNames = nodes.stream().filter(node -> this.nodeIsApp(node) && !this.isVirtualNode(node)).map(LinkNodeDTO::getNodeName).collect(Collectors.toList());
        List applicationsByName = this.applicationDAO.getApplicationByName(applicationNames);
        if (CollectionUtils.isEmpty((Collection)applicationsByName)) {
            return Maps.newHashMap();
        }
        Map<String, String> appNameManagerNameMap = applicationsByName.stream().filter(app -> StringUtils.isNotBlank((CharSequence)app.getAppManagerName())).collect(Collectors.toMap(ApplicationResult::getAppName, ApplicationResult::getAppManagerName));
        HashMap map = Maps.newHashMap();
        for (LinkNodeDTO node2 : nodes) {
            if (!this.nodeIsApp(node2) || this.isVirtualNode(node2)) continue;
            map.put(node2.getNodeName(), appNameManagerNameMap.get(node2.getNodeName()));
        }
        return map;
    }

    private List<ApplicationEntranceTopologyResponse.TopologyNodeResponse> convertNodes(LinkTopologyDTO applicationEntrancesTopology, Map<String, LinkNodeDTO> nodeMap, Map<String, List<LinkEdgeDTO>> providerEdgeMap, Map<String, List<LinkEdgeDTO>> callEdgeMap, Map<String, String> managerMap, Map<String, List<ApplicationNodeDTO>> appNodeMap) {
        if (CollectionUtils.isEmpty((Collection)applicationEntrancesTopology.getNodes())) {
            return Lists.newArrayList();
        }
        return applicationEntrancesTopology.getNodes().stream().map(node -> {
            if (NodeTypeGroupEnum.OTHER.getType().equals(node.getNodeTypeGroup()) && this.isVirtualNode(node)) {
                ApplicationEntranceTopologyResponse.TopologyVirtualNodeResponse nodeResponse = new ApplicationEntranceTopologyResponse.TopologyVirtualNodeResponse();
                this.setNodeDefaultResponse((ApplicationEntranceTopologyResponse.TopologyNodeResponse)nodeResponse, node, nodeMap, providerEdgeMap, callEdgeMap);
                this.setVirtualResponse(nodeResponse, node, nodeMap, providerEdgeMap, callEdgeMap, managerMap, appNodeMap);
                return nodeResponse;
            }
            if (NodeTypeGroupEnum.OTHER.getType().equals(node.getNodeTypeGroup()) && this.isOuterService(node)) {
                ApplicationEntranceTopologyResponse.TopologyOtherNodeResponse nodeResponse = new ApplicationEntranceTopologyResponse.TopologyOtherNodeResponse();
                this.setNodeDefaultResponse((ApplicationEntranceTopologyResponse.TopologyNodeResponse)nodeResponse, node, nodeMap, providerEdgeMap, callEdgeMap);
                this.setOtherResponse(nodeResponse, node, nodeMap, providerEdgeMap, callEdgeMap, managerMap, appNodeMap);
                return nodeResponse;
            }
            if (NodeTypeGroupEnum.OTHER.getType().equals(node.getNodeTypeGroup()) && this.isUnknownNode(node)) {
                ApplicationEntranceTopologyResponse.TopologyUnknownNodeResponse nodeResponse = new ApplicationEntranceTopologyResponse.TopologyUnknownNodeResponse();
                this.setNodeDefaultResponse((ApplicationEntranceTopologyResponse.TopologyNodeResponse)nodeResponse, node, nodeMap, providerEdgeMap, callEdgeMap);
                this.setUnknownResponse(nodeResponse, node, nodeMap, providerEdgeMap, callEdgeMap, managerMap, appNodeMap);
                return nodeResponse;
            }
            if (NodeTypeGroupEnum.APP.getType().equals(node.getNodeTypeGroup())) {
                ApplicationEntranceTopologyResponse.TopologyAppNodeResponse nodeResponse = new ApplicationEntranceTopologyResponse.TopologyAppNodeResponse();
                this.setNodeDefaultResponse((ApplicationEntranceTopologyResponse.TopologyNodeResponse)nodeResponse, node, nodeMap, providerEdgeMap, callEdgeMap);
                this.setAppNodeResponse(nodeResponse, node, nodeMap, providerEdgeMap, callEdgeMap, managerMap, appNodeMap);
                return nodeResponse;
            }
            if (NodeTypeGroupEnum.OSS.getType().equals(node.getNodeTypeGroup())) {
                ApplicationEntranceTopologyResponse.TopologyOssNodeResponse nodeResponse = new ApplicationEntranceTopologyResponse.TopologyOssNodeResponse();
                this.setNodeDefaultResponse((ApplicationEntranceTopologyResponse.TopologyNodeResponse)nodeResponse, node, nodeMap, providerEdgeMap, callEdgeMap);
                this.setOssNodeResponse(nodeResponse, node, nodeMap, providerEdgeMap, callEdgeMap, appNodeMap);
                return nodeResponse;
            }
            if (NodeTypeGroupEnum.CACHE.getType().equals(node.getNodeTypeGroup())) {
                ApplicationEntranceTopologyResponse.TopologyCacheNodeResponse nodeResponse = new ApplicationEntranceTopologyResponse.TopologyCacheNodeResponse();
                this.setNodeDefaultResponse((ApplicationEntranceTopologyResponse.TopologyNodeResponse)nodeResponse, node, nodeMap, providerEdgeMap, callEdgeMap);
                this.setCacheNodeResponse(nodeResponse, node, nodeMap, providerEdgeMap, callEdgeMap, appNodeMap);
                return nodeResponse;
            }
            if (NodeTypeGroupEnum.DB.getType().equals(node.getNodeTypeGroup())) {
                ApplicationEntranceTopologyResponse.TopologyDbNodeResponse nodeResponse = new ApplicationEntranceTopologyResponse.TopologyDbNodeResponse();
                this.setNodeDefaultResponse((ApplicationEntranceTopologyResponse.TopologyNodeResponse)nodeResponse, node, nodeMap, providerEdgeMap, callEdgeMap);
                this.setDbNodeResponse(nodeResponse, node, nodeMap, providerEdgeMap, callEdgeMap, appNodeMap);
                return nodeResponse;
            }
            if (NodeTypeGroupEnum.MQ.getType().equals(node.getNodeTypeGroup())) {
                ApplicationEntranceTopologyResponse.TopologyMqNodeResponse nodeResponse = new ApplicationEntranceTopologyResponse.TopologyMqNodeResponse();
                this.setNodeDefaultResponse((ApplicationEntranceTopologyResponse.TopologyNodeResponse)nodeResponse, node, nodeMap, providerEdgeMap, callEdgeMap);
                this.setMqNodeResponse(nodeResponse, node, nodeMap, providerEdgeMap, callEdgeMap, appNodeMap);
                return nodeResponse;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void setUnknownResponse(ApplicationEntranceTopologyResponse.TopologyUnknownNodeResponse nodeResponse, LinkNodeDTO node, Map<String, LinkNodeDTO> nodeMap, Map<String, List<LinkEdgeDTO>> providerEdgeMap, Map<String, List<LinkEdgeDTO>> callEdgeMap, Map<String, String> managerMap, Map<String, List<ApplicationNodeDTO>> appNodeMap) {
        nodeResponse.setNodes(this.getNodeDetails(node, nodeMap, providerEdgeMap, callEdgeMap, appNodeMap));
        nodeResponse.setProviderService(this.convertAppNodeProviderService(node, nodeMap, providerEdgeMap, callEdgeMap));
    }

    private List<String> getUpAppNames(LinkNodeDTO node, Map<String, LinkNodeDTO> nodeMap, Map<String, List<LinkEdgeDTO>> providerEdgeMap) {
        if (MapUtils.isEmpty(providerEdgeMap) || CollectionUtils.isEmpty((Collection)providerEdgeMap.get(node.getNodeId()))) {
            return new ArrayList<String>();
        }
        List updateNodeIdList = providerEdgeMap.get(node.getNodeId()).stream().map(LinkEdgeDTO::getSourceId).collect(Collectors.toList());
        return updateNodeIdList.stream().map(upNodeId -> {
            LinkNodeDTO linkNodeDTO = (LinkNodeDTO)nodeMap.get(upNodeId);
            if (linkNodeDTO != null) {
                return ((LinkNodeDTO)nodeMap.get(upNodeId)).getNodeName();
            }
            return null;
        }).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
    }

    private void setOtherResponse(ApplicationEntranceTopologyResponse.TopologyOtherNodeResponse nodeResponse, LinkNodeDTO node, Map<String, LinkNodeDTO> nodeMap, Map<String, List<LinkEdgeDTO>> providerEdgeMap, Map<String, List<LinkEdgeDTO>> callEdgeMap, Map<String, String> managerMap, Map<String, List<ApplicationNodeDTO>> appNodeMap) {
        nodeResponse.setNodes(this.getNodeDetails(node, nodeMap, providerEdgeMap, callEdgeMap, appNodeMap));
        nodeResponse.setProviderService(this.convertAppNodeProviderService(node, nodeMap, providerEdgeMap, callEdgeMap));
    }

    private void setVirtualResponse(ApplicationEntranceTopologyResponse.TopologyVirtualNodeResponse nodeResponse, LinkNodeDTO node, Map<String, LinkNodeDTO> nodeMap, Map<String, List<LinkEdgeDTO>> providerEdgeMap, Map<String, List<LinkEdgeDTO>> callEdgeMap, Map<String, String> managerMap, Map<String, List<ApplicationNodeDTO>> appNodeMap) {
        nodeResponse.setNodes(this.getNodeDetails(node, nodeMap, providerEdgeMap, callEdgeMap, appNodeMap));
    }

    private void setMqNodeResponse(ApplicationEntranceTopologyResponse.TopologyMqNodeResponse nodeResponse, LinkNodeDTO node, Map<String, LinkNodeDTO> nodeMap, Map<String, List<LinkEdgeDTO>> providerEdgeMap, Map<String, List<LinkEdgeDTO>> callEdgeMap, Map<String, List<ApplicationNodeDTO>> appNodeMap) {
        List<LinkEdgeDTO> linkEdgeDTOS = providerEdgeMap.get(node.getNodeId());
        List<Object> mqs = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(linkEdgeDTOS)) {
            mqs = linkEdgeDTOS.stream().map(edge -> {
                ApplicationEntranceTopologyResponse.MqInfo mqInfo = new ApplicationEntranceTopologyResponse.MqInfo();
                mqInfo.setTopic(edge.getService());
                return mqInfo;
            }).collect(Collectors.toList());
        }
        nodeResponse.setMq((List)mqs);
        nodeResponse.setNodes(this.getNodeDetails(node, nodeMap, providerEdgeMap, callEdgeMap, appNodeMap));
        if (this.isUnknownNode(node) || this.isOuterService(node)) {
            nodeResponse.setProviderService(this.convertAppNodeProviderService(node, nodeMap, providerEdgeMap, callEdgeMap));
        }
    }

    private void setDbNodeResponse(ApplicationEntranceTopologyResponse.TopologyDbNodeResponse nodeResponse, LinkNodeDTO node, Map<String, LinkNodeDTO> nodeMap, Map<String, List<LinkEdgeDTO>> providerEdgeMap, Map<String, List<LinkEdgeDTO>> callEdgeMap, Map<String, List<ApplicationNodeDTO>> appNodeMap) {
        List<LinkEdgeDTO> linkEdgeDTOS = providerEdgeMap.get(node.getNodeId());
        List<Object> dbs = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(linkEdgeDTOS)) {
            dbs = linkEdgeDTOS.stream().map(edge -> {
                ApplicationEntranceTopologyResponse.DbInfo db = new ApplicationEntranceTopologyResponse.DbInfo();
                db.setTableName(edge.getMethod());
                return db;
            }).collect(Collectors.toList());
        }
        nodeResponse.setDb((List)dbs);
        nodeResponse.setNodes(this.getNodeDetails(node, nodeMap, providerEdgeMap, callEdgeMap, appNodeMap));
    }

    private void setCacheNodeResponse(ApplicationEntranceTopologyResponse.TopologyCacheNodeResponse nodeResponse, LinkNodeDTO node, Map<String, LinkNodeDTO> nodeMap, Map<String, List<LinkEdgeDTO>> providerEdgeMap, Map<String, List<LinkEdgeDTO>> callEdgeMap, Map<String, List<ApplicationNodeDTO>> appNodeMap) {
        nodeResponse.setNodes(this.getNodeDetails(node, nodeMap, providerEdgeMap, callEdgeMap, appNodeMap));
    }

    private void setOssNodeResponse(ApplicationEntranceTopologyResponse.TopologyOssNodeResponse nodeResponse, LinkNodeDTO node, Map<String, LinkNodeDTO> nodeMap, Map<String, List<LinkEdgeDTO>> providerEdgeMap, Map<String, List<LinkEdgeDTO>> callEdgeMap, Map<String, List<ApplicationNodeDTO>> appNodeMap) {
        List<LinkEdgeDTO> linkEdgeDTOS = providerEdgeMap.get(node.getNodeId());
        List<Object> ossInfoLists = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(linkEdgeDTOS)) {
            ossInfoLists = linkEdgeDTOS.stream().map(edge -> {
                ApplicationEntranceTopologyResponse.OssInfo ossInfo = new ApplicationEntranceTopologyResponse.OssInfo();
                ossInfo.setFilePath(edge.getService());
                return ossInfo;
            }).collect(Collectors.toList());
        }
        nodeResponse.setNodes(this.getNodeDetails(node, nodeMap, providerEdgeMap, callEdgeMap, appNodeMap));
        nodeResponse.setOss((List)ossInfoLists);
    }

    private void setAppNodeResponse(ApplicationEntranceTopologyResponse.TopologyAppNodeResponse nodeResponse, LinkNodeDTO node, Map<String, LinkNodeDTO> nodeMap, Map<String, List<LinkEdgeDTO>> providerEdgeMap, Map<String, List<LinkEdgeDTO>> callEdgeMap, Map<String, String> managerMap, Map<String, List<ApplicationNodeDTO>> appNodeMap) {
        nodeResponse.setManager(managerMap.get(node.getNodeName()));
        nodeResponse.setNodes(this.getNodeDetails(node, nodeMap, providerEdgeMap, callEdgeMap, appNodeMap));
        nodeResponse.setCallService(this.convertAppNodeCallService(node, nodeMap, providerEdgeMap, callEdgeMap, appNodeMap));
        nodeResponse.setProviderService(this.convertAppNodeProviderService(node, nodeMap, providerEdgeMap, callEdgeMap));
    }

    private List<ApplicationEntranceTopologyResponse.AppProviderInfo> convertAppNodeProviderService(LinkNodeDTO node, Map<String, LinkNodeDTO> nodeMap, Map<String, List<LinkEdgeDTO>> providerEdgeMap, Map<String, List<LinkEdgeDTO>> callEdgeMap) {
        List<LinkEdgeDTO> providerEdge = providerEdgeMap.get(node.getNodeId());
        if (CollectionUtils.isEmpty(providerEdge)) {
            return Lists.newArrayList();
        }
        Map<String, List<LinkEdgeDTO>> providerEdgeByType = providerEdge.stream().collect(Collectors.groupingBy(LinkEdgeDTO::getMiddlewareName));
        return providerEdgeByType.entrySet().stream().map(entry -> {
            ApplicationEntranceTopologyResponse.AppProviderInfo appProviderInfo = new ApplicationEntranceTopologyResponse.AppProviderInfo();
            appProviderInfo.setLabel((String)entry.getKey());
            List<Object> datasource = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)((Collection)entry.getValue()))) {
                Map<String, List<LinkEdgeDTO>> serviceMethodGroup = ((List)entry.getValue()).stream().collect(Collectors.groupingBy(e -> e.getService() + "#" + e.getMethod()));
                datasource = serviceMethodGroup.entrySet().stream().map(item -> {
                    ApplicationEntranceTopologyResponse.AppProviderDatasourceInfo appProviderDatasourceInfo = new ApplicationEntranceTopologyResponse.AppProviderDatasourceInfo();
                    appProviderDatasourceInfo.setServiceName((String)item.getKey());
                    if (CollectionUtils.isNotEmpty((Collection)((Collection)item.getValue()))) {
                        appProviderDatasourceInfo.setBeforeApps(((List)item.getValue()).stream().filter(Objects::nonNull).map(LinkEdgeDTO::getSourceId).map(nodeMap::get).map(LinkNodeDTO::getNodeName).collect(Collectors.joining(",")));
                    }
                    return appProviderDatasourceInfo;
                }).collect(Collectors.toList());
            }
            appProviderInfo.setDataSource((List)datasource);
            return appProviderInfo;
        }).collect(Collectors.toList());
    }

    private List<ApplicationEntranceTopologyResponse.AppCallInfo> convertAppNodeCallService(LinkNodeDTO node, Map<String, LinkNodeDTO> nodeMap, Map<String, List<LinkEdgeDTO>> providerEdgeMap, Map<String, List<LinkEdgeDTO>> callEdgeMap, Map<String, List<ApplicationNodeDTO>> appNodeMap) {
        List<LinkEdgeDTO> callEdges = callEdgeMap.get(node.getNodeId());
        if (CollectionUtils.isEmpty(callEdges)) {
            return Lists.newArrayList();
        }
        Map<String, List<LinkEdgeDTO>> excludeMqNodeWithEdge = callEdges.stream().collect(Collectors.groupingBy(LinkEdgeDTO::getTargetId));
        return this.getCallInfo(nodeMap, excludeMqNodeWithEdge, appNodeMap);
    }

    private List<ApplicationEntranceTopologyResponse.AppCallInfo> getCallInfo(Map<String, LinkNodeDTO> nodeMap, Map<String, List<LinkEdgeDTO>> excludeMqNodeWithEdge, Map<String, List<ApplicationNodeDTO>> appNodeMap) {
        return excludeMqNodeWithEdge.entrySet().stream().map(entry -> {
            LinkNodeDTO linkNodeDTO = (LinkNodeDTO)nodeMap.get(entry.getKey());
            ApplicationEntranceTopologyResponse.AppCallInfo appCallInfo = new ApplicationEntranceTopologyResponse.AppCallInfo();
            appCallInfo.setNodeType(ApplicationEntranceTopologyResponse.NodeTypeResponseEnum.getTypeByAmdbType((String)linkNodeDTO.getNodeTypeGroup()));
            appCallInfo.setLabel(linkNodeDTO.getNodeType().toUpperCase());
            appCallInfo.setDataSource(this.convertCallTypeInfo((List)entry.getValue(), linkNodeDTO, nodeMap, appNodeMap));
            return appCallInfo;
        }).collect(Collectors.toList());
    }

    private List<ApplicationEntranceTopologyResponse.AppCallDatasourceInfo> convertCallTypeInfo(List<LinkEdgeDTO> edges, LinkNodeDTO node, Map<String, LinkNodeDTO> nodeMap, Map<String, List<ApplicationNodeDTO>> appNodeMap) {
        if (CollectionUtils.isEmpty(edges)) {
            return Lists.newArrayList();
        }
        if (NodeTypeGroupEnum.APP.name().equals(node.getNodeTypeGroup())) {
            ArrayList<ApplicationEntranceTopologyResponse.AppCallDatasourceInfo> infos = new ArrayList<ApplicationEntranceTopologyResponse.AppCallDatasourceInfo>();
            ApplicationEntranceTopologyResponse.AppCallDatasourceInfo info1 = new ApplicationEntranceTopologyResponse.AppCallDatasourceInfo();
            info1.setLabel("\u8282\u70b9\u540d\u79f0");
            info1.setDataSource((List)Lists.newArrayList((Object[])new String[]{node.getNodeName()}));
            infos.add(info1);
            ApplicationEntranceTopologyResponse.AppCallDatasourceInfo info2 = new ApplicationEntranceTopologyResponse.AppCallDatasourceInfo();
            info2.setLabel("\u8282\u70b9");
            List<ApplicationNodeDTO> applicationNodeDTOS = appNodeMap.get(node.getNodeName());
            if (CollectionUtils.isNotEmpty(applicationNodeDTOS)) {
                info2.setDataSource(applicationNodeDTOS.stream().map(ApplicationNodeDTO::getIpAddress).collect(Collectors.toList()));
            } else {
                info2.setDataSource((List)Lists.newArrayList());
            }
            infos.add(info2);
            ApplicationEntranceTopologyResponse.AppCallDatasourceInfo info3 = new ApplicationEntranceTopologyResponse.AppCallDatasourceInfo();
            info3.setLabel("\u670d\u52a1");
            info3.setDataSource(edges.stream().map(edge -> edge.getService() + "#" + edge.getMethod()).collect(Collectors.toList()));
            infos.add(info3);
            return infos;
        }
        if (NodeTypeGroupEnum.CACHE.name().equals(node.getNodeTypeGroup())) {
            ArrayList<ApplicationEntranceTopologyResponse.AppCallDatasourceInfo> infos = new ArrayList<ApplicationEntranceTopologyResponse.AppCallDatasourceInfo>();
            ApplicationEntranceTopologyResponse.AppCallDatasourceInfo info1 = new ApplicationEntranceTopologyResponse.AppCallDatasourceInfo();
            info1.setLabel("\u8282\u70b9");
            NodeExtendInfoForCacheDTO extend = (NodeExtendInfoForCacheDTO)this.convertNodeExtendInfo(node.getExtendInfo(), NodeExtendInfoForCacheDTO.class);
            info1.setDataSource((List)Lists.newArrayList((Object[])new String[]{extend.getIp() + ":" + extend.getPort()}));
            infos.add(info1);
            return infos;
        }
        if (NodeTypeGroupEnum.OSS.name().equals(node.getNodeTypeGroup())) {
            ArrayList<ApplicationEntranceTopologyResponse.AppCallDatasourceInfo> infos = new ArrayList<ApplicationEntranceTopologyResponse.AppCallDatasourceInfo>();
            ApplicationEntranceTopologyResponse.AppCallDatasourceInfo info2 = new ApplicationEntranceTopologyResponse.AppCallDatasourceInfo();
            info2.setLabel("\u6587\u4ef6\u8def\u5f84");
            info2.setDataSource(edges.stream().map(LinkEdgeDTO::getService).collect(Collectors.toList()));
            infos.add(info2);
            return infos;
        }
        if (NodeTypeGroupEnum.MQ.name().equals(node.getNodeTypeGroup())) {
            ArrayList<ApplicationEntranceTopologyResponse.AppCallDatasourceInfo> infos = new ArrayList<ApplicationEntranceTopologyResponse.AppCallDatasourceInfo>();
            ApplicationEntranceTopologyResponse.AppCallDatasourceInfo info1 = new ApplicationEntranceTopologyResponse.AppCallDatasourceInfo();
            info1.setLabel("\u8282\u70b9\u540d\u79f0");
            info1.setDataSource((List)Lists.newArrayList((Object[])new String[]{node.getNodeName()}));
            infos.add(info1);
            ApplicationEntranceTopologyResponse.AppCallDatasourceInfo info2 = new ApplicationEntranceTopologyResponse.AppCallDatasourceInfo();
            info2.setLabel("Topic");
            info2.setDataSource(edges.stream().map(LinkEdgeDTO::getService).collect(Collectors.toList()));
            infos.add(info2);
            return infos;
        }
        if (NodeTypeGroupEnum.DB.name().equals(node.getNodeTypeGroup())) {
            ArrayList<ApplicationEntranceTopologyResponse.AppCallDatasourceInfo> infos = new ArrayList<ApplicationEntranceTopologyResponse.AppCallDatasourceInfo>();
            ApplicationEntranceTopologyResponse.AppCallDatasourceInfo info1 = new ApplicationEntranceTopologyResponse.AppCallDatasourceInfo();
            info1.setLabel("\u8282\u70b9\u540d\u79f0");
            info1.setDataSource((List)Lists.newArrayList((Object[])new String[]{node.getNodeName()}));
            infos.add(info1);
            ApplicationEntranceTopologyResponse.AppCallDatasourceInfo info2 = new ApplicationEntranceTopologyResponse.AppCallDatasourceInfo();
            info2.setLabel("\u5e93\u540d\u79f0");
            info2.setDataSource((List)Lists.newArrayList((Object[])new String[]{edges.stream().map(LinkEdgeDTO::getService).distinct().collect(Collectors.joining(","))}));
            infos.add(info2);
            ApplicationEntranceTopologyResponse.AppCallDatasourceInfo info3 = new ApplicationEntranceTopologyResponse.AppCallDatasourceInfo();
            info3.setLabel("\u8868\u540d\u79f0");
            info3.setDataSource((List)Lists.newArrayList((Object[])new String[]{edges.stream().map(LinkEdgeDTO::getMethod).distinct().collect(Collectors.joining(","))}));
            infos.add(info3);
            return infos;
        }
        if (NodeTypeGroupEnum.SEARCH.name().equals(node.getNodeTypeGroup())) {
            ArrayList<ApplicationEntranceTopologyResponse.AppCallDatasourceInfo> infos = new ArrayList<ApplicationEntranceTopologyResponse.AppCallDatasourceInfo>();
            ApplicationEntranceTopologyResponse.AppCallDatasourceInfo info1 = new ApplicationEntranceTopologyResponse.AppCallDatasourceInfo();
            info1.setLabel("\u8282\u70b9\u540d\u79f0");
            info1.setDataSource((List)Lists.newArrayList((Object[])new String[]{node.getNodeName()}));
            infos.add(info1);
            return infos;
        }
        if (NodeTypeGroupEnum.OTHER.name().equals(node.getNodeTypeGroup())) {
            ArrayList<ApplicationEntranceTopologyResponse.AppCallDatasourceInfo> infos = new ArrayList<ApplicationEntranceTopologyResponse.AppCallDatasourceInfo>();
            ApplicationEntranceTopologyResponse.AppCallDatasourceInfo info1 = new ApplicationEntranceTopologyResponse.AppCallDatasourceInfo();
            info1.setLabel("\u8282\u70b9\u540d\u79f0");
            info1.setDataSource((List)Lists.newArrayList((Object[])new String[]{node.getNodeName()}));
            infos.add(info1);
            return infos;
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8282\u70b9\u7c7b\u578b:" + node.getNodeTypeGroup());
    }

    private void setNodeDefaultResponse(ApplicationEntranceTopologyResponse.TopologyNodeResponse nodeResponse, LinkNodeDTO node, Map<String, LinkNodeDTO> nodeMap, Map<String, List<LinkEdgeDTO>> providerEdgeMap, Map<String, List<LinkEdgeDTO>> callEdgeMap) {
        if (!this.isUnknownNode(node) && !this.isOuterService(node)) {
            nodeResponse.setNodeType(ApplicationEntranceTopologyResponse.NodeTypeResponseEnum.getTypeByAmdbType((String)node.getNodeTypeGroup()));
        }
        if (this.isUnknownNode(node)) {
            nodeResponse.setNodeType(ApplicationEntranceTopologyResponse.NodeTypeResponseEnum.UNKNOWN);
        }
        if (this.isOuterService(node)) {
            nodeResponse.setNodeType(ApplicationEntranceTopologyResponse.NodeTypeResponseEnum.OUTER);
        }
        if (this.isVirtualNode(node)) {
            nodeResponse.setNodeType(ApplicationEntranceTopologyResponse.NodeTypeResponseEnum.VIRTUAL);
        }
        nodeResponse.setLabel(this.getNodeInfoLabel(node));
        nodeResponse.setRoot(Boolean.valueOf(this.isRoot(node)));
        nodeResponse.setId(node.getNodeId());
        nodeResponse.setUpAppNames(this.getUpAppNames(node, nodeMap, providerEdgeMap));
    }

    private List<ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo> getNodeDetails(LinkNodeDTO node, Map<String, LinkNodeDTO> nodeMap, Map<String, List<LinkEdgeDTO>> providerEdgeMap, Map<String, List<LinkEdgeDTO>> callEdgeMap, Map<String, List<ApplicationNodeDTO>> appNodeMap) {
        if (NodeTypeGroupEnum.MQ.name().equals(node.getNodeTypeGroup())) {
            NodeExtendInfoForMQDTO extendInfo = (NodeExtendInfoForMQDTO)this.convertNodeExtendInfo(node.getExtendInfo(), NodeExtendInfoForMQDTO.class);
            ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo nodeDetailDatasourceInfo = new ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo();
            nodeDetailDatasourceInfo.setNode(extendInfo.getIp() + ":" + extendInfo.getPort());
            return Lists.newArrayList((Object[])new ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo[]{nodeDetailDatasourceInfo});
        }
        if (NodeTypeGroupEnum.CACHE.name().equals(node.getNodeTypeGroup())) {
            NodeExtendInfoForCacheDTO extendInfo = (NodeExtendInfoForCacheDTO)this.convertNodeExtendInfo(node.getExtendInfo(), NodeExtendInfoForCacheDTO.class);
            ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo nodeDetailDatasourceInfo = new ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo();
            nodeDetailDatasourceInfo.setNode(extendInfo.getIp() + ":" + extendInfo.getPort());
            return Lists.newArrayList((Object[])new ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo[]{nodeDetailDatasourceInfo});
        }
        if (NodeTypeGroupEnum.DB.name().equals(node.getNodeTypeGroup())) {
            NodeExtendInfoForDBDTO extendInfo = (NodeExtendInfoForDBDTO)this.convertNodeExtendInfo(node.getExtendInfo(), NodeExtendInfoForDBDTO.class);
            ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo nodeDetailDatasourceInfo = new ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo();
            nodeDetailDatasourceInfo.setNode(extendInfo.getIp() + ":" + extendInfo.getPort());
            return Lists.newArrayList((Object[])new ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo[]{nodeDetailDatasourceInfo});
        }
        if (NodeTypeGroupEnum.OSS.name().equals(node.getNodeTypeGroup())) {
            NodeExtendInfoForOSSDTO extendInfo = (NodeExtendInfoForOSSDTO)this.convertNodeExtendInfo(node.getExtendInfo(), NodeExtendInfoForOSSDTO.class);
            ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo nodeDetailDatasourceInfo = new ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo();
            nodeDetailDatasourceInfo.setNode(extendInfo.getIp() + ":" + extendInfo.getPort());
            return Lists.newArrayList((Object[])new ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo[]{nodeDetailDatasourceInfo});
        }
        if (NodeTypeGroupEnum.SEARCH.name().equals(node.getNodeTypeGroup())) {
            NodeExtendInfoForSearchDTO extendInfo = (NodeExtendInfoForSearchDTO)this.convertNodeExtendInfo(node.getExtendInfo(), NodeExtendInfoForSearchDTO.class);
            ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo nodeDetailDatasourceInfo = new ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo();
            nodeDetailDatasourceInfo.setNode(extendInfo.getIp() + ":" + extendInfo.getPort());
            return Lists.newArrayList((Object[])new ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo[]{nodeDetailDatasourceInfo});
        }
        if (NodeTypeGroupEnum.APP.name().equals(node.getNodeTypeGroup())) {
            if (CollectionUtils.isNotEmpty((Collection)appNodeMap.get(node.getNodeName()))) {
                return appNodeMap.get(node.getNodeName()).stream().map(nodeDTO -> {
                    ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo nodeDetailDatasourceInfo = new ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo();
                    nodeDetailDatasourceInfo.setNode(nodeDTO.getIpAddress());
                    return nodeDetailDatasourceInfo;
                }).collect(Collectors.toList());
            }
            return Lists.newArrayList();
        }
        if (this.isUnknownNode(node) || this.isOuterService(node)) {
            NodeExtendInfoBaseDTO extendInfo = (NodeExtendInfoBaseDTO)this.convertNodeExtendInfo(node.getExtendInfo(), NodeExtendInfoBaseDTO.class);
            ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo nodeDetailDatasourceInfo = new ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo();
            nodeDetailDatasourceInfo.setNode(extendInfo.getIp() + ":" + extendInfo.getPort());
            return Lists.newArrayList((Object[])new ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo[]{nodeDetailDatasourceInfo});
        }
        return null;
    }

    private List<ApplicationEntranceTopologyResponse.ExceptionListResponse> convertExceptions(ApplicationEntranceTopologyResponse applicationEntranceTopologyResponse, LinkTopologyDTO applicationEntrancesTopology, Map<String, LinkNodeDTO> nodeMap, Map<String, List<LinkEdgeDTO>> providerEdgeMap, Map<String, List<LinkEdgeDTO>> callEdgeMap) {
        ArrayList<ApplicationEntranceTopologyResponse.ExceptionListResponse> exceptionList = new ArrayList<ApplicationEntranceTopologyResponse.ExceptionListResponse>();
        if (CollectionUtils.isNotEmpty((Collection)applicationEntranceTopologyResponse.getNodes())) {
            applicationEntranceTopologyResponse.getNodes().stream().filter(arg_0 -> this.isUnknownResponseNode(arg_0)).forEach(node -> {
                ApplicationEntranceTopologyResponse.ExceptionListResponse exception = new ApplicationEntranceTopologyResponse.ExceptionListResponse();
                StringBuilder exceptionTitle = new StringBuilder();
                exceptionTitle.append("\u8282\u70b9\"").append(StringUtils.join((Iterable)node.getUpAppNames(), (String)",")).append("\"\u4e0b\u6e38\u5b58\u5728\u5e94\u7528\u672a\u63a5\u5165\u63a2\u9488");
                if (CollectionUtils.isNotEmpty((Collection)node.getNodes())) {
                    exceptionTitle.append("\uff0c\u8282\u70b9IP:").append(StringUtils.join((Iterable)node.getNodes().stream().map(ApplicationEntranceTopologyResponse.NodeDetailDatasourceInfo::getNode).collect(Collectors.toList()), (String)","));
                }
                exception.setTitle(exceptionTitle.toString());
                exception.setType("\u5e94\u7528\u672a\u63a5\u5165\u63a2\u9488");
                exception.setSuggest("\u786e\u8ba4\u8be5\u670d\u52a1\u4e3a\u5916\u90e8\u670d\u52a1\u6216\u5185\u90e8\u670d\u52a1\u63d0\u4f9b\uff0c\u82e5\u4e3a\u5916\u90e8\u670d\u52a1\u8bf7\u5c06\u5176\u6807\u8bb0\u4e3a\u5916\u90e8\u670d\u52a1\uff1b\u82e5\u4e3a\u5185\u90e8\u5e94\u7528\u8bf7\u5c06\u5176\u63a5\u5165\u63a2\u9488");
                exceptionList.add(exception);
            });
        }
        return exceptionList;
    }

    private List<ApplicationEntranceTopologyResponse.ApplicationEntranceTopologyEdgeResponse> convertEdges(LinkTopologyDTO applicationEntrancesTopology, Map<String, LinkNodeDTO> nodeMap, Map<String, List<LinkEdgeDTO>> providerEdgeMap, Map<String, List<LinkEdgeDTO>> callEdgeMap, ApplicationEntranceTopologyQueryRequest request) {
        if (CollectionUtils.isEmpty((Collection)applicationEntrancesTopology.getEdges())) {
            return Lists.newArrayList();
        }
        List<ApplicationEntranceTopologyResponse.ApplicationEntranceTopologyEdgeResponse> edgeResponseList = applicationEntrancesTopology.getEdges().stream().map(edge -> {
            ApplicationEntranceTopologyResponse.ApplicationEntranceTopologyEdgeResponse applicationEntranceTopologyEdgeResponse = new ApplicationEntranceTopologyResponse.ApplicationEntranceTopologyEdgeResponse();
            if (edge.getEagleType().equals("VIRTUAL")) {
                edge.setMethod(request.getMethod());
                edge.setService(request.getServiceName());
                edge.setMiddlewareName(request.getType().getType());
            }
            applicationEntranceTopologyEdgeResponse.setSource(edge.getSourceId());
            applicationEntranceTopologyEdgeResponse.setTarget(edge.getTargetId());
            applicationEntranceTopologyEdgeResponse.setLabel(edge.getMiddlewareName());
            applicationEntranceTopologyEdgeResponse.setInfo(this.convertEdgeInfo(edge, nodeMap));
            applicationEntranceTopologyEdgeResponse.setId(edge.getEagleId() != null ? edge.getEagleId() : MD5Util.getMD5((String)(edge.getService() + "|" + edge.getMethod())));
            return applicationEntranceTopologyEdgeResponse;
        }).collect(Collectors.toList());
        Map collect = edgeResponseList.stream().collect(Collectors.groupingBy(ApplicationEntranceTopologyResponse.ApplicationEntranceTopologyEdgeResponse::getSource, Collectors.groupingBy(ApplicationEntranceTopologyResponse.ApplicationEntranceTopologyEdgeResponse::getTarget, Collectors.mapping(ApplicationEntranceTopologyResponse.ApplicationEntranceTopologyEdgeResponse::getInfo, Collectors.toSet()))));
        edgeResponseList.forEach(edge -> {
            Map stringListMap = (Map)collect.get(edge.getSource());
            Set strings = (Set)stringListMap.get(edge.getTarget());
            edge.setInfo(null);
            edge.setInfos(strings);
        });
        return edgeResponseList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ApplicationEntranceTopologyResponse.ApplicationEntranceTopologyEdgeResponse>(Comparator.comparing(arg_0 -> this.fetchingGroupKey(arg_0)))), ArrayList::new));
    }

    private <T> T convertNodeExtendInfo(Object extendInfo, Class<T> clazz) {
        String json = JSON.toJSONString((Object)extendInfo);
        return (T)JSON.parseObject((String)json, clazz);
    }

    private String convertEdgeInfo(LinkEdgeDTO edge, Map<String, LinkNodeDTO> nodeMap) {
        return "";
    }

    private boolean isRoot(LinkNodeDTO node) {
        return node.isRoot() && node.getNodeName().endsWith("-Virtual");
    }

    private String getNodeInfoLabel(LinkNodeDTO node) {
        String label = node.getNodeName();
        if (this.isRoot(node)) {
            label = "\u5165\u53e3";
        } else if (node.getNodeTypeGroup().equalsIgnoreCase(NodeTypeGroupEnum.APP.getType()) || node.getNodeTypeGroup().equalsIgnoreCase(NodeTypeGroupEnum.CACHE.getType())) {
            label = node.getNodeType() + ":" + node.getNodeName();
        }
        if (this.isUnknownNode(node)) {
            label = "\u672a\u77e5\u5e94\u7528";
        } else if (this.isOuterService(node)) {
            label = "\u5916\u90e8\u5e94\u7528";
        }
        return label;
    }

    private boolean nodeIsApp(LinkNodeDTO node) {
        return node.getNodeType().equalsIgnoreCase(NodeTypeEnum.APP.name());
    }

    private boolean isUnknownNode(LinkNodeDTO node) {
        return node.getNodeName().equalsIgnoreCase("UNKNOWN");
    }

    private boolean isUnknownResponseNode(ApplicationEntranceTopologyResponse.TopologyNodeResponse node) {
        return node.getNodeType().getType().equals(ApplicationEntranceTopologyResponse.NodeTypeResponseEnum.UNKNOWN.getType());
    }

    private boolean isOuterService(LinkNodeDTO node) {
        return node.getNodeName().equalsIgnoreCase("OUTSERVICE");
    }

    private boolean isVirtualNode(LinkNodeDTO node) {
        return node.getNodeName().endsWith("-Virtual");
    }

    private String fetchingGroupKey(ApplicationEntranceTopologyResponse.ApplicationEntranceTopologyEdgeResponse response) {
        return response.getSource() + "@" + response.getTarget();
    }
}

