/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service;

import com.google.common.collect.Lists;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.common.util.DateUtils;
import com.pamirs.tro.entity.domain.entity.LinkBottleneck;
import com.pamirs.tro.entity.domain.entity.TLinkTopologyInfo;
import com.pamirs.tro.entity.domain.entity.TWList;
import com.pamirs.tro.entity.domain.vo.TLinkTopologyInfoVo;
import com.pamirs.tro.entity.domain.vo.TLinkTopologyShowVo;
import com.pamirs.tro.entity.domain.vo.TopologyLink;
import com.pamirs.tro.entity.domain.vo.TopologyNode;
import com.pamirs.tro.entity.domain.vo.bottleneck.AsyncVo;
import com.pamirs.tro.entity.domain.vo.bottleneck.BottleCountVo;
import com.pamirs.tro.entity.domain.vo.bottleneck.BottleLevelCountVo;
import com.pamirs.tro.entity.domain.vo.bottleneck.BottleNeckDetailVo;
import com.pamirs.tro.entity.domain.vo.bottleneck.BottleNeckVo;
import com.pamirs.tro.entity.domain.vo.bottleneck.RtVo;
import com.pamirs.tro.entity.domain.vo.bottleneck.StabilityVo;
import io.shulie.tro.web.app.common.CommonService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class LinkTopologyInfoService
extends CommonService {
    private static final Logger logger = LoggerFactory.getLogger(LinkTopologyInfoService.class);
    private static final String[] BOTTLE_TYPE_HTTP = new String[]{"1", "3", "4"};
    private static final String[] BOTTLE_TYPE_MQ = new String[]{"1", "2", "3"};
    private static final String[] BOTTLE_TYPE_JOB = new String[]{"1", "2", "3"};
    private static final String[] BOTTLE_TYPE_DEFAULT = new String[]{"1", "3"};
    private static final int PRE_FIVE_MINUTE = -5;
    private static final int PRE_TWENTY_FOUR_HOUR = -24;

    public static void checkFile(MultipartFile file) throws TROModuleException {
        if (null == file) {
            logger.warn("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            throw new TROModuleException(TROErrorEnum.TRANSPARENTFLOW_LINKTOPOLOGY_EXCEL_IS_EMTPT_EXCEPTION);
        }
        String fileName = file.getOriginalFilename();
        if (!fileName.endsWith("xls") && !fileName.endsWith("xlsx")) {
            logger.error(fileName + "\u4e0d\u662fexcel\u6587\u4ef6");
            throw new TROModuleException(TROErrorEnum.TRANSPARENTFLOW_LINKTOPOLOGY_EXCEL_SUFFIX_ERROR_EXCEPTION);
        }
    }

    public static Workbook getWorkBook(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        HSSFWorkbook workbook = null;
        try {
            InputStream is = file.getInputStream();
            if (fileName.endsWith("xls")) {
                workbook = new HSSFWorkbook(is);
            } else if (fileName.endsWith("xlsx")) {
                workbook = new XSSFWorkbook(is);
            }
        }
        catch (IOException e) {
            logger.info(e.getMessage());
        }
        return workbook;
    }

    public void importExcelData(MultipartFile excel) throws TROModuleException {
        LinkTopologyInfoService.checkFile((MultipartFile)excel);
        Workbook workbook = LinkTopologyInfoService.getWorkBook((MultipartFile)excel);
        ArrayList topologyInfoList = new ArrayList();
        if (workbook != null) {
            this.convertToTopology(workbook, topologyInfoList);
        }
        if (CollectionUtils.isNotEmpty(topologyInfoList)) {
            this.tLinkTopologyInfoDao.deleteAllData();
            this.tLinkTopologyInfoDao.insertList(topologyInfoList);
        }
    }

    private void convertToTopology(Workbook workbook, List<TLinkTopologyInfo> topologyInfoList) {
        Sheet sheet = workbook.getSheetAt(0);
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        for (int rowNum = firstRowNum + 1; rowNum <= lastRowNum; ++rowNum) {
            TLinkTopologyInfo topologyInfo = new TLinkTopologyInfo();
            topologyInfo.setTltiId(Long.valueOf(this.snowflake.next()));
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            int firstCellNum = row.getFirstCellNum();
            int lastCellNum = row.getPhysicalNumberOfCells();
            block17: for (int cellNum = firstCellNum; cellNum < lastCellNum; ++cellNum) {
                Cell cell = row.getCell(cellNum);
                cell.setCellType(CellType.STRING);
                switch (cellNum) {
                    case 0: {
                        if (!StringUtils.isNotEmpty((String)cell.getStringCellValue())) continue block17;
                        topologyInfo.setLinkId(Long.valueOf(Long.parseLong(cell.getStringCellValue())));
                        continue block17;
                    }
                    case 1: {
                        topologyInfo.setLinkName(cell.getStringCellValue());
                        continue block17;
                    }
                    case 2: {
                        topologyInfo.setEntranceType(cell.getStringCellValue());
                        continue block17;
                    }
                    case 3: {
                        topologyInfo.setLinkEntrance(cell.getStringCellValue());
                        continue block17;
                    }
                    case 4: {
                        topologyInfo.setNameServer(cell.getStringCellValue());
                        continue block17;
                    }
                    case 5: {
                        topologyInfo.setLinkType(cell.getStringCellValue());
                        continue block17;
                    }
                    case 6: {
                        topologyInfo.setLinkGroup(cell.getStringCellValue());
                        continue block17;
                    }
                    case 7: {
                        topologyInfo.setFromLinkIds(cell.getStringCellValue());
                        continue block17;
                    }
                    case 8: {
                        topologyInfo.setToLinkIds(cell.getStringCellValue());
                        continue block17;
                    }
                    case 9: {
                        topologyInfo.setShowFromLinkId(cell.getStringCellValue());
                        continue block17;
                    }
                    case 10: {
                        topologyInfo.setShowToLinkId(cell.getStringCellValue());
                        continue block17;
                    }
                    case 11: {
                        topologyInfo.setSecondLinkId(cell.getStringCellValue());
                        continue block17;
                    }
                    case 12: {
                        topologyInfo.setApplicationName(cell.getStringCellValue());
                        continue block17;
                    }
                    case 13: {
                        topologyInfo.setVolumeCalcStatus(cell.getStringCellValue());
                        continue block17;
                    }
                }
            }
            topologyInfoList.add(topologyInfo);
        }
    }

    public TLinkTopologyShowVo queryLinkTopologyByLinkGroup(String linkGroup, String secondLinkId) throws TROModuleException {
        if (StringUtils.isEmpty((String)linkGroup)) {
            throw new TROModuleException(TROErrorEnum.TRANSPARENTFLOW_LINKTOPOLOGY_LINK_GROUP_EMPTY_EXCEPTION);
        }
        TLinkTopologyShowVo vo = new TLinkTopologyShowVo();
        List topologyInfoList = this.tLinkTopologyInfoDao.queryLinkTopologyByLinkGroup(linkGroup, secondLinkId);
        if (CollectionUtils.isEmpty((Collection)topologyInfoList)) {
            return vo;
        }
        HashSet<TopologyLink> linkList = new HashSet<TopologyLink>();
        ArrayList<TopologyNode> nodeList = new ArrayList<TopologyNode>();
        for (TLinkTopologyInfoVo info : topologyInfoList) {
            String[] toinkId;
            TopologyLink link;
            TopologyNode node = new TopologyNode();
            BeanUtils.copyProperties((Object)info, (Object)node);
            String linkId = String.valueOf(info.getLinkId());
            node.setLinkId(linkId);
            String bottleLevel = this.getBottleLevel(info.getEntranceType(), info.getLinkEntrance(), info.getApplicationName(), this.queryBottleNeckPreOneMinute());
            node.setBottleLevel(bottleLevel);
            nodeList.add(node);
            if (StringUtils.isNotEmpty((String)info.getFromLinkIds())) {
                String[] fromLinkId;
                for (String fromLink : fromLinkId = info.getFromLinkIds().split(",")) {
                    link = new TopologyLink();
                    link.setFrom(fromLink);
                    link.setTo(linkId);
                    linkList.add(link);
                }
            }
            if (!StringUtils.isNotEmpty((String)info.getToLinkIds())) continue;
            for (String toLink : toinkId = info.getToLinkIds().split(",")) {
                link = new TopologyLink();
                link.setFrom(linkId);
                link.setTo(toLink);
                linkList.add(link);
            }
        }
        vo.setLinkList(linkList);
        vo.setNodeList(nodeList);
        return vo;
    }

    private List<LinkBottleneck> queryBottleNeckPreOneMinute() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -5);
        return this.queryBottleNeckPreTime(DateUtils.dateToString((Date)calendar.getTime(), (String)"yyyy-MM-dd HH:mm:ss"));
    }

    private List<LinkBottleneck> queryBottleNeckPreTime(String startTime) {
        return this.tLinkTopologyInfoDao.queryBottleNeckPreTime(startTime);
    }

    private String getBottleLevel(String type, String linkEntrance, String applicationName, List<LinkBottleneck> preMinuteBottleNeckList) {
        List bottleNeckList = preMinuteBottleNeckList.stream().filter(linkBottleneck -> applicationName.equals(linkBottleneck.getAppName()) && this.getBottleTypeList(type).contains(String.valueOf(linkBottleneck.getBottleneckType()))).collect(Collectors.toList());
        if (bottleNeckList.isEmpty()) {
            return "normal";
        }
        Integer minNodeBottleNeckLevel = bottleNeckList.stream().filter(linkBottleneck -> linkEntrance.equals(linkBottleneck.getKeyWords())).map(linkBottleneck -> linkBottleneck.getBottleneckLevel()).distinct().min(Comparator.comparingInt(o -> o)).orElse(3);
        Integer tpsRtBottleNeckLevel = bottleNeckList.stream().filter(linkBottleneck -> linkBottleneck.getBottleneckType() == 3).map(linkBottleneck -> linkBottleneck.getBottleneckLevel()).distinct().min(Comparator.comparingInt(o -> o)).orElse(3);
        Integer basicBottleNeckLevel = bottleNeckList.stream().filter(linkBottleneck -> linkBottleneck.getBottleneckType() == 1 && linkBottleneck.getCreateTime().getTime() > System.currentTimeMillis() - 60000L).map(linkBottleneck -> linkBottleneck.getBottleneckLevel()).distinct().min(Comparator.comparingInt(o -> o)).orElse(3);
        ArrayList list = Lists.newArrayList((Object[])new Integer[]{minNodeBottleNeckLevel, tpsRtBottleNeckLevel, basicBottleNeckLevel});
        int minValue = IntStream.of(minNodeBottleNeckLevel, tpsRtBottleNeckLevel, basicBottleNeckLevel).min().getAsInt();
        switch (minValue) {
            case 1: {
                return "serious";
            }
            case 2: {
                return "error";
            }
        }
        return "normal";
    }

    private List<String> getBottleTypeList(String type) {
        List<String> bottleTypeList = Arrays.stream(BOTTLE_TYPE_DEFAULT).collect(Collectors.toList());
        String entranceType = StringUtils.upperCase((String)type);
        if (entranceType.contains("MQ")) {
            entranceType = "MQ";
        }
        switch (entranceType) {
            case "HTTP": {
                bottleTypeList = Arrays.stream(BOTTLE_TYPE_HTTP).collect(Collectors.toList());
                break;
            }
            case "MQ": {
                bottleTypeList = Arrays.stream(BOTTLE_TYPE_MQ).collect(Collectors.toList());
                break;
            }
            case "JOB": {
                bottleTypeList = Arrays.stream(BOTTLE_TYPE_JOB).collect(Collectors.toList());
                break;
            }
            case "DUBBO": {
                break;
            }
        }
        return bottleTypeList;
    }

    public BottleCountVo queryLinkBottleSummary() {
        List preMinuteBottleNeckList = this.queryBottleNeckPreOneMinute();
        BottleCountVo bottleCountVo = new BottleCountVo();
        BottleLevelCountVo summary = new BottleLevelCountVo();
        ArrayList totalSeriousList = Lists.newArrayList();
        ArrayList totalErrorList = Lists.newArrayList();
        ArrayList totalNormalList = Lists.newArrayList();
        ArrayList linkRelatedList = Lists.newArrayList();
        List linkGroupAppList = this.tLinkTopologyInfoDao.queryLinkGroupInfo();
        Map linkGroupMaps = linkGroupAppList.stream().collect(Collectors.groupingByConcurrent(map -> MapUtils.getString((Map)map, (Object)"linkGroup")));
        linkGroupMaps.keySet().stream().sorted(Comparator.comparingInt(Integer::parseInt)).forEach(linkGroup -> {
            BottleLevelCountVo linkRelated = new BottleLevelCountVo();
            List linkGroupMapList = (List)linkGroupMaps.get(linkGroup);
            ArrayList seriousList = Lists.newArrayList();
            ArrayList errorList = Lists.newArrayList();
            ArrayList normalList = Lists.newArrayList();
            linkGroupMapList.stream().forEach(linkGroupMap -> {
                String appName = MapUtils.getString((Map)linkGroupMap, (Object)"APPLICATION_NAME");
                String entranceType = MapUtils.getString((Map)linkGroupMap, (Object)"ENTRANCE_TYPE");
                String linkEntrance = MapUtils.getString((Map)linkGroupMap, (Object)"LINK_ENTRANCE");
                String linkId = MapUtils.getString((Map)linkGroupMap, (Object)"LINK_ID");
                if (StringUtils.isNotEmpty((String)linkId)) {
                    if (StringUtils.isEmpty((String)appName) && StringUtils.isEmpty((String)linkEntrance)) {
                        normalList.add(linkId);
                    } else {
                        String bottleLevel;
                        switch (bottleLevel = this.getBottleLevel(entranceType, linkEntrance, appName, preMinuteBottleNeckList)) {
                            case "serious": {
                                seriousList.add(linkId);
                                break;
                            }
                            case "error": {
                                errorList.add(linkId);
                                break;
                            }
                            case "normal": {
                                normalList.add(linkId);
                                break;
                            }
                        }
                    }
                }
            });
            linkRelated.setSeriousBottle(seriousList.size());
            linkRelated.setBottle(errorList.size());
            linkRelated.setNormal(normalList.size());
            linkRelatedList.add(linkRelated);
            totalSeriousList.addAll(seriousList);
            totalErrorList.addAll(errorList);
            totalNormalList.addAll(normalList);
        });
        summary.setSeriousBottle(totalSeriousList.size());
        summary.setBottle(totalErrorList.size());
        summary.setNormal(totalNormalList.size());
        bottleCountVo.setSummary(summary);
        bottleCountVo.setLinkRelated((List)linkRelatedList);
        return bottleCountVo;
    }

    public BottleNeckDetailVo queryLinkBottleDetail(Map<String, Object> paramMap) {
        String applicationName = MapUtils.getString(paramMap, (Object)"applicationName", (String)"");
        String linkEntrance = MapUtils.getString(paramMap, (Object)"linkEntrance", (String)"");
        String entranceType = MapUtils.getString(paramMap, (Object)"entranceType", (String)"");
        List bottleNeckPre24Hour = this.queryBottleNeckPre24Hour();
        List basic = bottleNeckPre24Hour.stream().filter(linkBottleneck -> applicationName.equals(linkBottleneck.getAppName()) && linkBottleneck.getBottleneckType() == 1 && linkBottleneck.getBottleneckLevel() == 1).sorted((o1, o2) -> o2.getCreateTime().compareTo(o1.getCreateTime())).limit(10L).map(linkBottleNeck -> {
            BottleNeckVo bottleNeckVo = new BottleNeckVo();
            bottleNeckVo.setBottleNeckContent(linkBottleNeck.getText());
            bottleNeckVo.setCreateTime(DateUtils.dateToString((Date)linkBottleNeck.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            return bottleNeckVo;
        }).collect(Collectors.toList());
        List seriousAsync = bottleNeckPre24Hour.stream().filter(linkBottleneck -> applicationName.equals(linkBottleneck.getAppName()) && linkEntrance.equals(linkBottleneck.getKeyWords()) && linkBottleneck.getBottleneckType() == 2 && linkBottleneck.getBottleneckLevel() == 1).sorted((o1, o2) -> o2.getCreateTime().compareTo(o1.getCreateTime())).limit(5L).map(linkBottleNeck -> {
            BottleNeckVo bottleNeckVo = new BottleNeckVo();
            bottleNeckVo.setBottleNeckContent(linkBottleNeck.getText());
            bottleNeckVo.setCreateTime(DateUtils.dateToString((Date)linkBottleNeck.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            return bottleNeckVo;
        }).collect(Collectors.toList());
        List errorAsync = bottleNeckPre24Hour.stream().filter(linkBottleneck -> applicationName.equals(linkBottleneck.getAppName()) && linkEntrance.equals(linkBottleneck.getKeyWords()) && linkBottleneck.getBottleneckType() == 2 && linkBottleneck.getBottleneckLevel() == 2).sorted((o1, o2) -> o2.getCreateTime().compareTo(o1.getCreateTime())).limit(5L).map(linkBottleNeck -> {
            BottleNeckVo bottleNeckVo = new BottleNeckVo();
            bottleNeckVo.setBottleNeckContent(linkBottleNeck.getText());
            bottleNeckVo.setCreateTime(DateUtils.dateToString((Date)linkBottleNeck.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            return bottleNeckVo;
        }).collect(Collectors.toList());
        ArrayList async = Lists.newArrayList();
        async.add(new AsyncVo("serious", seriousAsync));
        async.add(new AsyncVo("error", errorAsync));
        List seriousStability = bottleNeckPre24Hour.stream().filter(linkBottleneck -> applicationName.equals(linkBottleneck.getAppName()) && linkBottleneck.getBottleneckType() == 3 && linkBottleneck.getBottleneckLevel() == 1).sorted((o1, o2) -> o2.getCreateTime().compareTo(o1.getCreateTime())).limit(5L).map(linkBottleNeck -> {
            BottleNeckVo bottleNeckVo = new BottleNeckVo();
            bottleNeckVo.setBottleNeckContent(linkBottleNeck.getText());
            bottleNeckVo.setCreateTime(DateUtils.dateToString((Date)linkBottleNeck.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            return bottleNeckVo;
        }).collect(Collectors.toList());
        List errorStability = bottleNeckPre24Hour.stream().filter(linkBottleneck -> applicationName.equals(linkBottleneck.getAppName()) && linkBottleneck.getBottleneckType() == 3 && linkBottleneck.getBottleneckLevel() == 2).sorted((o1, o2) -> o2.getCreateTime().compareTo(o1.getCreateTime())).limit(5L).map(linkBottleNeck -> {
            BottleNeckVo bottleNeckVo = new BottleNeckVo();
            bottleNeckVo.setBottleNeckContent(linkBottleNeck.getText());
            bottleNeckVo.setCreateTime(DateUtils.dateToString((Date)linkBottleNeck.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            return bottleNeckVo;
        }).collect(Collectors.toList());
        ArrayList stability = Lists.newArrayList();
        stability.add(new StabilityVo("serious", seriousStability));
        stability.add(new StabilityVo("error", errorStability));
        List seriousRt = bottleNeckPre24Hour.stream().filter(linkBottleneck -> applicationName.equals(linkBottleneck.getAppName()) && linkEntrance.equals(linkBottleneck.getKeyWords()) && linkBottleneck.getBottleneckType() == 4 && linkBottleneck.getBottleneckLevel() == 1).sorted((o1, o2) -> o2.getCreateTime().compareTo(o1.getCreateTime())).limit(5L).map(linkBottleNeck -> {
            BottleNeckVo bottleNeckVo = new BottleNeckVo();
            bottleNeckVo.setBottleNeckContent(linkBottleNeck.getText());
            bottleNeckVo.setCreateTime(DateUtils.dateToString((Date)linkBottleNeck.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            return bottleNeckVo;
        }).collect(Collectors.toList());
        ArrayList rt = Lists.newArrayList();
        String type = "";
        if (entranceType.equalsIgnoreCase("HTTP")) {
            TWList wList = this.tWListMntDao.getWListByParam((Map)new /* Unavailable Anonymous Inner Class!! */);
            type = wList == null ? "" : wList.getHttpType();
        }
        rt.add(new RtVo(type, seriousRt));
        BottleNeckDetailVo bottleNeckDetail = new BottleNeckDetailVo();
        bottleNeckDetail.setBasic(basic);
        bottleNeckDetail.setAsync((List)async);
        bottleNeckDetail.setStability((List)stability);
        bottleNeckDetail.setRt((List)rt);
        return bottleNeckDetail;
    }

    private List<LinkBottleneck> queryBottleNeckPre24Hour() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, -24);
        return this.queryBottleNeckPreTime(DateUtils.dateToString((Date)calendar.getTime(), (String)"yyyy-MM-dd HH:mm:ss"));
    }
}

