/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service;

import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.common.util.TroFileUtil;
import io.shulie.tro.web.app.common.CommonService;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileUploadService
extends CommonService {
    public List<String> batchUploadFile(MultipartFile[] files) throws IOException, TROModuleException {
        if (files == null || files.length == 0) {
            throw new TROModuleException(TROErrorEnum.ASSIST_DBCONF_SQL_BATHC_UPLOAD_PARAM_EXCEPTION);
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public String executeFile(MultipartFile file) throws IOException, TROModuleException {
        long size = file.getSize();
        int length = file.getBytes().length;
        String fileName = file.getOriginalFilename();
        String suffixName = StringUtils.substringAfterLast((String)fileName, (String)".");
        this.LOGGER.info("\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u4e3a\uff1a" + fileName + " \u6587\u4ef6\u7684\u540e\u7f00\u540d\u4e3a\uff1a" + suffixName + " \u6587\u4ef6\u7684\u5927\u5c0f\u4e3a\uff1a" + size + " \u6587\u4ef6\u7684\u957f\u5ea6\u4e3a\uff1a" + length);
        if (!fileName.endsWith(".sql")) {
            throw new TROModuleException(TROErrorEnum.ASSIST_DBCONF_SQL_UPLOAD_TYPE_ERROR);
        }
        String path = this.getLoadSqlPath() + fileName;
        TroFileUtil.createDirByString((String)path);
        if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            fileName = this.generateUUID() + "." + suffixName;
            path = this.getLoadSqlPath() + fileName;
        }
        Files.copy(file.getInputStream(), Paths.get(path, new String[0]), new CopyOption[0]);
        return path;
    }

    public void downloadFile(String fileName, HttpServletResponse response) throws IOException, TROModuleException {
        String filePath = this.getLoadSqlPath() + fileName;
        TroFileUtil.createDirByString((String)filePath);
        if (new File(filePath).exists()) {
            ServletOutputStream outputStream = response.getOutputStream();
            Files.copy(Paths.get(filePath, new String[0]), (OutputStream)outputStream);
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("UTF-8"), "iso-8859-1"));
        }
    }
}

