/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service;

import com.github.pagehelper.PageHelper;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.constant.TROConstantEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.common.util.PageInfo;
import com.pamirs.tro.entity.dao.dict.TDictionaryDataMapper;
import com.pamirs.tro.entity.domain.entity.TDictionaryData;
import com.pamirs.tro.entity.domain.entity.TDictionaryType;
import com.pamirs.tro.entity.domain.vo.TDictionaryVo;
import io.shulie.tro.web.app.common.CommonService;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictionaryMntService
extends CommonService {
    @Autowired
    private TDictionaryDataMapper tDictionaryDataMapper;

    @Transactional(value="troTransactionManager", rollbackFor={Exception.class})
    public void saveDictionary(TDictionaryVo tDictionaryVo) throws TROModuleException {
        String userName = null;
        TDictionaryType tDictionaryType = this.tDictionaryTypeMapper.selectDictionaryByTypeAlias(tDictionaryVo.getTypeAlias());
        if (tDictionaryType == null) {
            tDictionaryType = new TDictionaryType();
            tDictionaryType.setCreateUserCode(userName);
            tDictionaryType.setModifyUserCode(userName);
            tDictionaryType.setTypeAlias(tDictionaryVo.getTypeAlias());
            tDictionaryType.setTypeName(tDictionaryVo.getTypeName());
            tDictionaryType.setActive(tDictionaryVo.getTypeActive());
            this.tDictionaryTypeMapper.insert(tDictionaryType);
        }
        TDictionaryData tDictionaryData = new TDictionaryData();
        tDictionaryData.setDictType(tDictionaryType.getId());
        tDictionaryData.setValueCode(tDictionaryVo.getValueCode());
        tDictionaryData.setValueName(tDictionaryVo.getValueName());
        tDictionaryData.setValueOrder(Integer.valueOf(tDictionaryVo.getValueOrder()));
        tDictionaryData.setLanguage(tDictionaryVo.getLanguage());
        tDictionaryData.setActive(tDictionaryVo.getValueActive());
        tDictionaryData.setCreateUserCode(userName);
        tDictionaryData.setModifyUserCode(userName);
        this.tDictionaryDataMapper.insert(tDictionaryData);
    }

    public void updateDictionary(TDictionaryVo tDictionaryVo) {
        this.tDictionaryDataMapper.updateDictionary(tDictionaryVo);
    }

    public PageInfo<TDictionaryVo> queryDictionaryList(Map<String, Object> paramMap) {
        PageHelper.startPage((int)PageInfo.getPageNum(paramMap), (int)PageInfo.getPageSize(paramMap));
        List dictionaryVoList = this.tDictionaryDataMapper.queryDictionaryList(paramMap);
        return new PageInfo(dictionaryVoList);
    }

    public TDictionaryVo queryDictionaryDetail(String tDictionaryId) {
        return this.tDictionaryDataMapper.queryDictionaryDetail(tDictionaryId);
    }

    public void deleteDictionary(String tDictionaryIdList) {
        this.tDictionaryDataMapper.deleteDictionary(Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)tDictionaryIdList));
        this.tDictionaryDataMapper.deleteEmptyDictType();
    }

    public Map<String, Object> queryDictionaryKeyValue(String dictCode) {
        List dictMaps = this.tDicDao.queryDicList(StringUtils.upperCase((String)dictCode));
        if (dictMaps.isEmpty()) {
            return Maps.newHashMap();
        }
        TreeMap resultMap = Maps.newTreeMap(Comparator.comparingInt(Integer::parseInt));
        dictMaps.forEach(map -> resultMap.put(MapUtils.getString((Map)map, (Object)TROConstantEnum.VALUE_ORDER.toString()), MapUtils.getString((Map)map, (Object)TROConstantEnum.VALUE_NAME.toString())));
        return resultMap;
    }
}

