/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.constant.TRODictTypeEnum;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.constant.WListRuleEnum;
import com.pamirs.tro.common.constant.WListTypeEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.common.redis.RedisKey;
import com.pamirs.tro.common.util.PageInfo;
import com.pamirs.tro.common.util.RequestPradarUtil;
import com.pamirs.tro.common.util.Snowflake;
import com.pamirs.tro.common.util.TroFileUtil;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.dao.confcenter.TLinkMntDao;
import com.pamirs.tro.entity.dao.confcenter.TWListMntDao;
import com.pamirs.tro.entity.domain.entity.TAlarm;
import com.pamirs.tro.entity.domain.entity.TApplicationIp;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import com.pamirs.tro.entity.domain.entity.TBList;
import com.pamirs.tro.entity.domain.entity.TLinkServiceMnt;
import com.pamirs.tro.entity.domain.entity.TSecondLinkMnt;
import com.pamirs.tro.entity.domain.entity.TWList;
import com.pamirs.tro.entity.domain.entity.user.User;
import com.pamirs.tro.entity.domain.query.BListQueryParam;
import com.pamirs.tro.entity.domain.query.Result;
import com.pamirs.tro.entity.domain.query.TWListVo;
import com.pamirs.tro.entity.domain.vo.TApplicationInterface;
import com.pamirs.tro.entity.domain.vo.TLinkApplicationInterface;
import com.pamirs.tro.entity.domain.vo.TLinkBasicVO;
import com.pamirs.tro.entity.domain.vo.TLinkMntDictoryVo;
import com.pamirs.tro.entity.domain.vo.TLinkServiceMntVo;
import com.pamirs.tro.entity.domain.vo.TLinkTopologyInfoVo;
import io.shulie.tro.web.app.cache.webimpl.AllUserCache;
import io.shulie.tro.web.app.common.CommonService;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.service.ConfCenterService;
import io.shulie.tro.web.app.service.auth.TroAuthService;
import io.shulie.tro.web.app.service.linkManage.impl.WhiteListFileService;
import io.shulie.tro.web.app.service.user.TroUserService;
import io.shulie.tro.web.app.service.user.TroWebUserService;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.dao.blacklist.BlackListDAO;
import io.shulie.tro.web.data.param.application.ApplicationCreateParam;
import io.shulie.tro.web.data.param.blacklist.BlackListCreateParam;
import io.shulie.tro.web.data.result.user.UserCacheResult;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ConfCenterService
extends CommonService {
    private static final Logger log = LoggerFactory.getLogger(ConfCenterService.class);
    public static final String CONST_CAS_ASSERTION = "_const_cas_assertion_";
    @Autowired
    @Qualifier(value="modifyMonitorThreadPool")
    protected ThreadPoolExecutor modifyMonitorExecutor;
    @Autowired
    private TroAuthService troAuthService;
    @Autowired
    private TroWebUserService troWebUserService;
    @Autowired
    private TroUserService troUserService;
    @Autowired
    private WhiteListFileService whiteListFileService;
    @Value(value="${spring.config.whiteListPath}")
    private String whiteListPath;
    @Autowired
    private BlackListDAO blackListDAO;
    @Autowired
    private ApplicationDAO applicationDAO;
    @Autowired
    private AllUserCache allUserCache;

    @Transactional(rollbackFor={Exception.class})
    public void saveApplication(TApplicationMnt tApplicationMnt) throws TROModuleException {
        User user = RestContext.getUser();
        if (user == null) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_ADD_APPLICATION_DUPICATE_EXCEPTION);
        }
        int applicationExist = this.tApplicationMntDao.applicationExistByCustomerIdAndAppName(user.getCustomerId(), tApplicationMnt.getApplicationName());
        if (applicationExist > 0) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_ADD_APPLICATION_DUPICATE_EXCEPTION);
        }
        this.addApplication(tApplicationMnt);
        this.addApplicationToDataBuild(tApplicationMnt);
        this.addApplicationToLinkDetection(tApplicationMnt);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveAgentRegisteApplication(TApplicationMnt tApplicationMnt) throws TROModuleException {
        if (StringUtils.isBlank((CharSequence)RestContext.getTenantUserKey())) {
            OperationLogContextHolder.ignoreLog();
            log.error("tenantUserKey\u4e3a\u7a7a\uff0c\u5e94\u7528\u6ce8\u518c\u5931\u8d25");
        } else {
            UserCacheResult user = this.allUserCache.getCachedUserByKey(RestContext.getTenantUserKey());
            int applicationExist = this.tApplicationMntDao.applicationExistByCustomerIdAndAppName(user.getCustomerId(), tApplicationMnt.getApplicationName());
            if (applicationExist > 0) {
                OperationLogContextHolder.ignoreLog();
                return;
            }
            tApplicationMnt.setCustomerId(user.getCustomerId());
            tApplicationMnt.setUserId(user.getId());
            this.addApplication(tApplicationMnt);
            this.addApplicationToDataBuild(tApplicationMnt);
            this.addApplicationToLinkDetection(tApplicationMnt);
        }
    }

    private void addApplicationToLinkDetection(TApplicationMnt tApplicationMnt) {
        1 map = new /* Unavailable Anonymous Inner Class!! */;
        this.TLinkDetectionDao.insertLinkDetection((Map)map);
    }

    private void addApplicationToDataBuild(TApplicationMnt tApplicationMnt) {
        2 map = new /* Unavailable Anonymous Inner Class!! */;
        this.TDataBuildDao.insertDataBuild((Map)map);
    }

    @PostConstruct
    public void initWhiteList() {
        this.writeWhiteListFile();
    }

    private void addApplication(TApplicationMnt tApplicationMnt) throws TROModuleException {
        tApplicationMnt.setApplicationId(this.snowflake.next());
        tApplicationMnt.setCacheExpTime(StringUtils.isEmpty((CharSequence)tApplicationMnt.getCacheExpTime()) ? "0" : tApplicationMnt.getCacheExpTime());
        ApplicationCreateParam createParam = new ApplicationCreateParam();
        BeanUtils.copyProperties((Object)tApplicationMnt, (Object)createParam);
        this.applicationDAO.insert(createParam);
        TroFileUtil.createFile((String)(this.getBasePath() + tApplicationMnt.getApplicationName()));
    }

    public PageInfo<TApplicationInterface> queryWList(Map<String, Object> paramMap) {
        String applicationName = MapUtils.getString(paramMap, (Object)"applicationName");
        String principalNo = MapUtils.getString(paramMap, (Object)"principalNo");
        String type = MapUtils.getString(paramMap, (Object)"type");
        String whiteListUrl = MapUtils.getString(paramMap, (Object)"whiteListUrl");
        Long applicationId = MapUtils.getLong(paramMap, (Object)"applicationId");
        PageHelper.startPage((int)PageInfo.getPageNum(paramMap), (int)PageInfo.getPageSize(paramMap));
        List queryWListInfo = this.tWListMntDao.queryOnlyWList(applicationName, principalNo, type, whiteListUrl, null, applicationId);
        return new PageInfo(queryWListInfo.isEmpty() ? Lists.newArrayList() : queryWListInfo);
    }

    public List<TApplicationInterface> queryWListDownLoad(Map<String, Object> paramMap) {
        String applicationName = MapUtils.getString(paramMap, (Object)"applicationName");
        String principalNo = MapUtils.getString(paramMap, (Object)"principalNo");
        String type = MapUtils.getString(paramMap, (Object)"type");
        String whiteListUrl = MapUtils.getString(paramMap, (Object)"whiteListUrl");
        List applicationIds = null;
        Object wlistIds = paramMap.get("wlistIds");
        if (null != wlistIds) {
            applicationIds = (List)wlistIds;
        }
        return this.tWListMntDao.queryOnlyWList(applicationName, principalNo, type, whiteListUrl, applicationIds, null);
    }

    public void projectPressureSwitch(Long applicationId) {
    }

    public PageInfo<TApplicationMnt> queryApplicationList(Map<String, Object> paramMap) {
        List queryApplicationList;
        String applicationName = MapUtils.getString(paramMap, (Object)"applicationName");
        List applicationIds = (List)MapUtils.getObject(paramMap, (Object)"applicationIds");
        if (!StringUtils.equals((CharSequence)"-1", (CharSequence)MapUtils.getString(paramMap, (Object)"pageSize"))) {
            PageHelper.startPage((int)PageInfo.getPageNum(paramMap), (int)PageInfo.getPageSize(paramMap));
        }
        return new PageInfo((queryApplicationList = this.tApplicationMntDao.queryApplicationList(applicationName, applicationIds)).isEmpty() ? Lists.newArrayList() : queryApplicationList);
    }

    public TApplicationMnt queryApplicationinfoById(long applicationId) {
        TApplicationMnt tApplicationMnt = this.tApplicationMntDao.queryApplicationinfoById(applicationId);
        return tApplicationMnt;
    }

    public TApplicationMnt queryApplicationinfoByIdAndRole(long applicationId) {
        TApplicationMnt tApplicationMnt = this.tApplicationMntDao.queryApplicationinfoById(applicationId);
        return tApplicationMnt;
    }

    @Transactional(rollbackFor={Exception.class})
    public String deleteApplicationinfoByIds(String applicationIds) {
        GetDeleteIds deleteIds = new GetDeleteIds(this, applicationIds, "applicationName").invoke((Object)this.tApplicationMntDao);
        List ableDeleteApplicationList = deleteIds.getAbleDeleteList();
        if (!ableDeleteApplicationList.isEmpty()) {
            this.tWListMntDao.deleteApplicationinfoRelatedInterfaceByIds(ableDeleteApplicationList);
            ableDeleteApplicationList.forEach(applicationId -> {
                TApplicationMnt tApplicationMnt = this.tApplicationMntDao.queryApplicationinfoById(Long.parseLong(applicationId));
                this.redisManager.removeKey("tro_white_list_" + tApplicationMnt.getApplicationName());
                this.redisManager.removeKey("tro_white_list_metric_" + tApplicationMnt.getApplicationName());
            });
            this.redisManager.removeKey("tro_white_list_");
            this.redisManager.removeKey("tro_white_list_metric_");
            this.tApplicationMntDao.queryApplicationName(ableDeleteApplicationList).forEach(applicationName -> TroFileUtil.recursiveDeleteFile((File)new File(this.getBasePath() + applicationName)));
            this.tApplicationMntDao.deleteApplicationinfoByIds(ableDeleteApplicationList);
            this.TDataBuildDao.deleteApplicationToDataBuild(ableDeleteApplicationList);
            this.TLinkDetectionDao.deleteApplicationToLinkDetection(ableDeleteApplicationList);
            this.tShadowTableDataSourceDao.deleteByApplicationIdList(ableDeleteApplicationList);
            HashMap logMap = Maps.newHashMap();
            List ableDeleteApplicationWlistData = this.tApplicationMntDao.queryApplicationListByIds(ableDeleteApplicationList);
            List ableDeleteDataBuild = this.TDataBuildDao.queryDataBuildListByIds(ableDeleteApplicationList);
            List ableDeleteLinkDetection = this.TLinkDetectionDao.queryLinkDetectionListByIds(ableDeleteApplicationList);
            logMap.put("ableDeleteApplicationWlistData", ableDeleteApplicationWlistData);
            logMap.put("ableDeleteDataBuild", ableDeleteDataBuild);
            logMap.put("ableDeleteLinkDetection", ableDeleteLinkDetection);
        }
        return deleteIds.getResult();
    }

    public List<Map<String, Object>> queryApplicationdata() {
        List list = (List)this.transferElementToString((Object)this.tApplicationMntDao.queryApplicationdata());
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateApplicationinfo(TApplicationMnt tApplicationMnt) throws TROModuleException {
        TApplicationMnt originApplicationMnt = this.tApplicationMntDao.queryApplicationinfoById(tApplicationMnt.getApplicationId());
        String originApplicationName = originApplicationMnt.getApplicationName();
        if (!StringUtils.equals((CharSequence)originApplicationName, (CharSequence)tApplicationMnt.getApplicationName())) {
            int applicationExist = this.tApplicationMntDao.applicationExist(tApplicationMnt.getApplicationName());
            if (applicationExist > 0) {
                throw new TROModuleException(TROErrorEnum.CONFCENTER_UPDATE_APPLICATION_DUPICATE_EXCEPTION);
            }
            TroFileUtil.recursiveDeleteFile((File)new File(this.getBasePath() + originApplicationName));
            TroFileUtil.createFile((String)(this.getBasePath() + tApplicationMnt.getApplicationName()));
        }
        this.tApplicationMntDao.updateApplicationinfo(tApplicationMnt);
    }

    public List<String> saveWList(TWListVo twListVo) throws TROModuleException {
        ArrayList duplicateUrlList = Lists.newArrayList();
        if (WListTypeEnum.MQ.getValue().equals(twListVo.getType())) {
            int wListExist = this.tWListMntDao.queryWListCountByMqInfo(twListVo);
            if (wListExist > 0) {
                throw new TROModuleException(TROErrorEnum.CONFCENTER_ADD_WLIST_DUPICATE_EXCEPTION);
            }
            TWList tWList = new TWList();
            BeanUtils.copyProperties((Object)twListVo, (Object)tWList);
            this.addWList(tWList);
        } else {
            String appId = twListVo.getApplicationId();
            List list = twListVo.getList();
            ArrayList twLists = Lists.newArrayList();
            list.forEach(url -> {
                int wListExist = this.tWListMntDao.wListExist(appId, url, twListVo.getUseYn());
                if (wListExist > 0) {
                    duplicateUrlList.add(url);
                } else {
                    TWList tWList = new TWList();
                    BeanUtils.copyProperties((Object)twListVo, (Object)tWList);
                    tWList.setInterfaceName(url);
                    twLists.add(tWList);
                }
            });
            if (twLists.size() == 0 && duplicateUrlList.size() == 0) {
                throw new TROModuleException(TROErrorEnum.CONFCENTER_ADD_WLIST_INTERFACE_LOST_EXCEPTION);
            }
            if (twLists.size() == 0 && duplicateUrlList.size() != 0) {
                throw new TROModuleException(TROErrorEnum.CONFCENTER_ADD_WLIST_DUPICATE_EXCEPTION);
            }
            this.batchAddWList((List)twLists);
        }
        this.writeWhiteListFile();
        return duplicateUrlList;
    }

    private void writeWhiteListFile() {
        try {
            Map result = this.queryBWList("");
            if (null != result && result.size() > 0) {
                File file = new File(this.whiteListPath);
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (file.exists() && !(file = new File(this.whiteListPath + "bwlist")).isFile()) {
                    file.createNewFile();
                }
                ResponseOk.ResponseResult response = ResponseOk.result((Object)result);
                String content = JSONObject.toJSONString((Object)response);
                FileWriter fileWriter = new FileWriter(file.getAbsoluteFile(), false);
                BufferedWriter bufferWritter = new BufferedWriter(fileWriter);
                bufferWritter.write(content);
                bufferWritter.close();
            }
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage());
        }
    }

    private void batchAddWList(List<TWList> twLists) {
        this.tWListMntDao.batchAddWList(twLists);
    }

    private void addWList(TWList tWList) {
        this.tWListMntDao.addWList(tWList);
    }

    public List<TApplicationInterface> queryOnlyWList(String applicationName, String principalNo, String type, String x, Long appId) {
        List queryWListInfo = this.tWListMntDao.queryOnlyWList(applicationName, principalNo, type, x, null, null);
        return queryWListInfo.isEmpty() ? Lists.newArrayList() : queryWListInfo;
    }

    public List<TApplicationInterface> queryWList(String applicationName, String principalNo, String type) {
        return this.tWListMntDao.queryWList(applicationName, principalNo, type);
    }

    public TWList querySingleWListById(String wlistId) throws TROModuleException {
        TWList tWlist = this.tWListMntDao.querySingleWListById(wlistId);
        if (tWlist == null) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_QUERY_WLISTBYID_NOTEXIST);
        }
        return tWlist;
    }

    public void updateWListById(TWList param) throws TROModuleException {
        TWList dbData = this.tWListMntDao.querySingleWListById(String.valueOf(param.getWlistId()));
        if (dbData == null) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_QUERY_WLISTBYID_NOTEXIST);
        }
        int applicationExist = this.tWListMntDao.wListExist(param.getApplicationId(), param.getInterfaceName(), param.getUseYn());
        if (applicationExist > 1) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_UPDATE_WLIST_DUPICATE_EXCEPTION);
        }
        this.tWListMntDao.updateSelective(param);
        this.writeWhiteListFile();
    }

    public String deleteWListByIds(String wlistIds) {
        GetDeleteIds deleteIds = new GetDeleteIds(this, wlistIds, "interfaceName").invoke((Object)this.tWListMntDao);
        List ableDeleteWList = deleteIds.getAbleDeleteList();
        if (!ableDeleteWList.isEmpty()) {
            List ableDeleteWLists = this.tWListMntDao.queryWListByIds(ableDeleteWList);
            this.tWListMntDao.deleteWListByIds(ableDeleteWList);
            ableDeleteWLists.stream().map(tWList -> tWList.getApplicationId()).distinct().forEach(applicationId -> {
                TApplicationMnt tApplicationMnt = this.tApplicationMntDao.queryApplicationinfoById(Long.parseLong(applicationId));
            });
        }
        this.writeWhiteListFile();
        return deleteIds.getResult();
    }

    public void deleteWListByIds(List<Long> ids) {
        if (!ids.isEmpty()) {
            List ableDeleteWLists = this.tWListMntDao.getWListByIds(ids);
            this.tWListMntDao.deleteByIds(ids);
        }
        this.writeWhiteListFile();
    }

    public void saveBList(TBList tBList) throws TROModuleException {
        int applicationExist;
        if (StringUtils.isBlank((CharSequence)tBList.getUseYn())) {
            tBList.setUseYn("1");
        }
        if ((applicationExist = this.tBListMntDao.bListExist(tBList.getRedisKey())) > 0) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_ADD_BLIST_DUPICATE_EXCEPTION);
        }
        this.addBList(tBList);
        this.writeWhiteListFile();
    }

    private void addBList(TBList tBList) {
        BlackListCreateParam param = new BlackListCreateParam();
        param.setRedisKey(tBList.getRedisKey());
        param.setUseYn(Integer.valueOf(Integer.parseInt(tBList.getUseYn())));
        param.setCreateTime(new Date());
        param.setUpdateTime(new Date());
        this.blackListDAO.insert(param);
        User user = RestContext.getUser();
        this.configSyncService.syncBlockList(user.getKey());
        this.whiteListFileService.writeWhiteListFile(user.getCustomerId(), user.getCustomerKey());
    }

    public TBList querySingleBListById(String blistId) {
        TBList tbList = this.tBListMntDao.querySingleBListById(blistId);
        return tbList;
    }

    public void updateBListById(TBList tBList) {
        TBList originBList = this.tBListMntDao.querySingleBListById(String.valueOf(tBList.getBlistId()));
        this.tBListMntDao.updateBListById(tBList);
        User user = RestContext.getUser();
        if (user == null) {
            user = this.troWebUserService.queryUserByKey(RestContext.getTenantUserKey());
        }
        this.configSyncService.syncBlockList(user.getKey());
        this.whiteListFileService.writeWhiteListFile(user.getCustomerId(), user.getCustomerKey());
    }

    @Deprecated
    public void deleteBListByIds(String blistIds) {
        List blistIdList = Arrays.stream(blistIds.split(",")).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        this.tBListMntDao.deleteBListByIds(blistIdList);
        User user = RestContext.getUser();
        if (user == null) {
            user = this.troWebUserService.queryUserByKey(RestContext.getTenantUserKey());
        }
        this.configSyncService.syncBlockList(user.getKey());
        List deleteBLists = this.tBListMntDao.queryBListByIds(blistIdList);
        this.whiteListFileService.writeWhiteListFile(user.getCustomerId(), user.getCustomerKey());
    }

    public List<TBList> queryBListByIds(List<Long> blistIds) {
        if (CollectionUtils.isEmpty(blistIds)) {
            return Lists.newArrayList();
        }
        List blistIdList = blistIds.stream().map(String::valueOf).collect(Collectors.toList());
        return this.tBListMntDao.queryBListByIds(blistIdList);
    }

    public Response queryBList(BListQueryParam bListQueryParam) {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("pageNum", bListQueryParam.getCurrentPage());
        paramMap.put("pageSize", bListQueryParam.getPageSize());
        String redisKey = bListQueryParam.getRedisKey();
        PageHelper.startPage((int)PageInfo.getPageNum(paramMap), (int)PageInfo.getPageSize(paramMap));
        List queryBList = this.tBListMntDao.queryBList(redisKey, "");
        if (CollectionUtils.isNotEmpty((Collection)queryBList)) {
            for (TBList tbList : queryBList) {
                List allowEnableDisableUserIdList;
                List allowDeleteUserIdList;
                List allowUpdateUserIdList = RestContext.getUpdateAllowUserIdList();
                if (CollectionUtils.isNotEmpty((Collection)allowUpdateUserIdList)) {
                    tbList.setCanEdit(Boolean.valueOf(allowUpdateUserIdList.contains(tbList.getUserId())));
                }
                if (CollectionUtils.isNotEmpty((Collection)(allowDeleteUserIdList = RestContext.getDeleteAllowUserIdList()))) {
                    tbList.setCanRemove(Boolean.valueOf(allowDeleteUserIdList.contains(tbList.getUserId())));
                }
                if (!CollectionUtils.isNotEmpty((Collection)(allowEnableDisableUserIdList = RestContext.getEnableDisableAllowUserIdList()))) continue;
                tbList.setCanEnableDisable(Boolean.valueOf(allowEnableDisableUserIdList.contains(tbList.getUserId())));
            }
        }
        PageInfo pageInfo = new PageInfo(queryBList.isEmpty() ? Lists.newArrayList() : queryBList);
        Response response = Response.success((List)pageInfo.getList(), (long)(CollectionUtils.isEmpty((Collection)pageInfo.getList()) ? 0L : pageInfo.getTotal()));
        return response;
    }

    public Map<String, List<Map<String, Object>>> queryBWList(String appName) throws TROModuleException {
        String appNameKey = "";
        if (StringUtils.isNotEmpty((CharSequence)appName)) {
            appNameKey = appName;
        }
        List wLists = this.tWListMntDao.queryWListList(appName);
        List bLists = this.tBListMntDao.queryBListList();
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)30);
        ArrayList wListsResult = new ArrayList();
        if (wLists != null) {
            for (Map whiteItem : wLists) {
                String type = (String)whiteItem.get("TYPE");
                String interfaceName = (String)whiteItem.get("INTERFACE_NAME");
                if ("dubbo".equals(type) && StringUtils.contains((CharSequence)interfaceName, (CharSequence)"#")) {
                    interfaceName = StringUtils.substringBefore((String)interfaceName, (String)"#");
                }
                HashMap<String, String> whiteItemNew = new HashMap<String, String>();
                whiteItemNew.put("TYPE", type);
                whiteItemNew.put("INTERFACE_NAME", interfaceName);
                wListsResult.add(whiteItemNew);
            }
        }
        resultMap.put("wLists", wListsResult);
        resultMap.put("bLists", bLists);
        return resultMap;
    }

    public Map<String, List<Map<String, Object>>> queryBWMetricList(String appName) throws TROModuleException {
        Optional wListValue;
        List wLists = null;
        List bLists = null;
        String appNameKey = "";
        if (StringUtils.isNotEmpty((CharSequence)appName)) {
            appNameKey = appName;
        }
        if ((wListValue = this.redisManager.valueGet("tro_white_list_metric_" + appNameKey)).isPresent()) {
            wLists = (List)wListValue.get();
        } else {
            RedisKey wListRedis = new RedisKey("tro_white_list_metric_" + appNameKey, 604800L);
            wLists = this.tWListMntDao.queryWListList(appName);
            if (wLists == null || wLists.isEmpty()) {
                throw new TROModuleException(TROErrorEnum.CONFCENTER_QUERY_NOT_WLIST_FOR_APPNAME_EXCEPTION);
            }
            wLists.forEach(map -> {
                String type = (String)map.get("TYPE");
                if ("mq".equals(type)) {
                    String mqType = (String)map.get("MQ_TYPE");
                    if ("1".equals(mqType) || "2".equals(mqType)) {
                        map.put("TYPE", "ibmmq");
                    } else if ("3".equals(mqType) || "4".equals(mqType)) {
                        map.put("TYPE", "rocketmq");
                    }
                }
            });
            this.redisManager.valuePut(wListRedis, (Object)wLists);
        }
        Optional bListValue = this.redisManager.valueGet("tro_black_list");
        if (bListValue.isPresent()) {
            bLists = (List)bListValue.get();
        } else {
            RedisKey bListRedis = new RedisKey("tro_black_list", 604800L);
            bLists = this.tBListMntDao.queryBListList();
            this.redisManager.valuePut(bListRedis, (Object)bLists);
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)30);
        resultMap.put("wLists", wLists);
        resultMap.put("bLists", bLists);
        return resultMap;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveBasicLink(TLinkServiceMntVo tLinkServiceMntVo) throws TROModuleException {
        Map selectLinkId = this.tLinkMnDao.selectLinkId(tLinkServiceMntVo.getLinkName());
        Long linkId = MapUtils.getLong((Map)selectLinkId, (Object)"LINK_ID");
        String valueOf = String.valueOf(linkId == null ? "" : linkId);
        List tLinkServiceMntList = tLinkServiceMntVo.gettLinkServiceMntList();
        ArrayList tLinkServiceMntLists = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)valueOf)) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_ADD_LINK_EXIST);
        }
        tLinkServiceMntVo.setLinkId(this.snowflake.next());
        this.tLinkMnDao.addBasicLink(tLinkServiceMntVo);
        this.saveRelationLink(Long.valueOf(tLinkServiceMntVo.getLinkId()), tLinkServiceMntVo.getTechLinks(), "t_bs_tch_link");
        if (tLinkServiceMntList != null && !tLinkServiceMntList.isEmpty()) {
            tLinkServiceMntList.forEach(tLinkServiceMnt -> {
                tLinkServiceMnt.setLinkServiceId(this.snowflake.next());
                tLinkServiceMnt.setLinkId(tLinkServiceMntVo.getLinkId());
                tLinkServiceMntLists.add(tLinkServiceMnt);
            });
            this.tLinkMnDao.addLinkInterface((List)tLinkServiceMntLists);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveLink(TLinkServiceMntVo tLinkServiceMntVo) throws TROModuleException {
        Map selectLinkId = this.tLinkMnDao.selectLinkId(tLinkServiceMntVo.getLinkName());
        Long linkId = MapUtils.getLong((Map)selectLinkId, (Object)"LINK_ID");
        String valueOf = String.valueOf(linkId == null ? "" : linkId);
        List tLinkServiceMntList = tLinkServiceMntVo.gettLinkServiceMntList();
        ArrayList tLinkServiceMntLists = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)valueOf)) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_ADD_LINK_EXIST);
        }
        tLinkServiceMntVo.setLinkId(this.snowflake.next());
        this.tLinkMnDao.addBasicLink(tLinkServiceMntVo);
        this.tLinkMnDao.addSecondLinkRef(tLinkServiceMntVo.getSecondLinkId(), String.valueOf(tLinkServiceMntVo.getLinkId()));
        if (tLinkServiceMntList != null && !tLinkServiceMntList.isEmpty()) {
            tLinkServiceMntList.forEach(tLinkServiceMnt -> {
                tLinkServiceMnt.setLinkServiceId(this.snowflake.next());
                tLinkServiceMnt.setLinkId(tLinkServiceMntVo.getLinkId());
                tLinkServiceMntLists.add(tLinkServiceMnt);
            });
            this.tLinkMnDao.addLinkInterface((List)tLinkServiceMntLists);
        }
    }

    private void addParam(TLinkServiceMntVo tLinkServiceMntVo, String linkId, List<TLinkServiceMnt> tLinkServiceMntList, List<TLinkServiceMnt> tLinkServiceMntLists, String linkExist) throws TROModuleException {
        if (tLinkServiceMntList.isEmpty()) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_ADD_LINK_PARAM_EXCEPTION);
        }
        tLinkServiceMntList.forEach(tLinkServiceMnt -> {
            if (StringUtils.isNotEmpty((CharSequence)linkId)) {
                int linkInterfaceExist = this.tLinkMnDao.saveLinkInterfaceExist(linkId, tLinkServiceMnt.getInterfaceName());
                if (linkInterfaceExist == 0) {
                    tLinkServiceMnt.setLinkServiceId(this.snowflake.next());
                    tLinkServiceMnt.setLinkId(Long.valueOf(linkId).longValue());
                    tLinkServiceMntLists.add((TLinkServiceMnt)tLinkServiceMnt);
                }
            } else {
                tLinkServiceMnt.setLinkServiceId(this.snowflake.next());
                tLinkServiceMnt.setLinkId(tLinkServiceMntVo.getLinkId());
                tLinkServiceMntLists.add((TLinkServiceMnt)tLinkServiceMnt);
            }
        });
        tLinkServiceMntList.clear();
        tLinkServiceMntVo.settLinkServiceMntList(tLinkServiceMntLists);
    }

    public PageInfo<TLinkApplicationInterface> queryBasicLinkList(Map<String, Object> paramMap) {
        List queryBasicLinkList;
        boolean paginationFlag = !StringUtils.equals((CharSequence)"-1", (CharSequence)MapUtils.getString(paramMap, (Object)"pageSize"));
        Page newPage = new Page();
        if (paginationFlag) {
            newPage = PageHelper.startPage((int)PageInfo.getPageNum(paramMap), (int)PageInfo.getPageSize(paramMap));
        }
        if (CollectionUtils.isEmpty((Collection)(queryBasicLinkList = this.tLinkMnDao.queryBasicLinkList(paramMap)))) {
            return new PageInfo((List)Lists.newArrayList());
        }
        queryBasicLinkList = queryBasicLinkList.stream().peek(tLinkApplicationInterface -> {
            List basicLinkList = this.getRelationLinkRelationShip("t_bs_tch_link", String.valueOf(tLinkApplicationInterface.getLinkId()));
            tLinkApplicationInterface.setTechLinks(JSON.toJSONString((Object)basicLinkList));
        }).collect(Collectors.toList());
        newPage.clear();
        newPage.addAll(queryBasicLinkList);
        return new PageInfo((List)newPage);
    }

    public List<TLinkServiceMntVo> queryBasicLinkListDownload(Map<String, Object> paramMap) {
        List tLinkServiceMntVos = this.tLinkMnDao.queryBasicLinkListDownload(paramMap);
        for (TLinkServiceMntVo tLinkServiceMntVo : tLinkServiceMntVos) {
            List tLinkServiceMnts = this.tLinkMntDao.queryLinkInterface(String.valueOf(tLinkServiceMntVo.getLinkId()));
            tLinkServiceMntVo.settLinkServiceMntList(tLinkServiceMnts);
        }
        return tLinkServiceMntVos;
    }

    public String queryAppIdByAppName(Object obj) {
        if (obj == null) {
            return "1";
        }
        String str = String.valueOf(obj);
        String linkName = this.secondLinkDao.queryAppIdByAppName(str);
        return String.valueOf(linkName);
    }

    public TLinkServiceMntVo queryLinkByLinkId(String linkId) {
        TLinkServiceMntVo tLinkServiceMntVo = this.tLinkMnDao.queryLinkByLinkId(linkId);
        this.setTechLinks(tLinkServiceMntVo);
        this.setNodes(tLinkServiceMntVo);
        return tLinkServiceMntVo;
    }

    private void setTechLinks(TLinkServiceMntVo tLinkServiceMntVo) {
        if (StringUtils.isNotBlank((CharSequence)tLinkServiceMntVo.getTechLinks())) {
            List techLinks = (List)JSON.parseObject((String)tLinkServiceMntVo.getTechLinks(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            ArrayList showTechLinks = Lists.newArrayListWithExpectedSize((int)techLinks.size());
            techLinks.forEach(lstString -> {
                List tempObj = this.tLinkMntDao.transferBusinessLinkNameAndId(lstString);
                showTechLinks.add(tempObj);
            });
            tLinkServiceMntVo.setTechLinksList((List)showTechLinks);
        }
    }

    private void setNodes(TLinkServiceMntVo tLinkServiceMntVo) {
        List tLinkNodesVoList = this.tLinkMntDao.getNodesByBlinkId(String.valueOf(tLinkServiceMntVo.getLinkId()));
        if (CollectionUtils.isNotEmpty((Collection)tLinkNodesVoList)) {
            HashMap linkNode = Maps.newHashMapWithExpectedSize((int)tLinkNodesVoList.size());
            Integer maxBlank = tLinkNodesVoList.stream().mapToInt(tempNode -> tempNode.gettLinkBank()).max().getAsInt();
            ArrayList nodeList = Lists.newArrayListWithExpectedSize((int)(tLinkNodesVoList.size() + 1));
            ArrayList linksList = Lists.newArrayListWithExpectedSize((int)(tLinkNodesVoList.size() + 1));
            Integer parentKey = 10001;
            HashMap parentNode = Maps.newHashMapWithExpectedSize((int)6);
            parentNode.put("bank", "0");
            parentNode.put("x", "1");
            parentNode.put("y", maxBlank % 2 == 0 ? String.valueOf((double)(maxBlank / 2) + 0.5) : String.valueOf(maxBlank / 2 + 1));
            parentNode.put("text", tLinkServiceMntVo.getLinkName());
            parentNode.put("baseLinkId", String.valueOf(tLinkServiceMntVo.getLinkId()));
            parentNode.put("key", String.valueOf(parentKey));
            nodeList.add(parentNode);
            tLinkNodesVoList.stream().forEach(nodeVo -> {
                HashMap tempLink = Maps.newHashMapWithExpectedSize((int)4);
                if (1 == nodeVo.gettLinkOrder()) {
                    tempLink.put("from", String.valueOf(parentKey));
                    tempLink.put("source", tLinkServiceMntVo.getLinkName());
                } else {
                    tempLink.put("from", String.valueOf(parentKey + nodeVo.gettLinkBank() * 10000 + nodeVo.gettLinkOrder() - 1));
                    tempLink.put("source", tLinkNodesVoList.stream().filter(s -> s.gettLinkBank().equals(nodeVo.gettLinkBank()) && s.gettLinkOrder().equals(nodeVo.gettLinkOrder() - 1)).findFirst().get().getLinkName());
                }
                tempLink.put("to", String.valueOf(parentKey + nodeVo.gettLinkBank() * 10000 + nodeVo.gettLinkOrder()));
                tempLink.put("target", nodeVo.getLinkName());
                linksList.add(tempLink);
                HashMap childNode = Maps.newHashMapWithExpectedSize((int)6);
                childNode.put("bank", String.valueOf(nodeVo.gettLinkBank()));
                childNode.put("x", String.valueOf(1 + nodeVo.gettLinkOrder()));
                childNode.put("y", String.valueOf(nodeVo.gettLinkBank()));
                childNode.put("text", nodeVo.getLinkName());
                childNode.put("techLinkId", String.valueOf(nodeVo.gettLinkId()));
                childNode.put("key", String.valueOf(parentKey + nodeVo.gettLinkBank() * 10000 + nodeVo.gettLinkOrder()));
                nodeList.add(childNode);
            });
            tLinkServiceMntVo.setLinks((List)linksList);
            tLinkServiceMntVo.setNodes((List)nodeList);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public String deleteLinkByLinkIds(String basicLinkIds) {
        GetDeleteIds deleteIds = new GetDeleteIds(this, basicLinkIds, "basicLinkName").invoke((Object)this.tLinkMnDao);
        List ableDeleteBasicLink = deleteIds.getAbleDeleteList();
        if (!ableDeleteBasicLink.isEmpty()) {
            this.tLinkMnDao.deleteLinkByLinkIds(ableDeleteBasicLink);
            this.tLinkMnDao.deleteBTLinkRelationShip(ableDeleteBasicLink);
            this.tLinkMnDao.deleteLinkInterfaceByLinkIds(ableDeleteBasicLink);
            this.tLinkMnDao.deleteSecondBasicLinkRef(Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)basicLinkIds));
            List list = this.tLinkMnDao.queryLinksByLinkIds(ableDeleteBasicLink);
        }
        return deleteIds.getResult();
    }

    public void deleteLinkInterfaceByLinkServiceId(String linkServiceIds) {
        List linkServiceIdsList = Arrays.stream(linkServiceIds.split(",")).filter(e -> StringUtils.isNotEmpty((CharSequence)e)).distinct().collect(Collectors.toList());
        List tLinkServiceMntVos = this.tLinkMnDao.queryLinksByLinkIds(linkServiceIdsList);
        this.tLinkMnDao.deleteLinkInterfaceByLinkServiceId(linkServiceIdsList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateLinkinfo(TLinkServiceMntVo tLinkServiceMntVo) throws TROModuleException {
        if (StringUtils.isNotEmpty((CharSequence)tLinkServiceMntVo.getLinkServiceIds())) {
            this.deleteLinkInterfaceByLinkServiceId(tLinkServiceMntVo.getLinkServiceIds());
        }
        long linkId = tLinkServiceMntVo.getLinkId();
        int linkExist = this.tLinkMnDao.updateLinkExist(String.valueOf(linkId));
        List tLinkServiceMntList = tLinkServiceMntVo.gettLinkServiceMntList();
        ArrayList saveServiceMntLists = Lists.newArrayList();
        ArrayList updateServiceMntLists = Lists.newArrayList();
        if (linkExist > 0) {
            if (tLinkServiceMntList != null && !tLinkServiceMntList.isEmpty()) {
                tLinkServiceMntList.forEach(tLinkServiceMnt -> {
                    int linkInterfaceExist = this.tLinkMnDao.updateLinkInterfaceExist(String.valueOf(linkId), String.valueOf(tLinkServiceMnt.getLinkServiceId()));
                    if (linkInterfaceExist == 0) {
                        tLinkServiceMnt.setLinkServiceId(this.snowflake.next());
                        tLinkServiceMnt.setLinkId(linkId);
                        saveServiceMntLists.add(tLinkServiceMnt);
                    } else {
                        updateServiceMntLists.add(tLinkServiceMnt);
                    }
                });
            }
            this.tLinkMnDao.updateLink(tLinkServiceMntVo);
            this.tLinkMnDao.deleteReLationShipByTLinkId(Collections.singletonList(String.valueOf(linkId)));
            this.saveRelationLink(Long.valueOf(linkId), tLinkServiceMntVo.getTechLinks(), "t_bs_tch_link");
            if (!saveServiceMntLists.isEmpty()) {
                this.tLinkMnDao.addLinkInterface((List)saveServiceMntLists);
            }
            if (!updateServiceMntLists.isEmpty()) {
                for (TLinkServiceMnt mnt : updateServiceMntLists) {
                    ArrayList updateServiceMntLists2 = Lists.newArrayList();
                    updateServiceMntLists2.add(mnt);
                    this.LOGGER.info("update object:" + ToStringBuilder.reflectionToString((Object)mnt, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
                    this.tLinkMnDao.updateLinkInterface((List)updateServiceMntLists2);
                }
            }
        } else {
            tLinkServiceMntVo.setLinkId(this.snowflake.next());
            this.tLinkMnDao.addBasicLink(tLinkServiceMntVo);
            this.addParam(tLinkServiceMntVo, String.valueOf(linkId), tLinkServiceMntList, (List)saveServiceMntLists, String.valueOf(linkExist));
            this.tLinkMnDao.addLinkInterface((List)saveServiceMntLists);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateLinkInfo(TLinkServiceMntVo tLinkServiceMntVo) throws TROModuleException {
        if (StringUtils.isNotEmpty((CharSequence)tLinkServiceMntVo.getLinkServiceIds())) {
            this.deleteLinkInterfaceByLinkServiceId(tLinkServiceMntVo.getLinkServiceIds());
        }
        long linkId = tLinkServiceMntVo.getLinkId();
        int linkExist = this.tLinkMnDao.updateLinkExist(String.valueOf(linkId));
        List tLinkServiceMntList = tLinkServiceMntVo.gettLinkServiceMntList();
        ArrayList saveServiceMntLists = Lists.newArrayList();
        ArrayList updateServiceMntLists = Lists.newArrayList();
        if (linkExist > 0) {
            if (tLinkServiceMntList != null && !tLinkServiceMntList.isEmpty()) {
                tLinkServiceMntList.forEach(tLinkServiceMnt -> {
                    int linkInterfaceExist = this.tLinkMnDao.updateLinkInterfaceExist(String.valueOf(linkId), String.valueOf(tLinkServiceMnt.getLinkServiceId()));
                    if (linkInterfaceExist == 0) {
                        tLinkServiceMnt.setLinkServiceId(this.snowflake.next());
                        tLinkServiceMnt.setLinkId(linkId);
                        saveServiceMntLists.add(tLinkServiceMnt);
                    } else {
                        updateServiceMntLists.add(tLinkServiceMnt);
                    }
                });
            }
            this.tLinkMnDao.updateLink(tLinkServiceMntVo);
            int existSecondLinkRef = this.tLinkMnDao.existSecondLinkRef(tLinkServiceMntVo.getSecondLinkId(), String.valueOf(tLinkServiceMntVo.getLinkId()));
            if (existSecondLinkRef > 0) {
                this.tLinkMnDao.updateSecondLinkRef(tLinkServiceMntVo.getSecondLinkId(), String.valueOf(tLinkServiceMntVo.getLinkId()));
            } else {
                this.tLinkMnDao.addSecondLinkRef(tLinkServiceMntVo.getSecondLinkId(), String.valueOf(tLinkServiceMntVo.getLinkId()));
            }
            if (!saveServiceMntLists.isEmpty()) {
                this.tLinkMnDao.addLinkInterface((List)saveServiceMntLists);
            }
            if (!updateServiceMntLists.isEmpty()) {
                for (TLinkServiceMnt mnt : updateServiceMntLists) {
                    ArrayList updateServiceMntLists2 = Lists.newArrayList();
                    updateServiceMntLists2.add(mnt);
                    this.LOGGER.info("update object:" + ToStringBuilder.reflectionToString((Object)mnt, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
                    this.tLinkMnDao.updateLinkInterface((List)updateServiceMntLists2);
                }
            }
        } else {
            Map selectLinkId = this.tLinkMnDao.selectLinkId(tLinkServiceMntVo.getLinkName());
            Long saveLinkId = MapUtils.getLong((Map)selectLinkId, (Object)"LINK_ID");
            String valueOf = String.valueOf(saveLinkId == null ? "" : Long.valueOf(linkId));
            if (StringUtils.isNotEmpty((CharSequence)valueOf)) {
                throw new TROModuleException(TROErrorEnum.CONFCENTER_ADD_LINK_EXIST);
            }
            tLinkServiceMntVo.setLinkId(this.snowflake.next());
            this.saveLink(tLinkServiceMntVo);
            this.tLinkMnDao.addBasicLink(tLinkServiceMntVo);
            this.addParam(tLinkServiceMntVo, String.valueOf(linkId), tLinkServiceMntList, (List)saveServiceMntLists, String.valueOf(linkExist));
            this.tLinkMnDao.addLinkInterface((List)saveServiceMntLists);
        }
    }

    public List<TApplicationIp> queryApplicationIpByNameTypeList(String applicationName, String type) {
        return this.tApplicationIpDao.queryApplicationIpByNameTypeList(applicationName, type);
    }

    public List<TApplicationIp> queryApplicationIpByNameList(String applicationName) {
        List tApplicationIps = this.tApplicationIpDao.queryApplicationIpByNameList(applicationName);
        return tApplicationIps;
    }

    public void addTAlarm(TAlarm tAlarm) throws TROModuleException {
        List tApplicationIps = this.tApplicationIpDao.queryApplicationIpByIpList(tAlarm.getIp());
        if (CollectionUtils.isEmpty((Collection)tApplicationIps)) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_IP_NOTEXISTAPP_EXCEPTION);
        }
        for (TApplicationIp tApplicationIp : tApplicationIps) {
            tAlarm.setId(null);
            tAlarm.setWarPackages(tApplicationIp.getApplicationName());
            Result add = this.tAlarmService.add(tAlarm);
            if (add.isSuccess()) continue;
            TROModuleException troModuleException = new TROModuleException(add.getMessage());
            throw troModuleException;
        }
    }

    public List<TLinkServiceMntVo> queryTLinkMntsByIds(List<String> ids) {
        return this.tLinkMnDao.queryLinksByLinkIds(ids);
    }

    public PageInfo<?> queryWListByAppName(Map<String, Object> paramMap) {
        RedisTemplate redisTemplate;
        String pradaSynchronizedToRedisStatus;
        String type = MapUtils.getString(paramMap, (Object)"type");
        String interfaceName = MapUtils.getString(paramMap, (Object)"interfaceName");
        String applicationName = MapUtils.getString(paramMap, (Object)"applicationName");
        String pageNum = MapUtils.getString(paramMap, (Object)"pageNum");
        String pageSize = MapUtils.getString(paramMap, (Object)"pageSize");
        if ("1".equals(type) && StringUtils.isEmpty((CharSequence)interfaceName) && "Success".equals(pradaSynchronizedToRedisStatus = (String)(redisTemplate = this.redisManager.getRedisTemplate()).opsForValue().get((Object)"pradaSynchronizedToRedis"))) {
            Long total = redisTemplate.opsForList().size((Object)applicationName);
            int pageNumN = Integer.parseInt(pageNum);
            int pageSizeN = Integer.parseInt(pageSize);
            int start = (pageNumN - 1) * pageSizeN;
            int end = pageNumN * pageSizeN;
            List list = null;
            list = StringUtils.isEmpty((CharSequence)applicationName) ? redisTemplate.opsForList().range((Object)"allUrlList", (long)start, (long)(end - 1)) : redisTemplate.opsForList().range((Object)applicationName, (long)start, (long)(end - 1));
            ArrayList returnList = Lists.newArrayListWithCapacity((int)200);
            list.forEach(url -> {
                HashMap objectObjectHashMap = Maps.newHashMapWithExpectedSize((int)1);
                objectObjectHashMap.put("interfaceName", url);
                returnList.add(objectObjectHashMap);
            });
            PageInfo pageInfo = new PageInfo((List)(returnList.isEmpty() ? Lists.newArrayList() : returnList));
            pageInfo.setPageNum(pageNumN);
            pageInfo.setPageSize(pageSizeN);
            pageInfo.setTotal(total.longValue());
            return pageInfo;
        }
        PageHelper.startPage((int)PageInfo.getPageNum(paramMap), (int)PageInfo.getPageSize(paramMap));
        switch (type) {
            case "1": {
                List tPradaHttpData = this.tWListMntDao.queryInterfaceByAppNameByTPHD(applicationName, type, interfaceName);
                return new PageInfo(tPradaHttpData.isEmpty() ? Lists.newArrayList() : tPradaHttpData);
            }
            case "2": {
                List dubboData = this.tWListMntDao.queryInterfaceByAppNameFromTUID(applicationName, type, interfaceName);
                return new PageInfo(dubboData.isEmpty() ? Lists.newArrayList() : dubboData);
            }
            case "4": {
                List jobData = this.tWListMntDao.queryInterfaceByAppNameFromTUID(applicationName, type, interfaceName);
                return new PageInfo(jobData.isEmpty() ? Lists.newArrayList() : jobData);
            }
        }
        return new PageInfo((List)Lists.newArrayList());
    }

    public List<String> filterWList(String appName, List<String> list) {
        ArrayList filterList = Lists.newArrayListWithCapacity((int)4);
        if (!WListRuleEnum.getAppNameList().contains(appName)) {
            return list;
        }
        ArrayList numberDomainList = Lists.newArrayListWithCapacity((int)200);
        ArrayList domainList = Lists.newArrayListWithCapacity((int)200);
        ArrayList cubcList = Lists.newArrayListWithCapacity((int)200);
        ArrayList wms_dpjjwms_List = Lists.newArrayListWithCapacity((int)200);
        for (String infas : list) {
            if (infas.contains(WListRuleEnum.CUBC.getRule()) && NumberUtils.isDigits((String)StringUtils.substringAfterLast((String)infas, (String)"/"))) {
                cubcList.add(infas);
                continue;
            }
            if (infas.contains(WListRuleEnum.WMS_DPJJWMS.getRule()) && infas.endsWith(".cache.html")) {
                wms_dpjjwms_List.add(infas);
                continue;
            }
            String domain = StringUtils.substringBetween((String)infas, (String)"//", (String)"/");
            String domainNumber = domain.replaceAll("\\.", "").replaceAll(":", "");
            boolean numberDomain = NumberUtils.isDigits((String)domainNumber);
            if (numberDomain && infas.contains(WListRuleEnum.NVAS_VAS_CAS_WEB.getRule())) {
                numberDomainList.add(infas);
            }
            if (numberDomain || !infas.contains(WListRuleEnum.VIP_NVAS_VAS_CAS_WEB.getRule())) continue;
            domainList.add(infas);
        }
        if (CollectionUtils.isNotEmpty((Collection)numberDomainList)) {
            filterList.add(numberDomainList.get(0));
        }
        if (CollectionUtils.isNotEmpty((Collection)domainList)) {
            filterList.add(domainList.get(0));
        }
        if (CollectionUtils.isNotEmpty((Collection)cubcList)) {
            filterList.add(cubcList.get(0));
        }
        if (CollectionUtils.isNotEmpty((Collection)wms_dpjjwms_List)) {
            filterList.add(wms_dpjjwms_List.get(0));
        }
        return filterList;
    }

    public List<?> queryAppNameList() {
        ArrayList returnList = Lists.newArrayListWithCapacity((int)200);
        List list = this.tApplicationMntDao.queryAppNameList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        list.sort(String::compareTo);
        list.forEach(appName -> {
            HashMap map = Maps.newHashMapWithExpectedSize((int)1);
            map.put("key", appName);
            returnList.add(map);
        });
        return returnList;
    }

    public List<String> queryAppNameFromPradar() throws TROModuleException {
        Map pradarInitParams = RequestPradarUtil.initPrada();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)pradarInitParams, (MultiValueMap)headers);
        Map responseMap = (Map)this.restTemplate.postForObject(this.getPradarUrl() + "/pradarapp/source/queryAppNames.do", (Object)httpEntity, Map.class, new Object[0]);
        boolean resultFlag = MapUtils.getBoolean((Map)responseMap, (Object)"resultFlag");
        if (!resultFlag) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_QUERY_APPNAMEFROMPRADAR_EXCEPTION);
        }
        Object data = responseMap.get("data");
        List appNameList = Lists.newArrayListWithCapacity((int)300);
        if (data instanceof List) {
            appNameList = (List)data;
        }
        appNameList.sort(String::compareToIgnoreCase);
        return appNameList;
    }

    public List<Map<String, Object>> queryWListByAppId(String applicationId) {
        return this.tWListMntDao.queryWListByAppId(applicationId);
    }

    public void batchUploadLinkList(MultipartFile[] files) throws IOException, TROModuleException {
        for (MultipartFile file : files) {
            Sheet sheet = new Sheet(1, 1);
            BufferedInputStream stream = new BufferedInputStream(file.getInputStream());
            List lists = EasyExcelFactory.read((InputStream)stream, (Sheet)sheet);
            ArrayList<TLinkServiceMntVo> addList = new ArrayList<TLinkServiceMntVo>();
            ArrayList<TLinkServiceMntVo> updateList = new ArrayList<TLinkServiceMntVo>();
            int index = 0;
            for (Object list : lists) {
                ArrayList inVo = (ArrayList)list;
                TLinkServiceMntVo vo = new TLinkServiceMntVo();
                vo.setAswanId(String.valueOf(inVo.get(0)));
                List mnts = (List)JSONObject.parseObject((String)((String)inVo.get(1)), List.class);
                ArrayList TLinkServiceMnts = new ArrayList(mnts.size());
                StringBuffer sb = new StringBuffer();
                mnts.stream().forEach(mnt -> {
                    TLinkServiceMnt nt = new TLinkServiceMnt();
                    nt.setInterfaceName(String.valueOf(mnt.get((Object)"\u63a5\u53e3\u540d\u79f0")));
                    nt.setInterfaceDesc(String.valueOf(mnt.get((Object)"\u63a5\u53e3\u8bf4\u660e")));
                    String linkServiceId = mnt.getString("\u94fe\u8def\u670d\u52a1id");
                    nt.setLinkServiceId(Long.parseLong(linkServiceId));
                    TLinkServiceMnts.add(nt);
                    sb.append(linkServiceId).append(",");
                });
                vo.setLinkServiceIds(sb.toString().substring(0, sb.length() - 1));
                vo.settLinkServiceMntList(TLinkServiceMnts);
                vo.setLinkDesc(String.valueOf(inVo.get(2)));
                vo.setLinkEntrence(String.valueOf(inVo.get(3)));
                vo.setLinkModule("1");
                vo.setLinkName(String.valueOf(inVo.get(4)));
                vo.setLinkRank("1");
                vo.setLinkType("1");
                vo.setPrincipalNo("000000");
                vo.setRt(String.valueOf(inVo.get(6)));
                vo.setRtSa(String.valueOf(inVo.get(7)));
                String secondLinkName = String.valueOf(inVo.get(8));
                if ("null".equalsIgnoreCase(secondLinkName)) {
                    throw new TROModuleException(TROErrorEnum.CONFCENTER_NOT_ALLOW_EMPTY + "\uff0c\u7b2c" + index++ + "\u884c\u6570\u636e");
                }
                String secondlinkId = this.secondLinkDao.queryAppIdByAppName(secondLinkName);
                vo.setSecondLinkId(secondlinkId);
                vo.setTargetSuccessRate(String.valueOf(inVo.get(9)));
                vo.setTargetTps(String.valueOf(inVo.get(10)));
                vo.setUseYn("\u53ef\u7528".equalsIgnoreCase(String.valueOf(inVo.get(11))) ? 1 : 0);
                vo.setVolumeCalcStatus("1");
                String linkid = ObjectUtils.toString(inVo.get(12));
                vo.setTps(String.valueOf(inVo.get(13)));
                if (StringUtils.isBlank((CharSequence)linkid)) {
                    addList.add(vo);
                    continue;
                }
                vo.setLinkId(Long.parseLong(linkid));
                updateList.add(vo);
            }
            if (addList.size() > 0) {
                for (TLinkServiceMntVo vo : addList) {
                    this.saveLink(vo);
                }
            }
            if (updateList.size() <= 0) continue;
            for (TLinkServiceMntVo vo : updateList) {
                this.updateLinkInfo(vo);
            }
        }
    }

    private String getKey(TRODictTypeEnum enums, Object key) {
        String key1 = String.valueOf(key);
        Map data = this.queryDicList(enums);
        Map dataList = (Map)data.get("dicList");
        for (Map.Entry entry : dataList.entrySet()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ObjectUtils.toString(entry.getValue()), (CharSequence)key1)) continue;
            return String.valueOf(entry.getKey());
        }
        return null;
    }

    private String getValue(TRODictTypeEnum enums, Object value) {
        String key = String.valueOf(value);
        Map data = this.queryDicList(enums);
        Map dataList = (Map)data.get("dicList");
        for (Map.Entry entry : dataList.entrySet()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ObjectUtils.toString(entry.getValue()), (CharSequence)key)) continue;
            return String.valueOf(entry.getKey());
        }
        return null;
    }

    public void batchUploadWList(MultipartFile[] files) throws IOException, TROModuleException {
        List applicationDataList = this.queryApplicationdata();
        HashSet applicationSet = new HashSet();
        for (MultipartFile file : files) {
            applicationDataList.stream().forEach(map -> applicationSet.add(map.get("applicationName")));
            Sheet sheet = new Sheet(1, 1);
            BufferedInputStream stream = new BufferedInputStream(file.getInputStream());
            List lists = EasyExcelFactory.read((InputStream)stream, (Sheet)sheet);
            for (Object list : lists) {
                String twlist;
                String interfaceName;
                TWListVo vo = new TWListVo();
                ArrayList excelVo = (ArrayList)list;
                String applicationName = String.valueOf(excelVo.get(1));
                if (!applicationSet.contains(applicationName)) {
                    throw new TROModuleException(TROErrorEnum.CONFCENTER_ADD_APPLICATION_NOTEXIST_EXCEPTION);
                }
                vo.setPrincipalNo("000000");
                Long id = this.tApplicationMntDao.queryIdByApplicationName(String.valueOf(excelVo.get(1)));
                vo.setApplicationId(String.valueOf(id));
                WListTypeEnum[] wListTypeEnums = WListTypeEnum.values();
                Arrays.asList(wListTypeEnums).forEach(wListTypeEnum -> {
                    if (StringUtils.equalsIgnoreCase((CharSequence)wListTypeEnum.getName(), (CharSequence)StringUtils.trim((String)String.valueOf(excelVo.get(2))))) {
                        vo.setType(wListTypeEnum.getValue());
                    }
                });
                String httpType = this.isEmPty(excelVo.get(3)) ? null : String.valueOf(excelVo.get(3));
                vo.setHttpType(httpType);
                String jobInterval = this.isEmPty(excelVo.get(4)) ? null : String.valueOf(excelVo.get(4));
                vo.setJobInterval(jobInterval);
                String mqType = this.isEmPty(excelVo.get(5)) ? null : String.valueOf(excelVo.get(5));
                vo.setMqType(mqType);
                String useYn = String.valueOf(excelVo.get(6)).equalsIgnoreCase("\u53ef\u7528") ? "1" : "0";
                vo.setUseYn(useYn);
                String string = interfaceName = this.isEmPty(excelVo.get(7)) ? null : String.valueOf(excelVo.get(7));
                if (StringUtils.isNotBlank((CharSequence)interfaceName)) {
                    String[] strings = interfaceName.split(",");
                    vo.setList(Arrays.asList(strings));
                }
                vo.setDictType("ca888ed801664c81815d8c4f5b8dff0c");
                String pageLevel = this.isEmPty(excelVo.get(8)) ? null : String.valueOf(excelVo.get(8));
                vo.setPageLevel(this.pageLevel(pageLevel));
                String queueName = this.isEmPty(excelVo.get(9)) ? null : String.valueOf(excelVo.get(9));
                vo.setQueueName(queueName);
                String string2 = twlist = this.isEmPty(excelVo.get(10)) ? null : String.valueOf(excelVo.get(10));
                if (twlist != null) {
                    vo.setWlistId(Long.parseLong(twlist));
                }
                if (StringUtils.isBlank((CharSequence)twlist)) {
                    this.saveWList(vo);
                    continue;
                }
                TWList tWList = new TWList();
                BeanUtils.copyProperties((Object)vo, (Object)tWList);
                tWList.setInterfaceName(interfaceName);
                tWList.setQueueName(queueName);
                tWList.setPageLevel(pageLevel);
                tWList.setUseYn(useYn);
                tWList.setMqType(mqType);
                tWList.setHttpType(httpType);
                tWList.setJobInterval(jobInterval);
                this.updateWListById(tWList);
            }
        }
    }

    private boolean isEmPty(Object t) {
        return null == t || StringUtils.isBlank((CharSequence)ObjectUtils.toString((Object)t)) || "null".equalsIgnoreCase(ObjectUtils.toString((Object)t));
    }

    private String pageLevel(String pageLevel) {
        if (pageLevel == null) {
            return null;
        }
        switch (pageLevel = pageLevel.trim()) {
            case "\u666e\u901a\u9875\u9762\u52a0\u8f7d": {
                return "1";
            }
            case "\u7b80\u5355\u67e5\u8be2\u9875\u9762/\u590d\u6742\u754c\u9762": {
                return "2";
            }
            case "\u590d\u6742\u67e5\u8be2\u9875\u9762": {
                return "3";
            }
        }
        return null;
    }

    public List<TLinkBasicVO> queryLinkByLinkType(Map<String, Object> queryMap) {
        String linkTypeString;
        List<Object> linkTypeList = new ArrayList();
        if (queryMap != null && queryMap.get("linkType") != null && StringUtils.isNotEmpty((CharSequence)(linkTypeString = (String)queryMap.get("linkType")))) {
            linkTypeList = Arrays.asList(linkTypeString.split(",")).stream().map(s -> Integer.parseInt(s.trim())).collect(Collectors.toList());
        }
        return this.tLinkMntDao.queryLinksByLinkType(linkTypeList);
    }

    @Transactional(rollbackFor={Throwable.class})
    public void updateAppAgentVersion(String appName, String agentVersion, String pradarVersion) throws TROModuleException {
        if (StringUtils.isEmpty((CharSequence)appName)) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_UPDATE_APPLICATION_AGENT_VERSION_EXCEPTION);
        }
        TApplicationMnt applicationMnt = this.tApplicationMntDao.queryApplicationInfoByNameAndTenant(appName, RestContext.getUser().getCustomerId());
        if (applicationMnt == null) {
            throw new TROModuleException(TROErrorEnum.CONFCENTER_QUERY_APPLICATION_EXCEPTION);
        }
        this.tApplicationMntDao.updateApplicaionAgentVersion(Long.valueOf(applicationMnt.getApplicationId()), agentVersion, pradarVersion);
    }

    public List<Map<String, String>> queryLinkIdName() {
        return this.tLinkMnDao.queryLinkIdName();
    }

    public List<Map<String, String>> getWhiteListForLink() {
        return this.tWListMntDao.getWhiteListForLink();
    }

    @Deprecated
    public List<Map<String, Object>> queryLinkHeaderList() {
        ArrayList resultList = Lists.newArrayList();
        List linkHeaderInfo = this.tLinkMnDao.queryLinkHeaderInfo();
        HashMap<String, List> collect = new HashMap<String, List>(10);
        for (TLinkMntDictoryVo tLinkMntDictoryVo : linkHeaderInfo) {
            collect.computeIfAbsent(tLinkMntDictoryVo.getName() + ";" + tLinkMntDictoryVo.getOrder(), k -> new ArrayList()).add(tLinkMntDictoryVo);
        }
        collect.forEach((nameOrder, tLinkMntDictoryVoList) -> {
            HashMap resultMap = Maps.newHashMap();
            String[] nameOrderArr = nameOrder.split(";");
            resultMap.put("name", nameOrderArr[0]);
            resultMap.put("order", nameOrderArr[1]);
            String linkName = ((TLinkMntDictoryVo)tLinkMntDictoryVoList.get(0)).getLinkName();
            if (StringUtils.isEmpty((CharSequence)linkName)) {
                resultMap.put("count", 0);
            } else {
                resultMap.put("count", tLinkMntDictoryVoList.size());
            }
            List list = this.tLinkMnDao.queryCalcVolumeLinkList(nameOrderArr[1]);
            resultMap.put("calcVolumeLinkList", list);
            resultList.add(resultMap);
        });
        Collections.sort(resultList, Comparator.comparingInt(o -> Integer.valueOf((String)o.get("order"))));
        return resultList;
    }

    public List<Map<String, Object>> queryLinkHeaderInfoList() {
        ArrayList resultList = Lists.newArrayList();
        List linkHeaderInfo = this.tLinkMnDao.queryLinkHeaderInfoList();
        HashMap<String, List> collect = new HashMap<String, List>(16);
        for (TLinkTopologyInfoVo tLinkTopologyInfoVo : linkHeaderInfo) {
            collect.computeIfAbsent(tLinkTopologyInfoVo.getName() + ";" + tLinkTopologyInfoVo.getOrder(), k -> new ArrayList()).add(tLinkTopologyInfoVo);
        }
        collect.forEach((nameOrder, tLinkTopologyInfoVoList) -> {
            HashMap resultMap = Maps.newHashMap();
            String[] nameOrderArr = nameOrder.split(";");
            resultMap.put("name", nameOrderArr[0]);
            resultMap.put("order", nameOrderArr[1]);
            String linkName = ((TLinkTopologyInfoVo)tLinkTopologyInfoVoList.get(0)).getLinkName();
            if (StringUtils.isEmpty((CharSequence)linkName)) {
                resultMap.put("count", 0);
            } else {
                resultMap.put("count", tLinkTopologyInfoVoList.size());
            }
            ArrayList secondLinkList = Lists.newArrayList();
            HashMap<String, List> collect1 = new HashMap<String, List>(32);
            for (TLinkTopologyInfoVo tLinkTopologyInfoVo : tLinkTopologyInfoVoList) {
                if (!StringUtils.isNotEmpty((CharSequence)tLinkTopologyInfoVo.getSecondLinkId())) continue;
                collect1.computeIfAbsent(tLinkTopologyInfoVo.getSecondLinkId() + ";" + tLinkTopologyInfoVo.getSecondLinkName(), k -> new ArrayList()).add(tLinkTopologyInfoVo);
            }
            collect1.forEach((secondLinkIdName, secondLinkIdNameList) -> {
                HashMap secondLinkMap = Maps.newHashMap();
                secondLinkMap.put("secondLinkId", ((TLinkTopologyInfoVo)secondLinkIdNameList.get(0)).getSecondLinkId());
                secondLinkMap.put("secondLinkName", ((TLinkTopologyInfoVo)secondLinkIdNameList.get(0)).getSecondLinkName());
                secondLinkList.add(secondLinkMap);
            });
            resultMap.put("secondLinkList", secondLinkList);
            List list = this.tLinkMnDao.queryCalcVolumeLinkListByModule(nameOrderArr[1]);
            resultMap.put("calcVolumeLinkList", list);
            resultList.add(resultMap);
        });
        Collections.sort(resultList, Comparator.comparingInt(o -> Integer.valueOf((String)o.get("order"))));
        return resultList;
    }

    public List<TSecondLinkMnt> querySecondLinkByModule(String linkModule) {
        return this.tLinkMnDao.querySecondLinkMapByModule(linkModule);
    }

    static /* synthetic */ Snowflake access$000(ConfCenterService x0) {
        return x0.snowflake;
    }

    static /* synthetic */ Snowflake access$100(ConfCenterService x0) {
        return x0.snowflake;
    }

    static /* synthetic */ TApplicationMntDao access$200(ConfCenterService x0) {
        return x0.tApplicationMntDao;
    }

    static /* synthetic */ TWListMntDao access$300(ConfCenterService x0) {
        return x0.tWListMntDao;
    }

    static /* synthetic */ TLinkMntDao access$400(ConfCenterService x0) {
        return x0.tLinkMnDao;
    }
}

