/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service;

import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.entity.domain.entity.TBaseConfig;
import io.shulie.tro.web.app.common.CommonService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class BaseConfigService
extends CommonService {
    public TBaseConfig queryByConfigCode(String configCode) {
        return this.tbaseConfigDao.selectByPrimaryKey(configCode);
    }

    public void checkExistAndInsert(String configCode) {
        TBaseConfig config = this.queryByConfigCode(configCode);
        if (config != null) {
            return;
        }
        config = new TBaseConfig();
        config.setConfigCode(configCode);
        config.setConfigValue("1");
        config.setConfigDesc("\u767d\u540d\u5355\u5f00\u5173\uff1a0-\u5173\u95ed 1-\u5f00\u542f");
        this.tbaseConfigDao.insertSelective(config);
    }

    public void updateBaseConfig(TBaseConfig tBaseConfig) throws TROModuleException {
        if (StringUtils.isEmpty((CharSequence)tBaseConfig.getConfigCode()) || StringUtils.isEmpty((CharSequence)tBaseConfig.getConfigValue())) {
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_UPDATE_BASE_CONFIG_PARAM_EXCEPTION);
        }
        if (tBaseConfig.getConfigValue().length() > 128) {
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_UPDATE_BASE_CONFIG_VALUE_TOO_LONG_EXCEPTION);
        }
        this.tbaseConfigDao.updateByPrimaryKeySelective(tBaseConfig);
    }

    public void addBaseConfig(TBaseConfig tBaseConfig) throws TROModuleException {
        if (StringUtils.isEmpty((CharSequence)tBaseConfig.getConfigCode()) || StringUtils.isEmpty((CharSequence)tBaseConfig.getConfigValue())) {
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_ADD_BASE_CONFIG_EXCEPTION);
        }
        TBaseConfig source = this.tbaseConfigDao.selectByPrimaryKey(tBaseConfig.getConfigCode());
        if (source != null) {
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_ADD_BASE_CONFIG_EXIST);
        }
        if (tBaseConfig.getConfigValue().length() > 128) {
            throw new TROModuleException(TROErrorEnum.API_TRO_CONFCENTER_UPDATE_BASE_CONFIG_VALUE_TOO_LONG_EXCEPTION);
        }
        this.tbaseConfigDao.insertSelective(tBaseConfig);
    }
}

