/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service;

import com.github.pagehelper.PageHelper;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.pamirs.tro.common.constant.Constants;
import com.pamirs.tro.common.util.PageInfo;
import com.pamirs.tro.entity.domain.entity.TApplicationMntConfig;
import com.pamirs.tro.entity.domain.entity.TBaseConfig;
import com.pamirs.tro.entity.domain.entity.user.User;
import com.pamirs.tro.entity.domain.vo.AgentApplicationConfigVo;
import com.pamirs.tro.entity.domain.vo.TApplicationMntConfigVo;
import io.shulie.tro.web.app.common.CommonService;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.service.user.TroWebUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApplicationMntConfigService
extends CommonService {
    @Autowired
    private TroWebUserService troWebUserService;

    public PageInfo<TApplicationMntConfigVo> queryApplicationConfigPage(Map<String, Object> paramMap) {
        PageHelper.startPage((int)PageInfo.getPageNum(paramMap), (int)PageInfo.getPageSize(paramMap));
        List voList = this.tApplicationMntConfigDao.queryApplicationConfigPage(paramMap);
        return new PageInfo(CollectionUtils.isEmpty((Collection)voList) ? Lists.newArrayList() : voList);
    }

    public AgentApplicationConfigVo queryConfig(String applicationName) {
        AgentApplicationConfigVo vo = new AgentApplicationConfigVo();
        vo.setCheatCheck("N");
        if (StringUtils.isNotEmpty((CharSequence)applicationName)) {
            TApplicationMntConfig tApplicationMntConfig;
            User user = RestContext.getUser();
            if (user == null) {
                user = this.troWebUserService.queryUserByKey(RestContext.getTenantUserKey());
            }
            if ((tApplicationMntConfig = this.tApplicationMntConfigDao.queryByApplicationNameAndUserId(applicationName, user == null ? null : user.getId())) != null && Constants.INTEGER_USE.equals(tApplicationMntConfig.getCheatCheck())) {
                vo.setCheatCheck("Y");
            }
        }
        TBaseConfig tBaseConfig = this.tbaseConfigDao.selectByPrimaryKey("SQL_CHECK");
        vo.setSqlCheck("N");
        if (tBaseConfig != null && NumberUtils.isDigits((String)tBaseConfig.getConfigValue()) && Constants.INTEGER_USE.equals(Integer.parseInt(tBaseConfig.getConfigValue()))) {
            vo.setSqlCheck("Y");
        }
        return vo;
    }

    public void updateConfigBatch(TApplicationMntConfigVo configVo) {
        int cheatCheck = Integer.parseInt(configVo.getCheatCheck());
        List applicationIdList = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)configVo.getApplicationIds()).stream().distinct().collect(Collectors.toList());
        ArrayList<TApplicationMntConfig> configList = this.tApplicationMntConfigDao.queryByApplicationIdList(applicationIdList);
        Date now = new Date();
        if (CollectionUtils.isEmpty((Collection)configList)) {
            configList = new ArrayList<TApplicationMntConfig>();
            for (String appId : applicationIdList) {
                TApplicationMntConfig mntConfig = new TApplicationMntConfig();
                mntConfig.setTamcId(Long.valueOf(this.snowflake.next()));
                mntConfig.setApplicationId(Long.valueOf(Long.parseLong(appId)));
                mntConfig.setCheatCheck(Integer.valueOf(cheatCheck));
                mntConfig.setCreateTime(now);
                mntConfig.setUpdateTime(now);
                configList.add(mntConfig);
            }
            this.tApplicationMntConfigDao.insertList(configList);
        } else {
            this.batchInsertAndUpdate(cheatCheck, applicationIdList, configList, now);
        }
    }

    private void batchInsertAndUpdate(int cheatCheck, List<String> applicationIdList, List<TApplicationMntConfig> configList, Date now) {
        this.tApplicationMntConfigDao.updateCheatRuleByApplicationIdList(applicationIdList, cheatCheck);
        if (configList.size() != applicationIdList.size()) {
            ArrayList<String> configAppIdList = new ArrayList<String>();
            for (TApplicationMntConfig config : configList) {
                configAppIdList.add(config.getApplicationId().toString());
            }
            applicationIdList.removeAll(configAppIdList);
            configList = new ArrayList<TApplicationMntConfig>();
            for (String appId : applicationIdList) {
                TApplicationMntConfig mntConfig = new TApplicationMntConfig();
                mntConfig.setTamcId(Long.valueOf(this.snowflake.next()));
                mntConfig.setApplicationId(Long.valueOf(Long.parseLong(appId)));
                mntConfig.setCheatCheck(Integer.valueOf(cheatCheck));
                mntConfig.setCreateTime(now);
                mntConfig.setUpdateTime(now);
                configList.add(mntConfig);
            }
            this.tApplicationMntConfigDao.insertList(configList);
        }
    }
}

