/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service;

import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.pamirs.tro.common.util.PageInfo;
import com.pamirs.tro.entity.domain.entity.TApplicationInfoUpload;
import com.pamirs.tro.entity.domain.vo.TUploadInterfaceDetailVo;
import com.pamirs.tro.entity.domain.vo.TUploadInterfaceVo;
import io.shulie.tro.web.app.common.CommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ApplicationInfoUploadService
extends CommonService {
    public void saveApplicationInfoUpload(TUploadInterfaceVo vo) {
        if (StringUtils.isEmpty((CharSequence)vo.getAppName()) || CollectionUtils.isEmpty((Collection)vo.getAppDetails())) {
            return;
        }
        ArrayList<TApplicationInfoUpload> infoList = new ArrayList<TApplicationInfoUpload>();
        for (TUploadInterfaceDetailVo detail : vo.getAppDetails()) {
            if (StringUtils.isEmpty((CharSequence)detail.getInterfaceName()) || !"sql".equalsIgnoreCase(detail.getType()) && !"trace".equalsIgnoreCase(detail.getType())) continue;
            TApplicationInfoUpload infoUpload = new TApplicationInfoUpload();
            infoUpload.setTaiuId(Long.valueOf(this.snowflake.next()));
            infoUpload.setApplicationName(vo.getAppName());
            if ("sql".equalsIgnoreCase(detail.getType())) {
                infoUpload.setInfoType(Integer.valueOf(2));
            }
            if ("trace".equalsIgnoreCase(detail.getType())) {
                infoUpload.setInfoType(Integer.valueOf(1));
            }
            if (detail.getInterfaceName().length() > 2000) {
                infoUpload.setUploadInfo(detail.getInterfaceName().substring(0, 1999));
            } else {
                infoUpload.setUploadInfo(detail.getInterfaceName());
            }
            infoList.add(infoUpload);
        }
        if (CollectionUtils.isNotEmpty(infoList)) {
            this.tApplicationInfoUploadDao.insertList(infoList);
        }
    }

    public PageInfo<TApplicationInfoUpload> queryApplicationPage(Map<String, Object> paramMap) {
        PageHelper.startPage((int)PageInfo.getPageNum(paramMap), (int)PageInfo.getPageSize(paramMap));
        List voList = this.tApplicationInfoUploadDao.queryUploadInfoPage(paramMap);
        return new PageInfo(CollectionUtils.isEmpty((Collection)voList) ? Lists.newArrayList() : voList);
    }
}

