/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.service;

import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.pamirs.tro.common.constant.AppConfigSheetEnum;
import com.pamirs.tro.entity.domain.entity.simplify.TShadowJobConfig;
import com.pamirs.tro.entity.domain.vo.guardmanage.LinkGuardVo;
import io.shulie.tro.web.app.input.whitelist.WhitelistImportFromExcelInput;
import io.shulie.tro.web.app.request.application.ShadowConsumerCreateRequest;
import io.shulie.tro.web.app.service.AppConfigEntityConvertService;
import io.shulie.tro.web.common.enums.excel.BooleanEnum;
import io.shulie.tro.web.common.enums.shadow.ShadowMqConsumerType;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.param.application.ApplicationDsCreateParam;
import io.shulie.tro.web.data.param.blacklist.BlacklistCreateNewParam;
import io.shulie.tro.web.data.result.application.ApplicationDetailResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppConfigEntityConvertServiceImpl
implements AppConfigEntityConvertService {
    @Autowired
    private ApplicationDAO applicationDAO;

    public List<ApplicationDsCreateParam> convertDsSheet(ArrayList<ArrayList<String>> sourceList) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return null;
        }
        ArrayList<ApplicationDsCreateParam> result = new ArrayList<ApplicationDsCreateParam>();
        for (int i = 0; i < sourceList.size(); ++i) {
            List propertyList = sourceList.get(i);
            if (CollectionUtils.isEmpty((Collection)propertyList)) continue;
            ApplicationDsCreateParam createParam = new ApplicationDsCreateParam();
            createParam.setDbType(Integer.valueOf((String)propertyList.get(0)));
            createParam.setDsType(Integer.valueOf((String)propertyList.get(1)));
            createParam.setUrl((String)propertyList.get(2));
            createParam.setConfig((String)propertyList.get(3));
            createParam.setParseConfig((String)propertyList.get(4));
            createParam.setStatus(Integer.valueOf((String)propertyList.get(5)));
            result.add(createParam);
        }
        return result;
    }

    public List<LinkGuardVo> convertGuardSheet(ArrayList<ArrayList<String>> sourceList) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return null;
        }
        ArrayList<LinkGuardVo> result = new ArrayList<LinkGuardVo>();
        for (ArrayList<String> arrayList : sourceList) {
            if (CollectionUtils.isEmpty(arrayList)) continue;
            LinkGuardVo guardVo = new LinkGuardVo();
            guardVo.setMethodInfo(arrayList.get(0));
            guardVo.setGroovy(arrayList.get(1));
            guardVo.setIsEnable(Boolean.valueOf(arrayList.get(2)));
            if (arrayList.size() > 3) {
                guardVo.setRemark(String.valueOf(arrayList.get(3)));
            } else {
                guardVo.setRemark("");
            }
            result.add(guardVo);
        }
        return result;
    }

    public List<TShadowJobConfig> convertJobSheet(ArrayList<ArrayList<String>> sourceList) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return null;
        }
        ArrayList<TShadowJobConfig> result = new ArrayList<TShadowJobConfig>();
        for (int i = 0; i < sourceList.size(); ++i) {
            ArrayList<String> arrayList = sourceList.get(i);
            if (CollectionUtils.isEmpty(arrayList)) continue;
            TShadowJobConfig job = new TShadowJobConfig();
            job.setName(arrayList.get(0));
            job.setType(Integer.valueOf(arrayList.get(1)));
            job.setConfigCode(arrayList.get(2));
            job.setStatus(Integer.valueOf(arrayList.get(3)));
            job.setActive(Integer.valueOf(arrayList.get(4)));
            if (arrayList.size() > 5) {
                job.setRemark(String.valueOf(arrayList.get(5)));
            } else {
                job.setRemark("");
            }
            result.add(job);
        }
        return result;
    }

    public List<WhitelistImportFromExcelInput> converWhiteList(ArrayList<ArrayList<String>> importWhiteLists) {
        if (CollectionUtils.isEmpty(importWhiteLists)) {
            return null;
        }
        ArrayList<WhitelistImportFromExcelInput> result = new ArrayList<WhitelistImportFromExcelInput>();
        for (ArrayList<String> arrayList : importWhiteLists) {
            if (CollectionUtils.isEmpty(arrayList)) continue;
            WhitelistImportFromExcelInput input = new WhitelistImportFromExcelInput();
            input.setInterfaceName(arrayList.get(0));
            input.setInterfaceType(Integer.valueOf(arrayList.get(1)));
            input.setDictType(arrayList.get(2));
            input.setUseYn(Integer.valueOf(arrayList.get(3)));
            input.setIsGlobal(BooleanEnum.getByDesc((String)arrayList.get(4)));
            input.setIsHandwork(BooleanEnum.getByDesc((String)arrayList.get(5)));
            if (arrayList.size() == 6) {
                input.setEffectAppNames((List)(StringUtil.isNotEmpty((String)arrayList.get(6)) ? Lists.newArrayList((Object[])arrayList.get(6).split(",")) : Lists.newArrayList()));
            } else {
                input.setEffectAppNames((List)Lists.newArrayList());
            }
            result.add(input);
        }
        return result;
    }

    public List<BlacklistCreateNewParam> converBlackList(ArrayList<ArrayList<String>> sourceList, Long applicationId) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return Collections.emptyList();
        }
        ApplicationDetailResult result = this.applicationDAO.getApplicationById(applicationId);
        ArrayList params = Lists.newArrayList();
        for (ArrayList<String> arrayList : sourceList) {
            if (CollectionUtils.isEmpty(arrayList)) continue;
            if (arrayList.size() != AppConfigSheetEnum.BLACK.getColumnNum().intValue()) {
                throw new RuntimeException("\u9ed1\u540d\u5355\u6570\u636e\u5217\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u8ba4\uff01\u5bfc\u5165\u7684excel\u9700\u8981\u65f6\u4ece\u63a7\u5236\u53f0\u5bfc\u51fa\u7684\u914d\u7f6e\u6587\u4ef6\u3002\u5f02\u5e38\u6570\u636e\uff1a" + arrayList.toString());
            }
            BlacklistCreateNewParam newParam = new BlacklistCreateNewParam();
            newParam.setRedisKey(String.valueOf(arrayList.get(0)).trim());
            newParam.setType(Integer.valueOf(0));
            newParam.setUseYn(Integer.valueOf(arrayList.get(1)));
            newParam.setApplicationId(applicationId);
            if (result != null) {
                newParam.setCustomerId(result.getCustomerId());
                newParam.setUserId(result.getUserId());
            }
            params.add(newParam);
        }
        return params;
    }

    public List<ShadowConsumerCreateRequest> converComsumerList(ArrayList<ArrayList<String>> sourceList) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return Collections.emptyList();
        }
        ArrayList<ShadowConsumerCreateRequest> result = new ArrayList<ShadowConsumerCreateRequest>();
        for (ArrayList<String> arrayList : sourceList) {
            if (CollectionUtils.isEmpty(arrayList)) continue;
            if (arrayList.size() != 3) {
                throw new RuntimeException("\u5f71\u5b50\u6d88\u8d39\u8005\u6570\u636e\u5217\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u8ba4\uff01\u5bfc\u5165\u7684excel\u9700\u8981\u65f6\u4ece\u63a7\u5236\u53f0\u5bfc\u51fa\u7684\u914d\u7f6e\u6587\u4ef6\u3002\u5f02\u5e38\u6570\u636e\uff1a" + arrayList.toString());
            }
            ShadowConsumerCreateRequest request = new ShadowConsumerCreateRequest();
            request.setTopicGroup(arrayList.get(0));
            request.setType(ShadowMqConsumerType.of((String)arrayList.get(1)));
            request.setStatus(Integer.valueOf(arrayList.get(2)));
            result.add(request);
        }
        return result;
    }
}

