/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.init.sync;

import com.pamirs.tro.entity.dao.user.TUserMapper;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import com.pamirs.tro.entity.domain.entity.user.User;
import io.shulie.tro.web.app.init.sync.ConfigSyncService;
import io.shulie.tro.web.app.service.ApplicationService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigSynchronizer {
    private static final Logger log = LoggerFactory.getLogger(ConfigSynchronizer.class);
    @Autowired
    private ConfigSyncService configSyncService;
    @Autowired
    private ApplicationService applicationService;
    @Resource
    private TUserMapper userMapper;

    public void initSyncAgentConfig() {
        log.info("\u9879\u76ee\u542f\u52a8\uff0c\u91cd\u65b0\u540c\u6b65\u4fe1\u606f\u53bb\u914d\u7f6e\u4e2d\u5fc3");
        List userList = this.userMapper.selectDistinctUserAppKey();
        List userAppKeyList = userList.stream().map(User::getKey).distinct().collect(Collectors.toList());
        for (String userAppKey : userAppKeyList) {
            List userIdList = userList.stream().filter(user -> user.getKey().equals(userAppKey)).map(User::getId).collect(Collectors.toList());
            List applications = this.applicationService.getApplicationsByUserIdList(userIdList);
            if (CollectionUtils.isEmpty((Collection)applications)) continue;
            for (TApplicationMnt application : applications) {
                this.configSyncService.syncGuard(userAppKey, application.getApplicationId(), application.getApplicationName());
                this.sleep();
                this.configSyncService.syncShadowDB(userAppKey, application.getApplicationId(), application.getApplicationName());
                this.sleep();
                this.configSyncService.syncAllowList(userAppKey, application.getApplicationId(), application.getApplicationName());
                this.sleep();
                this.configSyncService.syncShadowJob(userAppKey, application.getApplicationId(), application.getApplicationName());
                this.sleep();
                this.configSyncService.syncShadowConsumer(userAppKey, application.getApplicationId(), application.getApplicationName());
            }
            this.configSyncService.syncClusterTestSwitch(userAppKey);
            this.sleep();
            this.configSyncService.syncAllowListSwitch(userAppKey);
            this.sleep();
            this.configSyncService.syncBlockList(userAppKey);
        }
        log.info("\u6240\u6709\u914d\u7f6e\u540c\u6b65\u5230\u914d\u7f6e\u4e2d\u5fc3\u6210\u529f");
    }

    private void sleep() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

