/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.init.fix;

import io.shulie.tro.web.data.dao.application.WhiteListDAO;
import io.shulie.tro.web.data.dao.application.WhitelistEffectiveAppDao;
import io.shulie.tro.web.data.param.whitelist.WhitelistEffectiveAppSearchParam;
import io.shulie.tro.web.data.param.whitelist.WhitelistSearchParam;
import io.shulie.tro.web.data.param.whitelist.WhitelistUpdatePartAppNameParam;
import io.shulie.tro.web.data.result.whitelist.WhitelistEffectiveAppResult;
import io.shulie.tro.web.data.result.whitelist.WhitelistResult;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class WhitelistEffectAppNameDataFixer {
    private static final Logger log = LoggerFactory.getLogger(WhitelistEffectAppNameDataFixer.class);
    @Autowired
    private WhitelistEffectiveAppDao whitelistEffectiveAppDao;
    @Autowired
    private WhiteListDAO whiteListDAO;

    public void fix() {
        log.info("\u5f00\u59cb\u8ba2\u6b63\u767d\u540d\u5355\u751f\u6548\u5e94\u7528\u7684\u767d\u540d\u5355\u7c7b\u578b\u5b57\u6bb5");
        WhitelistEffectiveAppSearchParam searchParam = new WhitelistEffectiveAppSearchParam();
        List appResults = this.whitelistEffectiveAppDao.getList(searchParam);
        if (appResults.stream().noneMatch(e -> e.getType() == null)) {
            log.info("\u6ca1\u6709\u53ef\u8ba2\u6b63\u767d\u540d\u5355\u751f\u6548\u5e94\u7528\u7684\u767d\u540d\u5355\u7c7b\u578b\u5b57\u6bb5\u7684\u6570\u636e");
            return;
        }
        List ids = appResults.stream().map(WhitelistEffectiveAppResult::getId).distinct().collect(Collectors.toList());
        WhitelistSearchParam param = new WhitelistSearchParam();
        param.setIds(ids);
        List whitelistResults = this.whiteListDAO.getList(param);
        Map<Long, List<WhitelistResult>> whitelistResultsMap = whitelistResults.stream().collect(Collectors.groupingBy(WhitelistResult::getWlistId));
        List updatePartAppNameParams = appResults.stream().map(result -> {
            WhitelistUpdatePartAppNameParam partAppNameParam = new WhitelistUpdatePartAppNameParam();
            List results = (List)whitelistResultsMap.get(result.getWlistId());
            partAppNameParam.setId(result.getId());
            if (!CollectionUtils.isEmpty((Collection)results)) {
                partAppNameParam.setType(((WhitelistResult)results.get(0)).getType());
            }
            return partAppNameParam;
        }).collect(Collectors.toList());
        this.whitelistEffectiveAppDao.updatePartAppName(updatePartAppNameParams);
    }
}

