/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.init.fix;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Maps;
import io.shulie.tro.web.amdb.bean.common.EntranceTypeEnum;
import io.shulie.tro.web.common.util.ActivityUtil;
import io.shulie.tro.web.data.mapper.mysql.BusinessLinkManageTableMapper;
import io.shulie.tro.web.data.mapper.mysql.LinkManageTableMapper;
import io.shulie.tro.web.data.model.mysql.BusinessLinkManageTableEntity;
import io.shulie.tro.web.data.model.mysql.LinkManageTableEntity;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LinkManageFixer {
    private static final Logger log = LoggerFactory.getLogger(LinkManageFixer.class);
    @Value(value="${link.fix.enable:false}")
    private Boolean enableLinkFix;
    @Resource
    private LinkManageTableMapper linkManageTableMapper;
    @Resource
    private BusinessLinkManageTableMapper businessLinkManageTableMapper;

    public void fix() {
        if (this.enableLinkFix.booleanValue()) {
            log.info("\u5f00\u59cb\u4fee\u590d\u65e7\u7684\u4e1a\u52a1\u6d3b\u52a8\u6570\u636e\u6570\u636e");
            List businessLinkManageTableEntities = this.businessLinkManageTableMapper.selectList((Wrapper)new LambdaQueryWrapper());
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            List linkManageTableEntities = this.linkManageTableMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtils.isEmpty((Collection)businessLinkManageTableEntities)) {
                return;
            }
            Map<Long, LinkManageTableEntity> collect = linkManageTableEntities.stream().collect(Collectors.toMap(LinkManageTableEntity::getLinkId, i -> i));
            businessLinkManageTableEntities.forEach(item -> {
                LinkManageTableEntity linkManageTableEntity = (LinkManageTableEntity)collect.get(Long.parseLong(item.getRelatedTechLink()));
                if (linkManageTableEntity == null) {
                    return;
                }
                if (linkManageTableEntity.getFeatures() != null) {
                    return;
                }
                try {
                    String entrace = item.getEntrace();
                    String[] split = entrace.split("\\|");
                    if (split.length > 3) {
                        String[] split1 = new String[]{"", "", ""};
                        split1[0] = split[0];
                        split1[1] = split[1];
                        split1[2] = split[split.length - 1];
                        split = split1;
                    }
                    ActivityUtil.EntranceJoinEntity entranceJoinEntity = new ActivityUtil.EntranceJoinEntity();
                    entranceJoinEntity.setApplicationName(split[0]);
                    entranceJoinEntity.setRpcType("0");
                    String s2 = split[2];
                    String method = "GET";
                    if (s2.startsWith("POST/")) {
                        s2 = s2.startsWith("POST/") ? s2.replace("POST/", "") : s2;
                        method = "POST";
                    }
                    if (s2.startsWith("PUT/")) {
                        s2 = s2.startsWith("PUT/") ? s2.replace("PUT/", "") : s2;
                        method = "PUT";
                    }
                    if (s2.startsWith("DELETE/")) {
                        s2 = s2.startsWith("DELETE/") ? s2.replace("DELETE/", "") : s2;
                        method = "DELETE";
                    }
                    if (s2.startsWith("GET/")) {
                        s2 = s2.startsWith("GET/") ? s2.replace("GET/", "") : s2;
                        method = "GET";
                    }
                    s2 = s2.startsWith("http:///") ? s2.replace("http:///", "") : s2;
                    s2 = s2.startsWith("http://") ? s2.replace("http://", "") : s2;
                    entranceJoinEntity.setMethodName(method);
                    entranceJoinEntity.setServiceName(s2);
                    HashMap features = Maps.newHashMap();
                    features.put("serverMiddlewareType", EntranceTypeEnum.HTTP.getType());
                    features.put("extend", "");
                    features.put("rpcType", "0");
                    features.put("method", method);
                    features.put("serviceName", s2);
                    LinkManageTableEntity entity = new LinkManageTableEntity();
                    entity.setLinkId(linkManageTableEntity.getLinkId());
                    entity.setEntrace(ActivityUtil.toEntrance((ActivityUtil.EntranceJoinEntity)entranceJoinEntity));
                    entity.setFeatures(JSON.toJSONString((Object)features));
                    this.linkManageTableMapper.updateById((Object)entity);
                    BusinessLinkManageTableEntity businessLinkManageTableEntity = new BusinessLinkManageTableEntity();
                    businessLinkManageTableEntity.setEntrace(ActivityUtil.toEntrance((ActivityUtil.EntranceJoinEntity)entranceJoinEntity));
                    businessLinkManageTableEntity.setLinkId(item.getLinkId());
                    this.businessLinkManageTableMapper.updateById((Object)businessLinkManageTableEntity);
                }
                catch (Exception e) {
                    log.error("\u4e1a\u52a1\u6d3b\u52a8\u5165\u53e3\u6570\u636e\u4fee\u6b63\u5931\u8d25\uff0c\u6570\u636e\u4e3a\uff1a" + JSON.toJSONString((Object)item));
                }
            });
        }
    }
}

