/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.init.fix;

import com.google.common.collect.Lists;
import io.shulie.tro.web.common.enums.blacklist.BlacklistTypeEnum;
import io.shulie.tro.web.data.dao.application.ApplicationDAO;
import io.shulie.tro.web.data.dao.blacklist.BlackListDAO;
import io.shulie.tro.web.data.param.application.ApplicationQueryParam;
import io.shulie.tro.web.data.param.blacklist.BlacklistCreateNewParam;
import io.shulie.tro.web.data.param.blacklist.BlacklistSearchParam;
import io.shulie.tro.web.data.result.blacklist.BlacklistResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BlacklistDataFixer {
    private static final Logger log = LoggerFactory.getLogger(BlacklistDataFixer.class);
    @Value(value="${blacklist.data.fix.enable:false}")
    private Boolean enableBlacklistFix;
    @Autowired
    private BlackListDAO blackListDAO;
    @Autowired
    private ApplicationDAO applicationDAO;

    public void fix() {
        if (this.enableBlacklistFix.booleanValue()) {
            log.info("\u5f00\u59cb\u8865\u5145\u6bcf\u4e2a\u5e94\u7528\u7684\u9ed1\u540d\u5355");
            BlacklistSearchParam param = new BlacklistSearchParam();
            List results = this.blackListDAO.selectList(param);
            if (CollectionUtils.isEmpty((Collection)results)) {
                return;
            }
            List noAppIdResult = results.stream().filter(result -> result.getApplicationId() == null || result.getApplicationId() == 0L).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(noAppIdResult)) {
                return;
            }
            ApplicationQueryParam queryParam = new ApplicationQueryParam();
            List detailResults = this.applicationDAO.getApplicationList(queryParam);
            ArrayList params = Lists.newArrayList();
            detailResults.forEach(detailResult -> noAppIdResult.forEach(result -> {
                BlacklistCreateNewParam newParam = new BlacklistCreateNewParam();
                newParam.setApplicationId(detailResult.getApplicationId());
                newParam.setCustomerId(detailResult.getCustomerId());
                newParam.setType(BlacklistTypeEnum.REDIS.getType());
                newParam.setUseYn(result.getUseYn());
                newParam.setRedisKey(result.getRedisKey());
                newParam.setUserId(detailResult.getUserId());
                params.add(newParam);
            }));
            this.blackListDAO.batchInsert((List)params);
            List ids = noAppIdResult.stream().map(BlacklistResult::getBlistId).collect(Collectors.toList());
            this.blackListDAO.logicalDelete(ids);
        }
    }
}

