/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.holder;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class OperationMessageHolder
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(OperationMessageHolder.class);
    public static final Map<String, String> MESSAGE_HOLDER = new ConcurrentHashMap();

    private OperationMessageHolder() {
    }

    public static String formatMessage(String key, Map<String, String> vars) {
        String messagePattern = (String)MESSAGE_HOLDER.get(key);
        if (messagePattern == null) {
            log.error("\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff0ckey[{}]\u5bf9\u5e94\u7684\u63cf\u8ff0\u4fe1\u606f\u5728\u6587\u4ef6\u4e2d\u6ca1\u6709\u53d1\u73b0", (Object)key);
            return "";
        }
        StringSubstitutor sub = new StringSubstitutor(vars);
        try {
            return sub.replace(messagePattern);
        }
        catch (Exception e) {
            log.error("\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff0ckey[{}]\u5bf9\u5e94\u7684\u63cf\u8ff0\u4fe1\u606f\u8f6c\u6362\u5931\u8d25,messagePattern:[{}],\u53d8\u91cf\u4e3a:[{}]", new Object[]{key, messagePattern, vars});
            return "";
        }
    }

    public void afterPropertiesSet() throws Exception {
        try (InputStream logFileInput = this.getClass().getClassLoader().getResourceAsStream("log_message/operation_log.properties");){
            if (logFileInput == null) {
                log.error("\u64cd\u4f5c\u65e5\u5fd7\u63cf\u8ff0\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25\uff0c\u5728classpath\u4e0b\u9762\uff0c\u6ca1\u6709\u627e\u5230/log_message\u7684\u76ee\u5f55");
                throw new IllegalArgumentException("\u64cd\u4f5c\u65e5\u5fd7\u63cf\u8ff0\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25\uff0c\u5728classpath\u4e0b\u9762\uff0c\u6ca1\u6709\u627e\u5230[log_message/operation_log.properties]\u7684\u6587\u4ef6");
            }
            Properties properties = new Properties();
            properties.load(new InputStreamReader(logFileInput, StandardCharsets.UTF_8));
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)properties.get(key);
                MESSAGE_HOLDER.put(key, value);
            }
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u64cd\u4f5c\u65e5\u5fd7\u7684\u6587\u4ef6\u5931\u8d25\uff01");
        }
    }
}

