/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.convert.user;

import io.shulie.tro.web.app.convert.user.UserConverter;
import io.shulie.tro.web.app.input.user.UserQueryInput;
import io.shulie.tro.web.app.output.user.RoleQueryOutput;
import io.shulie.tro.web.app.output.user.UserQueryOutput;
import io.shulie.tro.web.app.request.user.UserQueryRequest;
import io.shulie.tro.web.app.response.user.RoleQueryResponse;
import io.shulie.tro.web.app.response.user.UserQueryResponse;
import io.shulie.tro.web.data.result.user.RoleQueryResult;
import io.shulie.tro.web.data.result.user.UserCommonResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class UserConverterImpl
implements UserConverter {
    public UserQueryOutput result2Output(UserCommonResult user) {
        if (user == null) {
            return null;
        }
        UserQueryOutput userQueryOutput = new UserQueryOutput();
        userQueryOutput.setUserId(user.getUserId());
        userQueryOutput.setUserName(user.getUserName());
        List list = user.getDeptNameList();
        if (list != null) {
            userQueryOutput.setDeptNameList(new ArrayList(list));
        }
        userQueryOutput.setRoleList(this.roleQueryResultListToRoleQueryOutputList(user.getRoleList()));
        userQueryOutput.setCreateTime(user.getCreateTime());
        userQueryOutput.setUserAppKey(user.getUserAppKey());
        return userQueryOutput;
    }

    public UserQueryResponse output2Response(UserQueryOutput user) {
        if (user == null) {
            return null;
        }
        UserQueryResponse userQueryResponse = new UserQueryResponse();
        userQueryResponse.setRoleList(this.roleQueryOutputListToRoleQueryResponseList(user.getRoleList()));
        userQueryResponse.setUserAppKey(user.getUserAppKey());
        userQueryResponse.setId(user.getUserId());
        userQueryResponse.setDepartment(StringUtils.join((Collection)user.getDeptNameList(), (String)"/"));
        userQueryResponse.setAccountName(user.getUserName());
        return userQueryResponse;
    }

    public UserQueryInput request2Input(UserQueryRequest request) {
        if (request == null) {
            return null;
        }
        UserQueryInput userQueryInput = new UserQueryInput();
        userQueryInput.setCurrentPage(Integer.valueOf(request.getCurrentPage()));
        userQueryInput.setPageSize(Integer.valueOf(request.getPageSize()));
        userQueryInput.setCurrent(request.getCurrent());
        userQueryInput.setName(request.getAccountName());
        userQueryInput.setRoleIds(request.getRoleId() == null ? null : Arrays.asList(request.getRoleId().toString()));
        userQueryInput.setDeptIds(request.getDepartmentId() == null ? null : Arrays.asList(request.getDepartmentId().toString()));
        return userQueryInput;
    }

    protected RoleQueryOutput roleQueryResultToRoleQueryOutput(RoleQueryResult roleQueryResult) {
        if (roleQueryResult == null) {
            return null;
        }
        RoleQueryOutput roleQueryOutput = new RoleQueryOutput();
        roleQueryOutput.setId(roleQueryResult.getId());
        roleQueryOutput.setName(roleQueryResult.getName());
        roleQueryOutput.setDescription(roleQueryResult.getDescription());
        roleQueryOutput.setCreateTime(roleQueryResult.getCreateTime());
        return roleQueryOutput;
    }

    protected List<RoleQueryOutput> roleQueryResultListToRoleQueryOutputList(List<RoleQueryResult> list) {
        if (list == null) {
            return null;
        }
        ArrayList<RoleQueryOutput> list1 = new ArrayList<RoleQueryOutput>(list.size());
        for (RoleQueryResult roleQueryResult : list) {
            list1.add(this.roleQueryResultToRoleQueryOutput(roleQueryResult));
        }
        return list1;
    }

    protected RoleQueryResponse roleQueryOutputToRoleQueryResponse(RoleQueryOutput roleQueryOutput) {
        if (roleQueryOutput == null) {
            return null;
        }
        RoleQueryResponse roleQueryResponse = new RoleQueryResponse();
        roleQueryResponse.setId(roleQueryOutput.getId());
        roleQueryResponse.setName(roleQueryOutput.getName());
        roleQueryResponse.setDescription(roleQueryOutput.getDescription());
        return roleQueryResponse;
    }

    protected List<RoleQueryResponse> roleQueryOutputListToRoleQueryResponseList(List<RoleQueryOutput> list) {
        if (list == null) {
            return null;
        }
        ArrayList<RoleQueryResponse> list1 = new ArrayList<RoleQueryResponse>(list.size());
        for (RoleQueryOutput roleQueryOutput : list) {
            list1.add(this.roleQueryOutputToRoleQueryResponse(roleQueryOutput));
        }
        return list1;
    }
}

