/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.convert.user;

import com.google.common.collect.Lists;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.web.app.input.user.UserQueryInput;
import io.shulie.tro.web.app.output.user.UserQueryOutput;
import io.shulie.tro.web.app.request.user.UserQueryRequest;
import io.shulie.tro.web.app.response.user.UserQueryResponse;
import io.shulie.tro.web.data.result.user.UserCommonResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper(imports={StringUtils.class})
public interface UserConverter {
    public static final UserConverter INSTANCE = (UserConverter)Mappers.getMapper(UserConverter.class);

    public UserQueryOutput result2Output(UserCommonResult var1);

    default public PagingList<UserQueryOutput> toOutputPagingList(PagingList<UserCommonResult> pageInfo) {
        ArrayList result = Lists.newArrayList();
        if (null == pageInfo || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return PagingList.of((List)result, (long)0L);
        }
        List collect = pageInfo.getList().stream().map(arg_0 -> this.result2Output(arg_0)).collect(Collectors.toList());
        return PagingList.of(collect, (long)pageInfo.getTotal());
    }

    @Mappings(value={@Mapping(target="id", expression="java(user.getUserId())"), @Mapping(target="accountName", expression="java(user.getUserName())"), @Mapping(target="department", expression="java(StringUtils.join(user.getDeptNameList(),\"/\"))")})
    public UserQueryResponse output2Response(UserQueryOutput var1);

    default public PagingList<UserQueryResponse> toResponsePagingList(PagingList<UserQueryOutput> pageInfo) {
        ArrayList result = Lists.newArrayList();
        if (null == pageInfo || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return PagingList.of((List)result, (long)0L);
        }
        List collect = pageInfo.getList().stream().map(arg_0 -> this.output2Response(arg_0)).collect(Collectors.toList());
        return PagingList.of(collect, (long)pageInfo.getTotal());
    }

    @Mappings(value={@Mapping(target="name", expression="java(request.getAccountName())"), @Mapping(target="roleIds", expression="java(request.getRoleId()==null?null:java.util.Arrays.asList(request.getRoleId().toString()))"), @Mapping(target="deptIds", expression="java(request.getDepartmentId()==null?null:java.util.Arrays.asList(request.getDepartmentId().toString()))")})
    public UserQueryInput request2Input(UserQueryRequest var1);
}

