/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.convert.performace;

import io.shulie.tro.web.app.response.perfomanceanaly.PressureMachineStatisticsResponse;
import io.shulie.tro.web.data.result.perfomanceanaly.PressureMachineStatisticsResult;
import java.math.BigDecimal;
import java.util.List;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

@Mapper
public interface PressureMachineStatisticsRespConvert {
    public static final PressureMachineStatisticsRespConvert INSTANCE = (PressureMachineStatisticsRespConvert)Mappers.getMapper(PressureMachineStatisticsRespConvert.class);

    public PressureMachineStatisticsResponse of(PressureMachineStatisticsResult var1);

    public List<PressureMachineStatisticsResponse> ofs(List<PressureMachineStatisticsResult> var1);

    @AfterMapping
    default public void fillRespData(PressureMachineStatisticsResult source, @MappingTarget PressureMachineStatisticsResponse response) {
        Integer machineTotal = source.getMachineTotal();
        if (machineTotal == 0) {
            BigDecimal decimal = new BigDecimal(0);
            response.setOfflinePercent(decimal);
            response.setPressuredPercent(decimal);
            response.setFreePercent(decimal);
        } else {
            BigDecimal totalNum = new BigDecimal(source.getMachineTotal());
            BigDecimal freePercent = new BigDecimal(source.getMachineFree()).divide(totalNum, 4, 4);
            BigDecimal presssuredPercent = new BigDecimal(source.getMachinePressured()).divide(totalNum, 4, 4);
            BigDecimal offlinePercent = new BigDecimal(source.getMachineOffline()).divide(totalNum, 4, 4);
            response.setFreePercent(freePercent);
            response.setPressuredPercent(presssuredPercent);
            response.setOfflinePercent(offlinePercent);
        }
    }
}

