/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.verificationcode;

import io.shulie.tro.web.common.util.verificationcode.VerificationCodeUtil;
import io.swagger.annotations.ApiOperation;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/"})
public class VerificationCodeController {
    private static final Logger log = LoggerFactory.getLogger(VerificationCodeController.class);

    @ApiOperation(value="\u9a8c\u8bc1\u7801\u83b7\u53d6")
    @GetMapping(value={"verification/code"})
    public void getVerificationCode(HttpServletRequest request, HttpServletResponse response) {
        BufferedImage img = VerificationCodeUtil.getImage();
        try {
            String code = VerificationCodeUtil.VERIFICATION_CODE();
            request.getSession().setAttribute("verification_code", (Object)code);
            String accessToken = request.getHeader("Access-Token");
            VerificationCodeUtil.delSession((String)accessToken);
            VerificationCodeUtil.addSession((HttpSession)request.getSession());
            response.setHeader("Access-Control-Expose-Headers", "Access-Token");
            response.setHeader("Access-Token", request.getSession().getId());
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", -1L);
            response.setContentType("image/jpeg");
            VerificationCodeUtil.saveImage((BufferedImage)img, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            log.error("\u751f\u6210\u56fe\u7247\u9a8c\u8bc1\u7801\u5f02\u5e38", (Throwable)e);
        }
    }
}

