/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.user;

import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.request.user.UserAllocationUpdateRequest;
import io.shulie.tro.web.app.request.user.UserCreateRequest;
import io.shulie.tro.web.app.request.user.UserDeleteRequest;
import io.shulie.tro.web.app.request.user.UserDetailQueryRequest;
import io.shulie.tro.web.app.request.user.UserPasswordUpdateRequest;
import io.shulie.tro.web.app.request.user.UserUpdateRequest;
import io.shulie.tro.web.app.response.user.UserDetailResponse;
import io.shulie.tro.web.app.response.user.UserImportResponse;
import io.shulie.tro.web.app.service.user.TroWebUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/user"})
@Api(tags={"\u7528\u6237\u7ba1\u7406"})
public class TroWebUserController {
    @Autowired
    private TroWebUserService troWebUserService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u6dfb\u52a0\u7528\u6237")
    public void createUser(@Validated @RequestBody UserCreateRequest createRequest) {
        this.troWebUserService.createUser(createRequest);
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u7528\u6237")
    public void updateUser(@Validated @RequestBody UserUpdateRequest updateRequest) {
        this.troWebUserService.updateUser(updateRequest);
    }

    @DeleteMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u7528\u6237")
    public void deleteUser(@Validated @RequestBody UserDeleteRequest deleteRequest) {
        this.troWebUserService.deleteUser(deleteRequest);
    }

    @PutMapping(value={"/pwd/update"})
    @ApiOperation(value="\u66f4\u65b0\u5bc6\u7801")
    public void updatePassword(@Validated @RequestBody UserPasswordUpdateRequest updateRequest) {
        this.troWebUserService.updatePassword(updateRequest);
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u67e5\u8be2\u7528\u6237")
    public UserDetailResponse queryUser(@Validated @NotNull @RequestParam(value="id") Long id) {
        UserDetailQueryRequest queryRequest = new UserDetailQueryRequest();
        queryRequest.setId(id);
        return this.troWebUserService.queryUser(queryRequest);
    }

    @PostMapping(value={"/import"})
    @ApiOperation(value="\u5bfc\u5165\u7528\u6237")
    public UserImportResponse importUser(@NotNull @RequestBody MultipartFile file) {
        return this.troWebUserService.importUser(file);
    }

    @GetMapping(value={"/download"})
    @ApiOperation(value="\u4e0b\u8f7d\u5f02\u5e38\u7528\u6237\u6570\u636e")
    public void download(HttpServletResponse response, @NotEmpty String path) {
        this.troWebUserService.download(response, path);
    }

    @GetMapping(value={"/example/download"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    public void downloadExample(HttpServletResponse response) {
        this.troWebUserService.downloadExample(response);
    }

    @PostMapping(value={"/allocation"})
    @ApiOperation(value="\u6307\u5b9a\u8d1f\u8d23\u4eba")
    public Response allocationUser(@RequestBody UserAllocationUpdateRequest request) {
        return this.troWebUserService.allocationUser(request);
    }
}

